/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.service.warehouse.cond.PhyWhStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.dao.TmallStockLogMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotDiffDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotRcdSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPreAllotRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPreAllotRcdSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhAllotDiffDetailCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.enums.WarehouseCommodityStatusEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotTypeEnum;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.PcsSkuVO;
import com.thebeastshop.pegasus.service.warehouse.model.TmallStockLog;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotDiffDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotDiffDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhPreAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhPreAllotRcdExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhPreAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhPreAllotRcdSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhJitPackageSkuReferenceService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWarehouseGroupService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectAllotPackageService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.PhyWhStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotDiffDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotDiffSendMessageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotPackageInBoundSkuDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotPackageInBoundVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPreAllotRcdDownloadVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPreAllotRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseGroupVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.Constants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.service.SWhCommandService;
import com.thebeastshop.stock.vo.SWhCommandVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="whAllotService")
public class WhAllotServiceImpl
implements WhAllotService {
    private final Logger log = LoggerFactory.getLogger(WhAllotServiceImpl.class);
    @Autowired
    private WhAllotRcdMapper whAllotRcdMapper;
    @Autowired
    private WhAllotRcdSkuMapper whAllotRcdSkuMapper;
    @Autowired
    private WhPreAllotRcdMapper whPreAllotRcdMapper;
    @Autowired
    private WhPreAllotRcdSkuMapper whPreAllotRcdSkuMapper;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhWarehouseGroupService whWarehouseGroupService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhAllotDiffDetailMapper whAllotDiffDetailMapper;
    @Autowired
    private WhAllotDiffDetailCustomMapper whAllotDiffDetailCustomMapper;
    @Autowired
    private TmallStockLogMapper tmallStockLogMapper;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private SWhCommandService sWhCommandService;
    @Autowired
    private WhWmsConnectAllotPackageService whWmsConnectAllotPackageService;
    @Autowired
    private WhJitPackageSkuReferenceService whJitPackageSkuReferenceService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    @Override
    @Transactional
    public String createAllotRcd(WhAllotRcd whAllotRcd) throws Exception {
        this.checkBeforCreate(Collections.singletonList(whAllotRcd));
        return this.createAllot(whAllotRcd);
    }

    @Override
    @Transactional
    public String createAllotRcdNoSynTmall(WhAllotRcd whAllotRcd) throws Exception {
        this.checkBeforCreate(Collections.singletonList(whAllotRcd));
        return this.createAllotNoSynTmall(whAllotRcd);
    }

    private String createAllot(WhAllotRcd whAllotRcd) throws Exception {
        WhCommand whCommandOut;
        boolean diffProcessAndNoWarehouse;
        StringBuilder synErrorMsg = new StringBuilder("");
        String sourceWarehouseCode = whAllotRcd.getSourceWarehouseCode();
        String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();
        List<WhAllotRcdSku> whAllotRcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
        if (EmptyUtil.isEmpty(whAllotRcdSkuList)) {
            throw new WarehouseException("CO0001", "\u8c03\u62e8\u884c\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        WhWarehouse sourceWhWarehouse = this.checkSourcePhyWhSkuStock(whAllotRcd);
        if (EmptyUtil.isEmpty((Object)sourceWhWarehouse)) {
            sourceWhWarehouse = this.whInfoService.findWarehouseByCode(whAllotRcd.getSourceWarehouseCode());
        }
        WhWarehouseGroupVO whGroup = this.whWarehouseGroupService.findById(sourceWhWarehouse.getWarehouseGroupId(), false);
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION);
        whAllotRcd.setCreateTime(DateUtil.getNow());
        this.buildAltEstimatedAllocationDate(whAllotRcd);
        this.whAllotRcdMapper.insert(whAllotRcd);
        String code = this.generatorAltCode(whAllotRcd.getId(), whAllotRcd.getAllotType());
        whAllotRcd.setCode(code);
        this.whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);
        if (CollectionUtils.isNotEmpty(whAllotRcd.getPcsSkus())) {
            for (com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO pcsSkuVO : whAllotRcd.getPcsSkus()) {
                if (!EmptyUtil.isNotEmpty((Object)pcsSkuVO.getCanCustomize()) || pcsSkuVO.getCanCustomize() != 1) continue;
                whAllotRcd.setNoSyncOtherPlatform(true);
                break;
            }
        }
        ArrayList successSynTmall = Lists.newArrayList();
        Boolean buildFlag = true;
        if (EmptyUtil.isEmpty((String)whAllotRcd.getRemark()) || whAllotRcd.getRemark().indexOf("\u9884\u552e") == -1) {
            List<TmallStockLog> list;
            if (Constants.warehouseMap.containsKey(targetWarehouseCode) && !whAllotRcd.isNoSyncOtherPlatform()) {
                list = this.syncTmallStockAllot(this.getSyncSkuList(whAllotRcdSkuList, 1), (String)Constants.warehouseMap.get(targetWarehouseCode), code);
                for (TmallStockLog tmallStockLog : list) {
                    if (tmallStockLog.getSyncStatus() == 1) {
                        successSynTmall.add(tmallStockLog);
                        continue;
                    }
                    synErrorMsg.append("SKU[" + tmallStockLog.getSkuCode() + "]" + tmallStockLog.getRemark() + "\r\n");
                }
                whAllotRcdSkuList = this.buildTmallAllotSkus(successSynTmall);
                buildFlag = false;
            }
            if (Constants.warehouseMap.containsKey(sourceWarehouseCode) && !whAllotRcd.isNoSyncOtherPlatform()) {
                list = this.syncTmallStockAllot(this.getSyncSkuList(whAllotRcdSkuList, 0), (String)Constants.warehouseMap.get(sourceWarehouseCode), code);
                for (TmallStockLog tmallStockLog : list) {
                    if (tmallStockLog.getSyncStatus() == 1) {
                        successSynTmall.add(tmallStockLog);
                        continue;
                    }
                    synErrorMsg.append("SKU[" + tmallStockLog.getSkuCode() + "]" + tmallStockLog.getRemark() + "\r\n");
                }
                if (buildFlag.booleanValue()) {
                    whAllotRcdSkuList = this.buildTmallAllotSkus(successSynTmall);
                }
            }
        }
        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        String jdWarningMsg = this.trySyncJdStock(whAllotRcd);
        ArrayList<WhAllotDiffDetailVO> allotDiffDetailVOs = new ArrayList<WhAllotDiffDetailVO>();
        for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
            whAllotRcdSku.setAllotRcdId(whAllotRcd.getId());
            this.whAllotRcdSkuMapper.insert(whAllotRcdSku);
            if (!whAllotRcd.isDiffProcess()) continue;
            if (EmptyUtil.isNotEmpty((Object)whAllotRcdSku.getNeedUpdateRefId())) {
                WhAllotRcdSku record = new WhAllotRcdSku();
                record.setId(whAllotRcdSku.getNeedUpdateRefId());
                record.setProcessedQuantity(whAllotRcdSku.getQuantity());
                this.whAllotRcdSkuMapper.updateProcessedQuantityByPrimaryKey(record);
            }
            this.buildAllotDiffDetailVOs(whAllotRcd, whAllotRcdSku, allotDiffDetailVOs);
        }
        if (CollectionUtils.isNotEmpty(allotDiffDetailVOs)) {
            this.whAllotDiffDetailCustomMapper.batchInsert(allotDiffDetailVOs);
        }
        WhWarehouse targetWhWarehouse = this.whInfoService.findWarehouseByCode(targetWarehouseCode);
        Validation.paramNotNull((Object)targetWhWarehouse, (String)"\u76ee\u6807\u903b\u8f91\u4ed3\u4e3a\u7a7a");
        WhPhysicalWarehouse targetPhysicalWarehouse = null;
        if (EmptyUtil.isNotEmpty((String)whAllotRcd.getTargetPhysicalWarehouseCode())) {
            targetPhysicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(whAllotRcd.getTargetPhysicalWarehouseCode());
        }
        WhWarehouseGroupVO targetWhGroup = this.whWarehouseGroupService.findById(targetWhWarehouse.getWarehouseGroupId(), false);
        this.checkWhCommodityStatus(sourceWhWarehouse, whGroup, targetWhWarehouse, targetWhGroup);
        boolean isWarehouseGroupChannelMove = this.isWarehouseGroupChannelMove(whAllotRcd);
        boolean bl = diffProcessAndNoWarehouse = whAllotRcd.isDiffProcess() && NullUtil.isNotNull((Object)targetPhysicalWarehouse) && !WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(targetPhysicalWarehouse.getWarehouseType());
        if ((WhAllotRcd.TYPE_CUSTOMIZE_OUT.equals(whAllotRcd.getAllotType()) || WhAllotRcd.TYPE_CUSTOMIZE_IN.equals(whAllotRcd.getAllotType()) || WhAllotRcd.AUTO_TRANSFER_ALLOT.equals(whAllotRcd.getAllotType())) && CollectionUtils.isNotEmpty(whAllotRcd.getJitPackageSkuReferenceVOs())) {
            for (WhJitPackageSkuReferenceVO jitPackageSkuReferenceVO : whAllotRcd.getJitPackageSkuReferenceVOs()) {
                jitPackageSkuReferenceVO.setReferenceCode(whAllotRcd.getCode());
            }
            this.whJitPackageSkuReferenceService.createWhJitPackageSkuReference(whAllotRcd.getJitPackageSkuReferenceVOs());
        }
        if (EmptyUtil.isNotEmpty((String)whAllotRcd.getJitPackageSkuRefCode())) {
            this.whJitPackageSkuReferenceService.finishByReferenceCode(whAllotRcd.getJitPackageSkuRefCode());
        }
        String errorMsg = synErrorMsg.toString();
        if (EmptyUtil.isNotEmpty((String)jdWarningMsg)) {
            errorMsg = errorMsg + jdWarningMsg;
        }
        if (CollectionUtils.isEmpty((Collection)successSynTmall) && synErrorMsg.length() > 0 || EmptyUtil.isEmpty(whAllotRcd.getWhAllotRcdSkuList()) && EmptyUtil.isNotEmpty((String)jdWarningMsg)) {
            WhAllotRcdSkuExample example = new WhAllotRcdSkuExample();
            example.createCriteria().andAllotRcdIdEqualTo(whAllotRcd.getId());
            this.whAllotRcdSkuMapper.deleteByExample(example);
            this.whAllotRcdMapper.deleteByPrimaryKey(whAllotRcd.getId());
            return "\u521b\u5efa\u8c03\u62e8\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:" + errorMsg.toString();
        }
        if (whAllotRcd.getAllotType().intValue() == WhAllotTypeEnum.AUTO_ALLOT.getVal() && !whAllotRcd.getTargetWarehouseCode().equals("WH020600010096")) {
            whCommandOut = this.buildAltOutCommand(whAllotRcd);
            whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
            whCommandOut.setExpressNo(whAllotRcd.getCode());
            this.whCommandService.createCommand(whCommandOut);
        } else if (isWarehouseGroupChannelMove || this.isWarehouseInnerMove(whAllotRcd)) {
            whAllotRcd.setIsChannelGoods(1);
            boolean cleanCmdPhyWhCode = false;
            if (WhWarehouseGroupVO.WAREHOUSE_NO.equals(whGroup.getType()) && NullUtil.isNotNull((Object)sourceWhWarehouse.getCommodityStatus()) && sourceWhWarehouse.getCommodityStatus().equals(targetWhWarehouse.getCommodityStatus())) {
                cleanCmdPhyWhCode = true;
            } else if (isWarehouseGroupChannelMove && WhWarehouseGroupVO.WAREHOUSE_NO.equals(whGroup.getType()) && NullUtil.isNotNull((Object)sourceWhWarehouse.getCommodityStatus()) && !sourceWhWarehouse.getCommodityStatus().equals(targetWhWarehouse.getCommodityStatus())) {
                List<WhPhysicalWarehouseVO> phyWhList = this.whInfoService.findPhysicalWarehouseByGroupId(Collections.singletonList(whGroup.getId()));
                if (EmptyUtil.isEmpty(phyWhList) || phyWhList.size() > 1) {
                    throw new WarehouseException("WH0001", "\u6570\u636e\u5f02\u5e38");
                }
                WhPhysicalWarehouseVO phyWh = phyWhList.get(0);
                whAllotRcd.setSourcePhysicalWarehouseCode(phyWh.getCode());
                whAllotRcd.setTargetPhysicalWarehouseCode(phyWh.getCode());
            }
            this.allotFinishCommand(whAllotRcd, true, cleanCmdPhyWhCode);
        } else if (diffProcessAndNoWarehouse) {
            this.allotFinishCommand(whAllotRcd, false, false);
        } else if (!whAllotRcd.isNeedConfirm() && (StringUtils.isEmpty((String)whAllotRcd.getConfirmWarehouseCode()) && EmptyUtil.isEmpty((String)whAllotRcd.getConfirmPhysicalWarehouseCode()) || NullUtil.isNotNull((Object)targetPhysicalWarehouse) && NullUtil.isNotNull((Object)targetPhysicalWarehouse.getIsOnline()) && targetPhysicalWarehouse.getIsOnline() == 1)) {
            if (whAllotRcd.isDiffProcess()) {
                whAllotRcd.setNeedWaitInBound(true);
            }
            boolean result = this.updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND);
            if (whAllotRcd.isDiffProcess() && result) {
                this.outBoundProcess(whAllotRcd);
            }
        } else {
            whCommandOut = this.buildAltOutCommand(whAllotRcd);
            whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
            whCommandOut.setExpressNo(whAllotRcd.getCode());
            this.whCommandService.createCommand(whCommandOut);
        }
        if (errorMsg.length() > 0) {
            return code + ":\u90e8\u5206SKU\u8c03\u62e8\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + errorMsg.toString();
        }
        return code;
    }

    @Override
    public String trySyncJdStock(WhAllotRcd allotRcd) {
        String msg;
        if (EmptyUtil.isNotEmpty((String)allotRcd.getRemark()) && allotRcd.getRemark().contains("\u9884\u552e") || allotRcd.isNoSyncOtherPlatform()) {
            return null;
        }
        StringBuilder waringMsg = new StringBuilder();
        if (this.pegasusUtilFacade.needSyncJdStock(allotRcd.getSourceWarehouseCode()) && EmptyUtil.isNotEmpty((String)(msg = this.processSyncJdStock(allotRcd, true)))) {
            waringMsg.append(msg);
        }
        if (this.pegasusUtilFacade.needSyncJdStock(allotRcd.getTargetWarehouseCode()) && EmptyUtil.isNotEmpty((String)(msg = this.processSyncJdStock(allotRcd, false)))) {
            waringMsg.append(msg);
        }
        return waringMsg.toString();
    }

    @Override
    public String trySyncJdStockNew(WhAllotRcd allotRcd, boolean inStorage) {
        String msg;
        if (EmptyUtil.isNotEmpty((String)allotRcd.getRemark()) && allotRcd.getRemark().contains("\u9884\u552e") || allotRcd.isNoSyncOtherPlatform()) {
            return null;
        }
        StringBuilder waringMsg = new StringBuilder();
        if (this.pegasusUtilFacade.needSyncJdStock(allotRcd.getSourceWarehouseCode()) && !inStorage && EmptyUtil.isNotEmpty((String)(msg = this.processSyncJdStockNew(allotRcd, true)))) {
            waringMsg.append(msg);
        }
        if (this.pegasusUtilFacade.needSyncJdStock(allotRcd.getTargetWarehouseCode()) && inStorage && EmptyUtil.isNotEmpty((String)(msg = this.processSyncJdStockNew(allotRcd, false)))) {
            waringMsg.append(msg);
        }
        return waringMsg.toString();
    }

    private String processSyncJdStockNew(WhAllotRcd allotRcd, boolean out) {
        List<WhAllotRcdSku> rcdSkuList = allotRcd.getWhAllotRcdSkuList();
        LinkedList<String> referenceCodes = new LinkedList<String>();
        Map<String, Integer> skuQuantityMap = this.getSyncJdSkuQuantiyMap(rcdSkuList, out, referenceCodes);
        Long operatorId = null;
        if (NullUtil.isNotNull((Object)allotRcd.getCreateUserId())) {
            operatorId = allotRcd.getCreateUserId().longValue();
        }
        StringBuilder waringMsg = new StringBuilder();
        if (!skuQuantityMap.isEmpty()) {
            Map<String, JdStockSyncResult> syncResultMap = this.whCommandService.syncJdSkuStock(out ? allotRcd.getSourceWarehouseCode() : allotRcd.getTargetWarehouseCode(), skuQuantityMap, Constants.STOCK_SYNC_TYPE_ALLOT, referenceCodes, operatorId);
            Iterator<WhAllotRcdSku> iterator = rcdSkuList.iterator();
            while (iterator.hasNext()) {
                WhAllotRcdSku rcdSku = iterator.next();
                JdStockSyncResult syncResult = syncResultMap.get(rcdSku.getSkuCode());
                if (syncResult.isSuccess()) continue;
                iterator.remove();
                waringMsg.append(String.format("SKU[%s]%s\r\n", syncResult.getSkuCode(), syncResult.getErrorMsg()));
            }
        }
        return waringMsg.toString();
    }

    private String processSyncJdStock(WhAllotRcd allotRcd, boolean out) {
        List<WhAllotRcdSku> rcdSkuList = allotRcd.getWhAllotRcdSkuList();
        LinkedList<String> referenceCodes = new LinkedList<String>();
        referenceCodes.add(allotRcd.getCode());
        Map<String, Integer> skuQuantityMap = this.getSyncJdSkuQuantiyMap(rcdSkuList, out);
        Long operatorId = null;
        if (NullUtil.isNotNull((Object)allotRcd.getCreateUserId())) {
            operatorId = allotRcd.getCreateUserId().longValue();
        }
        StringBuilder waringMsg = new StringBuilder();
        if (!skuQuantityMap.isEmpty()) {
            Map<String, JdStockSyncResult> syncResultMap = this.whCommandService.syncJdSkuStock(out ? allotRcd.getSourceWarehouseCode() : allotRcd.getTargetWarehouseCode(), skuQuantityMap, Constants.STOCK_SYNC_TYPE_ALLOT, referenceCodes, operatorId);
            Iterator<WhAllotRcdSku> iterator = rcdSkuList.iterator();
            while (iterator.hasNext()) {
                WhAllotRcdSku rcdSku = iterator.next();
                JdStockSyncResult syncResult = syncResultMap.get(rcdSku.getSkuCode());
                if (syncResult.isSuccess()) continue;
                iterator.remove();
                waringMsg.append(String.format("SKU[%s]%s\r\n", syncResult.getSkuCode(), syncResult.getErrorMsg()));
            }
        }
        return waringMsg.toString();
    }

    private Map<String, Integer> getSyncJdSkuQuantiyMap(List<WhAllotRcdSku> rcdSkuList, boolean out) {
        LinkedHashMap<String, Integer> skuQuantityMap = new LinkedHashMap<String, Integer>();
        for (WhAllotRcdSku rcdSku : rcdSkuList) {
            if (!rcdSku.isSyncThridParty()) continue;
            if (out) {
                skuQuantityMap.put(rcdSku.getSkuCode(), -rcdSku.getQuantity().intValue());
                continue;
            }
            skuQuantityMap.put(rcdSku.getSkuCode(), rcdSku.getQuantity());
        }
        return skuQuantityMap;
    }

    private Map<String, Integer> getSyncJdSkuQuantiyMap(List<WhAllotRcdSku> rcdSkuList, boolean out, List<String> referenceCodes) {
        LinkedHashMap<String, Integer> skuQuantityMap = new LinkedHashMap<String, Integer>();
        for (WhAllotRcdSku rcdSku : rcdSkuList) {
            if (!rcdSku.isSyncThridParty()) continue;
            if (out) {
                skuQuantityMap.put(rcdSku.getSkuCode(), -rcdSku.getQuantity().intValue());
            } else {
                skuQuantityMap.put(rcdSku.getSkuCode(), rcdSku.getQuantity());
            }
            referenceCodes.add(rcdSku.getPreOccupyRefCode());
        }
        return skuQuantityMap;
    }

    private List<WhAllotRcdSku> buildTmallAllotSkus(List<TmallStockLog> successSynTmall) {
        ArrayList<WhAllotRcdSku> lines = new ArrayList<WhAllotRcdSku>();
        for (TmallStockLog tmallStockLog : successSynTmall) {
            WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
            whAllotRcdSku.setSkuCode(tmallStockLog.getSkuCode());
            whAllotRcdSku.setQuantity(Math.abs(tmallStockLog.getQuantity()));
            whAllotRcdSku.setPreOccupyRefCode(tmallStockLog.getReferenceCode());
            lines.add(whAllotRcdSku);
        }
        return lines;
    }

    private String createAllotNoSynTmall(WhAllotRcd whAllotRcd) throws Exception {
        boolean diffProcessAndNoWarehouse;
        String sourceWarehouseCode = whAllotRcd.getSourceWarehouseCode();
        String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();
        List<WhAllotRcdSku> whAllotRcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
        if (EmptyUtil.isEmpty(whAllotRcdSkuList)) {
            throw new WarehouseException("CO0001", "\u8c03\u62e8\u884c\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        WhWarehouse sourceWhWarehouse = this.checkSourcePhyWhSkuStock(whAllotRcd);
        if (EmptyUtil.isEmpty((Object)sourceWhWarehouse)) {
            sourceWhWarehouse = this.whInfoService.findWarehouseByCode(whAllotRcd.getSourceWarehouseCode());
        }
        WhWarehouseGroupVO whGroup = this.whWarehouseGroupService.findById(sourceWhWarehouse.getWarehouseGroupId(), false);
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION);
        whAllotRcd.setCreateTime(DateUtil.getNow());
        this.buildAltEstimatedAllocationDate(whAllotRcd);
        this.whAllotRcdMapper.insert(whAllotRcd);
        String code = this.generatorAltCode(whAllotRcd.getId(), whAllotRcd.getAllotType());
        whAllotRcd.setCode(code);
        this.whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);
        ArrayList<WhAllotDiffDetailVO> allotDiffDetailVOs = new ArrayList<WhAllotDiffDetailVO>();
        for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
            whAllotRcdSku.setAllotRcdId(whAllotRcd.getId());
            this.whAllotRcdSkuMapper.insert(whAllotRcdSku);
            if (!whAllotRcd.isDiffProcess()) continue;
            if (EmptyUtil.isNotEmpty((Object)whAllotRcdSku.getNeedUpdateRefId())) {
                WhAllotRcdSku record = new WhAllotRcdSku();
                record.setId(whAllotRcdSku.getNeedUpdateRefId());
                record.setProcessedQuantity(whAllotRcdSku.getQuantity());
                this.whAllotRcdSkuMapper.updateProcessedQuantityByPrimaryKey(record);
            }
            this.buildAllotDiffDetailVOs(whAllotRcd, whAllotRcdSku, allotDiffDetailVOs);
        }
        if (CollectionUtils.isNotEmpty(allotDiffDetailVOs)) {
            this.whAllotDiffDetailCustomMapper.batchInsert(allotDiffDetailVOs);
        }
        WhWarehouse targetWhWarehouse = this.whInfoService.findWarehouseByCode(targetWarehouseCode);
        Validation.paramNotNull((Object)targetWhWarehouse, (String)"\u76ee\u6807\u903b\u8f91\u4ed3\u4e3a\u7a7a");
        WhPhysicalWarehouse targetPhysicalWarehouse = null;
        if (EmptyUtil.isNotEmpty((String)whAllotRcd.getTargetPhysicalWarehouseCode())) {
            targetPhysicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(whAllotRcd.getTargetPhysicalWarehouseCode());
        }
        WhWarehouseGroupVO targetWhGroup = this.whWarehouseGroupService.findById(targetWhWarehouse.getWarehouseGroupId(), false);
        this.checkWhCommodityStatus(sourceWhWarehouse, whGroup, targetWhWarehouse, targetWhGroup);
        boolean isWarehouseGroupChannelMove = this.isWarehouseGroupChannelMove(whAllotRcd);
        boolean bl = diffProcessAndNoWarehouse = whAllotRcd.isDiffProcess() && NullUtil.isNotNull((Object)targetPhysicalWarehouse) && !WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(targetPhysicalWarehouse.getWarehouseType());
        if (whAllotRcd.getAllotType().intValue() == WhAllotTypeEnum.AUTO_ALLOT.getVal() && !whAllotRcd.getTargetWarehouseCode().equals("WH020600010096")) {
            WhCommand whCommandOut = this.buildAltOutCommand(whAllotRcd);
            whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
            whCommandOut.setExpressNo(whAllotRcd.getCode());
            this.whCommandService.createCommand(whCommandOut);
        } else if (isWarehouseGroupChannelMove || this.isWarehouseInnerMove(whAllotRcd)) {
            whAllotRcd.setIsChannelGoods(1);
            boolean cleanCmdPhyWhCode = false;
            if (WhWarehouseGroupVO.WAREHOUSE_NO.equals(whGroup.getType()) && NullUtil.isNotNull((Object)sourceWhWarehouse.getCommodityStatus()) && sourceWhWarehouse.getCommodityStatus().equals(targetWhWarehouse.getCommodityStatus())) {
                cleanCmdPhyWhCode = true;
            } else if (isWarehouseGroupChannelMove && WhWarehouseGroupVO.WAREHOUSE_NO.equals(whGroup.getType()) && NullUtil.isNotNull((Object)sourceWhWarehouse.getCommodityStatus()) && !sourceWhWarehouse.getCommodityStatus().equals(targetWhWarehouse.getCommodityStatus())) {
                List<WhPhysicalWarehouseVO> phyWhList = this.whInfoService.findPhysicalWarehouseByGroupId(Collections.singletonList(whGroup.getId()));
                if (EmptyUtil.isEmpty(phyWhList) || phyWhList.size() > 1) {
                    throw new WarehouseException("WH0001", "\u6570\u636e\u5f02\u5e38");
                }
                WhPhysicalWarehouseVO phyWh = phyWhList.get(0);
                whAllotRcd.setSourcePhysicalWarehouseCode(phyWh.getCode());
                whAllotRcd.setTargetPhysicalWarehouseCode(phyWh.getCode());
            }
            this.allotFinishCommand(whAllotRcd, true, cleanCmdPhyWhCode);
        } else if (diffProcessAndNoWarehouse) {
            this.allotFinishCommand(whAllotRcd, false, false);
        } else if (!whAllotRcd.isNeedConfirm() && (StringUtils.isEmpty((String)whAllotRcd.getConfirmWarehouseCode()) && EmptyUtil.isEmpty((String)whAllotRcd.getConfirmPhysicalWarehouseCode()) || NullUtil.isNotNull((Object)targetPhysicalWarehouse) && NullUtil.isNotNull((Object)targetPhysicalWarehouse.getIsOnline()) && targetPhysicalWarehouse.getIsOnline() == 1)) {
            if (whAllotRcd.isDiffProcess()) {
                whAllotRcd.setNeedWaitInBound(true);
            }
            boolean result = this.updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND);
            if (whAllotRcd.isDiffProcess() && result) {
                this.outBoundProcess(whAllotRcd);
            }
        } else {
            WhCommand whCommandOut = this.buildAltOutCommand(whAllotRcd);
            whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
            whCommandOut.setExpressNo(whAllotRcd.getCode());
            this.whCommandService.createCommand(whCommandOut);
        }
        if ((WhAllotRcd.TYPE_CUSTOMIZE_OUT.equals(whAllotRcd.getAllotType()) || WhAllotRcd.TYPE_CUSTOMIZE_IN.equals(whAllotRcd.getAllotType()) || WhAllotRcd.AUTO_TRANSFER_ALLOT.equals(whAllotRcd.getAllotType())) && CollectionUtils.isNotEmpty(whAllotRcd.getJitPackageSkuReferenceVOs())) {
            for (WhJitPackageSkuReferenceVO jitPackageSkuReferenceVO : whAllotRcd.getJitPackageSkuReferenceVOs()) {
                jitPackageSkuReferenceVO.setReferenceCode(whAllotRcd.getCode());
            }
            this.whJitPackageSkuReferenceService.createWhJitPackageSkuReference(whAllotRcd.getJitPackageSkuReferenceVOs());
        }
        if (EmptyUtil.isNotEmpty((String)whAllotRcd.getJitPackageSkuRefCode())) {
            this.whJitPackageSkuReferenceService.finishByReferenceCode(whAllotRcd.getJitPackageSkuRefCode());
        }
        return code;
    }

    private void checkWhCommodityStatus(WhWarehouse sourceWhWarehouse, WhWarehouseGroupVO sourceWhGroup, WhWarehouse targetWhWarehouse, WhWarehouseGroupVO targetWhGroup) {
        Integer sourceCommodityStatus = sourceWhWarehouse.getCommodityStatus();
        Integer targetCommodityStatus = targetWhWarehouse.getCommodityStatus();
        boolean sameCommodityStatus = true;
        if (!sourceWhWarehouse.getPhysicalWarehouseId().equals(targetWhWarehouse.getPhysicalWarehouseId())) {
            if (sourceWhGroup.getType().equals(targetWhGroup.getType())) {
                if (!sourceCommodityStatus.equals(targetCommodityStatus)) {
                    sameCommodityStatus = false;
                }
            } else {
                if (WhWarehouseVO.NOT_DEFECTIVE_COMMODITY_STATUS_DETAIL_MAP.containsKey(sourceCommodityStatus) && !sourceCommodityStatus.equals(targetCommodityStatus)) {
                    sameCommodityStatus = false;
                }
                if ((sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey()) || sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.MIDDLE_RESIDUE.getKey()) || sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.HEAVY_RESIDUE.getKey())) && WhWarehouseVO.NOT_DEFECTIVE_COMMODITY_STATUS_DETAIL_MAP.containsKey(targetCommodityStatus)) {
                    sameCommodityStatus = false;
                }
            }
        }
        if (!sameCommodityStatus) {
            throw new WarehouseException("WH0002", String.format("\u903b\u8f91\u4ed3[%s]%s,[%s]%s \u5546\u54c1\u72b6\u6001\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8c03\u62e8", sourceWhWarehouse.getCode(), sourceWhWarehouse.getName(), targetWhWarehouse.getCode(), targetWhWarehouse.getName()));
        }
        Integer sourceWhType = sourceWhGroup.getType();
        Integer targetWhType = targetWhGroup.getType();
        if (sourceWhType.equals(WhWarehouseGroupVO.WAREHOUSE_NO) && targetWhType.equals(WhWarehouseGroupVO.WAREHOUSE_YES) && sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey()) && !targetCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey())) {
            throw new WarehouseException("WH0002", String.format("\u975e\u4ed3\u5e93\u5f80\u4ed3\u5e93\u8c03\u62e8\uff0c\u4e14\u6e90\u4ed3\u5e93\u903b\u8f91\u4ed3\u5546\u54c1\u72b6\u6001\u4e3a\u6b8b\u6b21\u65f6\uff0c\u76ee\u6807\u4ed3\u903b\u8f91\u4ed3\u53ea\u80fd\u9009\u62e9\u5546\u54c1\u72b6\u6001\u4e3a\u8f7b\u6b8b\u7684", new Object[0]));
        }
        if (sourceWhType.equals(WhWarehouseGroupVO.WAREHOUSE_YES) && targetWhType.equals(WhWarehouseGroupVO.WAREHOUSE_NO) && (sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey()) || sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.MIDDLE_RESIDUE.getKey()) || sourceCommodityStatus.equals(WarehouseCommodityStatusEnum.HEAVY_RESIDUE.getKey())) && !targetCommodityStatus.equals(WarehouseCommodityStatusEnum.LIGHT_RESIDUE.getKey())) {
            throw new WarehouseException("WH0002", String.format("\u4ed3\u5e93\u5f80\u975e\u4ed3\u5e93\u8c03\u62e8\uff0c\u4e14\u6e90\u4ed3\u5e93\u903b\u8f91\u4ed3\u5546\u54c1\u72b6\u6001\u4e3a\u8f7b\u6b8b\u3001\u4e2d\u6b8b\u3001\u91cd\u6b8b\u65f6\uff0c\u76ee\u6807\u4ed3\u903b\u8f91\u4ed3\u53ea\u80fd\u9009\u62e9\u5546\u54c1\u72b6\u6001\u4e3a\u6b8b\u6b21\u7684", new Object[0]));
        }
    }

    private void allotFinishCommand(WhAllotRcd whAllotRcd, boolean isMoveOpt, boolean cleanCmdPhyWhCode) throws Exception {
        WhCommand whCommandOut = this.buildAltOutCommand(whAllotRcd);
        if (isMoveOpt) {
            whCommandOut.setInOutType(WhCommand.TYPE_MOVE_OUT);
        }
        Integer allotType = whAllotRcd.getAllotType();
        String outCmdCode = null;
        outCmdCode = WhAllotTypeEnum.AUTO_ALLOT_ONLINE.getVal() == allotType.intValue() ? this.whCommandService.createCommandAfterReleasePreOccupy(whCommandOut, whAllotRcd.getPreOccupyReleaseList()) : this.whCommandService.createCommand(whCommandOut);
        WhCommand tmpCmdOut = this.whCommandService.findCommandByCode(outCmdCode, false);
        if (cleanCmdPhyWhCode) {
            tmpCmdOut.setPhysicalWarehouseCode(null);
        }
        if (EmptyUtil.isNotEmpty((Object)whAllotRcd.getCreateUserId())) {
            tmpCmdOut.setOperatorId(whAllotRcd.getCreateUserId().longValue());
        } else {
            tmpCmdOut.setOperatorId(1L);
        }
        tmpCmdOut.setNoUpdateAllot(true);
        this.whCommandService.finishCommand(tmpCmdOut);
        WhCommand whCommandIn = this.buildAltInCommand(whAllotRcd);
        if (isMoveOpt) {
            whCommandIn.setInOutType(WhCommand.TYPE_MOVE_IN);
        }
        String inCmdCode = this.whCommandService.createCommand(whCommandIn);
        WhCommand tmpCmdIn = this.whCommandService.findCommandByCode(inCmdCode, false);
        if (cleanCmdPhyWhCode) {
            tmpCmdIn.setPhysicalWarehouseCode(null);
        }
        tmpCmdIn.setOperatorId(tmpCmdOut.getOperatorId());
        tmpCmdIn.setNoUpdateAllot(true);
        this.whCommandService.finishCommand(tmpCmdIn);
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_FINISHED);
        whAllotRcd.setFinishTime(new Date());
        this.whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);
    }

    private List<SStockReleaseDTO> buildAllotPreOccupyReleaseList(WhAllotRcd whAllotRcd) {
        ArrayList<SStockReleaseDTO> releaseList = new ArrayList<SStockReleaseDTO>();
        if (whAllotRcd != null) {
            List<WhAllotRcdSku> rcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
            for (WhAllotRcdSku rcdSku : rcdSkuList) {
                SStockReleaseDTO releaseDTO = new SStockReleaseDTO(SStockOccupyTypeEnum.ALLOT_PRE_OCCUPY);
                releaseDTO.setReferenceCode(rcdSku.getPreOccupyRefCode());
                releaseDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
                releaseList.add(releaseDTO);
            }
        }
        return releaseList;
    }

    private void finishAllotRcdCommand(WhAllotRcd whAllotRcd, boolean isMoveOpt, boolean cleanCmdPhyWhCode) throws Exception {
        WhCommand whCommandOut = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, whAllotRcd.getCode(), true);
        if (EmptyUtil.isEmpty((Object)whCommandOut)) {
            whCommandOut = this.buildAltOutCommand(whAllotRcd);
        } else {
            whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
            if (isMoveOpt) {
                whCommandOut.setInOutType(WhCommand.TYPE_MOVE_OUT);
            }
            whCommandOut.setPlanedDeliveryDate(whAllotRcd.getEstimatedAllocationDate());
            this.sWhCommandService.updateWhCommandByKey((SWhCommandVO)BeanUtil.buildFrom((Object)whCommandOut, SWhCommandVO.class));
            List<WhCommandSku> commandSkuList = whCommandOut.getWhCommandSkuList();
            if (EmptyUtil.isNotEmpty(commandSkuList)) {
                for (WhCommandSku whCommandSku : commandSkuList) {
                    WhInvOccupy record = new WhInvOccupy();
                    record.setReferenceCode(whCommandSku.getCode());
                    record.setOccupyType(WhCommand.TYPE_ALLOT_OUT);
                    if (isMoveOpt) {
                        record.setOccupyType(WhCommand.TYPE_MOVE_OUT);
                    }
                    this.whInvService.updateOccupyType(record);
                }
            }
        }
        WhCommand tmpCmdOut = this.whCommandService.findCommandByCode(whCommandOut.getCode(), false);
        if (cleanCmdPhyWhCode) {
            tmpCmdOut.setPhysicalWarehouseCode(null);
        }
        if (EmptyUtil.isNotEmpty((Object)whAllotRcd.getCreateUserId())) {
            tmpCmdOut.setOperatorId(whAllotRcd.getCreateUserId().longValue());
        } else {
            tmpCmdOut.setOperatorId(1L);
        }
        tmpCmdOut.setNoUpdateAllot(true);
        this.whCommandService.finishCommand(tmpCmdOut);
        WhCommand whCommandIn = this.buildAltInCommand(whAllotRcd);
        if (isMoveOpt) {
            whCommandIn.setInOutType(WhCommand.TYPE_MOVE_IN);
        }
        String inCmdCode = this.whCommandService.createCommand(whCommandIn);
        WhCommand tmpCmdIn = this.whCommandService.findCommandByCode(inCmdCode, false);
        if (cleanCmdPhyWhCode) {
            tmpCmdIn.setPhysicalWarehouseCode(null);
        }
        tmpCmdIn.setOperatorId(tmpCmdOut.getOperatorId());
        tmpCmdIn.setNoUpdateAllot(true);
        this.whCommandService.finishCommand(tmpCmdIn);
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_FINISHED);
        whAllotRcd.setFinishTime(new Date());
        this.whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);
    }

    private void outBoundProcess(WhAllotRcd whAllotRcd) throws Exception {
        WhCommand whCommand = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, whAllotRcd.getCode(), true);
        if (EmptyUtil.isEmpty((Object)whCommand) || CollectionUtils.isEmpty(whCommand.getWhCommandSkuList())) {
            throw new WarehouseException("CO0001", "command and commandSku not null");
        }
        if (EmptyUtil.isEmpty((Object)whCommand.getOperatorId()) && EmptyUtil.isNotEmpty((Object)whAllotRcd.getCreateUserId())) {
            whCommand.setOperatorId(whAllotRcd.getCreateUserId().longValue());
        }
        this.whCommandService.finishCommand(whCommand);
    }

    private boolean checkBeforCreate(List<WhAllotRcd> whAllotRcds) {
        HashSet<String> phyWhCodes = new HashSet<String>();
        String sourceWarehouseCode = null;
        String targetWarehouseCode = null;
        for (WhAllotRcd rcd : whAllotRcds) {
            if (EmptyUtil.isNotEmpty((String)rcd.getSourcePhysicalWarehouseCode())) {
                phyWhCodes.add(rcd.getSourcePhysicalWarehouseCode());
            }
            if (EmptyUtil.isNotEmpty((String)rcd.getTargetPhysicalWarehouseCode())) {
                phyWhCodes.add(rcd.getTargetPhysicalWarehouseCode());
            }
            sourceWarehouseCode = rcd.getSourceWarehouseCode();
            targetWarehouseCode = rcd.getTargetWarehouseCode();
            if (EmptyUtil.isEmpty((String)sourceWarehouseCode) || EmptyUtil.isEmpty((String)targetWarehouseCode)) {
                throw new WarehouseException("CO0001", "\u76ee\u6807\u4ed3\u548c\u6e90\u4ed3\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            if (!sourceWarehouseCode.equals(targetWarehouseCode)) continue;
            throw new WarehouseException("CO0001", "\u76ee\u6807\u4ed3\u548c\u6e90\u4ed3\u4e0d\u80fd\u4e00\u6837.");
        }
        if (phyWhCodes.isEmpty()) {
            return true;
        }
        List<WhWarehouseGroupVO> groupList = this.whWarehouseGroupService.findAll(true);
        HashMap<String, Long> whGroupMap = new HashMap<String, Long>();
        HashMap<String, Long> phyWhGroupMap = new HashMap<String, Long>();
        for (WhWarehouseGroupVO group : groupList) {
            List<WhPhysicalWarehouseVO> phyWhList;
            List<WhWarehouseVO> whList = group.getRelateWarehouses();
            if (EmptyUtil.isNotEmpty(whList)) {
                for (WhWarehouseVO wh : whList) {
                    whGroupMap.put(wh.getCode(), group.getId());
                }
            }
            if (!EmptyUtil.isNotEmpty(phyWhList = group.getRelatePhysicalWarehouses())) continue;
            for (WhPhysicalWarehouseVO phyWh : phyWhList) {
                phyWhGroupMap.put(phyWh.getCode(), group.getId());
            }
        }
        Long phyWhGroupId = null;
        Long whGroupId = null;
        for (WhAllotRcd rcd : whAllotRcds) {
            if (EmptyUtil.isNotEmpty((String)rcd.getSourcePhysicalWarehouseCode())) {
                phyWhGroupId = (Long)phyWhGroupMap.get(rcd.getSourcePhysicalWarehouseCode());
                whGroupId = (Long)whGroupMap.get(rcd.getSourceWarehouseCode());
                if (NullUtil.isNull((Object)phyWhGroupId) || NullUtil.isNull((Object)whGroupId) || !phyWhGroupId.equals(whGroupId)) {
                    throw new WarehouseException("WH0001", String.format("[%s][%s]\u4e0d\u662f\u540c\u4e00\u903b\u8f91\u4ed3\u5206\u7ec4", rcd.getSourcePhysicalWarehouseCode(), rcd.getSourceWarehouseCode()));
                }
            }
            if (!EmptyUtil.isNotEmpty((String)rcd.getTargetPhysicalWarehouseCode())) continue;
            phyWhGroupId = (Long)phyWhGroupMap.get(rcd.getTargetPhysicalWarehouseCode());
            whGroupId = (Long)whGroupMap.get(rcd.getTargetWarehouseCode());
            if (!NullUtil.isNull((Object)phyWhGroupId) && !NullUtil.isNull((Object)whGroupId) && phyWhGroupId.equals(whGroupId)) continue;
            throw new WarehouseException("WH0001", String.format("[%s][%s]\u4e0d\u662f\u540c\u4e00\u903b\u8f91\u4ed3\u5206\u7ec4", rcd.getTargetPhysicalWarehouseCode(), rcd.getTargetWarehouseCode()));
        }
        return true;
    }

    @Override
    public boolean isAllotDirectComplete(WhAllotRcd whAllotRcd) {
        WhPhysicalWarehouse targetPhysicalWarehouse = null;
        if (EmptyUtil.isNotEmpty((String)whAllotRcd.getTargetPhysicalWarehouseCode())) {
            targetPhysicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(whAllotRcd.getTargetPhysicalWarehouseCode());
        }
        return this.isWarehouseGroupChannelMove(whAllotRcd) || this.isWarehouseInnerMove(whAllotRcd) || whAllotRcd.isDiffProcess() && NullUtil.isNotNull((Object)targetPhysicalWarehouse) && !WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(targetPhysicalWarehouse.getWarehouseType());
    }

    @Override
    public boolean isAllotSecondConfirm(WhAllotRcd whAllotRcd) {
        WhWarehouseGroupVO whGroup;
        WhWarehouse sourceWh = this.whInfoService.findWarehouseByCode(whAllotRcd.getSourceWarehouseCode());
        WhWarehouse targetWh = this.whInfoService.findWarehouseByCode(whAllotRcd.getTargetWarehouseCode());
        return (this.isWarehouseInnerMove(whAllotRcd) || NullUtil.isNotNull((Object)sourceWh.getWarehouseGroupId()) && NullUtil.isNotNull((Object)targetWh.getWarehouseGroupId()) && sourceWh.getWarehouseGroupId().equals(targetWh.getWarehouseGroupId())) && WhWarehouseGroupVO.WAREHOUSE_YES.equals((whGroup = this.whWarehouseGroupService.findById(sourceWh.getWarehouseGroupId(), false)).getType()) && !sourceWh.getCommodityStatus().equals(targetWh.getCommodityStatus());
    }

    @Override
    public boolean isWarehouseInnerMove(WhAllotRcd whAllotRcd) {
        return EmptyUtil.isNotEmpty((String)whAllotRcd.getTargetPhysicalWarehouseCode()) && EmptyUtil.isNotEmpty((String)whAllotRcd.getSourcePhysicalWarehouseCode()) && whAllotRcd.getSourcePhysicalWarehouseCode().equals(whAllotRcd.getTargetPhysicalWarehouseCode());
    }

    @Override
    public boolean isWarehouseGroupChannelMove(WhAllotRcd whAllotRcd) {
        if (EmptyUtil.isNotEmpty((String)whAllotRcd.getTargetPhysicalWarehouseCode()) || EmptyUtil.isNotEmpty((String)whAllotRcd.getSourcePhysicalWarehouseCode())) {
            return false;
        }
        WhWarehouse sourceWh = this.whInfoService.findWarehouseByCode(whAllotRcd.getSourceWarehouseCode());
        WhWarehouse targetWh = this.whInfoService.findWarehouseByCode(whAllotRcd.getTargetWarehouseCode());
        return NullUtil.isNotNull((Object)sourceWh.getWarehouseGroupId()) && NullUtil.isNotNull((Object)targetWh.getWarehouseGroupId()) && sourceWh.getWarehouseGroupId().equals(targetWh.getWarehouseGroupId());
    }

    private WhWarehouse checkSourcePhyWhSkuStock(WhAllotRcd allotRcd) {
        if (EmptyUtil.isEmpty((String)allotRcd.getSourcePhysicalWarehouseCode()) || EmptyUtil.isEmpty((String)allotRcd.getSourceWarehouseCode()) || this.isWarehouseInnerMove(allotRcd)) {
            return null;
        }
        List<WhAllotRcdSku> allotRcdSkuList = allotRcd.getWhAllotRcdSkuList();
        HashMap<String, Integer> altSkuQuantityMap = new HashMap<String, Integer>();
        for (WhAllotRcdSku allotRcdSku : allotRcdSkuList) {
            Integer total = (Integer)altSkuQuantityMap.get(allotRcdSku.getSkuCode());
            if (NullUtil.isNull((Object)total)) {
                total = 0;
            }
            altSkuQuantityMap.put(allotRcdSku.getSkuCode(), total + allotRcdSku.getQuantity());
        }
        WhWarehouse warehouse = this.whInfoService.findWarehouseByCode(allotRcd.getSourceWarehouseCode());
        PhyWhStockCond cond = new PhyWhStockCond();
        cond.setPhysicalWarehouseCode(allotRcd.getSourcePhysicalWarehouseCode());
        cond.setSkuCodes(Arrays.asList(altSkuQuantityMap.keySet().toArray(new String[altSkuQuantityMap.size()])));
        cond.setSkuStatus(warehouse.getCommodityStatus());
        List<PhyWhStockVO> whStockList = this.whWmsSkuStockService.findPhyWhStockByCond(cond);
        HashMap<String, Integer> phyWhSkuStockMap = new HashMap<String, Integer>();
        if (EmptyUtil.isNotEmpty(whStockList)) {
            for (PhyWhStockVO phyWhStockVO : whStockList) {
                phyWhSkuStockMap.put(phyWhStockVO.getSkuCode(), phyWhStockVO.getCanUseQuantity());
            }
        }
        for (Map.Entry entry : altSkuQuantityMap.entrySet()) {
            Integer altQuantity = (Integer)entry.getValue();
            Integer skuCanQuantity = (Integer)phyWhSkuStockMap.get(entry.getKey());
            if (NullUtil.isNull((Object)skuCanQuantity)) {
                skuCanQuantity = 0;
            }
            if (altQuantity <= skuCanQuantity) continue;
            com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO pcsSkuVO = this.mcPcsSkuService.findByCode((String)entry.getKey());
            if (NullUtil.isNull((Object)pcsSkuVO)) {
                throw new WarehouseException("WH0001", String.format("[%s]\u4e0d\u5b58\u5728", entry.getKey()));
            }
            throw new WarehouseException("WH0001", String.format("[%s]\u7269\u7406\u4ed3\u5e93\u5b58\u4e0d\u8db3,[%s]%s,[%s][%s<%s]", allotRcd.getSourcePhysicalWarehouseCode(), pcsSkuVO.getCode(), pcsSkuVO.getNameCn(), WhCommand.getSkuStatusName(warehouse.getCommodityStatus()), skuCanQuantity, altQuantity));
        }
        return warehouse;
    }

    private String generatorAltCode(Long altId, Integer allotType) {
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("createTime", DateUtil.getNow());
        params.put("allotType", allotType);
        params.put("id", altId);
        return CodeGenerator.getInstance().generate("WH_ALLOT_RCD", params);
    }

    private WhCommand buildAltOutCommand(WhAllotRcd whAllotRcd) {
        WhCommand whCommandOut = new WhCommand();
        whCommandOut.setReferenceCode(whAllotRcd.getCode());
        whCommandOut.setPhysicalWarehouseCode(whAllotRcd.getSourcePhysicalWarehouseCode());
        whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
        whCommandOut.setWarehouseCode(whAllotRcd.getSourceWarehouseCode());
        whCommandOut.setPlanedDeliveryDate(whAllotRcd.getEstimatedAllocationDate());
        whCommandOut.setWhCommandSkuList(this.buildAltCommandSku(whAllotRcd));
        if (EmptyUtil.isNotEmpty((Object)whAllotRcd.getCreateUserId())) {
            whCommandOut.setOperatorId(Long.parseLong(whAllotRcd.getCreateUserId().toString()));
        } else {
            whCommandOut.setOperatorId(1L);
        }
        return whCommandOut;
    }

    private WhCommand buildAltInCommand(WhAllotRcd whAllotRcd) {
        WhCommand whCommandIn = new WhCommand();
        whCommandIn.setReferenceCode(whAllotRcd.getCode());
        whCommandIn.setInOutType(WhCommand.TYPE_ALLOT_IN);
        whCommandIn.setPhysicalWarehouseCode(whAllotRcd.getTargetPhysicalWarehouseCode());
        whCommandIn.setWarehouseCode(whAllotRcd.getTargetWarehouseCode());
        whCommandIn.setWhCommandSkuList(this.buildAltCommandSku(whAllotRcd));
        return whCommandIn;
    }

    private List<WhCommandSku> buildAltCommandSku(WhAllotRcd whAllotRcd) {
        ArrayList<WhCommandSku> whCommandSkuList = new ArrayList<WhCommandSku>();
        if (EmptyUtil.isNotEmpty(whAllotRcd.getWhAllotRcdSkuList())) {
            for (WhAllotRcdSku whAllotRcdSku : whAllotRcd.getWhAllotRcdSkuList()) {
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(whAllotRcdSku.getSkuCode());
                whCommandSku.setPlanedQuantity(whAllotRcdSku.getQuantity());
                if (whAllotRcd.isDiffProcess() && whAllotRcd.isNeedWaitInBound()) {
                    whCommandSku.setQuantity(whAllotRcdSku.getQuantity());
                }
                whCommandSkuList.add(whCommandSku);
            }
        }
        return whCommandSkuList;
    }

    private void buildAltEstimatedAllocationDate(WhAllotRcd whAllotRcd) {
        if (NullUtil.isNull((Object)whAllotRcd.getEstimatedAllocationDate())) {
            Calendar cal = Calendar.getInstance();
            int currHour = cal.get(11);
            if (currHour < 16) {
                whAllotRcd.setEstimatedAllocationDate(DateUtil.getNow());
            } else {
                whAllotRcd.setEstimatedAllocationDate(DateUtil.addDay((Date)DateUtil.getNow(), (int)1));
            }
        }
    }

    private void buildAllotDiffDetailVOs(WhAllotRcd whAllotRcd, WhAllotRcdSku whAllotRcdSku, List<WhAllotDiffDetailVO> allotDiffDetailVOs) {
        WhAllotDiffDetailVO whAllotDiffDetailVO = new WhAllotDiffDetailVO();
        whAllotDiffDetailVO.setCreateTime(DateUtil.getNow());
        whAllotDiffDetailVO.setOperatorId(whAllotRcd.getCreateUserId());
        whAllotDiffDetailVO.setSkuCode(whAllotRcdSku.getSkuCode());
        whAllotDiffDetailVO.setQuantity(whAllotRcdSku.getQuantity());
        whAllotDiffDetailVO.setProcessType(WhAllotDiffDetailVO.PROCESS_TYPE_CALLBACK);
        whAllotDiffDetailVO.setWarehouseCode(whAllotRcd.getTargetWarehouseCode());
        whAllotDiffDetailVO.setRefId(whAllotRcd.getOldAllotId());
        allotDiffDetailVOs.add(whAllotDiffDetailVO);
    }

    @Override
    @Transactional
    public String createAutoTransferAllot(WhAllotRcd whAllotRcd) throws Exception {
        String sourceWarehouseCode = whAllotRcd.getSourceWarehouseCode();
        String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();
        if (EmptyUtil.isEmpty((String)sourceWarehouseCode) || EmptyUtil.isEmpty((String)targetWarehouseCode)) {
            throw new WarehouseException("CO0001", "\u76ee\u6807\u4ed3\u548c\u6e90\u4ed3\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION);
        whAllotRcd.setCreateTime(DateUtil.getNow());
        this.buildAltEstimatedAllocationDate(whAllotRcd);
        this.whAllotRcdMapper.insert(whAllotRcd);
        String code = this.generatorAltCode(whAllotRcd.getId(), whAllotRcd.getAllotType());
        whAllotRcd.setCode(code);
        this.whAllotRcdMapper.updateByPrimaryKeySelective(whAllotRcd);
        List<WhAllotRcdSku> whAllotRcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
        if (EmptyUtil.isEmpty(whAllotRcdSkuList)) {
            throw new WarehouseException("CO0001", "\u8c03\u62e8\u884c\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
            whAllotRcdSku.setAllotRcdId(whAllotRcd.getId());
            this.whAllotRcdSkuMapper.insert(whAllotRcdSku);
        }
        if (whAllotRcd.getAllotType() != 12) {
            if (Constants.warehouseMap.containsKey(targetWarehouseCode)) {
                this.syncTmallStock(this.getSyncSkuList(whAllotRcdSkuList, 1), (String)Constants.warehouseMap.get(targetWarehouseCode), code);
            }
            if (Constants.warehouseMap.containsKey(sourceWarehouseCode)) {
                this.syncTmallStock(this.getSyncSkuList(whAllotRcdSkuList, 0), (String)Constants.warehouseMap.get(sourceWarehouseCode), code);
            }
        }
        return code;
    }

    @Override
    @Transactional
    public String createPreAllotRcd(WhPreAllotRcd whPreAllotRcd) throws Exception {
        this.checkPreAllot(Collections.singletonList(whPreAllotRcd));
        return this.createPreAllot(whPreAllotRcd);
    }

    private String createPreAllot(WhPreAllotRcd whPreAllotRcd) throws Exception {
        this.whPreAllotRcdMapper.insert(whPreAllotRcd);
        List<WhPreAllotRcdSku> whAllotRcdSkuList = whPreAllotRcd.getWhPreAllotRcdSkuList();
        if (whAllotRcdSkuList != null && !whAllotRcdSkuList.isEmpty()) {
            for (WhPreAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
                whAllotRcdSku.setPreAllotId(whPreAllotRcd.getId());
                this.whPreAllotRcdSkuMapper.insert(whAllotRcdSku);
            }
        } else {
            throw new WarehouseException("CO0001", "whAllotRcdSkuList can not be empty.");
        }
        return whPreAllotRcd.getCode();
    }

    private void checkPreAllot(List<WhPreAllotRcd> whPreAllotRcds) {
        HashSet<String> phyWhCodes = new HashSet<String>();
        String sourceWarehouseCode = null;
        String targetWarehouseCode = null;
        for (WhPreAllotRcd rcd : whPreAllotRcds) {
            if (EmptyUtil.isNotEmpty((String)rcd.getSourcePhysicalWarehouseCode())) {
                phyWhCodes.add(rcd.getSourcePhysicalWarehouseCode());
            }
            if (EmptyUtil.isNotEmpty((String)rcd.getTargetPhysicalWarehouseCode())) {
                phyWhCodes.add(rcd.getTargetPhysicalWarehouseCode());
            }
            sourceWarehouseCode = rcd.getSourceWarehouseCode();
            targetWarehouseCode = rcd.getTargetWarehouseCode();
            if (EmptyUtil.isEmpty((String)sourceWarehouseCode) || EmptyUtil.isEmpty((String)targetWarehouseCode)) {
                throw new WarehouseException("CO0001", "\u76ee\u6807\u4ed3\u548c\u6e90\u4ed3\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            if (!sourceWarehouseCode.equals(targetWarehouseCode)) continue;
            throw new WarehouseException("CO0001", "\u76ee\u6807\u4ed3\u548c\u6e90\u4ed3\u4e0d\u80fd\u4e00\u6837.");
        }
        if (phyWhCodes.isEmpty()) {
            return;
        }
        List<WhWarehouseGroupVO> groupList = this.whWarehouseGroupService.findAll(true);
        HashMap<String, Long> whGroupMap = new HashMap<String, Long>();
        HashMap<String, Long> phyWhGroupMap = new HashMap<String, Long>();
        for (WhWarehouseGroupVO group : groupList) {
            List<WhPhysicalWarehouseVO> phyWhList;
            List<WhWarehouseVO> whList = group.getRelateWarehouses();
            if (EmptyUtil.isNotEmpty(whList)) {
                for (WhWarehouseVO wh : whList) {
                    whGroupMap.put(wh.getCode(), group.getId());
                }
            }
            if (!EmptyUtil.isNotEmpty(phyWhList = group.getRelatePhysicalWarehouses())) continue;
            for (WhPhysicalWarehouseVO phyWh : phyWhList) {
                phyWhGroupMap.put(phyWh.getCode(), group.getId());
            }
        }
        Long phyWhGroupId = null;
        Long whGroupId = null;
        for (WhPreAllotRcd rcd : whPreAllotRcds) {
            if (EmptyUtil.isNotEmpty((String)rcd.getSourcePhysicalWarehouseCode())) {
                phyWhGroupId = (Long)phyWhGroupMap.get(rcd.getSourcePhysicalWarehouseCode());
                whGroupId = (Long)whGroupMap.get(rcd.getSourceWarehouseCode());
                if (NullUtil.isNull((Object)phyWhGroupId) || NullUtil.isNull((Object)whGroupId) || !phyWhGroupId.equals(whGroupId)) {
                    throw new WarehouseException("WH0001", String.format("[%s][%s]\u4e0d\u662f\u540c\u4e00\u903b\u8f91\u4ed3\u5206\u7ec4", rcd.getSourcePhysicalWarehouseCode(), rcd.getSourceWarehouseCode()));
                }
            }
            if (!EmptyUtil.isNotEmpty((String)rcd.getTargetPhysicalWarehouseCode())) continue;
            phyWhGroupId = (Long)phyWhGroupMap.get(rcd.getTargetPhysicalWarehouseCode());
            whGroupId = (Long)whGroupMap.get(rcd.getTargetWarehouseCode());
            if (!NullUtil.isNull((Object)phyWhGroupId) && !NullUtil.isNull((Object)whGroupId) && phyWhGroupId.equals(whGroupId)) continue;
            throw new WarehouseException("WH0001", String.format("[%s][%s]\u4e0d\u662f\u540c\u4e00\u903b\u8f91\u4ed3\u5206\u7ec4", rcd.getTargetPhysicalWarehouseCode(), rcd.getTargetWarehouseCode()));
        }
    }

    public List<TmallStockLog> syncTmallStock(List<PcsSkuVO> skuList, String sessionKey, String code) throws Exception {
        ArrayList tmallStockLogList = Lists.newArrayList();
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (PcsSkuVO pcsSkuVO : skuList) {
                this.whCommandService.checkTmallSku(this.pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), sessionKey), pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), sessionKey);
            }
            for (PcsSkuVO pcsSkuVO : skuList) {
                TmallStockLog tmallStockLog = this.whCommandService.synCommodityStocksAllot(this.pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), sessionKey), pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), sessionKey, 1, code);
                this.tmallStockLogMapper.insertSelective(tmallStockLog);
                if (tmallStockLog.getSyncStatus() != 1) continue;
                tmallStockLogList.add(tmallStockLog);
            }
        }
        return tmallStockLogList;
    }

    public List<TmallStockLog> syncTmallStockAllot(List<PcsSkuVO> skuList, String sessionKey, String code) throws Exception {
        ArrayList tmallStockLogList = Lists.newArrayList();
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (PcsSkuVO pcsSkuVO : skuList) {
                TmallStockLog tmallStockLog = this.whCommandService.synCommodityStocksAllot(this.pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), sessionKey), pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), sessionKey, 1, code);
                try {
                    this.tmallStockLogMapper.insertSelective(tmallStockLog);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tmallStockLogList.add(tmallStockLog);
            }
        }
        return tmallStockLogList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TmallStockLog> syncTmallStockAllotNew(List<PcsSkuVO> skuList, String channelCode, String referenceCode) throws Exception {
        ArrayList tmallStockLogList = Lists.newArrayList();
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (PcsSkuVO pcsSkuVO : skuList) {
                TmallStockLog tmallStockLog = new TmallStockLog();
                try {
                    tmallStockLog = this.whCommandService.synCommodityStocksAllot(this.pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), channelCode), pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), channelCode, 1, referenceCode);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage());
                    tmallStockLog.setSkuCode(pcsSkuVO.getCode());
                    tmallStockLog.setReferenceCode(referenceCode);
                    tmallStockLog.setSyncType(1);
                    tmallStockLog.setCreateTime(new Date());
                    tmallStockLog.setChannelCode(channelCode);
                    tmallStockLog.setSyncStatus((short)0);
                    tmallStockLog.setDealStatus((short)1);
                    tmallStockLog.setQuantity(pcsSkuVO.getQuantity());
                    tmallStockLog.setRemark("\u4e0d\u660e\u5f02\u5e38");
                }
                finally {
                    tmallStockLog.setReferenceCode(pcsSkuVO.getSkuLineCode());
                }
                try {
                    this.tmallStockLogMapper.insertSelective(tmallStockLog);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tmallStockLogList.add(tmallStockLog);
            }
        }
        return tmallStockLogList;
    }

    private List<PcsSkuVO> getSyncSkuList(List<WhAllotRcdSku> whAllotRcdSkuList, int in) {
        ArrayList<PcsSkuVO> skuList = new ArrayList<PcsSkuVO>();
        if (EmptyUtil.isNotEmpty(whAllotRcdSkuList)) {
            for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
                if (!whAllotRcdSku.isSyncThridParty()) continue;
                PcsSkuVO pcsSku = new PcsSkuVO();
                pcsSku.setCode(whAllotRcdSku.getSkuCode());
                pcsSku.setSkuLineCode(whAllotRcdSku.getPreOccupyRefCode());
                if (in == 1) {
                    pcsSku.setQuantity(whAllotRcdSku.getQuantity());
                } else {
                    pcsSku.setQuantity(-whAllotRcdSku.getQuantity().intValue());
                }
                skuList.add(pcsSku);
            }
        }
        return skuList;
    }

    @Override
    @Transactional
    public List<String> createAllotRcds(List<WhAllotRcd> whAllotRcds) throws Exception {
        this.checkBeforCreate(whAllotRcds);
        ArrayList<String> codes = new ArrayList<String>();
        for (WhAllotRcd whAllotRcd : whAllotRcds) {
            String code = this.createAllot(whAllotRcd);
            codes.add(code);
        }
        return codes;
    }

    @Override
    @Transactional
    public boolean recordAllotRcd(List<WhAllotRcd> whAllotRcds) {
        ArrayList<WhCommand> cmdList = new ArrayList<WhCommand>();
        whAllotRcds.forEach(whAllotRcd -> {
            this.whAllotRcdMapper.insert((WhAllotRcd)whAllotRcd);
            String code = this.generatorAltCode(whAllotRcd.getId(), whAllotRcd.getAllotType());
            whAllotRcd.setCode(code);
            this.whAllotRcdMapper.updateByPrimaryKeySelective((WhAllotRcd)whAllotRcd);
            whAllotRcd.getWhAllotRcdSkuList().forEach(rcdSku -> rcdSku.setAllotRcdId(whAllotRcd.getId()));
            this.whAllotRcdSkuMapper.batchInsert(whAllotRcd.getWhAllotRcdSkuList());
            WhCommand outCmd = this.buildAltOutCommand((WhAllotRcd)whAllotRcd);
            outCmd.getWhCommandSkuList().forEach(cmdSku -> {
                cmdSku.setQuantity(cmdSku.getPlanedQuantity());
                cmdSku.setDamagedQuantity(0);
            });
            outCmd.setCommandStatus(WhCommand.STATUS_DELIVERYCOMPLETION);
            outCmd.setProcessTime(DateUtil.getNow());
            cmdList.add(outCmd);
            WhCommand inCmd = this.buildAltInCommand((WhAllotRcd)whAllotRcd);
            inCmd.getWhCommandSkuList().forEach(cmdSku -> {
                cmdSku.setQuantity(cmdSku.getPlanedQuantity());
                cmdSku.setDamagedQuantity(0);
            });
            inCmd.setCommandStatus(WhCommand.STATUS_QUALITY_FINISHED);
            inCmd.setProcessTime(DateUtil.getNow());
            cmdList.add(inCmd);
        });
        this.whCommandService.recordCommand(cmdList);
        return true;
    }

    @Override
    public List<WhAllotRcd> autoAllotCreateRcds(List<WhAllotRcd> whAllotRcds) throws Exception {
        this.checkBeforCreate(whAllotRcds);
        if (whAllotRcds == null) {
            return null;
        }
        this.autoAllotPreOccupy(whAllotRcds);
        final ArrayList<SStockReleaseDTO> preOccupyReleaseList = new ArrayList<SStockReleaseDTO>();
        final ArrayList<WhAllotRcd> newAllotRcds = new ArrayList<WhAllotRcd>();
        for (WhAllotRcd rcd : whAllotRcds) {
            int lineSize;
            this.syncTmallStock(rcd, false);
            this.trySyncJdStockNew(rcd, false);
            this.syncTmallStock(rcd, true);
            this.trySyncJdStockNew(rcd, true);
            rcd.setNoSyncOtherPlatform(true);
            List<WhAllotRcdSku> whAllotRcdSkuList = rcd.getWhAllotRcdSkuList();
            int n = lineSize = whAllotRcdSkuList == null ? 0 : whAllotRcdSkuList.size();
            if (lineSize > 0) {
                newAllotRcds.add(rcd);
            }
            if (lineSize != 0) continue;
            preOccupyReleaseList.addAll(rcd.getPreOccupyReleaseList());
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionStatus) {
                WhAllotServiceImpl.this.sStockService.release(preOccupyReleaseList);
                ArrayList<String> codes = new ArrayList<String>();
                try {
                    for (WhAllotRcd whAllotRcd : newAllotRcds) {
                        String code = null;
                        code = WhAllotServiceImpl.this.createAllot(whAllotRcd);
                        codes.add(code);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
                return null;
            }
        });
        return newAllotRcds;
    }

    @Override
    @Transactional
    public void autoAllotPreOccupy(List<WhAllotRcd> whAllotRcds) throws Exception {
        ArrayList<SStockOccupyDTO> occupyList = new ArrayList<SStockOccupyDTO>();
        for (WhAllotRcd rcd : whAllotRcds) {
            String warehouseCode = rcd.getSourceWarehouseCode();
            List<WhAllotRcdSku> whAllotRcdSkuList = rcd.getWhAllotRcdSkuList();
            if (whAllotRcdSkuList == null || whAllotRcdSkuList.size() == 0) continue;
            for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
                SStockOccupyDTO stockOccupyDTO = new SStockOccupyDTO();
                stockOccupyDTO.setQuantity(whAllotRcdSku.getQuantity());
                stockOccupyDTO.setWarehouseCode(warehouseCode);
                stockOccupyDTO.setSkuCode(whAllotRcdSku.getSkuCode());
                stockOccupyDTO.setOccupyType(SStockOccupyTypeEnum.ALLOT_PRE_OCCUPY);
                stockOccupyDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
                stockOccupyDTO.setReferenceCode(whAllotRcdSku.getPreOccupyRefCode());
                occupyList.add(stockOccupyDTO);
            }
            rcd.setPreOccupyReleaseList(this.buildAllotPreOccupyReleaseList(rcd));
        }
        ServiceResp rsp = this.sStockService.occupy(occupyList);
        if (rsp.isFailure()) {
            this.log.info("\u81ea\u52a8\u5206\u8d27\u9884\u5360\u7528\u5931\u8d25\u53c2\u6570\uff1a", (Object)JSON.toJSONString(occupyList));
            throw new WarehouseException("\u9884\u5360\u7528\u5e93\u5b58\u5931\u8d25,", rsp.getRespMsg());
        }
    }

    private int syncTmallStock(WhAllotRcd whAllotRcd, boolean inStorage) throws Exception {
        StringBuilder synErrorMsg = new StringBuilder("");
        String sourceWarehouseCode = whAllotRcd.getSourceWarehouseCode();
        String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();
        List<WhAllotRcdSku> whAllotRcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
        if (CollectionUtils.isNotEmpty(whAllotRcd.getPcsSkus())) {
            for (com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO pcsSkuVO : whAllotRcd.getPcsSkus()) {
                if (!EmptyUtil.isNotEmpty((Object)pcsSkuVO.getCanCustomize()) || pcsSkuVO.getCanCustomize() != 1) continue;
                whAllotRcd.setNoSyncOtherPlatform(true);
                break;
            }
        }
        ArrayList successSynTmall = Lists.newArrayList();
        Boolean buildFlag = true;
        if (EmptyUtil.isEmpty((String)whAllotRcd.getRemark()) || whAllotRcd.getRemark().indexOf("\u9884\u552e") == -1) {
            List<TmallStockLog> list;
            if (Constants.warehouseMap.containsKey(sourceWarehouseCode) && !whAllotRcd.isNoSyncOtherPlatform() && !inStorage) {
                list = this.syncTmallStockAllotNew(this.getSyncSkuList(whAllotRcdSkuList, 0), (String)Constants.warehouseMap.get(sourceWarehouseCode), "");
                for (TmallStockLog tmallStockLog : list) {
                    if (tmallStockLog.getSyncStatus() == 1) {
                        successSynTmall.add(tmallStockLog);
                        continue;
                    }
                    synErrorMsg.append("SKU[" + tmallStockLog.getSkuCode() + "]" + tmallStockLog.getRemark() + "\r\n");
                }
                if (buildFlag.booleanValue()) {
                    whAllotRcdSkuList = this.buildTmallAllotSkus(successSynTmall);
                }
            }
            if (Constants.warehouseMap.containsKey(targetWarehouseCode) && !whAllotRcd.isNoSyncOtherPlatform() && inStorage) {
                list = this.syncTmallStockAllotNew(this.getSyncSkuList(whAllotRcdSkuList, 1), (String)Constants.warehouseMap.get(targetWarehouseCode), "");
                for (TmallStockLog tmallStockLog : list) {
                    if (tmallStockLog.getSyncStatus() == 1) {
                        successSynTmall.add(tmallStockLog);
                        continue;
                    }
                    synErrorMsg.append("SKU[" + tmallStockLog.getSkuCode() + "]" + tmallStockLog.getRemark() + "\r\n");
                }
                whAllotRcdSkuList = this.buildTmallAllotSkus(successSynTmall);
                buildFlag = false;
            }
        }
        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        return whAllotRcdSkuList.size();
    }

    @Override
    @Transactional
    public boolean createAllotRcdAndPrdcJobOccupy(List<WhAllotRcd> whAllotRcds, List<WhInvOccupy> whJobInvOccupyList, List<WhJitPackageSkuReferenceVO> whJobJitPackageSkuReferenceVOList) throws Exception {
        if (EmptyUtil.isNotEmpty(whAllotRcds)) {
            this.createAllotRcds(whAllotRcds);
        }
        if (EmptyUtil.isNotEmpty(whJobInvOccupyList)) {
            this.whInvService.occupy(whJobInvOccupyList, whJobJitPackageSkuReferenceVOList);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean cancelAllotRcdByCode(String code) throws Exception {
        WhAllotRcd whAllotRcd = this.findAllotRcdByCode(code, false);
        if (NullUtil.isNull((Object)whAllotRcd)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u8c03\u62e8\u5355\u4e0d\u5b58\u5728", code));
        }
        if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(whAllotRcd.getAllotStatus()) || WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(whAllotRcd.getAllotStatus())) {
            WhCommand cmd;
            if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(whAllotRcd.getAllotStatus()) && NullUtil.isNotNull((Object)(cmd = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, whAllotRcd.getCode(), false))) && !WhCommand.STATUS_IN_PROCESSING.equals(cmd.getCommandStatus())) {
                throw new WarehouseException("WH0001", "\u4ed3\u5e93\u5df2\u7ecf\u5f00\u59cb\u4f5c\u4e1a\uff0c\u5982\u9700\u53d6\u6d88\u8bf7\u8054\u7cfb\u4ed3\u5e93");
            }
            this.updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_CANCELED);
            return true;
        }
        throw new WarehouseException("WH0001", String.format("[%s]\u72b6\u6001[%s]\u65e0\u6cd5\u53d6\u6d88!", code, whAllotRcd.getAllotStatusStr()));
    }

    @Override
    public Map<String, Boolean> isAllotCanCancel(List<String> codes) {
        WhCommandCond cmdCond = new WhCommandCond();
        cmdCond.setReferenceCodeList(codes);
        cmdCond.setInOutType(WhCommand.TYPE_ALLOT_OUT);
        List<WhCommand> cmdList = this.whCommandService.findCommandByCond(cmdCond);
        HashMap<String, WhCommand> cmdMap = new HashMap<String, WhCommand>();
        if (EmptyUtil.isNotEmpty(cmdList)) {
            for (WhCommand cmd : cmdList) {
                cmdMap.put(cmd.getReferenceCode(), cmd);
            }
        }
        WhAllotCond cond = new WhAllotCond();
        cond.setCodes(codes);
        List<WhAllotRcd> list = this.selectAllotRcdByCond(cond);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhAllotRcd allot : list) {
                WhCommand cmd;
                map.put(allot.getCode(), false);
                if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(allot.getAllotStatus())) {
                    map.put(allot.getCode(), true);
                    continue;
                }
                if (!WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(allot.getAllotStatus()) || !NullUtil.isNotNull((Object)(cmd = (WhCommand)cmdMap.get(allot.getCode()))) || !WhCommand.STATUS_IN_PROCESSING.equals(cmd.getCommandStatus())) continue;
                map.put(allot.getCode(), true);
            }
        }
        return map;
    }

    @Override
    @Transactional
    public boolean cancelAllotRcdByCodeForCustomization(String code) throws Exception {
        WhAllotRcd whAllotRcd = this.findAllotRcdByCode(code, false);
        if (NullUtil.isNotNull((Object)whAllotRcd) && (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(whAllotRcd.getAllotStatus()) || WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(whAllotRcd.getAllotStatus()) && WhAllotRcd.TYPE_CUSTOMIZE_OUT.equals(whAllotRcd.getAllotType()))) {
            this.whJitPackageSkuReferenceService.finishByReferenceCode(code);
            this.updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_CANCELED);
            return true;
        }
        throw new WarehouseException("CO0002", "\u8c03\u62e8\u5355\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d6\u6d88");
    }

    @Override
    public boolean cancelAllotRcdByCodeFromWms(String code) throws Exception {
        WhAllotRcd whAllotRcd = this.findAllotRcdByCode(code, false);
        if (whAllotRcd == null) {
            throw new WarehouseException("CO0002", "whAllotRcd is null .");
        }
        this.updateAllotRcdStatus(whAllotRcd, WhAllotRcd.STATUS_CANCELED);
        return true;
    }

    @Override
    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku) {
        WhAllotRcd result = null;
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhAllotRcd> whAllotRcdList = this.whAllotRcdMapper.selectByExample(example);
        if (whAllotRcdList != null && !whAllotRcdList.isEmpty()) {
            result = whAllotRcdList.get(0);
            if (fetchSku) {
                result.setWhAllotRcdSkuList(this.findAllotRcdSkuByAllotId(result.getId()));
            }
        }
        return result;
    }

    @Override
    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku, boolean fetchRefPackageSku) {
        List<WhJitPackageSkuReferenceVO> jitPackageSkuReferenceVOs;
        WhAllotRcd whAllotRcd = this.findAllotRcdByCode(code, fetchSku);
        if (whAllotRcd != null && fetchRefPackageSku && CollectionUtils.isNotEmpty(jitPackageSkuReferenceVOs = this.whJitPackageSkuReferenceService.findByReferenceCode(code))) {
            whAllotRcd.setJitPackageSkuReferenceVOs(jitPackageSkuReferenceVOs);
        }
        return whAllotRcd;
    }

    @Override
    public List<WhAllotDiffDetailVO> findAllotDiffDetailByExample(WhAllotDiffDetailVO allotDiffDetailVO) {
        WhAllotDiffDetailExample example = new WhAllotDiffDetailExample();
        WhAllotDiffDetailExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)allotDiffDetailVO.getRefId())) {
            criteria.andRefIdEqualTo(allotDiffDetailVO.getRefId());
        } else if (CollectionUtils.isNotEmpty(allotDiffDetailVO.getRefIds())) {
            criteria.andRefIdIn((List)allotDiffDetailVO.getRefIds());
        }
        if (EmptyUtil.isNotEmpty((String)allotDiffDetailVO.getSkuCode())) {
            criteria.andSkuCodeEqualTo(allotDiffDetailVO.getSkuCode());
        } else if (CollectionUtils.isNotEmpty(allotDiffDetailVO.getSkuCodes())) {
            criteria.andSkuCodeIn((List)allotDiffDetailVO.getSkuCodes());
        }
        if (EmptyUtil.isNotEmpty((String)allotDiffDetailVO.getWarehouseCode())) {
            criteria.andWarehouseCodeEqualTo(allotDiffDetailVO.getWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((Object)allotDiffDetailVO.getProcessType())) {
            criteria.andProcessTypeEqualTo(allotDiffDetailVO.getProcessType());
        }
        List<WhAllotDiffDetail> allotDiffDetails = this.whAllotDiffDetailMapper.selectByExample(example);
        return BeanUtil.buildListFrom(allotDiffDetails, WhAllotDiffDetailVO.class);
    }

    @Override
    public List<WhAllotDiffDetailVO> listAllotDiffDetailByCode(WhAllotDiffDetailVO allotDiffDetailVO) {
        return this.whAllotDiffDetailCustomMapper.listAllotDiffDetailByCond(allotDiffDetailVO);
    }

    @Override
    public WhAllotRcd findAllotRcdById(Long id) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andIdEqualTo(id);
        WhAllotRcd whAllotRcd = this.whAllotRcdMapper.selectByPrimaryKey(id);
        return whAllotRcd;
    }

    @Override
    public Integer countRefPackCancelQuantityAfterAllotFinished(WhAllotCond cond) {
        Integer count = this.whAllotRcdMapper.countRefPackCancelQuantityAfterAllotFinished(cond);
        return count == null ? 0 : count;
    }

    @Override
    public WhAllotRcd findAllotRcdByTypeAndReferenceCode(Integer type, String referenceCode, boolean fetchSku) {
        WhAllotRcd result = null;
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotTypeEqualTo(type).andReferenceCodeEqualTo(referenceCode);
        List<WhAllotRcd> whAllotRcdList = this.whAllotRcdMapper.selectByExample(example);
        if (whAllotRcdList != null && !whAllotRcdList.isEmpty()) {
            result = whAllotRcdList.get(0);
            if (fetchSku) {
                result.setWhAllotRcdSkuList(this.findAllotRcdSkuByAllotId(result.getId()));
            }
        }
        return result;
    }

    @Override
    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond) {
        List<WhPreAllotRcdVO> whAllotRcdList = this.whPreAllotRcdMapper.findPreAllotRcdByCond(cond);
        return whAllotRcdList;
    }

    @Override
    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond, boolean fetchSku, boolean fetchCountQuantity) {
        List<WhPreAllotRcdVO> whAllotRcdList = this.whPreAllotRcdMapper.findPreAllotRcdByCond(cond);
        if (fetchSku) {
            for (WhPreAllotRcdVO vo : whAllotRcdList) {
                vo.setWhPreAllotRcdSkuList(this.findPreAllotRcdSkuByPreId(vo.getId()));
            }
        }
        if (fetchCountQuantity) {
            for (WhPreAllotRcdVO vo : whAllotRcdList) {
                vo.setWhPreAllotRcdSkuCountQuantityList(this.findPreAllotRcdSkuCountQuantityByPreId(vo.getId()));
            }
        }
        return whAllotRcdList;
    }

    @Override
    public List<WhPreAllotRcdSku> findPreAllotRcdSkuByPreId(Long preId) {
        WhPreAllotRcdSkuExample example = new WhPreAllotRcdSkuExample();
        example.createCriteria().andPreAllotIdEqualTo(preId);
        return this.whPreAllotRcdSkuMapper.findPreAllotRcdSkuByPreId(example);
    }

    @Override
    public List<WhPreAllotRcdSku> findPreAllotRcdSkuCountQuantityByPreId(Long preId) {
        WhPreAllotRcdSkuExample example = new WhPreAllotRcdSkuExample();
        example.createCriteria().andPreAllotIdEqualTo(preId);
        return this.whPreAllotRcdSkuMapper.findPreAllotRcdSkuCountQuantityByPreId(example);
    }

    @Override
    public List<WhPreAllotRcdDownloadVO> findPreAllotRcdListByCond(WhAllotCond cond) {
        List<WhPreAllotRcdDownloadVO> whAllotRcdList = this.whPreAllotRcdMapper.findPreAllotRcdListByCond(cond);
        return whAllotRcdList;
    }

    @Override
    @Transactional
    public String autoCreateAllotRcd(WhPreAllotRcdVO vo) {
        Date finishDate;
        String allotCode = null;
        Date date = finishDate = EmptyUtil.isNotEmpty((Object)vo.getEstimatedFinishedDate()) ? DateUtil.dayEnd((Date)vo.getEstimatedFinishedDate()) : null;
        if (finishDate != null && Calendar.getInstance().getTimeInMillis() >= finishDate.getTime()) {
            WhPreAllotRcd whPreAllotRcd = new WhPreAllotRcd();
            whPreAllotRcd.setId(vo.getId());
            whPreAllotRcd.setAllotStatus(3);
            int count = this.whPreAllotRcdMapper.updateByPrimaryKeySelective(whPreAllotRcd);
            if (count > 0) {
                WhPreAllotRcd preAllotRcd = this.whPreAllotRcdMapper.selectByPrimaryKey(whPreAllotRcd.getId());
                allotCode = preAllotRcd != null ? preAllotRcd.getCode() : null;
            }
        } else {
            WhPreAllotRcdSkuExample example = new WhPreAllotRcdSkuExample();
            example.createCriteria().andPreAllotIdEqualTo(vo.getId());
            List<WhPreAllotRcdSku> whPreAllotRcdSkuList = this.whPreAllotRcdSkuMapper.selectByExample(example);
            boolean isAllFinish = true;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int totalAmount = 0;
            int totalNeedAmount = 0;
            WhWarehouse sourceWh = this.whInfoService.findWarehouseByCode(vo.getSourceWarehouseCode());
            for (WhPreAllotRcdSku whPreAllotRcdSku : whPreAllotRcdSkuList) {
                if (whPreAllotRcdSku.getQuantity() <= whPreAllotRcdSku.getFinishQuantity()) continue;
                totalNeedAmount += whPreAllotRcdSku.getQuantity() - whPreAllotRcdSku.getFinishQuantity();
                Integer canUseQuantity = this.findSkuCanUseQuantity(whPreAllotRcdSku.getSkuCode(), sourceWh, vo.getSourcePhysicalWarehouseCode());
                if (canUseQuantity != null) {
                    int needAmount = whPreAllotRcdSku.getQuantity() - whPreAllotRcdSku.getFinishQuantity();
                    if (canUseQuantity >= needAmount) {
                        map.put(whPreAllotRcdSku.getSkuCode(), needAmount);
                        totalAmount += needAmount;
                        continue;
                    }
                    isAllFinish = false;
                    if (canUseQuantity <= 0) continue;
                    map.put(whPreAllotRcdSku.getSkuCode(), canUseQuantity);
                    totalAmount += canUseQuantity.intValue();
                    continue;
                }
                isAllFinish = false;
            }
            WhAllotRcd whAllotRcd = null;
            if (totalAmount >= vo.getMinAmount()) {
                whAllotRcd = this.buildWhAllotRcd(vo, map);
            } else if (totalNeedAmount < vo.getMinAmount() && totalAmount == totalNeedAmount) {
                whAllotRcd = this.buildWhAllotRcd(vo, map);
            }
            if (whAllotRcd != null) {
                try {
                    allotCode = this.createAllotRcd(whAllotRcd);
                    WhPreAllotRcd whPreAllotRcd = new WhPreAllotRcd();
                    whPreAllotRcd.setId(vo.getId());
                    if (isAllFinish) {
                        whPreAllotRcd.setAllotStatus(3);
                        this.whPreAllotRcdMapper.updateByPrimaryKeySelective(whPreAllotRcd);
                    } else {
                        whPreAllotRcd.setAllotStatus(2);
                        this.whPreAllotRcdMapper.updateByPrimaryKeySelective(whPreAllotRcd);
                    }
                    for (WhPreAllotRcdSku whPreAllotRcdSku : whPreAllotRcdSkuList) {
                        if (map.get(whPreAllotRcdSku.getSkuCode()) == null) continue;
                        whPreAllotRcdSku.setFinishQuantity(whPreAllotRcdSku.getFinishQuantity() + map.get(whPreAllotRcdSku.getSkuCode()));
                        this.whPreAllotRcdSkuMapper.updateByPrimaryKeySelective(whPreAllotRcdSku);
                    }
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        }
        return allotCode;
    }

    private Integer findSkuCanUseQuantity(String skuCode, WhWarehouse warehouse, String physicalWarehouseCode) {
        Integer whCanUseQuantity = 0;
        Integer phyWhCanUseQuantity = 0;
        WhInvVO whInvVO = this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, warehouse.getCode());
        if (NullUtil.isNotNull((Object)whInvVO)) {
            whCanUseQuantity = whInvVO.getCanUseInv();
        }
        if (EmptyUtil.isEmpty((String)physicalWarehouseCode)) {
            return whCanUseQuantity;
        }
        PhyWhStockCond cond = new PhyWhStockCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuCode(skuCode);
        cond.setSkuStatus(warehouse.getCommodityStatus());
        List<PhyWhStockVO> whStockList = this.whWmsSkuStockService.findPhyWhStockByCond(cond);
        if (EmptyUtil.isNotEmpty(whStockList)) {
            PhyWhStockVO stock = whStockList.get(0);
            phyWhCanUseQuantity = stock.getCanUseQuantity();
        }
        return Math.min(whCanUseQuantity, phyWhCanUseQuantity);
    }

    private WhAllotRcd buildWhAllotRcd(WhPreAllotRcdVO vo, HashMap<String, Integer> map) {
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
        whAllotRcd.setTargetPhysicalWarehouseCode(vo.getTargetPhysicalWarehouseCode());
        whAllotRcd.setTargetWarehouseCode(vo.getTargetWarehouseCode());
        whAllotRcd.setSourcePhysicalWarehouseCode(vo.getSourcePhysicalWarehouseCode());
        whAllotRcd.setSourceWarehouseCode(vo.getSourceWarehouseCode());
        whAllotRcd.setReferenceCode(vo.getCode());
        whAllotRcd.setRemark(vo.getRemark());
        whAllotRcd.setCreateUserId(vo.getCreateUserId() == null ? 1 : vo.getCreateUserId().intValue());
        ArrayList<WhAllotRcdSku> skuList = new ArrayList<WhAllotRcdSku>();
        whAllotRcd.setWhAllotRcdSkuList(skuList);
        if (map != null && map.size() > 0) {
            for (String key : map.keySet()) {
                WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                whAllotRcdSku.setSkuCode(key);
                whAllotRcdSku.setQuantity(map.get(key));
                skuList.add(whAllotRcdSku);
            }
        } else {
            return null;
        }
        return whAllotRcd;
    }

    @Override
    public List<WhAllotRcd> findAllotRcdByCond(WhAllotCond cond) {
        List<WhAllotRcd> whAllotRcdList = this.whAllotRcdMapper.findAllotRcdByCond(cond);
        if (cond.isFetch() && EmptyUtil.isNotEmpty(whAllotRcdList)) {
            ArrayList<Long> whAllotRcdIdList = new ArrayList<Long>();
            for (WhAllotRcd whAllotRcd : whAllotRcdList) {
                whAllotRcdIdList.add(whAllotRcd.getId());
            }
            List<WhAllotRcdSku> whAllotRcdSkuList = this.findAllotRcdSkuByAllotIds(whAllotRcdIdList);
            for (WhAllotRcd whAllotRcd : whAllotRcdList) {
                for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
                    if (!whAllotRcd.getId().equals(whAllotRcdSku.getAllotRcdId())) continue;
                    List<WhAllotRcdSku> t = whAllotRcd.getWhAllotRcdSkuList();
                    if (t == null) {
                        t = new ArrayList<WhAllotRcdSku>();
                        whAllotRcd.setWhAllotRcdSkuList(t);
                    }
                    t.add(whAllotRcdSku);
                }
            }
        }
        return whAllotRcdList;
    }

    @Override
    public List<WhAllotRcd> selectAllotRcdByCond(WhAllotCond cond) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        WhAllotRcdExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            criteria.andCodeIn((List)cond.getCodes());
        }
        List<WhAllotRcd> whAllotRcdList = this.whAllotRcdMapper.selectByExample(example);
        if (cond.isFetch() && EmptyUtil.isNotEmpty(whAllotRcdList)) {
            ArrayList<Long> whAllotRcdIdList = new ArrayList<Long>();
            for (WhAllotRcd whAllotRcd : whAllotRcdList) {
                whAllotRcdIdList.add(whAllotRcd.getId());
            }
            List<WhAllotRcdSku> whAllotRcdSkuList = this.findAllotRcdSkuByAllotIds(whAllotRcdIdList);
            for (WhAllotRcd whAllotRcd : whAllotRcdList) {
                for (WhAllotRcdSku whAllotRcdSku : whAllotRcdSkuList) {
                    if (!whAllotRcd.getId().equals(whAllotRcdSku.getAllotRcdId())) continue;
                    List<WhAllotRcdSku> t = whAllotRcd.getWhAllotRcdSkuList();
                    if (t == null) {
                        t = new ArrayList<WhAllotRcdSku>();
                        whAllotRcd.setWhAllotRcdSkuList(t);
                    }
                    t.add(whAllotRcdSku);
                }
            }
        }
        return whAllotRcdList;
    }

    @Override
    public List<WhAllotRcd> getAllotRcdByCond(WhAllotCond cond) {
        List<WhAllotRcd> whAllotRcdList = this.whAllotRcdMapper.getAllotRcdByCond(cond);
        return whAllotRcdList;
    }

    @Override
    @Transactional
    public void updateWhPreAllotRcdByCond(WhPreAllotRcd whPreAllotRcd) {
        if (whPreAllotRcd.getId() == null && whPreAllotRcd.getCode() != null) {
            WhPreAllotRcdExample example = new WhPreAllotRcdExample();
            example.createCriteria().andCodeEqualTo(whPreAllotRcd.getCode());
            List<WhPreAllotRcd> list = this.whPreAllotRcdMapper.selectByExample(example);
            if (list != null && list.size() > 0) {
                whPreAllotRcd.setId(list.get(0).getId());
            }
        }
        if (whPreAllotRcd.getId() != null) {
            this.whPreAllotRcdMapper.updateByPrimaryKeySelective(whPreAllotRcd);
        }
    }

    @Override
    public List<WhAllotRcdSku> findAllotRcdSkuByAllotId(Long allotId) {
        WhAllotRcdSkuExample example = new WhAllotRcdSkuExample();
        example.createCriteria().andAllotRcdIdEqualTo(allotId);
        example.setOrderByClause("id");
        return this.whAllotRcdSkuMapper.selectByExample(example);
    }

    private List<WhAllotRcdSku> findAllotRcdSkuByAllotIds(List<Long> allotIdList) {
        WhAllotRcdSkuExample example = new WhAllotRcdSkuExample();
        example.createCriteria().andAllotRcdIdIn((List)allotIdList);
        example.setOrderByClause("id");
        return this.whAllotRcdSkuMapper.selectByExample(example);
    }

    @Override
    public List<WhAllotRcdSku> findAllotRcdSkuByAllotCode(String allotCode) {
        WhAllotRcd whAllotRcd = this.findAllotRcdByCode(allotCode, false);
        return whAllotRcd != null ? this.findAllotRcdSkuByAllotId(whAllotRcd.getId()) : new ArrayList();
    }

    @Override
    public List<WhAllotRcd> findAllotRcdWaitForConfirmation(String warehouseCode) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotStatusEqualTo(WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION).andConfirmWarehouseCodeEqualTo(warehouseCode);
        example.setOrderByClause("id");
        return this.whAllotRcdMapper.selectByExample(example);
    }

    @Override
    public List<WhAllotRcd> findAllotRcdWaitForOutbound(String warehouseCode) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotStatusEqualTo(WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND).andSourceWarehouseCodeEqualTo(warehouseCode);
        example.setOrderByClause("id");
        return this.whAllotRcdMapper.selectByExample(example);
    }

    @Override
    public List<WhAllotRcd> findAllotRcdWaitForInbound(String warehouseCode) {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotStatusEqualTo(WhAllotRcd.STATUS_WAIT_FOR_INBOUND).andTargetWarehouseCodeEqualTo(warehouseCode);
        example.setOrderByClause("id");
        return this.whAllotRcdMapper.selectByExample(example);
    }

    @Override
    public boolean updateAllotRcdStatusById(Long id, Integer newStatus) throws Exception {
        WhAllotRcd rcd = this.whAllotRcdMapper.selectByPrimaryKey(id);
        return rcd != null ? this.updateAllotRcdStatus(rcd, newStatus) : false;
    }

    @Override
    public boolean updateAllotRcdStatusByCode(String code, Integer newStatus) throws Exception {
        WhAllotRcd rcd = this.findAllotRcdByCode(code, false);
        return rcd != null ? this.updateAllotRcdStatus(rcd, newStatus) : false;
    }

    @Override
    public boolean updateAllotRcdStatusByCodeNew(String code, Integer newStatus, String rejectedReason) throws Exception {
        WhAllotRcd rcd = this.findAllotRcdByCode(code, false);
        return rcd != null ? this.updateAllotRcdStatusNew(rcd, newStatus, rejectedReason) : false;
    }

    @Transactional
    public boolean updateAllotRcdStatus(WhAllotRcd rcd, Integer newStatus) throws Exception {
        Integer oldStatus = rcd.getAllotStatus();
        if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus) && WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(newStatus)) {
            boolean diffProcess = rcd.isDiffProcess();
            boolean needWaitInBound = rcd.isNeedWaitInBound();
            rcd = this.findAllotRcdByCode(rcd.getCode(), true);
            rcd.setDiffProcess(diffProcess);
            rcd.setNeedWaitInBound(needWaitInBound);
            WhCommand whCommandOut = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, rcd.getCode(), true);
            if (EmptyUtil.isEmpty((Object)whCommandOut)) {
                whCommandOut = this.buildAltOutCommand(rcd);
                whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
                whCommandOut.setExpressNo(rcd.getCode());
                this.whCommandService.createCommand(whCommandOut);
            } else {
                whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
                whCommandOut.setPlanedDeliveryDate(rcd.getEstimatedAllocationDate());
                this.whCommandService.updateCommand(whCommandOut);
                List<WhCommandSku> commandSkuList = whCommandOut.getWhCommandSkuList();
                if (EmptyUtil.isNotEmpty(commandSkuList)) {
                    for (WhCommandSku whCommandSku : commandSkuList) {
                        WhInvOccupy record = new WhInvOccupy();
                        record.setReferenceCode(whCommandSku.getCode());
                        record.setOccupyType(WhCommand.TYPE_ALLOT_OUT);
                        this.whInvService.updateOccupyType(record);
                    }
                }
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus) && WhAllotRcd.STATUS_WAIT_FOR_INBOUND.equals(newStatus)) {
            rcd = this.findAllotRcdByCode(rcd.getCode(), false);
            WhCommand whCommand = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, rcd.getCode(), true);
            ArrayList<WhCommandSku> whCommandSkuList = new ArrayList<WhCommandSku>();
            for (WhCommandSku allotOutWhCommandSku : whCommand.getWhCommandSkuList()) {
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(allotOutWhCommandSku.getSkuCode());
                int quantity = allotOutWhCommandSku.getQuantity();
                if (quantity == 0) continue;
                whCommandSku.setPlanedQuantity(quantity);
                whCommandSkuList.add(whCommandSku);
            }
            if (whCommandSkuList.size() == 0) {
                newStatus = WhAllotRcd.STATUS_FINISHED;
                rcd.setFinishTime(new Date());
                if (rcd.getAllotType() == WhAllotRcd.TYPE_CONSUMABLE) {
                    // empty if block
                }
            } else {
                WhCommand whCommandIn = this.buildAltInCommand(rcd);
                whCommandIn.setReferenceCode(rcd.getCode());
                whCommandIn.setWhCommandSkuList(whCommandSkuList);
                this.whCommandService.createCommand(whCommandIn);
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_INBOUND.equals(oldStatus) && WhAllotRcd.STATUS_FINISHED.equals(newStatus)) {
            rcd.setFinishTime(new Date());
        } else if (WhAllotRcd.STATUS_CANCELED.equals(newStatus)) {
            if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)) {
                this.releaseAllotOccupation(rcd.getCode());
            } else if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus)) {
                String commandReferenceCode = rcd.getCode();
                if (this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode, false) != null && !this.whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode)) {
                    throw new WarehouseException("WH0102", "\u8c03\u62e8\u5355\u53d6\u6d88\u5931\u8d25");
                }
            } else if (!WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)) {
                String commandReferenceCode = rcd.getCode();
                if (this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode, false) != null && !this.whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode)) {
                    throw new WarehouseException("WH0102", "updateAllotRcdStatus failed[cancel] , code = " + commandReferenceCode + " , oldStatus = " + oldStatus + " , newStatus = " + newStatus);
                }
                if (this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_IN, commandReferenceCode, false) != null && !this.whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_IN, rcd.getCode())) {
                    throw new WarehouseException("WH0102", "updateAllotRcdStatus failed[cancel] , code = " + rcd.getCode() + " , oldStatus = " + oldStatus + " , newStatus = " + newStatus);
                }
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus) && WhAllotRcd.STATUS_REJECTED.equals(newStatus)) {
            this.releaseAllotOccupation(rcd.getCode());
        } else {
            if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus) && WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(newStatus)) {
                return true;
            }
            throw new WarehouseException("WH0106", "updateAllotRcdStatus failed,status illegal");
        }
        rcd.setAllotStatus(newStatus);
        return this.whAllotRcdMapper.updateByPrimaryKeySelective(rcd) != 0;
    }

    @Transactional
    public boolean updateAllotRcdStatusNew(WhAllotRcd rcd, Integer newStatus, String rejectedReason) throws Exception {
        Integer oldStatus = rcd.getAllotStatus();
        if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus) && WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(newStatus)) {
            rcd = this.findAllotRcdByCode(rcd.getCode(), true);
            rcd.setConfirmTime(DateUtil.getNow());
            ArrayList<WhCommandSku> whCommandSkuList = new ArrayList<WhCommandSku>();
            for (WhAllotRcdSku whAllotRcdSku : rcd.getWhAllotRcdSkuList()) {
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(whAllotRcdSku.getSkuCode());
                whCommandSku.setPlanedQuantity(whAllotRcdSku.getQuantity());
                whCommandSkuList.add(whCommandSku);
            }
            WhCommand whCommandOut = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, rcd.getCode(), true);
            if (EmptyUtil.isEmpty((Object)whCommandOut)) {
                whCommandOut = new WhCommand();
                whCommandOut.setReferenceCode(rcd.getCode());
                whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
                whCommandOut.setPlanedDeliveryDate(rcd.getEstimatedAllocationDate());
                whCommandOut.setWarehouseCode(rcd.getSourceWarehouseCode());
                whCommandOut.setWhCommandSkuList(whCommandSkuList);
                whCommandOut.setExpressNo(rcd.getCode());
                this.whCommandService.createCommand(whCommandOut);
            } else {
                whCommandOut.setInOutType(WhCommand.TYPE_ALLOT_OUT);
                whCommandOut.setPlanedDeliveryDate(rcd.getEstimatedAllocationDate());
                this.whCommandService.updateCommand(whCommandOut);
                List<WhCommandSku> commandSkuList = whCommandOut.getWhCommandSkuList();
                if (EmptyUtil.isNotEmpty(commandSkuList)) {
                    for (WhCommandSku whCommandSku : commandSkuList) {
                        WhInvOccupy record = new WhInvOccupy();
                        record.setReferenceCode(whCommandSku.getCode());
                        record.setOccupyType(WhCommand.TYPE_ALLOT_OUT);
                        this.whInvService.updateOccupyType(record);
                    }
                }
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus) && WhAllotRcd.STATUS_WAIT_FOR_INBOUND.equals(newStatus)) {
            rcd = this.findAllotRcdByCode(rcd.getCode(), false);
            WhCommand whCommand = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, rcd.getCode(), true);
            ArrayList<WhCommandSku> whCommandSkuList = new ArrayList<WhCommandSku>();
            for (WhCommandSku allotOutWhCommandSku : whCommand.getWhCommandSkuList()) {
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(allotOutWhCommandSku.getSkuCode());
                int quantity = allotOutWhCommandSku.getQuantity();
                if (quantity == 0) continue;
                whCommandSku.setPlanedQuantity(quantity);
                whCommandSkuList.add(whCommandSku);
            }
            if (whCommandSkuList.size() == 0) {
                newStatus = WhAllotRcd.STATUS_FINISHED;
                rcd.setFinishTime(new Date());
                if (rcd.getAllotType() == WhAllotRcd.TYPE_CONSUMABLE) {
                    // empty if block
                }
            } else {
                WhCommand whCommandIn = new WhCommand();
                whCommandIn.setReferenceCode(rcd.getCode());
                whCommandIn.setInOutType(WhCommand.TYPE_ALLOT_IN);
                whCommandIn.setWarehouseCode(rcd.getTargetWarehouseCode());
                whCommandIn.setWhCommandSkuList(whCommandSkuList);
                this.whCommandService.createCommand(whCommandIn);
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_INBOUND.equals(oldStatus) && WhAllotRcd.STATUS_FINISHED.equals(newStatus)) {
            rcd.setFinishTime(new Date());
        } else if (WhAllotRcd.STATUS_CANCELED.equals(newStatus)) {
            if (!WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus)) {
                String commandReferenceCode = rcd.getCode();
                if (this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode, false) != null && !this.whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OUT, commandReferenceCode)) {
                    throw new WarehouseException("WH0102", "updateAllotRcdStatus failed[cancel] , code = " + commandReferenceCode + " , oldStatus = " + oldStatus + " , newStatus = " + newStatus);
                }
                if (this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_IN, commandReferenceCode, false) != null && !this.whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_IN, rcd.getCode())) {
                    throw new WarehouseException("WH0102", "updateAllotRcdStatus failed[cancel] , code = " + rcd.getCode() + " , oldStatus = " + oldStatus + " , newStatus = " + newStatus);
                }
            } else {
                this.releaseAllotOccupation(rcd.getCode());
            }
        } else if (WhAllotRcd.STATUS_WAIT_FOR_CONFIRMATION.equals(oldStatus) && WhAllotRcd.STATUS_REJECTED.equals(newStatus)) {
            this.releaseAllotOccupation(rcd.getCode());
            rcd.setRejectedReason(rejectedReason);
        } else {
            if (WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(oldStatus) && WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND.equals(newStatus)) {
                return true;
            }
            throw new WarehouseException("WH0106", "updateAllotRcdStatus failed,status illegal");
        }
        rcd.setAllotStatus(newStatus);
        return this.whAllotRcdMapper.updateByPrimaryKeySelective(rcd) != 0;
    }

    private void releaseAllotOccupation(String referenceCode) {
        WhCommand whCommand = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, referenceCode, true);
        if (whCommand != null && whCommand.getWhCommandSkuList() != null) {
            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
                whReleaseOccupationVO.setOccupyType(WhCommand.TYPE_ALLOT_OCCUPY);
                this.whInvService.releaseOccupation(whReleaseOccupationVO);
            }
        }
        this.whCommandService.cancelCommandByTypeAndReferenceCode(WhCommand.TYPE_ALLOT_OCCUPY, referenceCode);
    }

    @Override
    @Transactional
    public List<String> createAllotRcdByList(List<WhAllotRcdVO> whAllotRcdVOList) throws Exception {
        HashMap<String, WhAllotRcd> map = new HashMap<String, WhAllotRcd>();
        ArrayList<String> list = new ArrayList<String>();
        if (whAllotRcdVOList != null && whAllotRcdVOList.size() > 0) {
            for (WhAllotRcdVO whAllotRcdVO : whAllotRcdVOList) {
                WhAllotRcd whAllotRcd;
                WhInvVO canUseQttByWhDispathing = this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(whAllotRcdVO.getSkuCode(), whAllotRcdVO.getSourceWarehouseCode());
                if (canUseQttByWhDispathing.getCanUseInv() < whAllotRcdVO.getPlanAmount()) {
                    throw new RuntimeException("\u8c03\u62e8\u6570\u91cf\u4e0d\u8db3");
                }
                if (map.get(whAllotRcdVO.getSourceWarehouseCode() + "_" + whAllotRcdVO.getTargetWarehouseCode()) == null) {
                    whAllotRcd = new WhAllotRcd();
                    whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
                    whAllotRcd.setSourceWarehouseCode(whAllotRcdVO.getSourceWarehouseCode());
                    whAllotRcd.setTargetWarehouseCode(whAllotRcdVO.getTargetWarehouseCode());
                    whAllotRcd.setRemark("\u9884\u552eSKU\u5e93\u95f4\u81ea\u52a8\u8c03\u62e8");
                    map.put(whAllotRcdVO.getSourceWarehouseCode() + "_" + whAllotRcdVO.getTargetWarehouseCode(), whAllotRcd);
                }
                whAllotRcd = (WhAllotRcd)map.get(whAllotRcdVO.getSourceWarehouseCode() + "_" + whAllotRcdVO.getTargetWarehouseCode());
                this.buildWhAllotRcd(whAllotRcd, whAllotRcdVO.getSkuCode(), whAllotRcdVO.getPlanAmount());
            }
        }
        if (map.size() > 0) {
            for (WhAllotRcd whAllotRcd : map.values()) {
                list.add(this.createAllotRcd(whAllotRcd));
            }
        }
        return list;
    }

    private void buildWhAllotRcd(WhAllotRcd whAllotRcd, String skuCode, Integer quantity) {
        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
        whAllotRcdSku.setSkuCode(skuCode);
        whAllotRcdSku.setQuantity(quantity);
        if (whAllotRcd.getWhAllotRcdSkuList() != null && whAllotRcd.getWhAllotRcdSkuList().size() > 0) {
            whAllotRcd.getWhAllotRcdSkuList().add(whAllotRcdSku);
        } else {
            ArrayList<WhAllotRcdSku> whAllotRcdSkus = new ArrayList<WhAllotRcdSku>();
            whAllotRcdSkus.add(whAllotRcdSku);
            whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkus);
        }
    }

    @Override
    @Transactional
    public boolean revertAllotRcd(String code) throws Exception {
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhAllotRcd> whAllotRcdList = this.whAllotRcdMapper.selectByExample(example);
        if (whAllotRcdList != null && whAllotRcdList.size() > 0) {
            WhAllotRcd whAllotRcd = whAllotRcdList.get(0);
            WhAllotRcd whAllotRcd1 = new WhAllotRcd();
            whAllotRcd1.setAllotType(WhAllotRcd.TYPE_NORMAL);
            whAllotRcd1.setSourceWarehouseCode(whAllotRcd.getTargetWarehouseCode());
            whAllotRcd1.setTargetWarehouseCode(whAllotRcd.getSourceWarehouseCode());
            ArrayList<WhAllotRcdSku> list = new ArrayList<WhAllotRcdSku>();
            WhAllotRcdSkuExample example1 = new WhAllotRcdSkuExample();
            example1.createCriteria().andAllotRcdIdEqualTo(whAllotRcd.getId());
            List<WhAllotRcdSku> skuList = this.whAllotRcdSkuMapper.selectByExample(example1);
            for (WhAllotRcdSku whAllotRcdSku : skuList) {
                WhAllotRcdSku whAllotRcdSku1 = new WhAllotRcdSku();
                whAllotRcdSku1.setQuantity(whAllotRcdSku.getQuantity());
                whAllotRcdSku1.setSkuCode(whAllotRcdSku.getSkuCode());
                list.add(whAllotRcdSku1);
            }
            whAllotRcd1.setWhAllotRcdSkuList(list);
            this.createAllotRcd(whAllotRcd1);
        }
        return true;
    }

    @Override
    @Transactional
    public List<String> batchCreatePreAllotRcd(List<WhPreAllotRcd> whPreAllotRcdList) throws Exception {
        this.checkPreAllot(whPreAllotRcdList);
        ArrayList<String> allotCodeList = new ArrayList<String>();
        if (EmptyUtil.isNotEmpty(whPreAllotRcdList)) {
            for (WhPreAllotRcd whPreAllotRcd : whPreAllotRcdList) {
                allotCodeList.add(this.createPreAllot(whPreAllotRcd));
            }
        }
        return allotCodeList;
    }

    @Override
    public boolean updateAllotRcd(WhAllotRcd rcd) {
        return this.whAllotRcdMapper.updateByPrimaryKeySelective(rcd) != 0;
    }

    @Override
    public boolean updateAllotRcdSku(WhAllotRcdSku rcdSku) {
        return this.whAllotRcdSkuMapper.updateByPrimaryKeySelective(rcdSku) != 0;
    }

    @Override
    @Transactional
    public boolean allotPackageInbound(WhAllotPackageInBoundVO altPackageInBound) {
        WhWmsConnectAllotPackageVO altPackage = this.whWmsConnectAllotPackageService.findConnectAltPackage(altPackageInBound.getCode());
        if (NullUtil.isNull((Object)altPackage)) {
            throw new WarehouseException("WH0001", String.format("\u8c03\u62e8\u7bb1\u53f7[%s]\u4e0d\u5b58\u5728", altPackageInBound.getCode()));
        }
        if (!WhWmsConnectAllotPackageVO.STATUS_WAITING_RECEIVE.equals(altPackage.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u8c03\u62e8\u7bb1\u53f7[%s]\u5f53\u524d\u72b6\u6001[%s]", altPackage.getCode(), altPackage.getStatusName()));
        }
        altPackage.setStatus(WhWmsConnectAllotPackageVO.STATUS_RECEIVED);
        this.whWmsConnectAllotPackageService.updateCnnectAltPackage(altPackage);
        List<WhWmsConnectAllotPackageVO> altPackageList = this.whWmsConnectAllotPackageService.findByConnectId(altPackage.getConnectId());
        boolean allAltPackageDone = this.isAllAltPackageInBoundDone(altPackageList);
        altPackageInBound.setLastPackage(allAltPackageDone);
        altPackageInBound.setPhysicalWarehouseCode(altPackage.getTargetPhysicalWarehouseCode());
        altPackageInBound.setWarehouseCode(altPackage.getTargetWarehouseCode());
        WhWarehouse warehouse = this.whInfoService.findWarehouseByCode(altPackageInBound.getWarehouseCode());
        altPackageInBound.setWhCommodityStatus(warehouse.getCommodityStatus());
        List<WhAllotPackageInBoundSkuDetailVO> fixInBoundSkuDetailList = this.rebuildAltPackageInboundSkuDetail(altPackageInBound, altPackage);
        altPackageInBound.setInBoundSkuDetailList(fixInBoundSkuDetailList);
        this.whCommandService.processAllotPackageInBound(altPackageInBound);
        return true;
    }

    private boolean isAllAltPackageInBoundDone(List<WhWmsConnectAllotPackageVO> altPackageList) {
        for (WhWmsConnectAllotPackageVO altPackage : altPackageList) {
            if (WhWmsConnectAllotPackageVO.STATUS_RECEIVED.equals(altPackage.getStatus())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private List<WhAllotPackageInBoundSkuDetailVO> rebuildAltPackageInboundSkuDetail(WhAllotPackageInBoundVO altPackageInBound, WhWmsConnectAllotPackageVO altPackage) {
        List<WhAllotPackageInBoundSkuDetailVO> inBoundSkuDetailList = altPackageInBound.getInBoundSkuDetailList();
        if (EmptyUtil.isEmpty(inBoundSkuDetailList)) {
            return null;
        }
        HashMap<String, Integer> inSkuQtMap = new HashMap<String, Integer>();
        HashMap<String, Integer> inBarcodeQtMap = new HashMap<String, Integer>();
        HashMap<String, Integer> outSkuQtMap = new HashMap<String, Integer>();
        HashMap<String, List<String>> outSkuBarcodeMap = new HashMap<String, List<String>>();
        HashMap<String, Integer> outBarcodeQtMap = new HashMap<String, Integer>();
        this.altPackgeInBoundSkuGroup(altPackageInBound, inSkuQtMap, inBarcodeQtMap);
        this.altPackgeOutBoundSkuGroup(altPackage, outSkuQtMap, outSkuBarcodeMap, outBarcodeQtMap);
        for (Map.Entry inSkuQtEntry : inSkuQtMap.entrySet()) {
            void var11_11;
            Integer n = (Integer)outSkuQtMap.get(inSkuQtEntry.getKey());
            if (NullUtil.isNull((Object)n)) {
                Integer n2 = 0;
            }
            if (var11_11.compareTo((Integer)inSkuQtEntry.getValue()) >= 0) continue;
            throw new WarehouseException("WH0001", String.format("[%s]\u5165\u5e93\u6570\u91cf\u8d85\u51fa\u88c5\u7bb1\u5355\u6570\u91cf[%s>%s]", inSkuQtEntry.getKey(), inSkuQtEntry.getKey(), var11_11));
        }
        this.checkAltInBarcode(inBarcodeQtMap.keySet());
        HashMap<String, Integer> restOutBarcodeQtMap = new HashMap<String, Integer>(outBarcodeQtMap);
        for (Map.Entry entry : inBarcodeQtMap.entrySet()) {
            Integer outTotal = (Integer)restOutBarcodeQtMap.get(entry.getKey());
            if (NullUtil.isNull((Object)outTotal)) continue;
            restOutBarcodeQtMap.put((String)entry.getKey(), outTotal - (Integer)entry.getValue());
        }
        ArrayList<WhAllotPackageInBoundSkuDetailVO> fixedInDetailList = new ArrayList<WhAllotPackageInBoundSkuDetailVO>();
        for (WhAllotPackageInBoundSkuDetailVO inBoundSkuDetail : inBoundSkuDetailList) {
            if (EmptyUtil.isNotEmpty((String)inBoundSkuDetail.getBarCode())) {
                fixedInDetailList.add(inBoundSkuDetail);
                continue;
            }
            Integer needQt = inBoundSkuDetail.getQuantity();
            if (needQt == 0) continue;
            List barcodeList = (List)outSkuBarcodeMap.get(inBoundSkuDetail.getSkuCode());
            for (String barcode : barcodeList) {
                Integer barcodeQt = (Integer)restOutBarcodeQtMap.get(barcode);
                if (barcodeQt <= 0) {
                    restOutBarcodeQtMap.remove(barcode);
                    continue;
                }
                Integer canUse = Math.min(needQt, barcodeQt);
                needQt = needQt - canUse;
                barcodeQt = barcodeQt - canUse;
                restOutBarcodeQtMap.put(barcode, barcodeQt);
                WhAllotPackageInBoundSkuDetailVO partSkuDetail = (WhAllotPackageInBoundSkuDetailVO)BeanUtil.buildFrom((Object)inBoundSkuDetail, WhAllotPackageInBoundSkuDetailVO.class);
                partSkuDetail.setQuantity(canUse);
                partSkuDetail.setBarCode(barcode);
                fixedInDetailList.add(partSkuDetail);
                if (needQt != 0) continue;
                break;
            }
            if (needQt == 0) continue;
            throw new WarehouseException("WH0001", String.format("[%s]\u5165\u5e93\u6570\u91cf\u5f02\u5e38", inBoundSkuDetail.getQuantity()));
        }
        return fixedInDetailList;
    }

    private void checkAltInBarcode(Set<String> barcodes) {
        ArrayList<String> list = new ArrayList<String>(barcodes);
        if (EmptyUtil.isEmpty(list)) {
            return;
        }
        Map<String, WhWmsSkuBarcodeVO> bacodeMap = this.whWmsSkuBarcodeService.getBarcodeMap(list);
        for (String bacode : barcodes) {
            WhWmsSkuBarcodeVO barcodeVO = bacodeMap.get(bacode);
            if (!NullUtil.isNull((Object)barcodeVO)) continue;
            throw new WarehouseException("WH0001", String.format("\u4e0d\u5b58\u5728\u6279\u6b21[%s]", bacode));
        }
    }

    private void altPackgeOutBoundSkuGroup(WhWmsConnectAllotPackageVO altPackage, Map<String, Integer> outSkuQtMap, Map<String, List<String>> outSkuBarcodeMap, Map<String, Integer> outBarcodeQtMap) {
        for (WhWmsConnectAllotPackageDetailVO allotPackageDetail : altPackage.getDetails()) {
            if (allotPackageDetail.getQuantity() == 0) continue;
            Integer total = outSkuQtMap.get(allotPackageDetail.getSkuCode());
            if (NullUtil.isNull((Object)total)) {
                total = 0;
            }
            outSkuQtMap.put(allotPackageDetail.getSkuCode(), total + allotPackageDetail.getQuantity());
            Integer barcodeTotal = outBarcodeQtMap.get(allotPackageDetail.getBarCode());
            if (NullUtil.isNull((Object)barcodeTotal)) {
                barcodeTotal = 0;
            }
            outBarcodeQtMap.put(allotPackageDetail.getBarCode(), barcodeTotal + allotPackageDetail.getQuantity());
            List<String> barcodeList = outSkuBarcodeMap.get(allotPackageDetail.getSkuCode());
            if (NullUtil.isNull(barcodeList)) {
                barcodeList = new ArrayList<String>();
                outSkuBarcodeMap.put(allotPackageDetail.getSkuCode(), barcodeList);
            }
            if (barcodeList.contains(allotPackageDetail.getBarCode())) continue;
            barcodeList.add(allotPackageDetail.getBarCode());
        }
    }

    private void altPackgeInBoundSkuGroup(WhAllotPackageInBoundVO altPackageInBound, Map<String, Integer> inSkuQtMap, Map<String, Integer> inBarcodeQtMap) {
        List<WhAllotPackageInBoundSkuDetailVO> inBoundSkuDetailList = altPackageInBound.getInBoundSkuDetailList();
        if (EmptyUtil.isEmpty(inBoundSkuDetailList)) {
            return;
        }
        for (WhAllotPackageInBoundSkuDetailVO inBoundSkuDetail : inBoundSkuDetailList) {
            if (inBoundSkuDetail.getQuantity() == 0) continue;
            Integer total = inSkuQtMap.get(inBoundSkuDetail.getSkuCode());
            if (NullUtil.isNull((Object)total)) {
                total = 0;
            }
            inSkuQtMap.put(inBoundSkuDetail.getSkuCode(), total + inBoundSkuDetail.getQuantity());
            if (!EmptyUtil.isNotEmpty((String)inBoundSkuDetail.getBarCode())) continue;
            inBoundSkuDetail.setBarCode(inBoundSkuDetail.getBarCode().toUpperCase());
            Integer barcodeTotal = inBarcodeQtMap.get(inBoundSkuDetail.getBarCode());
            if (NullUtil.isNull((Object)barcodeTotal)) {
                barcodeTotal = 0;
            }
            inBarcodeQtMap.put(inBoundSkuDetail.getBarCode(), barcodeTotal + inBoundSkuDetail.getQuantity());
        }
    }

    @Override
    public List<WhAllotDiffSendMessageVO> getWhAllotDiffMessage(WhAllotCond cond) {
        if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            return this.whAllotRcdMapper.getWhAllotDiffMessage(cond.getCodes());
        }
        WhAllotRcdExample example = new WhAllotRcdExample();
        example.createCriteria().andAllotStatusEqualTo(WhAllotRcd.STATUS_FINISHED).andFinishTimeBetween(cond.getStartTime(), cond.getEndTime());
        List<WhAllotRcd> rcdList = this.whAllotRcdMapper.selectByExample(example);
        ArrayList<String> codeList = new ArrayList<String>(rcdList.size());
        if (CollectionUtils.isNotEmpty(rcdList)) {
            for (WhAllotRcd rcd : rcdList) {
                codeList.add(rcd.getCode());
            }
            return this.whAllotRcdMapper.getWhAllotDiffMessage(codeList);
        }
        return null;
    }

    @Override
    public void confirmExecuteAutoAllot(String allotRcdCode) throws Exception {
        WhAllotRcd rcd = this.findAllotRcdByCode(allotRcdCode, true);
        WhWarehouse whWarehouse = this.whInfoService.findWarehouseByCode(rcd.getTargetWarehouseCode());
        Long targetGroupId = whWarehouse.getWarehouseGroupId();
        if (targetGroupId == Constants.PHYSICAL_WAREHOUSE_DEFAULT_GROUP_ID) {
            this.finishAllotRcdCommand(rcd, true, false);
        } else {
            this.updateAllotRcdStatusByCodeNew(allotRcdCode, WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND, "\u81ea\u52a8\u5206\u8d27\u786e\u8ba4");
        }
    }
}

