/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.commdata.service.ChannelQueryService;
import com.thebeastshop.pegasus.service.warehouse.cond.TmallStockLogCond;
import com.thebeastshop.pegasus.service.warehouse.dao.TmallStockLogMapper;
import com.thebeastshop.pegasus.service.warehouse.model.TmallStockLog;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.service.TmallStockLogService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.vo.TmallStockLogVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

@Service(value="tmallStockLogService")
public class TmallStockLogServiceImpl
implements TmallStockLogService {
    @Autowired
    private TmallStockLogMapper tmallStockLogMapper;
    @Autowired
    private ChannelQueryService channelQueryService;
    @Autowired
    private WhAllotService whAllotService;

    @Override
    public Pagination<TmallStockLogVO> findByCond(TmallStockLogCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.tmallStockLogMapper.countByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return page;
        }
        List<TmallStockLogVO> list = this.tmallStockLogMapper.findByCond(cond);
        page.setResultList(list);
        return page;
    }

    @Override
    public TmallStockLogVO findDetailById(Integer id) {
        return this.tmallStockLogMapper.findDetailById(id);
    }

    @Override
    public Boolean dealOuterStockSyn(Integer id, String remark) {
        TmallStockLog record = new TmallStockLog();
        record.setId(id.longValue());
        record.setRemark(remark);
        record.setDealStatus((short)1);
        return this.tmallStockLogMapper.updateByPrimaryKeySelective(record) > 0;
    }

    @Override
    public String officialWebSiteAllot(Integer id, Long operatorId, String operatorName) throws Exception {
        TmallStockLogVO tmallStockLogVO = this.tmallStockLogMapper.findDetailById(id);
        String sellWarehouseCode = this.channelQueryService.getByCode(tmallStockLogVO.getChannelCode()).getWarehouseForSales();
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        if (tmallStockLogVO.getQuantity() < 0) {
            whAllotRcd.setSourceWarehouseCode("WH020600010102");
            whAllotRcd.setTargetWarehouseCode(sellWarehouseCode);
        } else {
            whAllotRcd.setTargetWarehouseCode("WH020600010102");
            whAllotRcd.setSourceWarehouseCode(sellWarehouseCode);
        }
        whAllotRcd.setAllotType(WhAllotRcd.TYPE_BETWEEN_CHANNELS);
        whAllotRcd.setAllotStatus(4);
        whAllotRcd.setEstimatedAllocationDate(new Date());
        ArrayList whAllotRcdSkuList = Lists.newArrayList();
        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
        whAllotRcdSku.setSkuCode(tmallStockLogVO.getSkuCode());
        whAllotRcdSku.setQuantity(Math.abs(tmallStockLogVO.getQuantity()));
        whAllotRcdSku.setSkuName(tmallStockLogVO.getSkuNameCn());
        whAllotRcdSku.setSyncThridParty(false);
        whAllotRcdSkuList.add(whAllotRcdSku);
        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        String allotCode = this.whAllotService.createAllotRcdNoSynTmall(whAllotRcd);
        whAllotRcd.setRemark("\u5916\u90e8\u5e93\u5b58\u540c\u6b65\u81ea\u52a8\u751f\u6210,\u540c\u6b65\u6570\u636eID" + whAllotRcd.getId());
        this.whAllotService.updateAllotRcd(whAllotRcd);
        TmallStockLog updateRecord = new TmallStockLog();
        updateRecord.setId(id.longValue());
        updateRecord.setDealStatus((short)1);
        this.tmallStockLogMapper.updateByPrimaryKeySelective(updateRecord);
        CommEntityOpRcd commEntityOpRcd = new CommEntityOpRcd();
        commEntityOpRcd.setOperatorId(operatorId);
        commEntityOpRcd.setOperatorName(operatorName);
        commEntityOpRcd.setOperationType(Integer.valueOf(1));
        commEntityOpRcd.setOperationDesc("\u5916\u90e8\u5e93\u5b58\u540c\u6b65\u81ea\u52a8\u751f\u6210,\u540c\u6b65\u6570\u636eID" + whAllotRcd.getId());
        commEntityOpRcd.setEntityName("WhAllotRcd");
        commEntityOpRcd.setEntityId(whAllotRcd.getId() + "");
        PegasusUtilFacade.getInstance().insertEntityOperationRcd(commEntityOpRcd);
        return allotCode;
    }

    @Override
    public List<TmallStockLogVO> findFailedSyncByAllotCode(String allotCode) {
        return this.tmallStockLogMapper.findFailedSyncByAllotCode(allotCode);
    }

    @Override
    public Map<String, Integer> findSkuSynQtyCountByCond(TmallStockLogCond cond) {
        return this.resolveListMap(this.tmallStockLogMapper.findSkuSynQtyCountByCond(cond));
    }

    private Map<String, Integer> resolveListMap(List<Map<String, Object>> resultsList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (resultsList != null && !resultsList.isEmpty() && null != resultsList.get(0)) {
            for (Map<String, Object> result : resultsList) {
                String tempKey = "";
                for (Map.Entry<String, Object> entry : result.entrySet()) {
                    if ("skuCode".equals(entry.getKey())) {
                        tempKey = entry.getValue().toString();
                        continue;
                    }
                    map.put(tempKey, ((BigDecimal)entry.getValue()).intValue());
                    tempKey = "";
                }
            }
        }
        return map;
    }

    public static void main(String[] args) {
        HashMap<String, Integer> newMap = new HashMap<String, Integer>();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("skuCode", "SO0310000013869");
        result.put("quality", "56");
        String tempKey = "";
        for (Map.Entry entry : result.entrySet()) {
            if ("skuCode".equals(entry.getKey())) {
                tempKey = (String)entry.getValue();
                continue;
            }
            newMap.put(tempKey, Integer.parseInt((String)entry.getValue()));
            tempKey = "";
        }
        System.out.println(111);
    }
}

