/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.common;

import com.thebeastshop.pegasus.service.warehouse.util.DateUtil;
import com.thebeastshop.pegasus.service.warehouse.util.JsonUtil;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MessageEvent
implements Serializable {
    private static final long serialVersionUID = -5884985566319453772L;
    private String type;
    private String source;
    private Object body;
    private String target;
    private long timestamp;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public static MessageEvent messageToEvent(String message) {
        MessageEvent event = new MessageEvent();
        Map eventMap = JsonUtil.getMapFromJson(message);
        event.setBody(eventMap.get("body"));
        event.setSource(eventMap.get("source") != null ? eventMap.get("source").toString() : null);
        event.setTarget(eventMap.get("target") != null ? eventMap.get("target").toString() : null);
        if (eventMap.get("timestamp") != null) {
            event.setTimestamp(Long.valueOf(eventMap.get("timestamp").toString()));
        }
        event.setType(eventMap.get("type") != null ? eventMap.get("type").toString() : null);
        return event;
    }

    public static MessageEvent getMessageEvent(Map<String, Object> bodyMap, String source, String target, String type) {
        MessageEvent event = new MessageEvent();
        event.setBody(bodyMap);
        event.setSource(source);
        event.setTarget(target);
        event.setTimestamp(DateUtil.getCurrDateTime().getTime());
        event.setType(type);
        return event;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("type", (Object)this.type).append("source", (Object)this.source).append("body", this.body).append("target", (Object)this.target).append("timestamp", this.timestamp).toString();
    }
}

