/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitResponse;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSimpleVO;
import com.thebeastshop.pegasus.service.warehouse.SpringUtil;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.PhyWhSkuStockRcdCond;
import com.thebeastshop.pegasus.service.warehouse.cond.PhyWhStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhConnectAltPackageCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhExpressWaybillCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhGradeAffectInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhGradeOfQualityCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhGradeOfQualityDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhSalesReturnExceptionCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhSalesReturnExceptionSkuCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsBoxNumberCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandPreOccupyCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectActiveRuleCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectPickSkuCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConsumableSkuCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsGradeOfQualityCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanDiffDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveSkuCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStorehouseBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStorehouseCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsOperationCountCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsOutStockRecordCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcJobTaskCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsQcProcessDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReceiveShelvesDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishRuleCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuPickShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuStockRecordCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsTaskAssignCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondAlt;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondPcsRtn;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondRecWaste;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutCancel;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhExpressWaybill;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeAffectInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQuality;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQualityDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnException;
import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnExceptionSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsBoxNumber;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectPickSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectTurnoverBox;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQuality;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStorehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStorehouseBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStorehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsOutStockRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsQcProcessDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRule;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsShelvesSkuInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuPickShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutaway;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandAssociateExpressService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandOutCancelService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhExpressWaybillService;
import com.thebeastshop.pegasus.service.warehouse.service.WhGradeOfQualityService;
import com.thebeastshop.pegasus.service.warehouse.service.WhThirdPartyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandCheckService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandHandoverService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandPreOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectActivityRuleService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectAllotPackageService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectDistributionService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectParaService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectPickSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartConfigService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartDurationService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartForbideRuleService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartRuleService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConsumableService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsGradeOfQualityService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsInventoryPlanDiffService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsInventoryService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsManualInOutService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStorehouseService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveWarehouseService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOperationRcdService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOutStockRecordService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskDetailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReceiveShelvesDetailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishRuleService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReportService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsShelvesSkuInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuTranslateService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTaskAssignService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayTaskService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.PhyWhSkuStockRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.PhyWhStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandAssoExpressVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandPickStockInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhExpressWaybillVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeAffectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeOfQualityVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeSalesOrderVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhQualityControlVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReceiveShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSalesReturnExceptionSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSalesReturnExceptionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsBatchReplenishInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsBoxNumberVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckBatch;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckInfo;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckPara;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandPreOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectActivityRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectCheckVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectCountInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributeInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuSubmitDataVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartConditionsVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartCountConfigVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartDurationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartForbideRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartResultVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleConfigVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConsumableSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsGradeOfQualityVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanDiffAuditeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanDiffDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanDiffProcessVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsManualInOutVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveHouseShelvesExcelVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStorehouseBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStorehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOperationCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPutawayExcuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPutawaySearchVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsQcProcessDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReceiveShelvesDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleBlacklistVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleHousetypeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuPickShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuPickStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockRecordVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuTranslateVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsStartPutawayVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTaskAssignReqVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTaskAssignVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitOutStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayTaskVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.task.TaskExecutor;
import page.Pagination;

public class PegasusWmsServiceFacade {
    private static final Logger log = LoggerFactory.getLogger(PegasusWmsServiceFacade.class);
    private static PegasusWmsServiceFacade instance;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;
    @Autowired
    private WhWmsConnectParaService whWmsConnectParaService;
    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhWmsMoveSkuService whWmsMoveSkuService;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;
    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsConnectDistributionService whWmsConnectDistributionService;
    @Autowired
    private WhWmsWaitPutawayTaskService whWmsWaitPutawayTaskService;
    @Autowired
    private WhWmsCommandCheckService whWmsCommandCheckService;
    @Autowired
    private WhWmsPrdcJobTaskService whWmsPrdcJobTaskService;
    @Autowired
    private WhCommandAssociateExpressService WhCommandAssociateExpressService;
    @Autowired
    private WhWmsReportService whWmsReportService;
    @Autowired
    private WhWmsCommandHandoverService whWmsCommandHandoverService;
    @Autowired
    private WhWmsManualInOutService whWmsManualInOutService;
    @Autowired
    private WhWmsPrdcJobTaskDetailService whWmsPrdcJobTaskDetailService;
    @Autowired
    private WhWmsReplenishService whWmsReplenishService;
    @Autowired
    private WhWmsInventoryService whWmsInventoryService;
    @Autowired
    private WhWmsInventoryPlanDiffService whWmsInventoryPlanDiffService;
    @Autowired
    private WhWmsSkuTranslateService whWmsSkuTranslateService;
    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;
    @Autowired
    private WhWmsConnectAllotPackageService whWmsConnectAllotPackageService;
    @Autowired
    private WhCommandOutCancelService whCommandOutCancelService;
    @Autowired
    private WhWmsOperationRcdService whWmsOperationRcdService;
    @Autowired
    private WhThirdPartyService whThirdPartyService;
    @Autowired
    private WhWmsConnectStartConfigService whWmsConnectStartConfigService;
    @Autowired
    private WhWmsConnectStartDurationService whWmsConnectStartDurationService;
    @Autowired
    private WhWmsConnectStartForbideRuleService whWmsConnectStartForbideRuleService;
    @Autowired
    private WhWmsConnectStartRuleService whWmsConnectStartRuleService;
    @Autowired
    private WhWmsCommandPreOccupyService whWmsCommandPreOccupyService;
    @Autowired
    private WhWmsConnectStartService whWmsConnectStartService;
    @Autowired
    private WhWmsConnectActivityRuleService whWmsConnectActivityRuleService;
    @Autowired
    private WhWmsOutStockRecordService whWmsOutStockRecordService;
    @Autowired
    private WhWmsConsumableService whWmsConsumableService;
    @Autowired
    private WhExpressWaybillService whExpressWaybillService;
    @Autowired
    private TaskExecutor myScheduler;
    @Autowired
    private RedisDistributLock redisDistributLock;
    @Autowired
    private WhWmsGradeOfQualityService whWmsGradeOfQualityService;
    @Autowired
    private WhGradeOfQualityService whGradeOfQualityService;
    @Autowired
    private WhWmsReplenishRuleService whWmsReplenishRuleService;
    @Autowired
    private WhWmsReplenishInfoService whWmsReplenishInfoService;
    @Autowired
    private WhWmsReceiveShelvesDetailService whWmsReceiveShelvesDetailService;
    @Autowired
    private WhWmsMoveWarehouseService whWmsMoveWarehouseService;
    @Autowired
    private WhWmsMoveStorehouseService whWmsMoveStorehouseService;

    private PegasusWmsServiceFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusWmsServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusFacadeLock> clazz = PegasusFacadeLock.class;
        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusWmsServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-warehouse/spring.xml");
                log.info("[fasade init finish] PegasusWmsServiceFacade");
            }
            instance = (PegasusWmsServiceFacade)SpringUtil.getBean("pegasusWmsServiceFacade");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<WhWmsShelvesSkuInfoVO> getShelvesSkuInfoByCond(WhWmsShelvesSkuInfoCond cond) {
        List<WhWmsShelvesSkuInfoVO> shelvesSkuInfoVOs = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(cond);
        return shelvesSkuInfoVOs;
    }

    public List<WhWmsSkuPickShelves> listSkuPickShelvesByCond(WhWmsSkuPickShelvesCond cond) {
        return this.whWmsShelvesSkuInfoService.listSkuPickShelvesByCond(cond);
    }

    public List<WhWmsSkuPickShelves> listSkuPickShelvesBySkuAndPhyCode(String skuCode, String phyCode) {
        WhWmsSkuPickShelvesCond cond = new WhWmsSkuPickShelvesCond();
        if (EmptyUtil.isNotEmpty((String)skuCode)) {
            cond.setSkuCode(skuCode);
        }
        if (EmptyUtil.isNotEmpty((String)phyCode)) {
            cond.setPhysicalWarehouseCode(phyCode);
        }
        return this.listSkuPickShelvesByCond(cond);
    }

    public List<WhWmsSkuPickShelves> listSkuPickShelvesBySkuCode(String skuCode) {
        return this.whWmsShelvesSkuInfoService.listSkuPickShelvesBySkuCode(skuCode);
    }

    public List<WhWmsSkuPickShelvesVO> listSkuPickShelvesVOBySkuCode(String skuCode) {
        return this.whWmsShelvesSkuInfoService.listSkuPickShelvesVOBySkuCode(skuCode);
    }

    public Boolean newWhShelvesSkuInfo(WhWmsShelvesSkuInfo skuInfo) {
        return this.whWmsShelvesSkuInfoService.newSkuInfo(skuInfo);
    }

    public Boolean newWhShelvesSkuInfoVO(WhWmsShelvesSkuInfoVO skuInfoVO) {
        return this.whWmsShelvesSkuInfoService.newWhShelvesSkuInfoVO(skuInfoVO);
    }

    public Boolean updateWhShelvesSkuInfo(WhWmsShelvesSkuInfo skuInfo) {
        return this.whWmsShelvesSkuInfoService.updateSkuInfo(skuInfo);
    }

    public Boolean updateWhShelvesSkuInfoVO(WhWmsShelvesSkuInfoVO skuInfoVO) {
        return this.whWmsShelvesSkuInfoService.updateWhShelvesSkuInfoVO(skuInfoVO);
    }

    public boolean saveOrUpdateWhWmsSkuPickShelves(List<WhWmsSkuPickShelves> whWmsSkuPickShelves) {
        return this.whWmsShelvesSkuInfoService.saveOrUpdateWhWmsSkuPickShelves(whWmsSkuPickShelves);
    }

    public WhWmsShelvesSkuInfo getShelvesSkuInfoByCode(String skuCode) {
        return this.whWmsShelvesSkuInfoService.getSkuInfoByCode(skuCode);
    }

    public WhWmsShelvesSkuInfoVO getShelvesSkuInfoVOBySkuCode(String skuCode, boolean fetchPickShelve) {
        return this.whWmsShelvesSkuInfoService.getSkuInfoVOBySkuCode(skuCode, fetchPickShelve);
    }

    public List<WhWmsHouseShelvesVO> getWhHouseShelvesByCond(WhWmsHouseShelvesCond cond) {
        return this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
    }

    public Pagination<WhWmsHouseShelvesVO> getHouseShelvesByCondPage(WhWmsHouseShelvesCond cond) {
        return this.whWmsHouseShelvesService.getHouseShelvesByCondPage(cond);
    }

    public WhWmsHouseShelvesVO getWhHouseShelvesByCode(String code) {
        return this.whWmsHouseShelvesService.getHouseShelvesByCode(code);
    }

    public List<WhWmsHouseShelves> getHouseShelvesByCode(List<String> codes) {
        return this.whWmsHouseShelvesService.getHouseShelvesByCode(codes);
    }

    public Map<String, WhWmsHouseShelves> getHouseShelvesMapByCode(List<String> codes) {
        return this.whWmsHouseShelvesService.getHouseShelvesMapByCode(codes);
    }

    public WhWmsHouseShelvesVO getWhHouseShelvesById(Integer id) {
        return this.whWmsHouseShelvesService.getHouseShelvesById(id);
    }

    public Boolean newHouseShelves(WhWmsHouseShelves houseShelves) {
        return this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
    }

    public Boolean updateHouseShelves(WhWmsHouseShelves houseShelves) {
        return this.whWmsHouseShelvesService.updateHouseShelves(houseShelves);
    }

    public WhWmsWarehouseArea getAreaByType(String areaType, String code) {
        return this.whWmsWarehouseAreaService.getAreaByType(areaType, code);
    }

    public List<WhWmsWarehouseArea> getAllArea() {
        return this.whWmsWarehouseAreaService.getAllArea();
    }

    public WhWmsWarehouseArea findHouseAreaByCode(String houseCode) {
        return this.whWmsWarehouseAreaService.getAreaByCode(houseCode);
    }

    public Pagination<WhWmsConnectInfoVO> findWmsConnectByCond(WhWmsConnectInfoCond cond) {
        return this.whWmsConnectInfoService.findByCond(cond);
    }

    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond) {
        return this.whWmsConnectInfoService.findWaitOutStockCommandByCond(cond);
    }

    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond) {
        return this.whWmsConnectInfoService.findWaitOutStockCommandAltByCond(cond);
    }

    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond) {
        return this.whWmsConnectInfoService.findWaitOutStockCommandPcsRtnByCond(cond);
    }

    public List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond) {
        return this.whWmsConnectInfoService.findWaitOutStockCommandSkuByCond(cond);
    }

    public Pagination<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond) {
        return this.whWmsConnectInfoService.findWaitOutStockCommandRecWasteByCond(cond);
    }

    public Integer findConnectParaValueByName(String name) {
        return this.whWmsConnectParaService.findValueByName(name);
    }

    public List<WhWmsConnectInfoVO> createWhWmsConnectInfo(WhWmsConnectInfoVO vo, int count) throws Exception {
        return this.whWmsConnectInfoService.createWhWmsConnectInfo(vo, count);
    }

    public WhWmsOutStockRecord createWhWmsOutStockRecord(WhWmsOutStockRecord vo) throws Exception {
        return this.whWmsOutStockRecordService.createWhWmsOutStockRecord(vo);
    }

    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoAlt(WhWmsConnectInfoVO vo, int count) throws Exception {
        return this.whWmsConnectInfoService.createWhWmsConnectInfoAlt(vo, count);
    }

    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoPcsRtn(WhWmsConnectInfoVO vo, int count) throws Exception {
        return this.whWmsConnectInfoService.createWhWmsConnectInfoPcsRtn(vo, count);
    }

    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoRecWaste(WhWmsConnectInfoVO vo, int count) throws Exception {
        return this.whWmsConnectInfoService.createWhWmsConnectInfoRecWaste(vo, count);
    }

    public boolean cancelConnect(List<Long> idList) {
        return this.whWmsConnectInfoService.cancelConnect(idList);
    }

    public List<WhWmsConnectCountVO> connectCount(String physicalWarehouseCode) {
        return this.whWmsConnectInfoService.connectCount(physicalWarehouseCode);
    }

    public boolean connectDistribute(WhWmsConnectDistributVO connectDistribut) {
        return this.whWmsConnectInfoService.connectDistribute(connectDistribut);
    }

    public boolean connectDistribute(Long connectId) {
        return this.whWmsConnectInfoService.connectDistribute(connectId);
    }

    public WhSalesReturnExceptionSkuVO findSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        return this.whCommandService.findSalesReturnExceptionSkuByCond(cond);
    }

    public List<WhSalesReturnExceptionSkuVO> listSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        return this.whCommandService.listSalesReturnExceptionSkuByCond(cond);
    }

    public List<WhSalesReturnExceptionSku> selectSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        return this.whCommandService.selectSalesReturnExceptionSkuByCond(cond);
    }

    public WhSalesReturnExceptionVO findSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        return this.whCommandService.findSalesReturnExceptionByCond(cond);
    }

    public WhSalesReturnExceptionVO selectSalesReturnExceptionById(Long id) throws Exception {
        WhSalesReturnException returnException = this.whCommandService.selectSalesReturnExceptionById(id);
        if (EmptyUtil.isEmpty((Object)returnException)) {
            return null;
        }
        return (WhSalesReturnExceptionVO)BeanUtil.buildFrom((Object)returnException, WhSalesReturnExceptionVO.class);
    }

    public List<WhSalesReturnExceptionVO> listSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        return this.whCommandService.listSalesReturnExceptionByCond(cond);
    }

    public List<WhSalesReturnException> selectSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        return this.whCommandService.selectSalesReturnExceptionByCond(cond);
    }

    public boolean updateSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception {
        return this.whCommandService.updateSalesReturnException(vo);
    }

    public boolean updateSalesReturnExceptionById(WhSalesReturnExceptionVO vo) throws Exception {
        return this.whCommandService.updateSalesReturnExceptionById(vo);
    }

    public boolean updateSalesReturnExceptionSkuById(WhSalesReturnExceptionSku returnExceptionSku) throws Exception {
        return this.whCommandService.updateSalesReturnExceptionSkuById(returnExceptionSku);
    }

    public boolean insertSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception {
        return this.whCommandService.insertSalesReturnException(vo);
    }

    public boolean addOrUpdateSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception {
        if (EmptyUtil.isNotEmpty((Object)vo.getId())) {
            WhSalesReturnException salesReturnException = this.whCommandService.selectSalesReturnExceptionById(vo.getId());
            if (EmptyUtil.isEmpty((Object)salesReturnException)) {
                throw new WarehouseException("\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728![id]" + vo.getId());
            }
            return this.updateSalesReturnException(vo);
        }
        return this.insertSalesReturnException(vo);
    }

    public Integer findCountSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        return this.whCommandService.findCountSalesReturnExceptionByCond(cond);
    }

    public List<WhReceiveShelvesVO> findReceiveShelvesByCon(WhReceiveShelvesVO vo) {
        return this.whCommandService.findReceiveShelvesByCon(vo);
    }

    public List<WhReceiveShelvesVO> findWaitClosePopCommandByCond(WhReceiveShelvesVO vo) {
        return this.whCommandService.findWaitClosePopCommandByCond(vo);
    }

    public Integer findCountReceiveShelvesByCon(WhReceiveShelvesVO vo) {
        return this.whCommandService.findCountReceiveShelvesByCon(vo);
    }

    public boolean updateCommandStatusById(Integer id, Integer status) {
        return this.whCommandService.updateCommandStatusById(id, status);
    }

    public List<WhReceiveShelvesVO> findReceiveShelvesDetail(Integer whInType, Integer whCommandId) {
        return this.whCommandService.findReceiveShelvesDetail(whInType, whCommandId);
    }

    public Pagination<WhWmsMoveSkuVO> getMoveSkuByMoveByCondPage(WhWmsMoveSkuCond cond) {
        return this.whWmsMoveSkuService.getMoveSkuByMoveByCondPage(cond);
    }

    public List<WhWmsMoveSkuVO> getMoveSkuByMoveByCond(WhWmsMoveSkuCond cond) {
        return this.whWmsMoveSkuService.getMoveSkuByMoveByCond(cond);
    }

    public Pagination<WhWmsMoveStockVO> getMoveStockByCond(WhWmsMoveStockCond cond) {
        return this.whWmsMoveStockService.getMoveStockByCond(cond);
    }

    public List<WhWmsMoveStockVO> getMoveStockByCodes(List<String> moveCodes, boolean cascade) {
        return this.whWmsMoveStockService.getMoveStockByCodes(moveCodes, cascade);
    }

    public List<WhWmsMoveSkuVO> findMoveStockSkuRf(String moveCode) {
        return this.whWmsMoveStockService.findMoveStockSkuRf(moveCode);
    }

    public boolean releaseWmsOccupyByMove(WhWmsOccupyVO vo) {
        return this.whWmsOccupyService.releaseWmsOccupyByMove(vo);
    }

    public WhWmsMoveStockVO getMoveStockByCode(String code) {
        return this.whWmsMoveStockService.getMoveStockByCode(code);
    }

    public WhWmsMoveStock getMoveStockById(Long id) {
        return this.whWmsMoveStockService.getMoveStockById(id);
    }

    public List<WhWmsMoveSkuVO> getMoveSkuByMoveCode(String moveCode) {
        return this.whWmsMoveSkuService.getMoveSkuByMoveCode(moveCode);
    }

    public Boolean newMoveStock(WhWmsMoveStockVO moveStockVO) {
        return this.whWmsMoveStockService.newMoveStock(moveStockVO);
    }

    public Boolean moveStockFinishByMoveSku(String moveCode, Long operatorId, Long moveSkuId) {
        return this.whWmsMoveStockService.moveStockFinishByMoveSku(moveCode, operatorId, moveSkuId);
    }

    public Boolean newMoveStockThenFinish(WhWmsMoveStockVO moveStockVO) {
        return this.whWmsMoveStockService.createMoveStockThenFinish(moveStockVO);
    }

    public Boolean moveStockFinishByMoveSku(String moveCode, Long operatorId, Long moveSkuId, WhWmsTaskAssignVO taskAssignVO) {
        return this.whWmsMoveStockService.moveStockFinishByMoveSku(moveCode, operatorId, moveSkuId, taskAssignVO);
    }

    public Boolean moveStockFinishByMoveSku(WhWmsMoveSkuVO whWmsMoveSkuVO, WhWmsTaskAssignVO taskAssignVO) {
        return this.whWmsMoveStockService.moveStockFinishByMoveSku(whWmsMoveSkuVO, taskAssignVO);
    }

    public List<WhWmsHouseShelves> getHouseShelvesLikeCode(String name) {
        return this.whWmsHouseShelvesService.getHouseShelvesLikeCode(name);
    }

    public List<WhWmsHouseShelves> getHouseShelvesByCondNoPage(WhWmsHouseShelvesCond cond) {
        return this.whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
    }

    public Boolean doMoveStockAndReleaseOccupyAndFinish(String moveCode, Long operatorId) {
        return this.whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveCode, operatorId);
    }

    public void cancelMoveStock(List<WhWmsMoveStockVO> list, Long operatorId) {
        if (EmptyUtil.isNotEmpty(list)) {
            list.forEach(vo -> {
                List<WhWmsMoveSkuVO> skuList = this.whWmsMoveSkuService.getMoveSkuByMoveCode(vo.getCode());
                vo.setMoveSkuList(skuList);
            });
            this.whWmsMoveStockService.cancelMoveStock(list, operatorId);
        }
    }

    public WhWmsMoveSkuVO getMoveSkuById(Long id) {
        return this.whWmsMoveSkuService.getMoveSkuById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean qualityControl(WhReceiveShelvesVO vo) {
        String lockKey = "lock:wms:qualityControl" + vo.getWhCommandId();
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 1L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                throw new WarehouseException("WH0001", "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            this.checkQuInfo(vo);
            boolean bl = this.whCommandService.qualityControl(vo);
            return bl;
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    private void checkQualityControlAmount(WhReceiveShelvesVO vo) {
        Map<String, Integer> skuPlanRestQuantityMap = this.getSkuPlanRestQuantityMap(vo);
        Map<String, Integer> skuQcMap = this.getQualityControlSkuQuantiyMap(vo);
        for (Map.Entry<String, Integer> entry : skuQcMap.entrySet()) {
            Integer qcQuantity = entry.getValue();
            Integer restQuantity = skuPlanRestQuantityMap.get(entry.getKey());
            if (NullUtil.isNull((Object)restQuantity)) {
                throw new WarehouseException("WH0001", String.format("\u8d28\u68c0\u5f02\u5e38[%s]", entry.getKey()));
            }
            if (qcQuantity <= restQuantity) continue;
            throw new WarehouseException("WH0001", String.format("\u6536\u8d27\u6570\u91cf\u5f02\u5e38[\u53ef\u6536\u6570\u91cf\uff1a%s],[\u5f53\u524d\u8d28\u68c0\u6570\u91cf\uff1a%s]", restQuantity, qcQuantity));
        }
    }

    private Map<String, Integer> getSkuPlanRestQuantityMap(WhReceiveShelvesVO vo) {
        HashMap<String, Integer> skuQuantityMap = new HashMap<String, Integer>();
        List<WhReceiveShelvesVO> receiveList = this.findReceiveShelvesDetail(vo.getWhInType(), vo.getWhCommandId());
        if (EmptyUtil.isNotEmpty(receiveList)) {
            for (WhReceiveShelvesVO receive : receiveList) {
                int total = receive.getPlanedQuantity();
                if (NullUtil.isNotNull((Object)receive.getAllNondefectiveQuantity())) {
                    total -= receive.getAllNondefectiveQuantity().intValue();
                }
                if (NullUtil.isNotNull((Object)receive.getAllDefectiveQuantity())) {
                    total -= receive.getAllDefectiveQuantity().intValue();
                }
                if (NullUtil.isNotNull((Object)receive.getAllSampleQuantity())) {
                    total -= receive.getAllSampleQuantity().intValue();
                }
                if (NullUtil.isNotNull((Object)receive.getAllWasteQuantity())) {
                    total -= receive.getAllWasteQuantity().intValue();
                }
                if (NullUtil.isNotNull((Object)receive.getAllDisplayQuantity())) {
                    total -= receive.getAllDisplayQuantity().intValue();
                }
                if (NullUtil.isNotNull((Object)receive.getAllPropQuantity())) {
                    total -= receive.getAllPropQuantity().intValue();
                }
                skuQuantityMap.put(receive.getSkuCode(), total);
            }
        }
        return skuQuantityMap;
    }

    private Map<String, Integer> getQualityControlSkuQuantiyMap(WhReceiveShelvesVO vo) {
        HashMap<String, Integer> skuQuantityMap = new HashMap<String, Integer>();
        if (EmptyUtil.isNotEmpty(vo.getQcList())) {
            for (WhQualityControlVO qc : vo.getQcList()) {
                Integer total = (Integer)skuQuantityMap.get(qc.getQcSku());
                if (NullUtil.isNull((Object)total)) {
                    total = 0;
                }
                if (NullUtil.isNotNull((Object)qc.getNondefectiveQuantity()) && qc.getNondefectiveQuantity() > 0) {
                    total = total + qc.getNondefectiveQuantity();
                }
                if (NullUtil.isNotNull((Object)qc.getDefectiveQuantity()) && qc.getDefectiveQuantity() > 0) {
                    total = total + qc.getDefectiveQuantity();
                }
                if (NullUtil.isNotNull((Object)qc.getSampleQuantity()) && qc.getSampleQuantity() > 0) {
                    total = total + qc.getSampleQuantity();
                }
                if (NullUtil.isNotNull((Object)qc.getWasteQuantity()) && qc.getWasteQuantity() > 0) {
                    total = total + qc.getWasteQuantity();
                }
                if (NullUtil.isNotNull((Object)qc.getDisplayQuantity()) && qc.getDisplayQuantity() > 0) {
                    total = total + qc.getDisplayQuantity();
                }
                if (NullUtil.isNotNull((Object)qc.getPropQuantity()) && qc.getPropQuantity() > 0) {
                    total = total + qc.getPropQuantity();
                }
                skuQuantityMap.put(qc.getQcSku(), total);
            }
        }
        return skuQuantityMap;
    }

    public Set<Long> getGlobalConfigByKey(String configKey) {
        return this.whCommandService.getGlobalConfigByKey(configKey);
    }

    public String startPutaway(WhWmsWaitPutawayVO vo) {
        return this.whWmsWaitPutawayService.startPutaway(vo);
    }

    public List<WhWmsWaitPutawayVO> findPrintPutawayOrder(WhWmsPutawaySearchVO vo) {
        return this.whWmsWaitPutawayService.findPrintPutawayOrder(vo);
    }

    public Pagination<WhWmsWaitPutawayVO> findPutawayList(WhWmsWaitPutawayVO vo) {
        return this.whWmsWaitPutawayService.findPutawayList(vo);
    }

    public Pagination<WhWmsWaitPutawayVO> getPutawayListBySkuCode(WhWmsWaitPutawayVO vo) {
        return this.whWmsWaitPutawayService.getPutawayListBySkuCode(vo);
    }

    public Pagination<WhWmsWaitPutawayVO> findPutawayTaskList(WhWmsWaitPutawayVO vo) {
        return this.whWmsWaitPutawayService.findPutawayTaskList(vo);
    }

    public Long wmsOccupy(WhWmsOccupyVO vo) {
        return this.whWmsOccupyService.wmsOccupy(vo);
    }

    public List<Long> wmsBatchOccupy(List<WhWmsOccupyVO> voList) {
        return this.whWmsOccupyService.wmsBatchOccupy(voList);
    }

    public boolean releaseWmsOccupy(WhWmsOccupyVO vo) {
        return this.whWmsOccupyService.releaseWmsOccupy(vo);
    }

    public List<WhWmsOccupyVO> getWmsOccupyByCond(WhWmsOccupyVO cond) {
        return this.whWmsOccupyService.getWmsOccupyByCond(cond);
    }

    public boolean updateStockById(Integer id, Integer amount) {
        return this.whWmsSkuStockService.updateStockById(id, amount);
    }

    public boolean updateStockByCond(Integer amount, String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus, Integer inoutType, String receiptNo, Long userId) {
        return this.whWmsSkuStockService.updateStockByCond(amount, physicalWarehouseCode, houseType, barcode, shelvesCode, skuCode, skuStatus, inoutType, receiptNo, userId);
    }

    public boolean convertBarcodeUpdateSkuStock(WhWmsSkuStockVO vo) {
        return this.whWmsSkuStockService.convertBarcodeUpdateSkuStock(vo);
    }

    public List<WhWmsSkuStockVO> getWmsSkuStockByCond(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.getWmsSkuStockByCond(cond);
    }

    public List<WhWmsSkuStockVO> getWmsSkuStocksByCond(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.getWmsSkuStocksByCond(cond);
    }

    public List<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCond(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(cond);
    }

    public List<WhWmsSkuStockVO> getWmsSkuStocksByCondForReport(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.getWmsSkuStocksByCondForReport(cond);
    }

    public Pagination<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.getWmsSkuStocksByShelvesCondForReport(cond);
    }

    public List<WhWmsSkuStockVO> listWmsSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.getSkuStocksByShelvesCondForReport(cond);
    }

    public List<WhWmsSkuStockVO> listWmsSkuStocksByCond(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.listSkuStocksByCond(cond);
    }

    public List<WhWmsMoveStorehouseVO> listWhWmsMoveStorehouseVOsByCond(WhWmsMoveStorehouseCond cond) {
        return this.whWmsMoveStorehouseService.listWhWmsMoveStorehouseVOsByCond(cond);
    }

    public WhWmsMoveStorehouseVO listWhWmsMoveStorehouseVOsByCode(String code) {
        WhWmsMoveStorehouseCond cond = new WhWmsMoveStorehouseCond();
        cond.setCode(code);
        List<WhWmsMoveStorehouseVO> moveStorehouseVOs = this.listWhWmsMoveStorehouseVOsByCond(cond);
        if (CollectionUtils.isEmpty(moveStorehouseVOs)) {
            return null;
        }
        return moveStorehouseVOs.get(0);
    }

    public List<WhWmsMoveStorehouse> listWhWmsMoveStorehouseByCond(WhWmsMoveStorehouseCond cond) {
        return this.whWmsMoveStorehouseService.listWhWmsMoveStorehouseByCond(cond);
    }

    public void updateWhWmsMoveStorehouse(WhWmsMoveStorehouse record, WhWmsMoveStorehouseExample example) {
        this.whWmsMoveStorehouseService.updateWhWmsMoveStorehouse(record, example);
    }

    public WhWmsMoveStorehouse findWhWmsMoveStorehouseById(Long id) {
        return this.whWmsMoveStorehouseService.findWhWmsMoveStorehouseById(id);
    }

    public WhWmsMoveStorehouse findWhWmsMoveStorehouseByCode(String code) {
        if (EmptyUtil.isEmpty((String)code)) {
            return null;
        }
        WhWmsMoveStorehouseCond cond = new WhWmsMoveStorehouseCond();
        cond.setCode(code);
        List<WhWmsMoveStorehouse> moveStorehouses = this.listWhWmsMoveStorehouseByCond(cond);
        if (CollectionUtils.isNotEmpty(moveStorehouses)) {
            return moveStorehouses.get(0);
        }
        return null;
    }

    public WhWmsMoveStorehouseVO findWhWmsMoveStorehouseVOByCode(String code, boolean fetchBc) {
        WhWmsMoveStorehouseVO moveStorehouseVO = this.listWhWmsMoveStorehouseVOsByCode(code);
        if (EmptyUtil.isNotEmpty((Object)moveStorehouseVO) && fetchBc) {
            WhWmsMoveStorehouseBarcodeCond cond = new WhWmsMoveStorehouseBarcodeCond();
            cond.setRefId(moveStorehouseVO.getId());
            moveStorehouseVO.setMoveStorehouseBarcodeVOs(this.listWhWmsMoveStorehouseBarcodeVOsByCond(cond));
        }
        return moveStorehouseVO;
    }

    public void addOrEditWhWmsMoveStorehouseVO(WhWmsMoveStorehouseVO moveStorehouseVO) {
        this.whWmsMoveStorehouseService.addOrEditWhWmsMoveStorehouseVO(moveStorehouseVO);
    }

    public List<WhWmsMoveStorehouseBarcodeVO> listWhWmsMoveStorehouseBarcodeVOsByCond(WhWmsMoveStorehouseBarcodeCond cond) {
        return this.whWmsMoveStorehouseService.listWhWmsMoveStorehouseBarcodeVOsByCond(cond);
    }

    public List<WhWmsMoveStorehouseBarcode> listWhWmsMoveStorehouseBarcodeByCond(WhWmsMoveStorehouseBarcodeCond cond) {
        return this.whWmsMoveStorehouseService.listWhWmsMoveStorehouseBarcodeByCond(cond);
    }

    public WhWmsMoveStorehouseVO findWhWmsMoveStorehouseById(Long id, boolean cascade) {
        return this.whWmsMoveStorehouseService.findWhWmsMoveStorehouseById(id, cascade);
    }

    public boolean moveStorehousePutAway(WhWmsMoveStorehouseVO vo) {
        return this.whWmsMoveStorehouseService.moveStorehousePutAway(vo);
    }

    public boolean moveWarehouseStock(List<WhWmsMoveHouseShelvesExcelVO> excelList, Long operatorId) {
        return this.whWmsMoveWarehouseService.moveStock(excelList, operatorId);
    }

    public WhWmsSkuStockVO countSkuAmountBySkuStatus(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.countSkuAmountBySkuStatus(cond);
    }

    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccountWithPreOccupy(WhWmsSkuStockVO vos, boolean gtZero) {
        return this.whWmsSkuStockService.findWmsSkuAvailableAccountWithPreOccupy(vos, gtZero);
    }

    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccount(WhWmsSkuStockVO vos) {
        return this.whWmsSkuStockService.findWmsSkuAvailableAccount(vos);
    }

    public List<WhWmsConnectPickSkuVO> findConnectPickSkuByConnectId(Long connectId) {
        return this.whWmsConnectPickSkuService.findByConnectId(connectId);
    }

    public List<WhWmsConnectPickSkuVO> findConnectPickSkuByCond(WhWmsConnectPickSkuCond cond) {
        return this.whWmsConnectPickSkuService.findConnectPickSkuByCond(cond);
    }

    public List<WhWmsConnectPickSkuVO> findConnectPickSkuByConnectIds(List<Long> connectIds) {
        return this.whWmsConnectPickSkuService.findByConnectIds(connectIds);
    }

    public List<WhWmsConnectPickSkuVO> findListConnectPickSku(List<Long> connectIds) {
        return this.whWmsConnectPickSkuService.findListConnectPickSku(connectIds);
    }

    public Boolean submitConnectPickSku(Long connectId, List<WhWmsConnectPickSkuVO> pickSkuVOList, Long operatorId, WhWmsTaskAssignVO task) throws Exception {
        long time1 = Calendar.getInstance().getTimeInMillis();
        WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(connectId);
        if (connectVO == null || !connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.WAITING_PROCESS) && !connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.PROCESSING)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u72b6\u6001\u4e0d\u662f\u5f85\u62e3\u8d27\u6216\u62e3\u8d27\u4e2d");
        }
        ArrayList<WhWmsConnectPickSkuVO> submitList = new ArrayList<WhWmsConnectPickSkuVO>();
        for (WhWmsConnectPickSkuVO vo : pickSkuVOList) {
            submitList.add(vo);
        }
        WhCommand cmd = new WhCommand();
        ArrayList<WhWmsCommandConnectVO> commandConnects = new ArrayList<WhWmsCommandConnectVO>();
        if (this.whWmsConnectPickSkuService.preSubmitConnectPickSku(connectVO, pickSkuVOList, operatorId, cmd, commandConnects)) {
            return true;
        }
        boolean result = false;
        try {
            WhWmsConnectPickSkuSubmitDataVO vo;
            if (cmd.getInOutType().equals(WhCommand.TYPE_PURCHASE_RETURN_OUT)) {
                vo = this.whWmsConnectPickSkuService.checkSubmitConnectPickSkuPcsRtn(connectVO, commandConnects, pickSkuVOList, operatorId);
                result = this.whWmsConnectPickSkuService.submitConnectPickSkuPcsRtn(vo, operatorId);
            } else if (cmd.getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
                vo = this.whWmsConnectPickSkuService.checkSubmitConnectPickSkuAlt(connectVO, pickSkuVOList, operatorId);
                result = this.whWmsConnectPickSkuService.submitConnectPickSkuAlt(vo, operatorId);
            } else if ("receive_waste".equals(connectVO.getConnectType())) {
                vo = this.whWmsConnectPickSkuService.checkSubmitConnectPickSkuRecWaste(connectVO, commandConnects, pickSkuVOList, operatorId);
                result = this.whWmsConnectPickSkuService.submitConnectPickSkuRecWaste(vo, operatorId);
            } else {
                vo = this.whWmsConnectPickSkuService.checkSubmitConnectPickSku(connectVO, pickSkuVOList, operatorId, cmd, commandConnects);
                result = this.whWmsConnectPickSkuService.submitConnectPickSku(vo);
                if (result && NullUtil.isNotNull((Object)task)) {
                    this.whWmsTaskAssignService.finishTaskAssigned(task.getId(), operatorId);
                }
            }
        }
        catch (Exception e) {
            for (WhWmsConnectPickSkuVO whWmsConnectPickSkuVO : submitList) {
                WhWmsConnectPickSku vo = new WhWmsConnectPickSku();
                vo.setStatus(0);
                vo.setId(whWmsConnectPickSkuVO.getId());
                this.whWmsConnectPickSkuService.updateWhWmsConnectPickSkuByKey(vo);
            }
            throw new RuntimeException(e.getMessage());
        }
        long time2 = Calendar.getInstance().getTimeInMillis();
        log.warn("\u63d0\u4ea4\u62e3\u8d27\u4efb\u52a1submitConnectPickSku task \u6ce2\u6b21" + connectVO.getId() + "\u8017\u65f6\uff1a" + (time2 - time1));
        return result;
    }

    public void handleConnectToNextAction() {
        List<WhWmsConnectInfoVO> list = this.whWmsConnectInfoService.findNeedHandleConnect();
        if (EmptyUtil.isEmpty(list)) {
            return;
        }
        for (WhWmsConnectInfoVO connectVO : list) {
            List<WhWmsCommandConnectVO> commandConnects = this.findNotCanceledConnectCommandByConnectId(connectVO.getId());
            WhCommand cmd = this.whCommandService.findCommandByCode(commandConnects.get(0).getCommandCode(), false);
            List<WhWmsConnectPickSkuVO> pickSkuVOList = this.findConnectPickSkuByConnectId(connectVO.getId());
            boolean result = false;
            try {
                WhWmsConnectPickSkuSubmitDataVO vo;
                if (cmd.getInOutType().equals(WhCommand.TYPE_PURCHASE_RETURN_OUT)) {
                    vo = this.whWmsConnectPickSkuService.checkSubmitConnectPickSkuPcsRtn(connectVO, commandConnects, pickSkuVOList, 1L);
                    result = this.whWmsConnectPickSkuService.submitConnectPickSkuPcsRtn(vo, 1L);
                    continue;
                }
                if (cmd.getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
                    vo = this.whWmsConnectPickSkuService.checkSubmitConnectPickSkuAlt(connectVO, pickSkuVOList, 1L);
                    result = this.whWmsConnectPickSkuService.submitConnectPickSkuAlt(vo, 1L);
                    continue;
                }
                vo = this.whWmsConnectPickSkuService.checkSubmitConnectPickSku(connectVO, pickSkuVOList, 1L, cmd, commandConnects);
                result = this.whWmsConnectPickSkuService.submitConnectPickSku(vo);
            }
            catch (Exception e) {
                log.info(String.format("WhWmsCommandConnectVO[%s]\u540e\u7eed\u6d41\u7a0b\u5904\u7406\u5931\u8d25", connectVO.getId()));
            }
        }
    }

    public Boolean bindConnectBox(Long connectId, String turnoverBoxNo, Long createUserId) {
        return this.whWmsConnectPickSkuService.bindConnectBox(connectId, turnoverBoxNo, createUserId);
    }

    public List<WhWmsConnectTurnoverBox> findConnectBox(Long connectId) {
        return this.whWmsConnectPickSkuService.findConnectBoxByConnectId(connectId);
    }

    public Boolean delConnectBox(Long connectId, String turnoverBoxNo) {
        return this.whWmsConnectPickSkuService.delConnectBox(connectId, turnoverBoxNo);
    }

    public List<WhWmsCommandConnectVO> findNotCanceledConnectCommandByConnectId(Long connectId) {
        return this.whWmsCommandConnectService.findNotCanceledByConnectId(connectId);
    }

    public List<WhWmsCommandConnectVO> findWhWmsCommandConnectVOListByCond(WhWmsCommandConnectCond whWmsCommandConnectCond) {
        return this.whWmsCommandConnectService.findByCond(whWmsCommandConnectCond);
    }

    public List<WhWmsSkuPickStockVO> generalPickSkuStockStragety(List<WhWmsSkuPickStockVO> pickStockList, Integer skuStatus, String physicalWarehouseCode) {
        return this.whWmsCommandConnectService.generalPickSkuStockStragety(pickStockList, skuStatus, physicalWarehouseCode);
    }

    public List<WhWmsConnectTurnoverBox> findPickSkuBoxByCond(WhWmsConnectTurnoverBox cond) {
        return this.whWmsConnectPickSkuService.findBoxByCond(cond);
    }

    public List<WhCountVO> countConnectPickSku(Long operatorId, String physicalWarehouseCode) {
        return this.whWmsConnectPickSkuService.countConnectPickSku(operatorId, physicalWarehouseCode);
    }

    public List<WhWmsSkuBarcodeVO> getWmsSkuBarcodeByCond(WhWmsSkuBarcodeVO vo) {
        return this.whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(vo);
    }

    public boolean isReceiveOver(String cmdCode) {
        return this.whWmsWaitPutawayService.isReceiveOver(cmdCode);
    }

    public List<WhWmsConnectDistributionVO> createConnectDistribution(List<WhWmsConnectDistributionVO> vos) {
        return this.whWmsConnectDistributionService.create(vos);
    }

    @Deprecated
    public List<WhWmsConnectDistributionVO> createConnectDistribution(List<WhWmsConnectDistributionVO> vos, Long operatorId) {
        return this.whWmsConnectDistributionService.create(vos, operatorId);
    }

    public boolean connectDistribute(WhWmsConnectDistributeInfoVO connectDistributeInfo) {
        if (EmptyUtil.isNotEmpty(connectDistributeInfo.getMoveStockList())) {
            for (WhWmsMoveStockVO moveStock : connectDistributeInfo.getMoveStockList()) {
                this.whWmsMoveStockService.buildMoveStock(moveStock);
            }
        }
        return this.whWmsConnectDistributionService.connectDistribute(connectDistributeInfo);
    }

    public List<WhWmsConnectDistributionVO> findConnectDistributionByCond(WhWmsConnectDistributionVO cond) {
        return this.whWmsConnectDistributionService.findByCond(cond);
    }

    public Map<String, List<String>> findPackageDistributionBoxNo(List<Long> commandIdList, List<String> commandCodeList) {
        return this.whWmsConnectDistributionService.findPackageDistributionBoxNo(commandIdList, commandCodeList);
    }

    public Pagination<WhWmsWaitPutawayTaskVO> findPutawayTaskList(WhWmsWaitPutawayTaskVO vo) {
        return this.whWmsWaitPutawayTaskService.findPutawayTaskList(vo);
    }

    public List<WhWmsWaitPutawayTaskVO> findWhWmsWaitPutawayTaskVOList(WhWmsWaitPutawayTaskVO vo) {
        return this.whWmsWaitPutawayTaskService.findWhWmsWaitPutawayTaskVOList(vo);
    }

    public WhWmsPrdcJobTaskVO getPrdcJobTaskById(Long id) {
        return this.whWmsPrdcJobTaskService.getPrdcJobTaskById(id);
    }

    public boolean submitConnectCheck(WhWmsConnectCheckVO connectCheck) {
        if (EmptyUtil.isNotEmpty(connectCheck.getMoveStockList())) {
            for (WhWmsMoveStockVO moveStock : connectCheck.getMoveStockList()) {
                this.whWmsMoveStockService.buildMoveStock(moveStock);
            }
        }
        return this.whWmsCommandCheckService.submitConnectCheck(connectCheck);
    }

    public boolean checkGiftCardCanBindByCardNo(String cardNo) {
        return this.whWmsCommandCheckService.checkGiftCardCanBindByCardNo(cardNo);
    }

    public boolean createCustomization(WhWmsCommandCheckInfo checkInfo) {
        return this.whWmsCommandCheckService.createCustomization(checkInfo);
    }

    public boolean createCommandCheck(WhWmsCommandCheckInfo checkInfo) {
        WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO = this.whWmsCommandCheckService.preCheckCommandCheck(checkInfo.getCommandCheckDetailList(), checkInfo.getOperatorId());
        whWmsConnectPickSkuSubmitDataVO.setCheckGiftCardList(checkInfo.getCheckGiftCardList());
        this.whWmsCommandCheckService.create(checkInfo.getCommandCheckDetailList(), whWmsConnectPickSkuSubmitDataVO, checkInfo.getOperatorId());
        return true;
    }

    public Boolean createCommandCheck(Long connectId, List<WhWmsCommandCheckBatch> batchList, List<PackageInfo> fedList, List<PackageInfo> sfList) {
        return this.whWmsCommandCheckService.create(connectId, batchList, fedList, sfList);
    }

    public boolean putawayTaskExcu(WhWmsPutawayExcuVO vo, Long operatorId) throws Exception {
        return this.whWmsWaitPutawayTaskService.putawayTaskExcu(vo, operatorId);
    }

    public boolean targetShelvesCodeCheck(String shelvesCode, String barCode, boolean focus) {
        return this.whWmsWaitPutawayTaskService.targetShelvesCodeCheck(shelvesCode, barCode, focus);
    }

    public List<WhCountVO> countPutawayTask(String physicalWarehouseCode) {
        return this.whWmsWaitPutawayTaskService.countPutawayTask(physicalWarehouseCode);
    }

    public boolean manualReceive(WhWmsManualInOutVO vo) throws Exception {
        return this.whWmsManualInOutService.manualInOutStock(vo);
    }

    public boolean manualOut(List<WhWmsManualInOutVO> voList) throws Exception {
        return this.whWmsManualInOutService.manualInOutStock(voList);
    }

    public Boolean cancelCommandCheck(String commandCode, Long operatorId, List<WhWmsCommandCheckVO> vos) {
        return this.whWmsCommandCheckService.cancel(commandCode, operatorId, vos);
    }

    public Boolean cancelCommandCheck(String commandCode, Long operatorId) {
        return this.whWmsCommandCheckService.cancel(commandCode, operatorId);
    }

    public Boolean rejectCommandCheck(String commandCode, Long operatorId) {
        return this.whWmsCommandCheckService.reject(commandCode, operatorId);
    }

    public Boolean commandAssociateExpress(String commandCode, String expressCode) {
        return this.WhCommandAssociateExpressService.commandAssociateExpress(commandCode, expressCode);
    }

    public Boolean commandAssociateExpress(String commandCode, String expressCode, String operationSource) {
        return this.WhCommandAssociateExpressService.commandAssociateExpress(commandCode, expressCode, operationSource);
    }

    public Boolean commandAssociateExpress(WhCommandAssoExpressVO vo) {
        return this.WhCommandAssociateExpressService.commandAssociateExpress(vo);
    }

    @Deprecated
    public void packageAssoExpressZTAndPackage(ZTOrderSubmitResponse ztOrderSubmitResponse) {
        this.whCommandService.packageAssoExpressZTAndPackage(ztOrderSubmitResponse);
    }

    @Deprecated
    public Boolean commandAssociateExpressSF(String commandCode, PackageInfo pi) {
        return this.WhCommandAssociateExpressService.commandAssociateExpressSF(commandCode, pi);
    }

    @Deprecated
    public Boolean commandAssociateExpressFED(String commandCode, PackageInfo pi) {
        return this.WhCommandAssociateExpressService.commandAssociateExpressFED(commandCode, pi);
    }

    @Deprecated
    public void packageAssoExpressTmsAndCommand(PackageInfo pi) {
        this.whCommandService.packageAssoExpressTmsAndCommand(pi);
    }

    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByJobCode(String jobCode) {
        return this.whWmsPrdcJobTaskService.getPrdcJobTaskByJobCode(jobCode);
    }

    public Boolean createJobTaskAndOccupyStock(WhWmsPrdcJobTaskVO vo) {
        return this.whWmsPrdcJobTaskService.createJobTaskAndOccupyStock(vo);
    }

    public List<WhWmsPrdcJobTaskDetailVO> getTaskDetailByTaskCode(String taskCode) {
        return this.whWmsPrdcJobTaskDetailService.getTaskDetailByTaskCode(taskCode);
    }

    public Boolean finishTaskAndUpdateStock(WhWmsPrdcJobTaskVO jobTaskVO, Long userId) throws Exception {
        return this.whWmsPrdcJobTaskService.finishTaskAndUpdateStock(jobTaskVO, userId);
    }

    public List<WhWmsSkuStockVO> getStockByWarehouseCode(String warehouseCode) {
        return this.whWmsReportService.getStockByWarehouseCode(warehouseCode);
    }

    public List<WhWmsSkuStockVO> getShelvesStockByWarehouseCode(String warehouseCode) {
        return this.whWmsReportService.getShelvesStockByWarehouseCode(warehouseCode);
    }

    public Map<String, Object> getStockCountByWarehouseCode(String warehouseCode) {
        return this.whWmsReportService.getStockCountByWarehouseCode(warehouseCode);
    }

    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByCond(WhWmsPrdcJobTaskCond cond) {
        return this.whWmsPrdcJobTaskService.getPrdcJobTaskByCond(cond);
    }

    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        return this.whWmsPrdcJobTaskService.getPrdcJobMaxTask(vo);
    }

    public WhWmsSkuBarcode findMinExpiryDateByMaterialOccupy(WhWmsPrdcJobTaskVO vo) {
        return this.whWmsPrdcJobTaskService.findMinExpiryDateByMaterialOccupy(vo);
    }

    public List<Map<String, Object>> getWmsPrdcJobTaskFinishedInfo(List<String> prdcJobCodes) {
        return this.whWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
    }

    public List<Map<String, Object>> getWmsPrdcJobTaskProcessingInfo(List<String> prdcJobCodes) {
        return this.whWmsPrdcJobTaskService.getWmsPrdcJobTaskProcessingInfo(prdcJobCodes);
    }

    public List<Map<String, Object>> getWmsPrdcJobTaskFinishedRealAmount(List<String> prdcJobCodes) {
        return this.whWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedRealAmount(prdcJobCodes);
    }

    public Boolean updateJobTask(WhWmsPrdcJobTaskVO vo) {
        return this.whWmsPrdcJobTaskService.updateJobTask(vo);
    }

    public Pagination<WhWmsPrdcJobTaskVO> getPrdcTaskByCondPage(WhWmsPrdcJobTaskCond cond) {
        return this.whWmsPrdcJobTaskService.getPrdcTaskByCondPage(cond);
    }

    public List<WhWmsCommandInfoVO> findCommandInfoByCond(WhWmsCommandInfoCond cond) {
        return this.whCommandService.findCommandInfoByCond(cond);
    }

    public List<WhWmsCommandInfoVO> findNewCommandInfoByCond(WhWmsCommandInfoCond cond) {
        return this.whCommandService.findNewCommandInfoByCond(cond);
    }

    public Pagination<WhWmsCommandInfoVO> findPaginationCommandInfoByCond(WhWmsCommandInfoCond cond) {
        return this.whCommandService.findPaginationCommandInfoByCond(cond);
    }

    public Map<String, Object> countCommandInfoByCond(WhWmsCommandInfoCond cond) {
        return this.whCommandService.countCommandInfoByCond(cond);
    }

    public List<Map<String, Object>> findAdditionalInfosByCond(WhWmsCommandInfoCond cond) {
        return this.whCommandService.findAdditionalInfosByCond(cond);
    }

    public WhWmsConnectInfoVO findWhWmsConnectInfoVOByCommandCode(String commandCode) {
        return this.whCommandService.findWhWmsConnectInfoVOByCommandCode(commandCode);
    }

    public boolean commandHandover(WhCommand cmd) {
        return this.whWmsCommandHandoverService.commandHandover(cmd);
    }

    public void processSubmitCommandHandover(WhCommand cmd) {
        this.whWmsCommandHandoverService.processSubmitCommandHandover(cmd);
    }

    public String findSalerEmailAddressByOrderCode(String orderCode) {
        String defaultEmail = "thebeastcorpsale@163.com";
        if (EmptyUtil.isNotEmpty((String)orderCode)) {
            String email = this.whCommandService.findSalesOrderAddressByCond(orderCode);
            if (EmptyUtil.isEmpty((String)email)) {
                email = defaultEmail;
            }
            return email;
        }
        return defaultEmail;
    }

    public WhCommand findCommandByExpressCode(String expressCode) {
        return this.whCommandService.findCommandByExpressCode(expressCode);
    }

    public boolean createPreOccupy(WhWmsCommandPreOccupyVO vo) {
        return this.whWmsCommandPreOccupyService.createPreOccupy(vo);
    }

    public boolean createPreOccupy(List<WhWmsCommandPreOccupyVO> voList) {
        return this.whWmsCommandPreOccupyService.createPreOccupy(voList);
    }

    public List<WhWmsCommandPreOccupyVO> findPreOccupyByCond(WhWmsCommandPreOccupyCond cond) {
        return this.whWmsCommandPreOccupyService.findByCond(cond);
    }

    public boolean releasePreOccupy(WhWmsCommandPreOccupyCond cond) {
        return this.whWmsCommandPreOccupyService.releasePreOccupy(cond);
    }

    public void commandPreOccupy(String physicalWarehouseCode, Integer skuStatus) {
        this.whWmsConnectStartService.commandPreOccupy(physicalWarehouseCode, skuStatus);
    }

    public void commandPreOccupy(String physicalWarehouseCode, Integer skuStatus, List<String> commandCodes) {
        this.whWmsConnectStartService.commandPreOccupy(physicalWarehouseCode, skuStatus, commandCodes);
    }

    public boolean releasePreOccupy(String physicalWarehouseCode) {
        return this.whWmsConnectStartService.releasePreOccupy(physicalWarehouseCode);
    }

    public WhWmsConnectStartResultVO connectStart(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        return this.whWmsConnectStartService.connectStart(pickStockInfoList, conditions, countConfig);
    }

    public WhWmsConnectStartResultVO connectStartWithConnectType(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        return this.whWmsConnectStartService.connectStartWithConnectType(pickStockInfoList, conditions, countConfig);
    }

    public WhWmsCommandPreOccupyCond buildPreOccupyCond(WhWmsConnectStartConditionsVO conditions) {
        return this.whWmsConnectStartService.buildPreOccupyCond(conditions);
    }

    public List<WhCommandPickStockInfoVO> convertPickStockInfoFromPreOccupy(List<WhWmsCommandPreOccupyVO> preOccupyList, WhWmsConnectStartConditionsVO conditions) {
        return this.whWmsConnectStartService.convertPickStockInfoFromPreOccupy(preOccupyList, conditions);
    }

    public Map<Integer, WhWmsConnectCountInfoVO> countUnfinishedConnect(String physicalWarehouseCode) {
        return this.whWmsConnectInfoService.countUnfinishedConnect(physicalWarehouseCode);
    }

    public List<WhWmsConnectActivityRuleVO> findConnectActivityRuleByCond(WhWmsConnectActiveRuleCond cond, boolean cascade) {
        return this.whWmsConnectActivityRuleService.findConnectActivityRuleByCond(cond, cascade);
    }

    public Pagination<WhWmsConnectActivityRuleVO> findConnectActivityRuleByCondPage(WhWmsConnectActiveRuleCond cond, boolean cascade) {
        return this.whWmsConnectActivityRuleService.findConnectActivityRuleByCondPage(cond, cascade);
    }

    public WhWmsConnectActivityRuleVO findConnectActivityRule(Long ruleId) {
        return this.whWmsConnectActivityRuleService.findConnectActivityRule(ruleId);
    }

    public boolean saveConnectActiveRule(WhWmsConnectActivityRuleVO ruleVO) {
        return this.whWmsConnectActivityRuleService.saveConnectActivityRule(ruleVO);
    }

    public boolean enableDisableConnectActivityRule(Long ruleId, Integer enableOrDisable) {
        return this.whWmsConnectActivityRuleService.enableDisableConnectActivityRule(ruleId, enableOrDisable);
    }

    public WhWmsCommandConnectVO findNotCanceledConnectCommandByCommandCode(String commandCode) {
        return this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
    }

    public WhWmsConnectInfoVO findConnectInfoByConnectId(Long connectId) {
        return this.whWmsConnectInfoService.findById(connectId);
    }

    public WhWmsConnectInfoVO findConnectInfoByCommandCode(String commandCode) {
        WhCommand whCommand = this.whCommandService.findCommandByCode(commandCode, true);
        if (whCommand == null) {
            return null;
        }
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        if (commandConnectVO == null) {
            return null;
        }
        return this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
    }

    public WhWmsConnectInfoVO findConnectInfoByCommandCode(String commandCode, boolean isFetch, boolean isCanceled) {
        WhCommand whCommand = this.whCommandService.findCommandByCode(commandCode, isFetch);
        if (whCommand == null) {
            return null;
        }
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findByWhCommandCode(commandCode, isCanceled);
        if (commandConnectVO == null) {
            return null;
        }
        return this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
    }

    public List<WhWmsShelvesSkuInfo> getSkuInfoLikeCode(String codeLike) {
        return this.whWmsShelvesSkuInfoService.getSkuInfoLikeCode(codeLike);
    }

    public List<WhCommandSku> findCommandSkuByCommandId(Long commandId) {
        return this.whCommandService.findCommandSkuByCommandId(commandId);
    }

    public boolean commandShortagesToInProcessing(String whCommandCode) {
        return this.whCommandService.commandShortagesToInProcessing(whCommandCode);
    }

    public List<WhCommand> findCommandByCond(WhCommandCond cond) {
        return this.whCommandService.findCommandByCond(cond);
    }

    public List<WhWmsHouseShelvesVO> findNeedToReplenishShelves(String houseType, Integer shelvesType) {
        return this.whWmsReplenishService.findNeedToReplenishShelves(houseType, shelvesType);
    }

    public void processReplenish(WhWmsHouseShelvesVO shelvesVO) {
        this.whWmsReplenishService.processReplenish(shelvesVO);
    }

    public WhWmsWarehouseArea getAreaByName(String name) {
        return this.whWmsWarehouseAreaService.getAreaByName(name);
    }

    public WhWmsWarehouseArea getAreaByCode(String code) {
        return this.whWmsWarehouseAreaService.getAreaByCode(code);
    }

    public List<WhCommand> findCommandByConnectIdAndBarCode(String barCode, Long connectId) {
        return this.whCommandService.findCommandByConnectIdAndBarCode(barCode, connectId);
    }

    public List<WhWmsSkuStock> getGroupByShelvesByCond(WhWmsSkuStockVO vo) {
        return this.whWmsSkuStockService.getGroupByShelvesByCond(vo);
    }

    public List<WhWmsSkuStock> getStockByCond(WhWmsSkuStockVO vo) {
        return this.whWmsSkuStockService.getStockByCond(vo);
    }

    public List<PhyWhStockVO> findPhyWhStockByCond(PhyWhStockCond cond) {
        return this.whWmsSkuStockService.findPhyWhStockByCond(cond);
    }

    public List<PhyWhStockVO> findPhyWhSkuTotalQuantityByCond(PhyWhStockCond cond) {
        return this.whWmsSkuStockService.findPhyWhSkuTotalQuantityByCond(cond);
    }

    public Boolean checkConnectDistributionBoxNo(String code) {
        return this.whWmsConnectDistributionService.checkBoxNo(code);
    }

    public WhCommand findCommandByReferenceCode(String referenceCode) {
        return this.whCommandService.findCommandByReferenceCode(referenceCode);
    }

    public boolean checkQuInfo(WhReceiveShelvesVO vo) {
        return this.whWmsWaitPutawayService.checkQuInfo(vo);
    }

    public List<WhWmsReceiveShelvesDetailVO> listWhWmsReceiveShelvesDetailVOByCond(WhWmsReceiveShelvesDetailCond cond) {
        return this.whWmsReceiveShelvesDetailService.listWhWmsReceiveShelvesDetailVOByCond(cond);
    }

    public WhWmsQcProcessDetailVO findWhWmsQcProcessDetailVOByCond(WhWmsQcProcessDetailCond cond) {
        return this.whWmsReceiveShelvesDetailService.findWhWmsQcProcessDetailVOByCond(cond);
    }

    public List<WhWmsQcProcessDetailVO> listWhWmsQcProcessDetailVOByCond(WhWmsQcProcessDetailCond cond) {
        return this.whWmsReceiveShelvesDetailService.listWhWmsQcProcessDetailVOByCond(cond);
    }

    public WhWmsQcProcessDetail findWhWmsQcProcessDetailByCond(WhWmsQcProcessDetailCond cond) {
        return this.whWmsReceiveShelvesDetailService.findWhWmsQcProcessDetailByCond(cond);
    }

    public List<WhWmsQcProcessDetail> listWhWmsQcProcessDetailsByCond(WhWmsQcProcessDetailCond cond) {
        return this.whWmsReceiveShelvesDetailService.listWhWmsQcProcessDetailsByCond(cond);
    }

    public void purchaseDefectiveProcess(List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs, Long processUserId) throws Exception {
        this.whWmsReceiveShelvesDetailService.purchaseDefectiveProcess(receiveShelvesDetailVOs, processUserId);
    }

    public List<WhWmsMoveSkuVO> recommendWmsHouseShelves(List<WhWmsStartPutawayVO> pvoList) {
        return this.whWmsWaitPutawayService.recommendWmsHouseShelves(pvoList);
    }

    public WhWmsWaitPutawayVO findWhWmsWaitPutawayVOById(Long qcId) {
        return this.whWmsWaitPutawayService.findById(qcId);
    }

    public boolean skuTranslate(WhWmsSkuTranslateVO vo) {
        return this.whWmsSkuTranslateService.skuTranslate(vo);
    }

    public Boolean delConnectDistributionBoxNo(Long connectId, String commandCode) {
        return this.whWmsConnectDistributionService.deleteConnectDistribution(connectId, commandCode);
    }

    public List<WhWmsSkuStockRecordVO> findWhWmsStockRecordList(WhWmsSkuStockRecordCond whWmsSkuStockRecordCond) {
        return this.whWmsSkuStockService.findWhWmsStockRecord(whWmsSkuStockRecordCond);
    }

    public int findWhWmsStockRecordCount(WhWmsSkuStockRecordCond whWmsSkuStockRecordCond) {
        return this.whWmsSkuStockService.findWhWmsStockRecordCount(whWmsSkuStockRecordCond);
    }

    public Pagination<PhyWhSkuStockRcdVO> findPhyWhSkuStockRcdByCond(PhyWhSkuStockRcdCond cond) {
        return this.whWmsSkuStockService.findPhyWhSkuStockRcdByCond(cond);
    }

    public List<WhCommandCountVO> getCommandOutCountByCond(WhCommandCond cond) {
        return this.whCommandService.getCommandOutCountByCond(cond);
    }

    public void addConnectAllotPackage(WhWmsConnectAllotPackageVO vo) {
        this.whWmsConnectAllotPackageService.add(vo);
    }

    public WhWmsConnectAllotPackageVO findConnectAllotPackageById(Long id) {
        return this.whWmsConnectAllotPackageService.findById(id);
    }

    public List<WhWmsConnectAllotPackageVO> findConnectAllotPackageByConnectId(Long connectId) {
        return this.whWmsConnectAllotPackageService.findByConnectId(connectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean splitAllotPackage(WhWmsConnectAllotPackageVO allotPackage) {
        String lockKey = "wms:splitAltPackage:" + allotPackage.getSourceAltPackageId();
        try {
            boolean getLock = this.redisDistributLock.tryLock(lockKey, 10L, TimeUnit.SECONDS);
            if (!getLock) {
                throw new WarehouseException("WH0001", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            boolean bl = this.whWmsConnectAllotPackageService.splitAllotPackage(allotPackage);
            return bl;
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    public Pagination<WhWmsConnectAllotPackageVO> findConnectAllotPackageByCond(WhConnectAltPackageCond cond) {
        return this.whWmsConnectAllotPackageService.findByCond(cond);
    }

    public List<WhWmsConnectAllotPackageVO> findConnectAltPackageList(WhConnectAltPackageCond cond) {
        return this.whWmsConnectAllotPackageService.findConnectAltPackageList(cond);
    }

    public WhWmsConnectAllotPackageVO findConnectAltPackage(String allotPackageCode) {
        return this.whWmsConnectAllotPackageService.findConnectAltPackage(allotPackageCode);
    }

    public List<WhWmsConnectAllotPackageVO> findMinEstimatedAllocationDate(List<Long> packageIdList) {
        return this.whWmsConnectAllotPackageService.findMinEstimatedAllocationDate(packageIdList);
    }

    public WhWmsConnectAllotPackageVO findConnectBoxsByCond(WhConnectAltPackageCond cond) {
        return this.whWmsConnectAllotPackageService.findConnectBoxsByCond(cond);
    }

    public List<WhWmsConnectAllotPackageVO> findAllotTypeByByCond(WhConnectAltPackageCond cond) {
        return this.whWmsConnectAllotPackageService.findAllotTypeByByCond(cond);
    }

    public boolean submitConnectAltCheck(WhWmsConnectAllotPackageVO packageVO) throws Exception {
        return this.whWmsConnectInfoService.submitConnectAltCheck(packageVO);
    }

    public List<WhCommandOutCancel> findUnHandleCommand() {
        return this.whCommandOutCancelService.findUnHandleCommand();
    }

    public boolean insert(WhCommandOutCancel whCommandOutCancel) {
        return this.whCommandOutCancelService.insert(whCommandOutCancel);
    }

    public boolean cancelMakeCommandHandover(WhCommand command, Long operatorId) {
        return this.whCommandOutCancelService.cancelMakeCommandHandover(command, operatorId);
    }

    public List<WhWmsMoveSkuVO> buildMoveStockSku(List<WhCommandSku> commandSkuList, List<WhWmsConnectPickSkuVO> picSkuList, WhWmsHouseShelvesVO oriShelves, WhWmsHouseShelvesVO tarShelves) {
        return this.whCommandOutCancelService.buildMoveStockSku(commandSkuList, picSkuList, oriShelves, tarShelves);
    }

    public List<WhWmsMoveSkuVO> buildMoveStockSkuFormDistribution(WhCommand command, WhWmsHouseShelvesVO oriShelves, WhWmsHouseShelvesVO tarShelves) {
        return this.whCommandOutCancelService.buildMoveStockSkuFormDistribution(command, oriShelves, tarShelves);
    }

    public String cancelMakeCommandOnCheckOut(WhWmsMoveStockVO move, WhCommand command) {
        return this.whCommandOutCancelService.cancelMakeCommandOnCheckOut(move, command);
    }

    public String commandCheckOutByParam(WhWmsCommandCheckPara whWmsCommandCheckPara) {
        return this.whCommandOutCancelService.commandCheckOutByParam(whWmsCommandCheckPara);
    }

    public Boolean sendMailToNoticeCancelMakeOnHandover(String packageCode) {
        try {
            EmailVO emailVO = new EmailVO();
            emailVO.setToAddressList(Arrays.asList(PegasusUtilFacade.getInstance().findConfigByKey("wms-cancelMake").getConfigValue().split(",")));
            emailVO.setSubject("[\u53d6\u6d88\u5236\u5355]\u5df2\u89e6\u53d1");
            StringBuffer contentBuffer = new StringBuffer("\u4ed3\u5e93\u5df2\u5904\u7406\u76f8\u5e94\u5305\u88f9,\u89e6\u53d1\u72b6\u6001:\u5305\u88f9\u4ea4\u63a5");
            contentBuffer.append("</br>");
            contentBuffer.append("\u5305\u88f9:" + packageCode);
            contentBuffer.append("</br>");
            emailVO.setContent(contentBuffer.toString());
            boolean tf = EmailUtil.getInstance().send(emailVO);
            return tf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean associateExpress(WhWmsConnectAllotPackageVO packageVO) {
        return this.whWmsConnectAllotPackageService.associateExpress(packageVO);
    }

    public int findPickCommandCount(Long connectId) {
        return this.whWmsConnectPickSkuService.findPickCommandCount(connectId);
    }

    public void deleteConnectBox(Long connectId) {
        this.whWmsConnectPickSkuService.deleteConnectBox(connectId);
    }

    public List<WhWmsTaskAssignVO> findWhWmsTaskAssignByCond(WhWmsTaskAssignCond cond) {
        return this.whWmsTaskAssignService.findWhWmsTaskAssignByCond(cond);
    }

    public WhWmsTaskAssignVO taskAssignAuto(WhWmsTaskAssignReqVO reqVO) {
        return this.whWmsTaskAssignService.taskAssignAuto(reqVO);
    }

    public WhWmsTaskAssignVO taskAssignAsked(WhWmsTaskAssignReqVO reqVO) {
        return this.whWmsTaskAssignService.taskAssignAsked(reqVO);
    }

    public List<WhWmsInventoryPlanShelvesVO> findCanInventoryPlanShelvesByCond(WhWmsInventoryPlanShelvesDetailCond cond) {
        return this.whWmsInventoryService.findCanInventoryPlanShelvesByCond(cond);
    }

    public WhWmsInventoryPlanVO findInventoryPlan(Long id, boolean cascade) {
        return this.whWmsInventoryService.findInventoryPlan(id, cascade);
    }

    public List<WhWmsInventoryPlanVO> findInventoryPlan(WhWmsInventoryPlanCond cond) {
        return this.whWmsInventoryService.findInventoryPlan(cond);
    }

    public Pagination<WhWmsInventoryPlanVO> findInventoryPlanPage(WhWmsInventoryPlanCond cond) {
        return this.whWmsInventoryService.findInventoryPlanPage(cond);
    }

    public boolean saveInventoryPlan(WhWmsInventoryPlanVO plan) {
        return this.whWmsInventoryService.saveInventoryPlan(plan);
    }

    public boolean cancelInventoryPlan(Long id) {
        return this.whWmsInventoryService.cancelInventoryPlan(id);
    }

    public Pagination<WhWmsInventoryPlanShelvesVO> findInventoryPlanShelvesByCondPage(WhWmsInventoryPlanShelvesCond cond) {
        return this.whWmsInventoryService.findInventoryPlanShelvesByCondPage(cond);
    }

    public WhWmsInventoryPlanShelvesVO findInventoryPlanShelves(Long planShelvesId, boolean cascade) {
        return this.whWmsInventoryService.findInventoryPlanShelves(planShelvesId, cascade);
    }

    public boolean complateInventoryPlanShelves(WhWmsInventoryPlanShelvesVO planShelves) {
        return this.whWmsInventoryService.complateInventoryPlanShelves(planShelves);
    }

    public Pagination<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetailPage(WhWmsInventoryPlanDiffDetailCond cond) {
        return this.whWmsInventoryPlanDiffService.findInventoryPlanDiffDetailPage(cond);
    }

    public List<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetail(WhWmsInventoryPlanDiffDetailCond cond) {
        return this.whWmsInventoryPlanDiffService.findInventoryPlanDiffDetail(cond);
    }

    public List<Long> processInventoryPlanDiff(WhWmsInventoryPlanDiffProcessVO processVO) {
        return this.whWmsInventoryPlanDiffService.processInventoryPlanDiff(processVO);
    }

    public List<Long> auditeInventoryPlanDiff(WhWmsInventoryPlanDiffAuditeVO auditeVO) {
        return this.whWmsInventoryPlanDiffService.auditeInventoryPlanDiff(auditeVO);
    }

    public boolean inventoryQuick(List<WhWmsInventoryPlanVO> planList) {
        return this.whWmsInventoryService.inventoryQuick(planList);
    }

    public List<WhCountVO> countInventoryPlan(Long operatorId, String physicalWarehouseCode) {
        return this.whWmsInventoryService.countInventoryPlan(operatorId, physicalWarehouseCode);
    }

    public List<WhWmsConnectStartCountConfigVO> findAllConnectStartCountConfig() {
        return this.whWmsConnectStartConfigService.findAllConnectStartCountConfig();
    }

    public WhWmsConnectStartCountConfigVO findConnectStartCountConfig(String physicalWarehouseCode) {
        return this.whWmsConnectStartConfigService.findConnectStartCountConfig(physicalWarehouseCode);
    }

    public boolean saveConnectStartCountConfig(WhWmsConnectStartCountConfigVO countConfigVO) {
        return this.whWmsConnectStartConfigService.saveConnectStartCountConfig(countConfigVO);
    }

    public List<WhWmsConnectStartRuleConfigVO> findAllConnectStartRuleConfig() {
        return this.whWmsConnectStartConfigService.findAllConnectStartRuleConfig();
    }

    public WhWmsConnectStartRuleConfigVO findConnectStartRuleConfig(String physicalWarehouseCode) {
        return this.whWmsConnectStartConfigService.findConnectStartRuleConfig(physicalWarehouseCode);
    }

    public boolean saveConnectStartRuleConfig(WhWmsConnectStartRuleConfigVO ruleConfigVO) {
        return this.whWmsConnectStartConfigService.saveConnectStartRuleConfig(ruleConfigVO);
    }

    public List<WhWmsConnectStartDurationVO> findConnectStartDuration(String physicalWarehouseCode) {
        return this.whWmsConnectStartDurationService.findConnectStartDuration(physicalWarehouseCode);
    }

    public WhWmsConnectStartDurationVO findConnectStartDuration(Long startDurationId) {
        return this.whWmsConnectStartDurationService.findConnectStartDuration(startDurationId);
    }

    public boolean saveConnectStartDuration(WhWmsConnectStartDurationVO startDurationVO) {
        return this.whWmsConnectStartDurationService.saveConnectStartDuration(startDurationVO);
    }

    public boolean delConnectStartDuration(Long startDurationId) {
        return this.whWmsConnectStartDurationService.delConnectStartDuration(startDurationId);
    }

    public List<WhWmsConnectStartForbideRuleVO> findConnectStartForbideRule(String physicalWarehouseCode, boolean cascade) {
        return this.whWmsConnectStartForbideRuleService.findConnectStartForbideRule(physicalWarehouseCode, cascade);
    }

    public WhWmsConnectStartForbideRuleVO findConnectStartForbideRule(Long forbideRuleId, boolean cascade) {
        return this.whWmsConnectStartForbideRuleService.findConnectStartForbideRule(forbideRuleId, cascade);
    }

    public boolean saveConnectStartForbideRule(WhWmsConnectStartForbideRuleVO forbideRuleVO) {
        return this.whWmsConnectStartForbideRuleService.saveConnectStartForbideRule(forbideRuleVO);
    }

    public boolean enableDisableConnectStartForbideRule(Long forbideRuleId, Integer enableOrDisable) {
        return this.whWmsConnectStartForbideRuleService.enableDisableConnectStartForbideRule(forbideRuleId, enableOrDisable);
    }

    public void disableExpireConnectStartForbideRule() {
        this.whWmsConnectStartForbideRuleService.disableExpireConnectStartForbideRule();
    }

    public List<WhWmsConnectStartRuleVO> findConnectStartRule(String physicalWarehouseCode, Integer ruleType) {
        return this.whWmsConnectStartRuleService.findConnectStartRule(physicalWarehouseCode, ruleType);
    }

    public List<WhWmsConnectStartRuleVO> findConnectStartRule(String physicalWarehouseCode, Integer ruleType, Boolean enableOrNot) {
        return this.whWmsConnectStartRuleService.findConnectStartRule(physicalWarehouseCode, ruleType, enableOrNot);
    }

    public WhWmsConnectStartRuleVO findConnectStartRule(Long ruleId, boolean cascade) {
        return this.whWmsConnectStartRuleService.findConnectStartRule(ruleId, cascade);
    }

    public boolean saveConnectStartRule(WhWmsConnectStartRuleVO startRuleVO) {
        return this.whWmsConnectStartRuleService.saveConnectStartRule(startRuleVO);
    }

    public boolean saveConnectStartRuleForChannel(WhWmsConnectStartRuleVO startRuleVO) {
        return this.whWmsConnectStartRuleService.saveConnectStartRuleForChannel(startRuleVO);
    }

    public boolean saveConnectStartRuleForShelvesArea(WhWmsConnectStartRuleVO shelvesAreaRuleVO) {
        return this.whWmsConnectStartRuleService.saveConnectStartRuleForShelvesArea(shelvesAreaRuleVO);
    }

    public boolean delConnectStartRule(Long startRuleId) {
        return this.whWmsConnectStartRuleService.delConnectStartRule(startRuleId);
    }

    public List<WhWmsWaitPutaway> getAllRemearkByReceiptsNo(String receiptsNo) {
        return this.whWmsWaitPutawayService.getAllRemearkByReceiptsNo(receiptsNo);
    }

    public List<WhWmsWaitPutawayVO> countQcQuantityByCond(List<String> receiptsNos, Integer inOutType) {
        return this.whWmsWaitPutawayService.countQcQuantityByCond(receiptsNos, inOutType);
    }

    public List<WhWmsWaitPutaway> getAllRemearkByCond(WhWmsWaitPutawayVO cond) {
        return this.whWmsWaitPutawayService.getAllRemearkByCond(cond);
    }

    public List<WhWmsWaitPutawayVO> findWaitPutawayWasteByCond(WhWmsWaitPutawayVO vo) {
        return this.whWmsWaitPutawayService.findWaitPutawayWasteByCond(vo);
    }

    public List<WhWmsWaitPutaway> listWaitPutawayByCond(WhWmsWaitPutawayVO vo) {
        return this.whWmsWaitPutawayService.listWaitPutawayByCond(vo);
    }

    public List<WhWmsSkuStockVO> listExpiryDateSku(WhWmsSkuStockVO cond) {
        return this.whWmsSkuStockService.listExpiryDateSku(cond);
    }

    public List<WhWmsOperationCountVO> getCountInfoByCond(WhWmsOperationCountCond cond) {
        return this.whWmsOperationRcdService.getCountInfoByCond(cond);
    }

    public boolean vipShip(WhCommand whCommand) {
        return this.whThirdPartyService.vipShip(whCommand);
    }

    public List<WhWmsBoxNumber> findWmsBoxNumberByCond(WhWmsBoxNumberCond cond) {
        return this.whWmsConnectInfoService.findWmsBoxNumberByCond(cond);
    }

    public List<WhWmsBoxNumberVO> findSingleBoxNumberByCond(WhWmsBoxNumberCond cond) {
        return this.whWmsConnectInfoService.findSingleBoxNumberByCond(cond);
    }

    public int findCountByConnectId(Long connectId) {
        return this.whWmsCommandConnectService.findCountByConnectId(connectId);
    }

    public WhWmsBoxNumberVO createBoxNumber(WhWmsBoxNumberVO vo) {
        return this.whWmsConnectInfoService.createBoxNumber(vo);
    }

    public boolean createBoxNumber(WhWmsBoxNumber boxMember) {
        return this.whWmsConnectInfoService.createBoxNumber(boxMember);
    }

    public List<WhWmsWarehouseArea> getAreaHouseByType(String type) {
        return this.whWmsWarehouseAreaService.getAreaHouseByType(type);
    }

    public List<WhWmsOutStockRecord> findWhWmsOutStockRecordsByCond(WhWmsOutStockRecordCond cond) {
        return this.whWmsOutStockRecordService.findWhWmsOutStockRecordsByCond(cond);
    }

    public boolean updateWhWmsOutStockRecordsByCond(WhWmsOutStockRecord record) {
        return this.whWmsOutStockRecordService.updateWhWmsOutStockRecordsByCond(record);
    }

    public boolean updateWhWmsOutStockRecordsByConds(List<WhWmsOutStockRecord> records) {
        return this.whWmsOutStockRecordService.updateWhWmsOutStockRecordsByConds(records);
    }

    public PageInfo<WhWmsConsumableSkuVO> findWmsConsumableSkuByCond(WhWmsConsumableSkuCond cond) {
        return this.whWmsConsumableService.findWmsConsumableSkuByCond(cond);
    }

    public List<Integer> batchCreate(List<WhWmsConsumableSkuVO> consumableSkuVOList) {
        return this.whWmsConsumableService.batchCreate(consumableSkuVOList);
    }

    public Pagination<WhWmsGradeOfQualityVO> listWhWmsGradeOfQualityVOByCondPage(WhWmsGradeOfQualityCond cond) {
        return this.whWmsGradeOfQualityService.listWhWmsGradeOfQualityVOByCond(cond);
    }

    public WhWmsGradeOfQualityVO findWhWmsGradeOfQualityVOById(Long id, boolean fetchGradeSku, boolean fetchGradeBarcode) {
        return this.whWmsGradeOfQualityService.findWhWmsGradeOfQualityVOById(id, fetchGradeSku, fetchGradeBarcode);
    }

    public WhWmsGradeOfQuality findWhWmsGradeOfQualityById(Long id) throws Exception {
        return this.whWmsGradeOfQualityService.findWhWmsGradeOfQualityById(id);
    }

    public WhWmsGradeOfQualityVO findWhWmsGradeOfQualityVOByCond(WhWmsGradeOfQualityCond cond) {
        return this.whWmsGradeOfQualityService.findWhWmsGradeOfQualityVOByCond(cond);
    }

    public boolean createWhWmsGradeOfQualityVO(WhWmsGradeOfQualityVO vo) throws Exception {
        return this.whWmsGradeOfQualityService.create(vo);
    }

    public boolean manualApprovalFlag(WhWmsGradeOfQualityVO vo) throws Exception {
        return this.whWmsGradeOfQualityService.manualApprovalFlag(vo);
    }

    public boolean approveWhWmsGradeOfQuality(WhWmsGradeOfQualityVO vo) throws Exception {
        return this.whWmsGradeOfQualityService.approveWhWmsGradeOfQuality(vo);
    }

    public List<WhGradeSalesOrderVO> listSalesOrderByWmsOccupyRefCodes(WhWmsGradeOfQualityCond cond) throws Exception {
        return this.whWmsGradeOfQualityService.listSalesOrderByWmsOccupyRefCodes(cond);
    }

    public boolean createOrUpdateWhWmsGradeOfQualityVO(WhWmsGradeOfQualityVO vo) throws Exception {
        return this.whWmsGradeOfQualityService.createOrUpdate(vo);
    }

    public boolean cancelWhWmsGradeOfQuality(WhWmsGradeOfQuality record) throws Exception {
        return this.whWmsGradeOfQualityService.cancelWhWmsGradeOfQuality(record);
    }

    public WhWarehouse findGradeWarehouseByCond(String phyCode, Integer relateType, Integer skuStatus) throws Exception {
        return this.whWmsGradeOfQualityService.findGradeWarehouseByCond(phyCode, relateType, skuStatus);
    }

    public Pagination<WhGradeOfQualityVO> pageWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond) {
        return this.whGradeOfQualityService.pageWhGradeOfQualityVOByCond(cond);
    }

    public List<WhGradeOfQualityDetail> listWhGradeOfQualityDetailByCond(WhGradeOfQualityDetailCond cond) {
        return this.whGradeOfQualityService.listWhGradeOfQualityDetailByCond(cond);
    }

    public List<WhGradeAffectInfo> listWhGradeAffectInfoByCond(WhGradeAffectInfoCond cond) {
        return this.whGradeOfQualityService.listWhGradeAffectInfoByCond(cond);
    }

    public List<WhGradeAffectInfoVO> listWhGradeAffectInfoVOByCond(WhGradeAffectInfoCond cond) {
        return this.whGradeOfQualityService.listWhGradeAffectInfoVOByCond(cond);
    }

    public boolean updateWhGradeAffectInfo(WhGradeAffectInfo affectInfo) {
        return this.whGradeOfQualityService.updateWhGradeAffectInfo(affectInfo);
    }

    public void gradeAdjustApplySendMail(List<WhGradeOfQualityVO> whGradeVOs) {
        this.whGradeOfQualityService.gradeAdjustApplySendMail(whGradeVOs);
    }

    public void stockOutByGradeAdjustSendMail(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs) {
        this.whGradeOfQualityService.stockOutByGradeAdjustSendMail(whGradeVO, affectInfoVOs);
    }

    public void sendMailStockOutByGradeAdjust(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs, Map<String, WhGradeAffectInfoVO> waitSendEmailMap) {
        this.whGradeOfQualityService.sendMailStockOutByGradeAdjust(whGradeVO, affectInfoVOs, waitSendEmailMap);
    }

    public void sendStockOutEmailForGradeAdjust(List<String> toAddressList, String emailContent, List<Long> affectIds) {
        this.whGradeOfQualityService.sendStockOutEmailForGradeAdjust(toAddressList, emailContent, affectIds);
    }

    public void orderExceptionByGradeAdjustSendMail(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs) {
        this.whGradeOfQualityService.orderExceptionByGradeAdjustSendMail(whGradeVO, affectInfoVOs);
    }

    public void sendMailOrderExceptionByGradeAdjust(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs, Map<String, WhGradeAffectInfoVO> waitSendEmailMap) {
        this.whGradeOfQualityService.sendMailOrderExceptionByGradeAdjust(whGradeVO, affectInfoVOs, waitSendEmailMap);
    }

    public void sendOrderExceptionEmailForGradeAdjust(List<String> toAddressList, String emailContent, List<Long> affectIds) {
        this.whGradeOfQualityService.sendOrderExceptionEmailForGradeAdjust(toAddressList, emailContent, affectIds);
    }

    public void stockChangeByGradeAdjustSendMail(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs) {
        this.whGradeOfQualityService.stockChangeByGradeAdjustSendMail(whGradeVO, affectInfoVOs);
    }

    public void sendMailStockChangeByGradeAdjust(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs, Map<String, WhGradeAffectInfoVO> waitSendEmailMap) {
        this.whGradeOfQualityService.sendMailStockChangeByGradeAdjust(whGradeVO, affectInfoVOs, waitSendEmailMap);
    }

    public void sendStockChangeEmailForGradeAdjust(List<String> toAddressList, String emailContent, List<Long> affectIds) {
        this.whGradeOfQualityService.sendStockChangeEmailForGradeAdjust(toAddressList, emailContent, affectIds);
    }

    public WhGradeOfQualityVO findWhGradeOfQualityVOById(Long id, WhGradeOfQualityCond cond) {
        return this.whGradeOfQualityService.findWhGradeOfQualityVOById(id, cond);
    }

    public WhGradeOfQualityVO findWhGradeOfQualityVOById(Long id) {
        return this.findWhGradeOfQualityVOById(id, new WhGradeOfQualityCond());
    }

    public WhGradeOfQualityVO findWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond) {
        return this.whGradeOfQualityService.findWhGradeOfQualityVOByCond(cond);
    }

    public List<WhGradeOfQualityVO> listWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond) {
        return this.whGradeOfQualityService.listWhGradeOfQualityVOByCond(cond);
    }

    public List<WhGradeOfQualityVO> listWhGradeOfQualityVOsByCond(WhGradeOfQualityCond cond) {
        return this.whGradeOfQualityService.listWhGradeOfQualityVOsByCond(cond);
    }

    public List<WhGradeOfQuality> listWhGradeOfQualityByCond(WhGradeOfQualityCond cond) {
        return this.whGradeOfQualityService.listWhGradeOfQualityByCond(cond);
    }

    public boolean createWhGradeOfQualityVO(WhGradeOfQualityVO vo) throws Exception {
        return this.whGradeOfQualityService.create(vo);
    }

    public boolean updateWhGradeOfQualityVO(WhGradeOfQualityVO vo) throws Exception {
        return this.whGradeOfQualityService.update(vo);
    }

    public boolean createOrUpdateWhGradeOfQualityVO(WhGradeOfQualityVO vo) throws Exception {
        return this.whGradeOfQualityService.createOrUpdate(vo);
    }

    public boolean auditWhGradeOfQuality(WhGradeOfQualityVO vo) throws Exception {
        return this.whGradeOfQualityService.auditWhGradeOfQuality(vo);
    }

    public List<Long> batchAuditWhGradeOfQuality(List<WhGradeOfQualityVO> gradeOfQualityVOs, Long approveUserId) throws Exception {
        return this.whGradeOfQualityService.batchAuditWhGradeOfQuality(gradeOfQualityVOs, approveUserId);
    }

    public boolean batchCreateWhGradeAndFetch(List<WhGradeOfQualityVO> vos) throws Exception {
        return this.whGradeOfQualityService.batchCreateWhGradeAndFetch(vos);
    }

    public boolean updateWhGradeOfQualityDetail(WhGradeOfQualityDetail whGradeDetail) {
        return this.whGradeOfQualityService.updateWhGradeOfQualityDetail(whGradeDetail);
    }

    public boolean batchCreateWhGradeOfQuality(List<WhGradeOfQuality> gradeOfQualitys) {
        return this.whGradeOfQualityService.batchCreateWhGradeOfQuality(gradeOfQualitys);
    }

    public boolean batchCreateWhGradeOfQualityDetail(List<WhGradeOfQualityDetail> gradeOfQualityDetails) {
        return this.whGradeOfQualityService.batchCreateWhGradeOfQualityDetail(gradeOfQualityDetails);
    }

    public boolean batchDeleteWhGradeOfQualityDetailByCond(WhGradeOfQualityDetailCond cond) {
        return this.whGradeOfQualityService.batchDeleteWhGradeOfQualityDetailByCond(cond);
    }

    public void batchDeleteConsumableSku(List<String> skuCodes) {
        this.whWmsConsumableService.batchDeleteConsumableSku(skuCodes);
    }

    public List<PcsSkuSimpleVO> findConsumableSkuByCodeOrName(String skuCodeOrName) {
        return this.whWmsConsumableService.findConsumableSkuByCodeOrName(skuCodeOrName);
    }

    public List<String> findBySkuCodes(List<String> skuCodes) {
        return this.whWmsConsumableService.findBySkuCodes(skuCodes);
    }

    public boolean insertWhExpressWaybill(WhExpressWaybill whExpressWaybill) {
        return this.whExpressWaybillService.insert(whExpressWaybill);
    }

    public boolean deleteWhExpressWaybillById(Long id) {
        return this.whExpressWaybillService.deleteById(id);
    }

    public boolean deleteWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        return this.whExpressWaybillService.deleteByCond(cond);
    }

    public boolean updateWhExpressWaybillByCond(WhExpressWaybill whExpressWaybill, WhExpressWaybillCond cond) {
        return this.whExpressWaybillService.updateByCond(whExpressWaybill, cond);
    }

    public boolean updateWhExpressWaybillById(WhExpressWaybill whExpressWaybill) {
        return this.whExpressWaybillService.updateById(whExpressWaybill);
    }

    public WhExpressWaybill findById(Long id) {
        return this.whExpressWaybillService.findById(id);
    }

    public List<WhExpressWaybill> findWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        return this.whExpressWaybillService.findWhExpressWaybillByCond(cond);
    }

    public List<WhExpressWaybillVO> listWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        return this.whExpressWaybillService.listWhExpressWaybillByCond(cond);
    }

    public Pagination<WhExpressWaybillVO> listWhExpressWaybillByCondPage(WhExpressWaybillCond cond) {
        return this.whExpressWaybillService.listWhExpressWaybillByCondPage(cond);
    }

    public boolean batchCreateWhExpressWaybill(List<WhExpressWaybillVO> whExpressWaybillVOs) {
        return this.whExpressWaybillService.batchCreate(whExpressWaybillVOs);
    }

    public Pagination<WhWmsReplenishRuleVO> pageWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond) {
        return this.whWmsReplenishRuleService.pageWhWmsReplenishRuleVOByCond(cond);
    }

    public List<WhWmsReplenishRuleVO> listWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond) {
        return this.whWmsReplenishRuleService.listWhWmsReplenishRuleVOByCond(cond);
    }

    public List<WhWmsReplenishRule> listWhWmsReplenishRuleByCond(WhWmsReplenishRuleCond cond) {
        return this.whWmsReplenishRuleService.listWhWmsReplenishRuleByCond(cond);
    }

    public WhWmsReplenishRule findWhWmsReplenishRuleByPhyCode(String phyCode) {
        return this.whWmsReplenishRuleService.findWhWmsReplenishRuleByPhyCode(phyCode);
    }

    public String replenishInfoGenerateByCond(WhWmsReplenishInfoCond cond) throws Exception {
        return this.whWmsReplenishRuleService.replenishInfoGenerateByCond(cond);
    }

    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOByPhyCode(String phyCode) {
        WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
        cond.setPhysicalWarehouseCode(phyCode);
        List<WhWmsReplenishRuleVO> replenishRuleVOs = this.listWhWmsReplenishRuleVOByCond(cond);
        if (CollectionUtils.isNotEmpty(replenishRuleVOs)) {
            return replenishRuleVOs.get(0);
        }
        return null;
    }

    public WhWmsReplenishRule findWhWmsReplenishRuleById(Long id) {
        return this.whWmsReplenishRuleService.findWhWmsReplenishRuleById(id);
    }

    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOById(Long id, boolean fetchHouse, boolean fetchBlack) {
        return this.whWmsReplenishRuleService.findWhWmsReplenishRuleVOById(id, fetchHouse, fetchBlack);
    }

    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOByPhyCode(String phyCode, boolean fetchHouse, boolean fetchBlack) {
        return this.whWmsReplenishRuleService.findWhWmsReplenishRuleVOByPhyCode(phyCode, fetchHouse, fetchBlack);
    }

    public List<WhWmsReplenishRuleVO> listPcsSkuVOsByCond(WhWmsReplenishRuleCond cond) {
        return this.whWmsReplenishRuleService.listPcsSkuVOsByCond(cond);
    }

    public WhWmsReplenishRuleVO saveOrUpdateWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO) {
        return this.whWmsReplenishRuleService.saveOrUpdateWhWmsReplenishRuleVO(replenishRuleVO);
    }

    public List<WhWmsReplenishRuleBlacklistVO> listWhWmsReplenishRuleBlacklistVOByRuleId(Long ruleId) {
        return this.whWmsReplenishRuleService.listWhWmsReplenishRuleBlacklistVOByRuleId(ruleId);
    }

    public List<WhWmsReplenishRuleHousetypeVO> listWhWmsReplenishRuleHousetypeVOByRuleId(Long ruleId) {
        return this.whWmsReplenishRuleService.listWhWmsReplenishRuleHousetypeVOByRuleId(ruleId);
    }

    public Pagination<WhWmsReplenishInfoVO> pageWhWmsReplenishInfoVOByCond(WhWmsReplenishInfoCond cond) {
        return this.whWmsReplenishInfoService.pageWhWmsReplenishInfoVOByCond(cond);
    }

    public List<WhWmsReplenishInfoVO> listWhWmsReplenishInfoVOByCond(WhWmsReplenishInfoCond cond) {
        return this.whWmsReplenishInfoService.listWhWmsReplenishInfoVOByCond(cond);
    }

    public List<WhWmsReplenishInfo> listWhWmsReplenishInfoByCond(WhWmsReplenishInfoCond cond) {
        return this.whWmsReplenishInfoService.listWhWmsReplenishInfoByCond(cond);
    }

    public WhWmsReplenishInfo findWhWmsReplenishInfoById(Long id) {
        return this.whWmsReplenishInfoService.findWhWmsReplenishInfoById(id);
    }

    public WhWmsReplenishInfoVO findWhWmsReplenishInfoVOById(Long id) {
        return this.whWmsReplenishInfoService.findWhWmsReplenishInfoVOById(id);
    }

    public WhWmsReplenishInfoVO saveOrUpdateWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO) {
        return this.whWmsReplenishInfoService.saveOrUpdateWhWmsReplenishInfoVO(replenishInfoVO);
    }

    public boolean batchSaveWhWmsReplenishInfo(List<WhWmsReplenishInfo> replenishInfos) {
        return this.whWmsReplenishInfoService.batchSaveWhWmsReplenishInfo(replenishInfos);
    }

    public String batchSaveWhWmsReplenishInfoVO(List<WhWmsReplenishInfoVO> replenishInfoVOs) throws Exception {
        WhWmsBatchReplenishInfoVO batchReplenishInfo = new WhWmsBatchReplenishInfoVO();
        batchReplenishInfo.setReplenishInfoList(replenishInfoVOs);
        batchReplenishInfo.setAutoReplenish(false);
        return this.whWmsReplenishInfoService.batchSaveWhWmsReplenishInfoVO(batchReplenishInfo);
    }

    public String createReplenishMoveStock(WhWmsReplenishInfoCond cond) throws Exception {
        return this.whWmsReplenishInfoService.createReplenishMoveStock(cond);
    }

    public boolean saveWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO) {
        return this.whWmsReplenishInfoService.saveWhWmsReplenishInfoVO(replenishInfoVO);
    }

    public boolean updateWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO) {
        return this.whWmsReplenishInfoService.updateWhWmsReplenishInfoVO(replenishInfoVO);
    }

    public Map<String, Boolean> usedSupplierAndEffectiveGoods(List<String> skuCodes) {
        return this.whWmsReplenishInfoService.usedSupplierAndEffectiveGoods(skuCodes);
    }

    public String buildAndCreateMoveStock(WhWmsReplenishInfo replenishInfo, Map<String, Boolean> skuBooleanMap, WhWmsReplenishInfoCond cond) throws WarehouseException {
        return this.whWmsReplenishInfoService.buildAndCreateMoveStock(replenishInfo, skuBooleanMap, cond);
    }
}

