/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitResponse;
import com.thebeastshop.pegasus.service.warehouse.SpringUtil;
import com.thebeastshop.pegasus.service.warehouse.cond.OffSpotGoodsCond;
import com.thebeastshop.pegasus.service.warehouse.cond.PhyWhStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.TmallStockLogCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAutoAllotCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhDamagedRcdCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInvRcdCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInventoryCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInventoryDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTakeStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTlBuyerApplyCondVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseGroupCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcMaterialDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.OffSpotGood;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotCallbackExcludeCategory;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotExcludeCategory;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutFinish;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhCrossGoods;
import com.thebeastshop.pegasus.service.warehouse.model.WhCustomizatonParam;
import com.thebeastshop.pegasus.service.warehouse.model.WhDamagedRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcdExtend;
import com.thebeastshop.pegasus.service.warehouse.model.WhJitPackageSkuReference;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhPreAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhPreAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhTlBuyerPackage;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWastedRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandShortRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsExpressInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcMaterialDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSubmitHandRecord;
import com.thebeastshop.pegasus.service.warehouse.service.OffSpotGoodsService;
import com.thebeastshop.pegasus.service.warehouse.service.TmallStockLogService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotStoreApplicationService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAutoAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhBondedWarehouseAllotApplyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCrossGoodsService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCustomizatonParamService;
import com.thebeastshop.pegasus.service.warehouse.service.WhDamageWasteService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInventoryService;
import com.thebeastshop.pegasus.service.warehouse.service.WhJitPackageSendMailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhJitPackageSkuReferenceService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTakeStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTlBuyerPackageService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWarehouseGroupService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectPickSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcMaterialDetailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTaskAssignService;
import com.thebeastshop.pegasus.service.warehouse.vo.AssociatedInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.BondedWarehouseAllotApplyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.BondedWarehouseAllotPackageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.PhyWhStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.TmallStockLogVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotDiffDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotDiffSendMessageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotPackageInBoundVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRecordDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRecordVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCrossGoodsCondVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCrossGoodsVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhDistrictPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGjStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvQttVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryAuditVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryCountInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryCreateVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryDetailAuditVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryEmailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryReasionDicVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSendMailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPackageInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseRelateWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPreAllotRcdDownloadVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPreAllotRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhQualityControlVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSkuInvQttVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhTakeStockRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhTlBuyerApplyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhTlBuyerPackageOrderVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseGroupVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseInvQttVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseSkuInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcMaterialDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockDiffVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import page.Pagination;

public class PegasusWarehouseServiceFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(PegasusWarehouseServiceFacade.class);
    private static PegasusWarehouseServiceFacade instance;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private OffSpotGoodsService offSpotGoodsService;
    @Autowired
    private WhDamageWasteService whDamageWasteService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhInventoryService whInventoryService;
    @Autowired
    private WhTakeStockService whTakeStockService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;
    @Autowired
    private WhCustomizatonParamService whCustomizatonParamService;
    @Autowired
    private WhWarehouseGroupService whWarehouseGroupService;
    @Autowired
    private WhJitPackageSkuReferenceService whJitPackageSkuReferenceService;
    @Autowired
    private WhJitPackageSendMailService whJitPackageSendMailService;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;
    @Autowired
    private WhWmsPrdcMaterialDetailService whWmsPrdcMaterialDetailService;
    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;
    @Autowired
    private WhAutoAllotService whAutoAllotService;
    @Autowired
    private WhCrossGoodsService whCrossGoodsService;
    @Autowired
    private TmallStockLogService tmallStockLogService;
    @Autowired
    private WhBondedWarehouseAllotApplyService whBondedWarehouseAllotApplyService;
    @Autowired
    private WhTlBuyerPackageService whTlBuyerPackageService;
    @Autowired
    private RedisDistributLock redisDistributLock;
    @Autowired
    private WhAllotStoreApplicationService whAllotStoreApplicationService;

    private PegasusWarehouseServiceFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusWarehouseServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusFacadeLock> clazz = PegasusFacadeLock.class;
        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                LOGGER.info("[fasade init start] PegasusWarehouseServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-warehouse/spring.xml");
                LOGGER.info("[fasade init finish] PegasusWarehouseServiceFacade");
            }
            instance = (PegasusWarehouseServiceFacade)SpringUtil.getBean("pegasusWarehouseServiceFacade");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String createPhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        return this.whInfoService.createPhysicalWarehouse(whPhysicalWarehouse);
    }

    public boolean updatePhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        return this.whInfoService.updatePhysicalWarehouse(whPhysicalWarehouse);
    }

    public boolean updatePhysicalWarehouseByCode(String code, WhPhysicalWarehouse whPhysicalWarehouse) {
        return this.whInfoService.updatePhysicalWarehouseByCode(code, whPhysicalWarehouse);
    }

    public WhWmsExpressInfo findExpressInfoById(Long id) {
        return this.whInfoService.findExpressInfoById(id);
    }

    public boolean deletePhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        return this.whInfoService.deletePhysicalWarehouse(whPhysicalWarehouse);
    }

    public WhPhysicalWarehouse findPhysicalWarehouseByCode(String code) {
        return this.whInfoService.findPhysicalWarehouseByCode(code);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByDistrict(List<Long> districtIds) {
        return this.whInfoService.findPhysicalWarehouseByDistrict(districtIds);
    }

    public WhPhysicalWarehouseVO findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(String code) {
        return this.whInfoService.findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(code);
    }

    public WhPhysicalWarehouse findPhysicalWarehouseById(Long id) {
        return this.whInfoService.findPhysicalWarehouseById(id);
    }

    public List<WhPhysicalWarehouse> listPhysicalWarehouseByIds(List<Long> ids) {
        return this.whInfoService.listPhysicalWarehouseByIds(ids);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByNameCode(String nameOrCode) {
        return this.whInfoService.findPhysicalWarehouseByNameCode(nameOrCode);
    }

    public List<WhPhysicalWarehouse> findNewPhysicalWarehouseByNameOrCode(String nameOrCode) {
        return this.whInfoService.findNewPhysicalWarehouseByNameOrCode(nameOrCode);
    }

    public List<WhPhysicalWarehouse> findAllPhysicalWarehouse() {
        return this.whInfoService.findAllPhysicalWarehouse();
    }

    public Map<String, WhPhysicalWarehouseVO> findAllPhysicalWarehouseMap() {
        return this.whInfoService.findAllPhysicalWarehouseMap();
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByCond(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        return this.whInfoService.findPhysicalWarehouseByCond(whPhysicalWarehouseVO);
    }

    public List<WhPhysicalWarehouseVO> listOffLinePhysicalWarehouse(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        return this.whInfoService.listOffLinePhysicalWarehouse(whPhysicalWarehouseVO);
    }

    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        return this.whInfoService.findDistrictPyWarehouseByExample(whDistrictPhysicalWarehouseVO);
    }

    public List<WhDistrictPhysicalWarehouseVO> listDistrictPyWarehouseByCond(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        return this.whInfoService.listDistrictPyWarehouseByCond(whDistrictPhysicalWarehouseVO);
    }

    public boolean batchInsertDistrictPyWarehouse(List<WhDistrictPhysicalWarehouseVO> whDistrictPhysicalWarehouseVOs) {
        return this.whInfoService.batchInsertDistrictPyWarehouse(whDistrictPhysicalWarehouseVOs) > 0;
    }

    public boolean deleteDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        return this.whInfoService.deleteDistrictPyWarehouseByExample(whDistrictPhysicalWarehouseVO) > 0;
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouse() {
        return this.whInfoService.findPhysicalWarehouse();
    }

    public String createWarehouse(WhPhysicalWarehouse whPhysicalWarehouse, WhWarehouse whWarehouse) {
        return this.whInfoService.createWarehouse(whPhysicalWarehouse, whWarehouse);
    }

    public boolean updateWarehouse(WhWarehouse whWarehouse) {
        return this.whInfoService.updateWarehouse(whWarehouse);
    }

    public boolean updateWarehouseByCode(String code, WhWarehouse whWarehouse) {
        return this.whInfoService.updateWarehouseByCode(code, whWarehouse);
    }

    public boolean deleteWarehouse(WhWarehouse whWarehouse) {
        return this.whInfoService.deleteWarehouse(whWarehouse);
    }

    public WhWarehouse findWarehouseByCode(String code) {
        return this.whInfoService.findWarehouseByCode(code);
    }

    public WhWarehouseVO findWarehouseAndGroupByWarehouseCode(String code) {
        return this.whInfoService.findWarehouseAndGroupByWarehouseCode(code);
    }

    public List<WhWarehouseVO> findWarehouseAndGroupByWarehouseCodes(List<String> warehouseCodes) {
        return this.whInfoService.findWarehouseAndGroupByWarehouseCodes(warehouseCodes);
    }

    public List<WhWarehouse> findWarehouseByCodes(List<String> codes) {
        return this.whInfoService.findWarehouseByCodes(codes);
    }

    public Map<String, WhWarehouseVO> findWarehouseMapByCodes(List<String> codes) {
        return this.whInfoService.findWarehouseMapByCodes(codes);
    }

    public WhWarehouse findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(String phyCode, Integer commodityStatus) {
        return this.whInfoService.findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(phyCode, commodityStatus);
    }

    public WhWarehouse findDefaultOutWarehouseByPhyWhCodeAndCommodityStatus(String phyCode, Integer commodityStatus) {
        return this.whInfoService.findDefaultOutWarehouseByPhyWhCodeAndCommodityStatus(phyCode, commodityStatus);
    }

    public List<WhWarehouse> findWarehouseByCond(WhWarehouseCond cond) {
        return this.whInfoService.findWarehouseByCond(cond);
    }

    public List<WhWarehouse> findWarehouseByNameCodeAndType(String nameOrCode, Integer warehouseType) {
        return this.whInfoService.findWarehouseByNameCodeAndType(nameOrCode, warehouseType);
    }

    @Deprecated
    public List<WhWarehouse> findWarehouseByNameAndWaitForDispatchingFilter(String nameOrCode, Integer filterRuleType) {
        return this.whInfoService.findWarehouseByNameAndWaitForDispatchingFilter(nameOrCode, filterRuleType);
    }

    public List<WhWarehouse> findWarehouseByNameCode(String nameOrCode) {
        return this.whInfoService.findWarehouseByNameCode(nameOrCode);
    }

    public List<WhWarehouse> findGroupWarehouseByNameCode(String nameOrCode, String physicalWarehouseCode, Boolean noPage) {
        return this.whInfoService.findGroupWarehouseByNameCode(nameOrCode, physicalWarehouseCode, noPage);
    }

    @Deprecated
    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouse(String warehouseCode) {
        return this.whInfoService.findPhysicalWarehouseByWarehouse(warehouseCode);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodes(Set<String> warehouseCodeSet) {
        return this.whInfoService.findPhysicalWarehouseByWarehouseCodes(warehouseCodeSet);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodesNew(Set<String> warehouseCodeSet) {
        return this.whInfoService.findPhysicalWarehouseByWarehouseCodesNew(warehouseCodeSet);
    }

    @Deprecated
    public WhWarehouse findUniqWaitForDispatchingWarehouse(String warehouseCode) {
        return this.whInfoService.findUniqWaitForDispatchingWarehouse(warehouseCode);
    }

    public WhWarehouse findUniqDamagedWarehouse(String warehouseCode) {
        return this.whInfoService.findUniqDamagedWarehouse(warehouseCode);
    }

    public WhWarehouse findUniqWastedWarehouse(String warehouseCode) {
        return this.whInfoService.findUniqWastedWarehouse(warehouseCode);
    }

    public void autoProcessShelvesStatus() {
        this.whWmsConnectPickSkuService.autoProcessShelvesStatus();
    }

    public WhWarehouse findUniqProducingWarehouse(String warehouseCode) {
        return this.whInfoService.findUniqProducingWarehouse(warehouseCode);
    }

    public boolean isInSamePhysicalWarehouse(String warehouseCode1, String warehouseCode2) {
        return this.whInfoService.isInSamePhysicalWarehouse(warehouseCode1, warehouseCode2);
    }

    public boolean isWarehouseInSameWarehouseGroup(String warehouseCode1, String warehouseCode2) {
        return this.whInfoService.isWarehouseInSameWarehouseGroup(warehouseCode1, warehouseCode2);
    }

    public boolean isWarehouseMove(String warehouseCode1, String warehouseCode2) {
        return this.whInfoService.isWarehouseMove(warehouseCode1, warehouseCode2);
    }

    @Deprecated
    public List<WhWarehouse> findWarehouseByPhysicalCodeAndStatusTmp(String pyhialCode, Integer type) {
        return this.whInfoService.findWarehouseByPhysicalCodeAndStatus(pyhialCode, type);
    }

    @Deprecated
    public List<WhWarehouse> findWarehouseByPhysicalCodeAndStatus(String pyhialCode, Integer commodityStatus) {
        return this.whInfoService.findWarehouseByPhysicalCodeAndStatus(pyhialCode, commodityStatus);
    }

    public List<WhWarehouse> findAllWarehousesByPhyCodeAndStatus(String pyhialCode, Integer commodityStatus, Integer relateType) {
        return this.whInfoService.findAllWarehousesByPhyCodeAndStatus(pyhialCode, commodityStatus, relateType);
    }

    public List<WhWarehouse> listWarehousesByPhyCodeAndStatusFromGroup(String pyhialCode, Integer commodityStatus) {
        return this.whInfoService.listWarehousesByPhyCodeAndStatusFromGroup(pyhialCode, commodityStatus);
    }

    public WhWarehouse findDefaultInNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultInNondefectiveWarehouseByPhyWhCode(physicalWarehouseCode);
    }

    public WhWarehouse findDefaultOutNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultOutNondefectiveWarehouseByPhyWhCode(physicalWarehouseCode);
    }

    public WhWarehouse findDefaultInDefectiveWarehouseByPhyWhCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(physicalWarehouseCode);
    }

    @Deprecated
    public WhWarehouse findPhyWhUniqWaitForDispatchingWarehouse(String pyhialCode) {
        List<WhWarehouse> whWarehouseList = this.whInfoService.findWarehouseByPhysicalCodeAndStatus(pyhialCode, WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        if (EmptyUtil.isEmpty(whWarehouseList) || whWarehouseList.size() > 1) {
            throw new WarehouseException("WH0001", "\u540c\u7269\u7406\u4ed3\u53ea\u80fd\u6709\u4e00\u4e2a\u5f53\u524d\u7c7b\u578b\u7684\u903b\u8f91\u4ed3");
        }
        return whWarehouseList.get(0);
    }

    public List<WhWarehouseGroupVO> findWarehouseGroupByCond(WhWarehouseGroupCond cond, boolean cascade) {
        return this.whWarehouseGroupService.findByCond(cond, cascade);
    }

    public List<WhWarehouseGroupVO> findWarehouseGroupByWhCodes(WhWarehouseGroupCond cond) {
        return this.whWarehouseGroupService.findWarehouseGroupByWhCodes(cond);
    }

    public WhWarehouseGroupVO findWarehouseGroupByWhCode(String warehouseCode, boolean cascade) {
        return this.whWarehouseGroupService.findWarehouseGroupByWhCode(warehouseCode, cascade);
    }

    public WhWarehouseGroupVO findWarehouseGroupByPhyWhCode(String phyWhCode, boolean cascade) {
        return this.whWarehouseGroupService.findWarehouseGroupByPhyWhCode(phyWhCode, cascade);
    }

    public Pagination<WhWarehouseGroupVO> findWarehouseGroupByCondPage(WhWarehouseGroupCond cond) {
        return this.whWarehouseGroupService.findByCondPage(cond);
    }

    public Map<Long, WhWarehouseGroupVO> findAllWarehouseGroupMap(boolean cascade) {
        return this.whWarehouseGroupService.findAllMap(cascade);
    }

    public Map<String, WhWarehouseGroupVO> findWhGroupMap(List<String> relateWarehouseCodes) {
        return this.whWarehouseGroupService.findWhGroupMap(relateWarehouseCodes);
    }

    public List<WhWarehouseGroupVO> findAllWarehouseGroup(boolean cascade) {
        return this.whWarehouseGroupService.findAll(cascade);
    }

    public WhWarehouseGroupVO findWarehouseGroupById(Long id, boolean cascade) {
        return this.whWarehouseGroupService.findById(id, cascade);
    }

    public boolean saveOrUpdateWarehouseGroup(WhWarehouseGroupVO groupVO) {
        return this.whWarehouseGroupService.saveOrUpdate(groupVO);
    }

    public String createAllotRcd(WhAllotRcd whAllotRcd) throws Exception {
        return this.whAllotService.createAllotRcd(whAllotRcd);
    }

    public String createAllotRcdAndFinishCommand(WhAllotRcd whAllotRcd, Integer type, boolean fetch) throws Exception {
        String allotCode = this.whCommandService.createAllotRcdAndFinishCommand(whAllotRcd, type, fetch);
        return allotCode;
    }

    public String createAutoTransferAllot(WhAllotRcd whAllotRcd) throws Exception {
        return this.whAllotService.createAutoTransferAllot(whAllotRcd);
    }

    public String createPreAllotRcd(WhPreAllotRcd whPreAllotRcd) throws Exception {
        return this.whAllotService.createPreAllotRcd(whPreAllotRcd);
    }

    public boolean isWarehouseInnerMove(WhAllotRcd whAllotRcd) {
        return this.whAllotService.isWarehouseInnerMove(whAllotRcd);
    }

    public boolean isWarehouseGroupChannelMove(WhAllotRcd whAllotRcd) {
        return this.whAllotService.isWarehouseGroupChannelMove(whAllotRcd);
    }

    public boolean isAllotDirectComplete(WhAllotRcd whAllotRcd) {
        return this.whAllotService.isAllotDirectComplete(whAllotRcd);
    }

    public boolean isAllotSecondConfirm(WhAllotRcd whAllotRcd) {
        return this.whAllotService.isAllotSecondConfirm(whAllotRcd);
    }

    public boolean cancelAllotRcdByCode(String code) throws Exception {
        return this.whAllotService.cancelAllotRcdByCode(code);
    }

    public Map<String, Boolean> isAllotCanCancel(List<String> codes) {
        return this.whAllotService.isAllotCanCancel(codes);
    }

    public boolean cancelAllotRcdByCodeFromWms(String code) throws Exception {
        return this.whAllotService.cancelAllotRcdByCodeFromWms(code);
    }

    public boolean cancelAllotRcdByCodeForCustomization(String code) throws Exception {
        return this.whAllotService.cancelAllotRcdByCodeForCustomization(code);
    }

    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku) {
        return this.whAllotService.findAllotRcdByCode(code, fetchSku);
    }

    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku, boolean fetchRefPackageSku) {
        return this.whAllotService.findAllotRcdByCode(code, fetchSku, fetchRefPackageSku);
    }

    public List<WhAllotDiffDetailVO> findAllotDiffDetailByExample(WhAllotDiffDetailVO allotDiffDetailVO) {
        return this.whAllotService.findAllotDiffDetailByExample(allotDiffDetailVO);
    }

    public List<WhAllotDiffDetailVO> listAllotDiffDetailByCode(WhAllotDiffDetailVO allotDiffDetailVO) {
        return this.whAllotService.listAllotDiffDetailByCode(allotDiffDetailVO);
    }

    public WhAllotRcd findAllotRcdById(Long id) {
        return this.whAllotService.findAllotRcdById(id);
    }

    public Integer countRefPackCancelQuantityAfterAllotFinished(WhAllotCond allotCond) {
        return this.whAllotService.countRefPackCancelQuantityAfterAllotFinished(allotCond);
    }

    public WhAllotRcd findAllotRcdByTypeAndReferenceCode(Integer type, String referenceCode, boolean fetchSku) {
        return this.whAllotService.findAllotRcdByTypeAndReferenceCode(type, referenceCode, fetchSku);
    }

    public List<WhAllotRcd> findAllotRcdByCond(WhAllotCond cond) {
        return this.whAllotService.findAllotRcdByCond(cond);
    }

    public List<WhAllotRcd> selectAllotRcdByCond(WhAllotCond cond) {
        return this.whAllotService.selectAllotRcdByCond(cond);
    }

    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond) {
        return this.whAllotService.findPreAllotRcdByCond(cond);
    }

    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond, boolean fetchSku, boolean fetchCountQuantity) {
        return this.whAllotService.findPreAllotRcdByCond(cond, fetchSku, fetchCountQuantity);
    }

    public List<WhPreAllotRcdDownloadVO> findPreAllotRcdListByCond(WhAllotCond cond) {
        return this.whAllotService.findPreAllotRcdListByCond(cond);
    }

    public List<WhPreAllotRcdSku> findPreAllotRcdSkuByPreId(Long preId) {
        return this.whAllotService.findPreAllotRcdSkuByPreId(preId);
    }

    public String autoCreateAllotRcd(WhPreAllotRcdVO vo) {
        return this.whAllotService.autoCreateAllotRcd(vo);
    }

    public List<WhAllotRcd> getAllotRcdByCond(WhAllotCond cond) {
        return this.whAllotService.getAllotRcdByCond(cond);
    }

    public void updateWhPreAllotRcdByCond(WhPreAllotRcd whPreAllotRcd) {
        this.whAllotService.updateWhPreAllotRcdByCond(whPreAllotRcd);
    }

    public List<WhAllotRcdSku> findAllotRcdSkuByAllotId(Long allotId) {
        return this.whAllotService.findAllotRcdSkuByAllotId(allotId);
    }

    public List<WhAllotRcdSku> findAllotRcdSkuByAllotCode(String allotCode) {
        return this.whAllotService.findAllotRcdSkuByAllotCode(allotCode);
    }

    public List<WhAllotRcd> findAllotRcdWaitForConfirmation(String warehouseCode) {
        return this.whAllotService.findAllotRcdWaitForConfirmation(warehouseCode);
    }

    public List<WhAllotRcd> findAllotRcdWaitForOutbound(String warehouseCode) {
        return this.whAllotService.findAllotRcdWaitForOutbound(warehouseCode);
    }

    public List<WhAllotRcd> findAllotRcdWaitForInbound(String warehouseCode) {
        return this.whAllotService.findAllotRcdWaitForInbound(warehouseCode);
    }

    public boolean updateAllotRcdStatusById(Long id, Integer newStatus) throws Exception {
        return this.whAllotService.updateAllotRcdStatusById(id, newStatus);
    }

    public boolean updateAllotRcdStatusByCode(String code, Integer newStatus) throws Exception {
        return this.whAllotService.updateAllotRcdStatusByCode(code, newStatus);
    }

    public boolean updateAllotRcdStatusByCodeNew(String code, Integer newStatus, String rejectedReason) throws Exception {
        return this.whAllotService.updateAllotRcdStatusByCodeNew(code, newStatus, rejectedReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allotPackageInbound(WhAllotPackageInBoundVO altPackageInBound) {
        String lockKey = "scm:inbound:cmd:" + altPackageInBound.getInCommandCode();
        try {
            boolean getLock = this.redisDistributLock.tryLock(lockKey, 10L, TimeUnit.SECONDS);
            if (!getLock) {
                throw new WarehouseException("WH0001", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            boolean bl = this.whAllotService.allotPackageInbound(altPackageInBound);
            return bl;
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    public boolean updateByPrimaryKeySelective(WhJitPackageSkuReference record) {
        return this.whJitPackageSkuReferenceService.updateByPrimaryKeySelective(record);
    }

    public boolean createWhJitPackageSkuReference(List<WhJitPackageSkuReferenceVO> voList) {
        return this.whJitPackageSkuReferenceService.createWhJitPackageSkuReference(voList);
    }

    public List<WhJitPackageSkuReferenceVO> findByReferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceService.findByReferenceCode(referenceCode);
    }

    public List<WhJitPackageSkuReferenceVO> findBySkuCode(String skuCode) {
        return this.whJitPackageSkuReferenceService.findBySkuCode(skuCode);
    }

    public List<WhJitPackageSkuReferenceVO> findByPackageCode(String packageCode) {
        return this.whJitPackageSkuReferenceService.findByPackageCode(packageCode);
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageRefByPackageCode(String packageCode, Integer type) {
        return this.whJitPackageSkuReferenceService.findJitPackageRefByPackageCode(packageCode, type);
    }

    public int findUndistributedNumberByreferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceService.findUndistributedNumberByreferenceCode(referenceCode);
    }

    public List<WhJitPackageSkuReferenceVO> findNeedAllotPackageByReferenceCode(String referenceCode, Integer type) {
        return this.whJitPackageSkuReferenceService.findNeedAllotPackageByReferenceCode(referenceCode, type);
    }

    public List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceListByTypeAndReferenceCode(String referenceCode, Integer type) {
        return this.whJitPackageSkuReferenceService.findOpJitPackageReferenceListByTypeAndReferenceCode(referenceCode, type);
    }

    public List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceByTypeAndReferenceCode(List<String> referenceCodes, Integer type) {
        return this.whJitPackageSkuReferenceService.findOpJitPackageReferenceByTypeAndReferenceCode(referenceCodes, type);
    }

    public WhJitPackageSkuReferenceVO findLastUsableJitPackageReferenceByTypeAndReferenceCode(String referenceCode, Integer type) {
        return this.whJitPackageSkuReferenceService.findLastUsableJitPackageReferenceByTypeAndReferenceCode(referenceCode, type);
    }

    public List<WhJitPackageSkuReferenceVO> findNeedAllotByReferenceCode(String packageCode, String skuCode) {
        return this.whJitPackageSkuReferenceService.findNeedAllotByReferenceCode(packageCode, skuCode);
    }

    public List<WhJitPackageSkuReferenceVO> findNeedAllotByPackageCodeAndSkuCode(String packageCode, String skuCode, Integer referenceType) {
        return this.whJitPackageSkuReferenceService.findNeedAllotByPackageCodeAndSkuCode(packageCode, skuCode, referenceType);
    }

    public int countAssigndNumber(String packageCode, String skuCode) {
        return this.whJitPackageSkuReferenceService.countAssigndNumber(packageCode, skuCode);
    }

    public WhJitPackageSkuReferenceVO findPopWarehouseByReferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceService.findPopWarehouseByReferenceCode(referenceCode);
    }

    public WhJitPackageSkuReferenceVO findPjWarehouseByReferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceService.findPjWarehouseByReferenceCode(referenceCode);
    }

    public List<WhJitPackageSkuReferenceVO> findByPackageCode(List<String> packageCodeList, Integer referenceType) {
        return this.whJitPackageSkuReferenceService.findByPackageCode(packageCodeList, referenceType);
    }

    public List<WhJitPackageSkuReferenceVO> findByReferenceCode(List<String> referenceCodeList) {
        return this.whJitPackageSkuReferenceService.findByReferenceCode(referenceCodeList);
    }

    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPakcageSkuByReferenceCodeGroup(List<String> referenceCodeList) {
        return this.whJitPackageSkuReferenceService.findByReferenceCodeGroup(referenceCodeList);
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobCancel() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotSendMailAfterJobCancel();
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobFinishException() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotSendMailAfterJobFinishException();
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotCreatePrdcJobAfterAltFinished() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotCreatePrdcJobAfterAltFinished();
    }

    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotCreatePrdcJobAfterAltFinishedGroup() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotCreatePrdcJobAfterAltFinishedGroup();
    }

    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotSendMailAfterAltFinishedGroup(WhJitPackageSkuReferenceVO vo) {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotSendMailAfterAltFinishedGroup(vo);
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotAltAfterPrdcJobFinished() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotAltAfterPrdcJobFinished();
    }

    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotAltAfterPrdcJobFinishedGroup() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotAltAfterPrdcJobFinishedGroup();
    }

    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuOrderCancelGroup() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuOrderCancelGroup();
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterOrderCancel() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotSendMailAfterOrderCancel();
    }

    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotProcessAfterOrderPaidGroup() {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuNotProcessAfterOrderPaidGroup();
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuByPackageCode(List<String> packageCodes) {
        return this.whJitPackageSkuReferenceService.findJitPackageSkuByPackageCode(packageCodes);
    }

    public List<WhJitPackageSkuReferenceVO> findReferenceCodeByPackageCode(List<String> packageCodes) {
        return this.whJitPackageSkuReferenceService.findReferenceCodeByPackageCode(packageCodes);
    }

    public List<AssociatedInfoVO> findAssociatedInfoByreferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceService.findAssociatedInfoByreferenceCode(referenceCode);
    }

    public List<AssociatedInfoVO> findJobAssociatedInfoByreferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceService.findJobAssociatedInfoByreferenceCode(referenceCode);
    }

    public List<WhJitPackageSkuReferenceVO> findNonCustomByPackageCode(Long orderId) {
        return this.whJitPackageSkuReferenceService.findNonCustomByPackageCode(orderId);
    }

    public WhCustomizatonParam findCustomizatonParamByType(Integer type) {
        return this.whCustomizatonParamService.findCustomizatonParamByType(type);
    }

    public boolean saveOrUpdateCustomizationParam(WhCustomizatonParam param) {
        return this.whCustomizatonParamService.saveOrUpdateCustomizationParam(param);
    }

    public String createCommand(WhCommand whCommand) throws Exception {
        return this.whCommandService.createCommand(whCommand);
    }

    public String createCommandThenFinish(WhCommand whCommand) throws Exception {
        return this.whCommandService.createCommandThenFinish(whCommand);
    }

    public String createCommandAfterRelease(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.whCommandService.createCommandAfterRelease(whCommand, whReleaseOccupationVOList);
    }

    public String createCommandAfterOccupy(WhCommand whCommand, List<WhInvOccupy> whInvOccupyList) throws Exception {
        return this.whCommandService.createCommandAfterOccupy(whCommand, whInvOccupyList);
    }

    public String createCommandAfterReleaseThenFinish(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.whCommandService.createCommandAfterReleaseThenFinish(whCommand, whReleaseOccupationVOList);
    }

    public String createCommandThenFinishWithoutOccupy(WhCommand whCommand, List<WhReleaseOccupationVO> releaseList) {
        return this.whCommandService.createCommandThenFinishWithoutOccupy(whCommand, releaseList);
    }

    public String createCommandThenFinishForSales(WhCommand whCommand, List<WhReleaseOccupationVO> releaseList, List<WhInvRcd> invRcdList, String uniqueCode) {
        return this.whCommandService.createCommandThenFinishForSales(whCommand, releaseList, invRcdList, uniqueCode);
    }

    public boolean finishOutCommandForSales(WhCommand whCommand, List<WhReleaseOccupationVO> releaseList, List<WhInvRcd> invRcdList) {
        return this.whCommandService.finishOutCommandForSales(whCommand, releaseList, invRcdList);
    }

    public WhCommand findCommandByCode(String code, boolean fetch) {
        return this.whCommandService.findCommandByCode(code, fetch);
    }

    public WhCommand findNewCommandByCode(String code, boolean fetch) {
        return this.whCommandService.findNewCommandByCode(code, fetch);
    }

    public List<WhCommand> findCommandByCodes(List<String> codeList, boolean fetch) {
        return this.whCommandService.findCommandByCodes(codeList, fetch);
    }

    public List<WhCommandSku> findCommandSkuByCommandCodes(List<String> commandCodeList) {
        return this.whCommandService.findCommandSkuByCommandCodes(commandCodeList);
    }

    public List<WhCommandSku> findCommandSkuByCommandSkuCodes(List<String> commandCodeList) {
        return this.whCommandService.findCommandSkuByCommandSkuCodes(commandCodeList);
    }

    public List<WhCommand> findInProcessCommandByWarehouseAndAndCodes(List<String> warehouseCodeList, List<String> codeList) {
        return this.whCommandService.findInProcessCommandByWarehouseAndAndCodes(warehouseCodeList, codeList);
    }

    public WhCommand findCommandByTypeAndReferenceCode(Integer type, String referenceCode, boolean fetch) {
        return this.whCommandService.findCommandByTypeAndReferenceCode(type, referenceCode, fetch);
    }

    public WhCommand findCommandByReferenceCode(String referenceCode) {
        return this.whCommandService.findCommandByReferenceCode(referenceCode);
    }

    public List<WhCommand> findCommandByCond(WhCommandCond cond) {
        return this.whCommandService.findCommandByCond(cond);
    }

    public List<OffSpotGood> findOffSpotGoodsListByCond(OffSpotGoodsCond cond) {
        return this.offSpotGoodsService.findOffSpotGoodsListByCond(cond);
    }

    public List<OffSpotGood> findDetailOffSpotGoodsList(String skuCode) {
        return this.offSpotGoodsService.findDetailOffSpotGoodsList(skuCode);
    }

    public List<OffSpotGood> findDetailOnTheWayOffSpotGoodsList(String skuCode) {
        return this.offSpotGoodsService.findDetailOnTheWayOffSpotGoodsList(skuCode);
    }

    public List<WhCommand> findUnDeliveryGoodsAndNoSendMailByCond(WhCommandCond cond) {
        return this.whCommandService.findUnDeliveryGoodsAndNoSendMailByCond(cond);
    }

    public List<WhCommand> findInProcessCommandByWarehouseAndTimeRange(List<String> warehouseCodeList, Date startTime, Date endTime) {
        return this.whCommandService.findInProcessCommandByWarehouseAndTimeRange(warehouseCodeList, startTime, endTime);
    }

    public WhCommandSku findCommandSkuByCode(String code) {
        return this.whCommandService.findCommandSkuByCode(code);
    }

    public List<WhCommandSku> findCommandSkuByCommandCode(String commandCode) {
        return this.whCommandService.findCommandSkuByCommandCode(commandCode);
    }

    public List<WhCommandSku> findCommandSkuByCommandId(Long commandId) {
        return this.whCommandService.findCommandSkuByCommandId(commandId);
    }

    public boolean cancelCommandWithoutOccupy(WhCommand rcd) {
        return this.whCommandService.cancelCommandWithoutOccupy(rcd);
    }

    public boolean cancelCommandById(Long id) {
        return this.whCommandService.cancelCommandById(id);
    }

    public boolean cancelCommandByCode(String code) {
        return this.whCommandService.cancelCommandByCode(code);
    }

    public boolean cancelCommandByTypeAndReferenceCode(Integer type, String referenceCode) {
        return this.whCommandService.cancelCommandByTypeAndReferenceCode(type, referenceCode);
    }

    public void resetCommandReferenceCodeByTypeAndReferenceCode(Integer type, String referenceCode) {
        this.whCommandService.resetCommandReferenceCodeByTypeAndReferenceCode(type, referenceCode);
    }

    public void resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(Integer type, String referenceCode, List<WhInvOccupy> whInvOccupyList) {
        this.whCommandService.resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(type, referenceCode, whInvOccupyList);
    }

    public boolean finishCommandById(Long id) throws Exception {
        return this.whCommandService.finishCommandById(id);
    }

    public List<WhCommand> findInProcessCommandByIncrement(List<String> warehouseCodeList, Date incrementTime) {
        return this.whCommandService.findInProcessCommandByIncrement(warehouseCodeList, incrementTime);
    }

    public boolean finishCommandByTypeAndReferenceCode(Integer type, String referenceCode) throws Exception {
        return this.whCommandService.finishCommandByTypeAndReferenceCode(type, referenceCode);
    }

    public boolean finishCommand(WhCommand rcd) throws Exception {
        return this.whCommandService.finishCommand(rcd);
    }

    public boolean finishCommandWithoutOccupy(WhCommand rcd) {
        return this.whCommandService.finishCommandWithoutOccupy(rcd);
    }

    public boolean processCommandOutFinish(WhCommand command, List<WhInvRcd> invRcdList, List<WhReleaseOccupationVO> releaseList) {
        return this.whCommandService.processCommandOutFinish(command, invRcdList, releaseList);
    }

    public List<WhWmsMoveStock> findWmsMoveStockByPrdCode(String prdCode) {
        return this.whWmsMoveStockService.findWmsMoveStockByPrdCode(prdCode);
    }

    public Integer cancelWmsMoveStockByIdList(List<Long> idList) {
        return this.whWmsMoveStockService.cancelWmsMoveStockByIdList(idList);
    }

    public Long recordDamage(WhDamagedRcd whDamagedRcd) throws Exception {
        return this.whDamageWasteService.recordDamage(whDamagedRcd);
    }

    public Long recordWaste(WhWastedRcd whWastedRcd) throws Exception {
        return this.whDamageWasteService.recordWaste(whWastedRcd);
    }

    public Map<String, List<WhDamagedRcd>> findDamagedRcdBySkuCode(String skuCode) {
        return this.whDamageWasteService.findDamagedRcdBySkuCode(skuCode);
    }

    public List<WhDamagedRcd> findDamagedRcdBySkuCodeAndWarehouseCode(String skuCode, String sourceWarehouseCode) {
        return this.whDamageWasteService.findDamagedRcdBySkuCodeAndWarehouseCode(skuCode, sourceWarehouseCode);
    }

    public List<WhDamagedRcd> findDamagedRcdByCond(WhDamagedRcdCond cond) {
        return this.whDamageWasteService.findDamagedRcdByCond(cond);
    }

    public Map<String, List<WhWastedRcd>> findWastedRcdBySkuCode(String skuCode) {
        return this.whDamageWasteService.findWastedRcdBySkuCode(skuCode);
    }

    public List<WhWastedRcd> findWastedRcdBySkuCodeAndWarehouseCode(String skuCode, String sourceWarehouseCode) {
        return this.whDamageWasteService.findWastedRcdBySkuCodeAndWarehouseCode(skuCode, sourceWarehouseCode);
    }

    public boolean dealDamaged(String warehouseCode, String skuCode, Integer quantity, String type) throws Exception {
        return this.whDamageWasteService.dealDamaged(warehouseCode, skuCode, quantity, type);
    }

    public List<WhWarehouseInvQttVO> findInvQttBySkuCode(String skuCode) {
        return this.whInvService.findInvQttBySkuCode(skuCode);
    }

    public List<WhWarehouseInvQttVO> findWillInQttBySkuCode(String skuCode) {
        return this.whInvService.findWillInQttBySkuCode(skuCode);
    }

    public List<WhSkuInvQttVO> findSkuInvQttByWarehouseCode(String warehouseCode) {
        return this.whInvService.findSkuInvQttByWarehouseCode(warehouseCode);
    }

    public List<WhSkuInvQttVO> findSkuInvQttByPhysicalWarehouseCode(String physicalWarehouseCode) {
        return this.whInvService.findSkuInvQttByPhysicalWarehouseCode(physicalWarehouseCode);
    }

    public List<WhSkuInvQttVO> findSkuInvQttByWarehouseCodes(List<String> warehouseCodeList) {
        return this.whInvService.findSkuInvQttByWarehouseCodes(warehouseCodeList);
    }

    public List<WhSkuInvQttVO> findOccupyQttByWarehouseCode(String warehouseCode) {
        return this.whInvService.findOccupyQttByWarehouseCode(warehouseCode);
    }

    public List<WhSkuInvQttVO> findWillInQttByWarehouseCode(String warehouseCode) {
        return this.whInvService.findWillInQttByWarehouseCode(warehouseCode);
    }

    public int findInvQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode) {
        return this.whInvService.findInvQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
    }

    public int findQttBySkuCode(String skuCode) {
        return this.whInvService.findQttBySkuCode(skuCode);
    }

    public List<WhSkuInvQttVO> findInvQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        return this.whInvService.findInvQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
    }

    public List<WhWarehouseInvQttVO> findOccupyQttBySkuCode(String skuCode) {
        return this.whInvService.findOccupyQttBySkuCode(skuCode);
    }

    public int findOccupyQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode) {
        return this.whInvService.findOccupyQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
    }

    public List<WhSkuInvQttVO> findOccupyQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        return this.whInvService.findOccupyQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
    }

    public Map<String, WhInvVO> findCanUseQttBySkuCode(String skuCode) {
        return this.whInvService.findCanUseQttBySkuCode(skuCode);
    }

    public List<WhWarehouseSkuInvVO> findWarehousesSkuInvByCond(List<String> warehouseCodeList, String skuCode) {
        return this.whInvService.findWarehousesSkuInvByCond(warehouseCodeList, skuCode);
    }

    public Map<String, WhWarehouse> getWarehouseMap(List<String> warehouseCodeList) {
        return this.whInvService.getWarehouseMap(warehouseCodeList);
    }

    public Map<String, WhInvVO> findCanUseQttByWarehouseCode(String warehouseCode) {
        return this.whInvService.findCanUseQttByWarehouseCode(warehouseCode);
    }

    public WhInvVO findCanUseQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode) {
        return this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
    }

    public Map<String, WhInvVO> findCanUseQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        return this.whInvService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
    }

    public List<WhInvQttVO> findInvQttBySkuCode_IPOS(String channelCode, String skuCodes) {
        return this.whInvService.findInvQttBySkuCode_IPOS(channelCode, skuCodes);
    }

    public List<WhInvVO> calCanUseQtt() {
        return this.whInvService.calCanUseQtt();
    }

    public Long createTakeStock(WhTakeStock whTakeStock) throws Exception {
        return this.whTakeStockService.createTakeStock(whTakeStock);
    }

    public List<Long> batchCreateTakeStock(List<WhTakeStock> whTakeStockList) throws Exception {
        return this.whTakeStockService.batchCreateTakeStock(whTakeStockList);
    }

    public boolean createWhInventory(WhInventoryCreateVO inventoryInfo) {
        return this.whInventoryService.createWhInventory(inventoryInfo);
    }

    public WhInventoryVO findWhInventory(Long id) {
        return this.whInventoryService.findWhInventory(id);
    }

    public WhInventoryVO findWhInventory(Long id, boolean cascade) {
        return this.whInventoryService.findWhInventory(id, cascade);
    }

    public List<WhInventoryVO> findWhInventoryByCond(WhInventoryCond cond) {
        return this.whInventoryService.findWhInventoryByCond(cond);
    }

    public Pagination<WhInventoryVO> findWhInventoryByCondPage(WhInventoryCond cond) {
        return this.whInventoryService.findWhInventoryByCondPage(cond);
    }

    public boolean initWhInventory(Long invenotryId) {
        return this.whInventoryService.initWhInventory(invenotryId);
    }

    public boolean cancelWhInventory(Long inventoryId) {
        return this.whInventoryService.cancelWhInventory(inventoryId);
    }

    public boolean submitInventoryForManagerAudit(Long inventoryId) {
        return this.whInventoryService.submitInventoryForManagerAudit(inventoryId);
    }

    public boolean whInventoryExistDiff(Long inventoryId) {
        return this.whInventoryService.whInventoryExistDiff(inventoryId);
    }

    public WhInventoryDetailVO findWhInventoryDetail(Long detailId) {
        return this.whInventoryService.findWhInventoryDetail(detailId);
    }

    public List<WhInventoryDetailVO> findWhInventoryDetailByCond(WhInventoryDetailCond detailCond) {
        return this.whInventoryService.findWhInventoryDetailByCond(detailCond);
    }

    public Pagination<WhInventoryDetailVO> findWhInventoryDetailByCondPage(WhInventoryDetailCond detailCond) {
        return this.whInventoryService.findWhInventoryDetailByCondPage(detailCond);
    }

    public List<WhInventoryReasionDicVO> findAllWhInventoryReasionDic() {
        return this.whInventoryService.findAllWhInventoryReasionDic();
    }

    public boolean submitWhInventoryDetail(WhInventoryDetailVO inventoryDetail) {
        return this.whInventoryService.submitWhInventoryDetail(inventoryDetail);
    }

    public boolean reInitInventoryDetail(Long inventoryDetailId) {
        return this.whInventoryService.reInitInventoryDetail(inventoryDetailId);
    }

    public boolean addWhInventoryDetail(WhInventoryDetailVO inventoryDetail) {
        return this.whInventoryService.addWhInventoryDetail(inventoryDetail);
    }

    public boolean inventoryDetailManagerAudit(WhInventoryDetailAuditVO auditInfo) {
        return this.whInventoryService.inventoryDetailManagerAudit(auditInfo);
    }

    public boolean inventoryDetailManagerBatchAudit(WhInventoryDetailAuditVO auditInfo) {
        return this.whInventoryService.inventoryDetailManagerBatchAudit(auditInfo);
    }

    public boolean inventoryFinishForManager(WhInventoryAuditVO auditInfo) {
        return this.whInventoryService.inventoryFinishForManager(auditInfo);
    }

    public boolean inventoryDetailFinanceAudit(WhInventoryDetailAuditVO auditInfo) {
        return this.whInventoryService.inventoryDetailFinanceAudit(auditInfo);
    }

    public boolean inventoryDetailFinanceBatchAudit(WhInventoryDetailAuditVO auditInfo) {
        return this.whInventoryService.inventoryDetailFinanceBatchAudit(auditInfo);
    }

    public boolean inventoryFinishForFinance(WhInventoryAuditVO auditInfo) {
        return this.whInventoryService.inventoryFinishForFinance(auditInfo);
    }

    public WhInventoryCountInfoVO countProcessingWhInventory(String physicalWarehouseCode) {
        return this.whInventoryService.countProcessingWhInventory(physicalWarehouseCode);
    }

    public boolean processingWhInventoryDetailInSingle(WhInventoryDetailVO inventoryDetail) {
        return this.whInventoryService.processingWhInventoryDetailInSingle(inventoryDetail);
    }

    public boolean processingWhInventoryDetailInContinue(WhInventoryDetailVO inventoryDetail) {
        return this.whInventoryService.processingWhInventoryDetailInContinue(inventoryDetail);
    }

    public List<WhInventoryEmailVO> findAllWhInventoryEmail() {
        return this.whInventoryService.findAllWhInventoryEmail();
    }

    public List<WhInventoryEmailVO> findWhInventoryEmail(String physicalWarehouseCode) {
        return this.whInventoryService.findWhInventoryEmail(physicalWarehouseCode);
    }

    public boolean saveWhInventoryEmail(List<WhInventoryEmailVO> emailList) {
        return this.whInventoryService.saveWhInventoryEmail(emailList);
    }

    public List<WhTakeStockRcdVO> findTakeStockByWarehouseCode(String warehouseCode, boolean fetchRcd) {
        return this.whTakeStockService.findTakeStockByWarehouseCode(warehouseCode, fetchRcd);
    }

    public PageInfo<WhTakeStockRcdVO> findTakeStockByCond(WhTakeStockCond cond) {
        return this.whTakeStockService.findTakeStockByCond(cond);
    }

    public List<WhInvRcdVO> getInvRcdByCond(WhInvRcdCond cond) {
        List<WhInvRcdVO> whInvRcdVOList = this.whInvService.getInvRcdByCond(cond);
        if (EmptyUtil.isNotEmpty(whInvRcdVOList)) {
            for (WhInvRcdVO whInvRcdVO : whInvRcdVOList) {
                if (EmptyUtil.isNotEmpty((String)whInvRcdVO.getReferenceCode())) continue;
                if (NullUtil.isNotNull((Object)whInvRcdVO.getTakeStockRcdId())) {
                    whInvRcdVO.setReferenceCode(whInvRcdVO.getTakeStockRcdId() + "");
                    continue;
                }
                if (!NullUtil.isNotNull((Object)whInvRcdVO.getWmsTakeStockRcdId())) continue;
                whInvRcdVO.setReferenceCode(whInvRcdVO.getWmsTakeStockRcdId() + "");
            }
        }
        return whInvRcdVOList;
    }

    public List<WhInvRcdExtend> findWhInvRcdExtendListByIdList(List<Long> idList) {
        return this.whInvService.findWhInvRcdExtendListByIdList(idList);
    }

    public List<WhInvOccupy> getInvOccupyByCond(WhInvRcdCond cond) {
        List<WhInvOccupy> whInvRcdVOList = this.whInvService.getInvOccupyByCond(cond);
        return whInvRcdVOList;
    }

    public WhInvOccupy getCountInvRcdWillInByCond(WhInvRcdCond cond) {
        WhInvOccupy whInvRcdVOList = this.whInvService.getCountInvRcdWillInByCond(cond);
        return whInvRcdVOList;
    }

    public List<WhInvOccupy> getInvRcdWillInByCond(WhInvRcdCond cond) {
        List<WhInvOccupy> whInvRcdVOList = this.whInvService.getInvRcdWillInByCond(cond);
        return whInvRcdVOList;
    }

    public WhCommandSku findCommandSku(String skuCode, Long commandId) {
        return this.whCommandService.findCommandSku(skuCode, commandId);
    }

    public WhPhysicalWarehouse findPhysicalWarehouseByNo(String no) {
        return this.whInfoService.findPhysicalWarehouseByNo(no);
    }

    public List<WhPhysicalWarehouseVO> findNotRelatePhysicalWarehouses() {
        return this.whInfoService.findNotRelatePhysicalWarehouses();
    }

    public List<WhWarehouseVO> findNotRelateWarehouses() {
        return this.whInfoService.findNotRelateWarehouses();
    }

    public WhPhysicalWarehouse computeDispatchPhysicalWarehouse(String dispatchWhCode, Map<String, Integer> skuQuantityMap, Long targetDistrict) {
        return this.whWmsSkuStockService.computeDispatchPhysicalWarehouse(dispatchWhCode, skuQuantityMap, targetDistrict);
    }

    public boolean updateAllotRcd(WhAllotRcd rcd) {
        return this.whAllotService.updateAllotRcd(rcd);
    }

    public boolean updateAllotRcdSku(WhAllotRcdSku rcdSku) {
        return this.whAllotService.updateAllotRcdSku(rcdSku);
    }

    public void packageAssoExpressFED(PackageInfo pi) {
        this.whCommandService.packageAssoExpressFED(pi);
    }

    public void packageAssoExpressFEDAndCommand(PackageInfo pi) {
        this.whCommandService.packageAssoExpressFEDAndCommand(pi);
    }

    public void packageAssoExpressSF(PackageInfo pi) {
        this.whCommandService.packageAssoExpressSF(pi);
    }

    public void packageAssoExpressSFAndPackage(PackageInfo pi) {
        this.whCommandService.packageAssoExpressSFAndPackage(pi);
    }

    public void packageAssoExpressZTAndPackage(ZTOrderSubmitResponse ztOrderSubmitResponse) {
        this.whCommandService.packageAssoExpressZTAndPackage(ztOrderSubmitResponse);
    }

    public void packageAssoExpressTmsAndCommand(PackageInfo pi) {
        this.whCommandService.packageAssoExpressTmsAndCommand(pi);
    }

    public void commandAssociateExpress(String commandCode, String deliveryCode) {
        this.whCommandService.commandAssociateExpress(commandCode, deliveryCode);
    }

    public void updaeCommand(WhCommand whCommand) {
        this.whCommandService.updateCommand(whCommand);
    }

    public List<WhWmsCommandShortRecord> findWhWmsCommandShortRecordByCommandCode(String commandCode) {
        return this.whCommandService.findWhWmsCommandShortRecordByCommandCode(commandCode);
    }

    public void commandWithPackageExpress() {
        this.whCommandService.commandWithPackageExpress();
    }

    public WhInvOccupy findOccupyQttByReferenceCode(String referenceCode) {
        return this.whInvService.findOccupyQttByReferenceCode(referenceCode);
    }

    public String synCommodityStocks(Long numIid, String outerId, long quantity, String sessionKey, int syncType, String referenceCode, Long operatorId) throws Exception {
        return this.whCommandService.synCommodityStocks(numIid, outerId, quantity, sessionKey, syncType, referenceCode, operatorId);
    }

    public Map<String, JdStockSyncResult> syncJdSkuStock(String warehouseCode, Map<String, Integer> skuQuantityMap, Integer syncType, String referenceCode, Long operatorId) {
        LinkedList<String> referenceCodes = new LinkedList<String>();
        referenceCodes.add(referenceCode);
        return this.whCommandService.syncJdSkuStock(warehouseCode, skuQuantityMap, syncType, referenceCodes, operatorId);
    }

    public void insertWhCommandOutFinish(WhCommandOutFinish whCommandOutFinish) {
        this.whCommandService.insertWhCommandOutFinish(whCommandOutFinish);
    }

    public boolean saveJitPackageSendMail(WhJitPackageSendMailVO vo) {
        return this.whJitPackageSendMailService.saveJitPackageSendMail(vo);
    }

    public String getBarCode(String skuCode, Date prodDate) {
        return this.whCommandService.getBarCode(skuCode, prodDate);
    }

    public String getBarCode(String skuCode, Date prodDate, Date expirationDate) {
        return this.whCommandService.getBarCode(skuCode, prodDate, expirationDate);
    }

    public String getBarCode(WhQualityControlVO qc) {
        return this.whCommandService.getBarCode(qc);
    }

    public String getPrePrintBarCode(WhQualityControlVO qc) {
        return this.whCommandService.getPrePrintBarCode(qc);
    }

    public Long getSupplierIdByPurchaseReturnCode(String purchaseReturnCode) {
        return this.whCommandService.getSupplierIdByPurchaseReturnCode(purchaseReturnCode);
    }

    public String getOriPhyCodeByPurchaseReturnCode(String purchaseReturnCode) {
        return this.whCommandService.getOriPhyCodeByPurchaseReturnCode(purchaseReturnCode);
    }

    public Integer findSkuShelfLifeBySkuCode(String skuCode) {
        return this.whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(skuCode);
    }

    public WhWmsSkuBarcode findMinProdOrExpiryDateByBarCodes(List<String> barCodes) {
        return this.whWmsSkuBarcodeService.findMinProdOrExpiryDateByBarCodes(barCodes);
    }

    public WhWmsSkuBarcodeVO findWhWmsBarcodeById(Long id, boolean fetchMaterial) {
        WhWmsSkuBarcodeVO skuBarcodeVO = this.whWmsSkuBarcodeService.findById(id);
        if (EmptyUtil.isNotEmpty((Object)skuBarcodeVO) && fetchMaterial) {
            WhWmsPrdcMaterialDetailCond cond = new WhWmsPrdcMaterialDetailCond();
            cond.setProdSku(skuBarcodeVO.getSkuCode());
            cond.setProdBarcode(skuBarcodeVO.getBarCode());
            cond.setOrderByClause("MATERIAL_SKU ASC,MATERIAL_BARCODE ASC");
            List<WhWmsPrdcMaterialDetailVO> materialDetailVOs = this.whWmsPrdcMaterialDetailService.listWhWmsPrdcMaterialDetailVOByCond(cond);
            skuBarcodeVO.setMaterialDetailVOs(materialDetailVOs);
        }
        return skuBarcodeVO;
    }

    public List<WhWmsSkuBarcodeVO> findExpiryDateSkuInfo(WhWmsSkuBarcodeCond cond) {
        return this.whWmsSkuBarcodeService.findExpiryDateSkuInfo(cond);
    }

    public List<WhWmsSkuBarcodeVO> getWmsSkuBarcodeByCond(WhWmsSkuBarcodeVO cond) {
        return this.whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(cond);
    }

    public Pagination<WhWmsSkuBarcodeVO> findExpiryDateSkuInfoByCondPage(WhWmsSkuBarcodeCond cond) {
        return this.whWmsSkuBarcodeService.findExpiryDateSkuInfoByCondPage(cond);
    }

    public boolean modifyExpiryDate(WhWmsSkuBarcode cond) {
        return this.whWmsSkuBarcodeService.modifyExpiryDate(cond);
    }

    public List<WhPackageInfoVO> findCHN2053PackageInfo() {
        return this.whCommandService.findCHN2053PackageInfo();
    }

    public List<WhWmsSubmitHandRecord> autoProcessSubmitHandData() {
        return this.whCommandService.autoProcessSubmitHandData();
    }

    public void processSubmitData(List<WhWmsSubmitHandRecord> list) {
        this.whCommandService.processSubmitData(list);
    }

    public List<WhCommandOutFinish> findWhCommandOutFinishNoFinish() {
        return this.whCommandService.findWhCommandOutFinishNoFinish();
    }

    public List<WhWmsExpressInfo> findAllExpressInfo() {
        return this.whInfoService.findAllExpressInfo();
    }

    public List<String> createCommandsAfterReleaseThenFinish(List<WhCommand> whCommandList, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.whCommandService.createCommandsAfterReleaseThenFinish(whCommandList, whReleaseOccupationVOList);
    }

    public boolean consumableReceiveOutInPut(String dispatchBillCode, Map<String, Integer> quantityMap, List<WhWmsSkuStock> whWmsSkuStocks, Long operatorId) throws Exception {
        return this.whWmsConnectPickSkuService.consumableReceiveOutInPut(dispatchBillCode, quantityMap, whWmsSkuStocks, operatorId);
    }

    public int releaseOccupy(List<WhInvOccupy> whInvOccupyList) {
        return this.whInvService.releaseOccupy(whInvOccupyList);
    }

    public void processWhWmsSkuStockDiff() {
        List<WhWmsSkuStockDiffVO> diffList = this.whWmsSkuStockService.findWhWmsSkuStockDiffList();
        if (EmptyUtil.isNotEmpty(diffList)) {
            for (WhWmsSkuStockDiffVO skuStockDiff : diffList) {
                if (NullUtil.isNull((Object)skuStockDiff.getDiffAmount()) || skuStockDiff.getDiffAmount() >= 0 || NullUtil.isNull((Object)skuStockDiff.getScmAmount()) || skuStockDiff.getScmAmount() < 0) continue;
                try {
                    WhWarehouseGroupVO whGroup = this.whWarehouseGroupService.findById(skuStockDiff.getWarehouseGroupId(), true);
                    List<WhPhysicalWarehouseVO> phyWhList = whGroup.getRelatePhysicalWarehouses();
                    if (EmptyUtil.isEmpty(phyWhList) || phyWhList.size() > 1) {
                        throw new RuntimeException(String.format("[%s]\u903b\u8f91\u4ed3\u5206\u7ec4\u914d\u7f6e\u5f02\u5e38\uff01", skuStockDiff.getWarehouseGroupId()));
                    }
                    WhPhysicalWarehouseVO phyWh = phyWhList.get(0);
                    this.whCommandService.updatePhyWhSkuStockOut(phyWh.getCode(), skuStockDiff.getSkuCode(), skuStockDiff.getSkuStatus(), skuStockDiff.getDiffAmount());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void processWhWmsSkuStockDiffNotAdd() {
        List<WhWmsSkuStockDiffVO> diffList = this.whWmsSkuStockService.findWhWmsSkuStockDiffList();
        if (EmptyUtil.isNotEmpty(diffList)) {
            for (WhWmsSkuStockDiffVO skuStockDiff : diffList) {
                if (NullUtil.isNull((Object)skuStockDiff.getDiffAmount()) || skuStockDiff.getDiffAmount() <= 0 || NullUtil.isNull((Object)skuStockDiff.getScmAmount()) || skuStockDiff.getScmAmount() < 0) continue;
                try {
                    WhWarehouseGroupVO whGroup = this.whWarehouseGroupService.findById(skuStockDiff.getWarehouseGroupId(), true);
                    List<WhPhysicalWarehouseVO> phyWhList = whGroup.getRelatePhysicalWarehouses();
                    if (EmptyUtil.isEmpty(phyWhList) || phyWhList.size() > 1) {
                        throw new RuntimeException(String.format("[%s]\u903b\u8f91\u4ed3\u5206\u7ec4\u914d\u7f6e\u5f02\u5e38\uff01", skuStockDiff.getWarehouseGroupId()));
                    }
                    WhPhysicalWarehouseVO phyWh = phyWhList.get(0);
                    this.whWmsSkuStockService.updatePhyWhSkuStock(phyWh.getCode(), skuStockDiff.getSkuCode(), skuStockDiff.getSkuStatus(), skuStockDiff.getDiffAmount(), 19, "diffStock", 1L, "diffStock");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int updateReferenceCode(String oldReferenceCode, String newReferenceCode) {
        return this.whInvService.updateReferenceCode(oldReferenceCode, newReferenceCode);
    }

    public List<String> batchCreatePreAllotRcd(List<WhPreAllotRcd> whPreAllotRcdList) throws Exception {
        return this.whAllotService.batchCreatePreAllotRcd(whPreAllotRcdList);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutNondefectiveWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultOutNondefectiveWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutDefectiveWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultOutDefectiveWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutSampleWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultOutSampleWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutWasteWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultOutWasteWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhWarehouse findDefaultInOrOutWarehouseByPhyWhCode(String physicalWarehouseCode, Integer inOrOut, Integer skuStatus) {
        return this.whInfoService.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode, inOrOut, skuStatus);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInNondefectiveWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultInNondefectiveWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDefectiveWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultInDefectiveWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInSampleWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultInSampleWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInWasteWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultInWasteWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDisplayWarehouseByPyCode(String physicalWarehouseCode) {
        return this.whInfoService.findDefaultInDisplayWarehouseByPyCode(physicalWarehouseCode);
    }

    public List<WhPhysicalWarehouseVO> findRelatePhysicalWarehouseByWarehouseCode(String warehouseCode, Integer inOrOut, Integer skuStatus) {
        return this.whInfoService.findRelatePhysicalWarehouseByWarehouseCode(warehouseCode, inOrOut, skuStatus);
    }

    public List<WhPhysicalWarehouseVO> findPhysicalWarehouseByWarehouseCode(String warehouseCode) {
        return this.whInfoService.findPhysicalWarehouseByWarehouseCode(warehouseCode);
    }

    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByCodeAndDistrictId(List<String> codes, Long districtId) {
        return this.whInfoService.findDistrictPyWarehouseByCodeAndDistrictId(codes, districtId);
    }

    public List<PhyWhStockVO> findPhyWhStockByCond(PhyWhStockCond cond) {
        return this.whWmsSkuStockService.findPhyWhStockByCond(cond);
    }

    public List<WhGjStockVO> findWhGjStock() {
        return this.whWmsSkuStockService.findWhGjStock();
    }

    public List<WhGjStockVO> findWhGjStockByLimit(int pageSize, int pageNum) {
        return this.whWmsSkuStockService.findWhGjStockByLimit(pageSize, pageNum);
    }

    public List<WhPhysicalWarehouseRelateWarehouseVO> findPhysicalWarehouseRelateWarehouseByCond(WhPhysicalWarehouseRelateWarehouseVO cond) {
        return this.whInfoService.findPhysicalWarehouseRelateWarehouseByCond(cond);
    }

    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouseGroupCond(String warehouseCode, Integer relateInOrOut) {
        return this.whInfoService.findPhysicalWarehouseByWarehouseGroupCond(warehouseCode, relateInOrOut);
    }

    public List<WhAllotDiffSendMessageVO> getWhAllotDiffMessage(WhAllotCond cond) {
        return this.whAllotService.getWhAllotDiffMessage(cond);
    }

    public List<WhWmsCommandConnectVO> findCommandConnectByCond(WhWmsCommandConnectCond cond) {
        return this.whWmsCommandConnectService.findByCond(cond);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByType(List<Integer> warehouseTypeList) {
        return this.whInfoService.findPhysicalWarehouseByType(warehouseTypeList);
    }

    public int saveAutoAllotRule(WhAutoAllotRuleVO whAutoAllotRule) throws Exception {
        return this.whAutoAllotService.saveAutoAllotRule(whAutoAllotRule);
    }

    public List<WhAutoAllotRuleVO> findHisRules(String bu, short allotChannel) {
        return this.whAutoAllotService.findHisRules(bu, allotChannel);
    }

    public List<WhAutoAllotExcludeCategory> findExcludeCategorysByRuleId(Integer ruleId) {
        return this.whAutoAllotService.findExcludeCategorysByRuleId(ruleId);
    }

    public List<WhAutoAllotCallbackExcludeCategory> findCallbackExcludeCategorysByRuleId(Integer ruleId) {
        return this.whAutoAllotService.findCallbackExcludeCategorysByRuleId(ruleId);
    }

    public void executeAutoAllot(Long operatorId, String bu, boolean isAuto) throws Exception {
        this.whAutoAllotService.executeAutoAllot(operatorId, bu, isAuto);
    }

    public void cronExecuteAutoAllot(Long operatorId) throws Exception {
        this.whAutoAllotService.cronExecuteAutoAllot(operatorId);
    }

    public void executeAutoAllotOnline(Long operatorId, boolean isAuto) throws Exception {
        this.whAutoAllotService.executeAutoAllotOnline(operatorId, isAuto);
    }

    public PageInfo<WhAutoAllotRecordVO> findAutoAllotRecords(WhAutoAllotCond whAutoAllotCond) {
        return this.whAutoAllotService.findAutoAllotRecords(whAutoAllotCond);
    }

    public List<WhAutoAllotRecordDetailVO> findDetailByRecordId(Integer recordId) {
        return this.whAutoAllotService.findDetailByRecordId(recordId);
    }

    public Set<String> cancleExecuteAutoAllot(Integer recordId) throws Exception {
        return this.whAutoAllotService.cancleExecuteAutoAllot(recordId);
    }

    public Set<String> confirmExecuteAutoAllot(Integer recordId) throws Exception {
        return this.whAutoAllotService.confirmExecuteAutoAllot(recordId);
    }

    public WhAutoAllotRuleVO findCurrentRule(String bu, short allotChannel) {
        if (allotChannel == 0) {
            return this.whAutoAllotService.findCurrentRule(bu, true);
        }
        return this.whAutoAllotService.findCurrentRuleOnline(true);
    }

    public int updatePlanedDyDateByReCodes(List<WhCommand> whCommandList) {
        return this.whCommandService.updatePlanedDyDateByReCodes(whCommandList);
    }

    public List<WhWarehouseGroupVO> findWhGroupByCodeOrName(String codeOrName) {
        return this.whWarehouseGroupService.findByCodeOrName(codeOrName);
    }

    public List<WhWarehouseGroupVO> findWhGroupByIds(List<Long> ids) {
        return this.whWarehouseGroupService.findByIds(ids);
    }

    public boolean createWhWmsPrdcMaterialDetail(WhWmsPrdcMaterialDetail record) {
        return this.whWmsPrdcMaterialDetailService.create(record);
    }

    public boolean batchCreateWhWmsPrdcMaterialDetail(List<WhWmsPrdcMaterialDetail> records) {
        return this.whWmsPrdcMaterialDetailService.batchCreate(records);
    }

    Boolean updateById(WhWmsPrdcMaterialDetail record) {
        return this.whWmsPrdcMaterialDetailService.updateById(record);
    }

    Boolean updateByCond(WhWmsPrdcMaterialDetail record, WhWmsPrdcMaterialDetailCond cond) {
        return this.whWmsPrdcMaterialDetailService.updateByCond(record, cond);
    }

    WhWmsPrdcMaterialDetail findWhWmsPrdcMaterialDetailById(Long id) {
        return this.whWmsPrdcMaterialDetailService.findWhWmsPrdcMaterialDetailById(id);
    }

    public List<WhWmsPrdcMaterialDetail> listWhWmsPrdcMaterialDetailByCond(WhWmsPrdcMaterialDetailCond cond) {
        return this.whWmsPrdcMaterialDetailService.listWhWmsPrdcMaterialDetailByCond(cond);
    }

    public List<WhWmsPrdcMaterialDetailVO> listWhWmsPrdcMaterialDetailVOByCond(WhWmsPrdcMaterialDetailCond cond) {
        return this.whWmsPrdcMaterialDetailService.listWhWmsPrdcMaterialDetailVOByCond(cond);
    }

    public Integer checkIfAnyMoveStockAssigned(List<String> codeList) {
        return this.whWmsTaskAssignService.checkIfAnyMoveStockAssignEd(codeList);
    }

    public List<WhWarehouseVO> findWarehouseByGroupId(Long warehouseGroupId) {
        return this.whInfoService.findWarehouseByGroupId(warehouseGroupId);
    }

    public Boolean addOrEditCrossGoodsApply(WhCrossGoods whCrossGoods) {
        return this.whCrossGoodsService.addOrEditCrossGoodsApply(whCrossGoods);
    }

    public Boolean approveCrossGoodsApply(WhCrossGoods whCrossGoods) throws Exception {
        return this.whCrossGoodsService.approveCrossGoodsApply(whCrossGoods);
    }

    public Pagination<WhCrossGoodsVO> listCrossGoods(WhCrossGoodsCondVO cond) {
        return this.whCrossGoodsService.listCrossGoods(cond);
    }

    public WhCrossGoodsVO detailCrossGoods(Long id) {
        return this.whCrossGoodsService.detailCrossGoods(id);
    }

    public Integer batchApproveCrossGoodsApply(List<Long> ids, Integer status, Long operatorId, String approveRemark) throws Exception {
        return this.whCrossGoodsService.batchUpdate(ids, status, operatorId, approveRemark);
    }

    public Pagination<TmallStockLogVO> findTmallStockLogByCond(TmallStockLogCond cond) {
        return this.tmallStockLogService.findByCond(cond);
    }

    public TmallStockLogVO findTmallStockLogDetailById(Integer id) {
        return this.tmallStockLogService.findDetailById(id);
    }

    public Boolean dealOuterStockSyn(Integer id, String remark) {
        return this.tmallStockLogService.dealOuterStockSyn(id, remark);
    }

    public String officialWebSiteAllot(Integer id, Long operatorId, String operatorName) throws Exception {
        return this.tmallStockLogService.officialWebSiteAllot(id, operatorId, operatorName);
    }

    public List<TmallStockLogVO> findFailedSyncByAllotCode(String allotCode) {
        return this.tmallStockLogService.findFailedSyncByAllotCode(allotCode);
    }

    public Integer addOrEditBondedWarehouseAllotApply(BondedWarehouseAllotApplyVO allotApplyVO) {
        return this.whBondedWarehouseAllotApplyService.addOrEditBondedWarehouseAllotApply(allotApplyVO);
    }

    public Pagination<WhTlBuyerApplyVO> findByCondBondedWarehouseAllotApply(WhTlBuyerApplyCondVO whTlBuyerApplyCondVO) {
        return this.whBondedWarehouseAllotApplyService.findByCond(whTlBuyerApplyCondVO);
    }

    public WhTlBuyerApplyVO findById(Integer id) {
        return this.whBondedWarehouseAllotApplyService.findById(id);
    }

    public Integer approveBondedWarehouseAllotApply(BondedWarehouseAllotApplyVO allotApplyVO) {
        return this.whBondedWarehouseAllotApplyService.approveApply(allotApplyVO);
    }

    public Integer cancelApply(Integer id) {
        return this.whBondedWarehouseAllotApplyService.cancelApply(id);
    }

    public Integer batchPackage(List<Integer> ids, String name, Long operatorId) throws Exception {
        return this.whBondedWarehouseAllotApplyService.batchPackage(ids, name, operatorId);
    }

    public Integer batchUpdate(List<Integer> applyIds, Integer buyerPackageId) {
        return this.whBondedWarehouseAllotApplyService.batchUpdate(applyIds, buyerPackageId);
    }

    public Pagination<WhTlBuyerPackageOrderVO> findPackageOrderByCond(WhTlBuyerApplyCondVO whTlBuyerApplyCondVO) {
        return this.whTlBuyerPackageService.findByCond(whTlBuyerApplyCondVO);
    }

    public WhTlBuyerPackageOrderVO findPackageOrderDetailById(Integer id) {
        return this.whTlBuyerPackageService.findById(id);
    }

    public List<WhTlBuyerPackageOrderVO> findPackageOrderDetailByIds(List<Integer> ids) {
        return this.whTlBuyerPackageService.findByIds(ids);
    }

    public Integer packageOrderInOrOutBond(BondedWarehouseAllotPackageVO saveVO) throws Exception {
        return this.whTlBuyerPackageService.packageOrderInOrOutBond(saveVO);
    }

    public WhTlBuyerPackage findBuyerPackageDetailByIdForExceal(Integer buyerPackageId) {
        return this.whTlBuyerPackageService.findBuyerPackageDetailByIdForExceal(buyerPackageId);
    }

    public Map<String, Integer> findSkuSynQtyCountByCond(TmallStockLogCond cond) {
        return this.tmallStockLogService.findSkuSynQtyCountByCond(cond);
    }

    public void createAllotsCron() throws Exception {
        this.whAllotStoreApplicationService.createAllotsCron();
    }

    public void autoAllotForLbLimitSale() {
        this.whAutoAllotService.autoAllotForLbLimitSale();
    }
}

