/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.service.warehouse.SpringUtil;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotStoreApplicationCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotStoreApplication;
import com.thebeastshop.pegasus.service.warehouse.model.WhApplicatPara;
import com.thebeastshop.pegasus.service.warehouse.model.WhApplicatParaSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotStoreApplicationService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhProxyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhThirdPartyService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationApproveVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationSkuRefusedDateVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.pegasus.util.vo.ThirdpartyGoodsQuantityRequest;
import com.thebeastshop.pegasus.util.vo.ThirdpartyGoodsQuantityResponse;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PegasusWarehouseInnerServiceFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(PegasusWarehouseInnerServiceFacade.class);
    private static PegasusWarehouseInnerServiceFacade instance;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhProxyService whProxyService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhAllotStoreApplicationService whAllotStoreApplicationService;
    @Autowired
    private WhThirdPartyService whThirdPartyService;

    private PegasusWarehouseInnerServiceFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusWarehouseInnerServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusFacadeLock> clazz = PegasusFacadeLock.class;
        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                LOGGER.info("[fasade init start] PegasusWarehouseInnerServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-warehouse/spring.xml");
                LOGGER.info("[fasade init finish] PegasusWarehouseInnerServiceFacade");
            }
            instance = (PegasusWarehouseInnerServiceFacade)SpringUtil.getBean("pegasusWarehouseInnerServiceFacade");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String createCommand(WhCommand whCommand) throws Exception {
        return this.whCommandService.createCommand(whCommand);
    }

    public String createCommandThenFinish(WhCommand whCommand) throws Exception {
        return this.whCommandService.createCommandThenFinish(whCommand);
    }

    public void saveOrUpdateApplicationPara(String bu, boolean autoAudit) {
        this.whInfoService.saveOrUpdateApplicationPara(bu, autoAudit);
    }

    public WhApplicatPara findWhApplicationParaByBu(String bu) {
        return this.whInfoService.findWhApplicationParaByBu(bu);
    }

    public List<WhApplicatPara> findAllWhApplicationPara() {
        return this.whInfoService.findAllWhApplicationPara();
    }

    public List<WhApplicatParaSku> findWhApplicationParaSkuBySkuCode(String skuCode) {
        return this.whInfoService.findWhApplicationParaSkuBySkuCode(skuCode);
    }

    public void insertApplicationParaSku(WhApplicatParaSku whApplicatParaSku) {
        this.whInfoService.insertApplicationParaSku(whApplicatParaSku);
    }

    public void deleteApplicationParaSku(String skuCode) {
        this.whInfoService.deleteApplicationParaSku(skuCode);
    }

    public List<WhApplicatParaSku> findAllWhApplicationParaSku() {
        return this.whInfoService.findAllWhApplicationParaSku();
    }

    public List<String> createCommandsThenFinish(List<WhCommand> whCommands) throws Exception {
        return this.whCommandService.createCommandsThenFinish(whCommands);
    }

    public String createCommandAfterRelease(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.whCommandService.createCommandAfterRelease(whCommand, whReleaseOccupationVOList);
    }

    public String createCommandWithoutOccupy(WhCommand whCommand) {
        return this.whCommandService.createCommandWithoutOccupy(whCommand);
    }

    public String createCommandAfterOccupy(WhCommand whCommand, List<WhInvOccupy> whInvOccupyList) throws Exception {
        return this.whCommandService.createCommandAfterOccupy(whCommand, whInvOccupyList);
    }

    public String createCommandAfterReleaseThenFinish(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.whCommandService.createCommandAfterReleaseThenFinish(whCommand, whReleaseOccupationVOList);
    }

    public String createCommandThenFinishWithoutOccupy(WhCommand whCommand, List<WhReleaseOccupationVO> releaseList) {
        return this.whCommandService.createCommandThenFinishWithoutOccupy(whCommand, releaseList);
    }

    public List<String> createCommandsAfterReleaseThenFinish(List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.whCommandService.createCommandsAfterReleaseThenFinish(whCommands, whReleaseOccupationVOList);
    }

    public List<String> createCommandsAfterReleaseThenFinishForPrdc(List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.whCommandService.createCommandsAfterReleaseThenFinishForPrdc(whCommands, whReleaseOccupationVOList);
    }

    public String createCommandAfterOccupyThenFinish(WhCommand whCommand, List<WhInvOccupy> whInvOccupyList) throws Exception {
        return this.whCommandService.createCommandAfterOccupyThenFinish(whCommand, whInvOccupyList);
    }

    public void releaseJitPackageOccupy(String packageCode) {
        this.whInvService.releaseJitPackageOccupy(packageCode);
    }

    public WhCommand findCommandByCode(String code, boolean fetch) {
        return this.whCommandService.findCommandByCode(code, fetch);
    }

    public WhCommand findCommandById(Integer id, boolean fetch) {
        return this.whCommandService.findCommandById(id, fetch);
    }

    public List<WhCommand> findCommandByCodes(List<String> codeList, boolean fetch) throws Exception {
        return this.whCommandService.findCommandByCodes(codeList, fetch);
    }

    public WhCommand findCommandByTypeAndReferenceCode(Integer type, String referenceCode, boolean fetch) {
        return this.whCommandService.findCommandByTypeAndReferenceCode(type, referenceCode, fetch);
    }

    public WhCommand findCommandByReferenceCode(String referenceCode) {
        return this.whCommandService.findCommandByReferenceCode(referenceCode);
    }

    public void resetCommandReferenceCodeByTypeAndReferenceCode(Integer type, String referenceCode) {
        this.whCommandService.resetCommandReferenceCodeByTypeAndReferenceCode(type, referenceCode);
    }

    public void resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(Integer type, String referenceCode, List<WhInvOccupy> whInvOccupyList) {
        this.whCommandService.resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(type, referenceCode, whInvOccupyList);
    }

    public void occupy(List<WhInvOccupy> whInvOccupyList) {
        this.whInvService.occupy(whInvOccupyList);
    }

    public void occupy(List<WhInvOccupy> whInvOccupyList, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        this.whInvService.occupy(whInvOccupyList, whJitPackageSkuReferenceVOList);
    }

    public void occupCustomization(List<WhInvOccupy> whInvOccupyList, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList, List<WhAllotRcd> allotList) {
    }

    public void occupy(List<WhInvOccupy> whInvOccupyList, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList, String allotCode) {
        this.whInvService.occupy(whInvOccupyList, whJitPackageSkuReferenceVOList, allotCode);
    }

    public void occupyAfterRelease(List<WhInvOccupy> whInvOccupyList, List<WhReleaseOccupationVO> whReleaseOccupationVOList, String referenceCode, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        this.whInvService.occupyAfterRelease(whInvOccupyList, whReleaseOccupationVOList, referenceCode, whJitPackageSkuReferenceVOList);
    }

    public void releaseOccupation(WhReleaseOccupationVO whReleaseOccupationVO) {
        this.whInvService.releaseOccupation(whReleaseOccupationVO);
    }

    public void releaseOccupation(List<WhReleaseOccupationVO> whReleaseOccupationVOList, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        this.whInvService.releaseOccupation(whReleaseOccupationVOList, whJitPackageSkuReferenceVOList);
    }

    public Map<String, WhInvVO> findCanUseQttBySkuCode(String skuCode) {
        return this.whInvService.findCanUseQttBySkuCode(skuCode);
    }

    public WhInvVO findCanUseQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode) {
        return this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
    }

    public Map<String, WhInvVO> findCanUseQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        return this.whInvService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
    }

    public WhAllotRcd findAllotRcdByCode(String code, boolean fetchSku) {
        return this.whAllotService.findAllotRcdByCode(code, fetchSku);
    }

    public WhAllotRcd findAllotRcdByTypeAndReferenceCode(Integer type, String referenceCode, boolean fetchSku) {
        return this.whAllotService.findAllotRcdByTypeAndReferenceCode(type, referenceCode, fetchSku);
    }

    public String createAllotRcd(WhAllotRcd whAllotRcd) throws Exception {
        return this.whAllotService.createAllotRcd(whAllotRcd);
    }

    public List<String> createAllotRcds(List<WhAllotRcd> whAllotRcds) throws Exception {
        return this.whAllotService.createAllotRcds(whAllotRcds);
    }

    public boolean cancelCommandByTypeAndReferenceCode(Integer type, String referenceCode) {
        return this.whCommandService.cancelCommandByTypeAndReferenceCode(type, referenceCode);
    }

    public boolean cancelCommandByTypeAndReferenceCodeAfterRelease(Integer type, String referenceCode, List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        return this.whCommandService.cancelCommandByTypeAndReferenceCodeAfterRelease(type, referenceCode, whReleaseOccupationVOList);
    }

    public boolean cancelCommandByTypeAndReferenceCodeBeforeOccupy(Integer type, String referenceCode, List<WhInvOccupy> whInvOccupyList) {
        return this.whCommandService.cancelCommandByTypeAndReferenceCodeBeforeOccupy(type, referenceCode, whInvOccupyList);
    }

    public boolean cancelCommandByTypeAndReferenceCodeWithoutOccupy(Integer type, String referenceCode) {
        return this.whCommandService.cancelCommandByTypeAndReferenceCodeWithoutOccupy(type, referenceCode);
    }

    public boolean firstMethodCreateCommandThenFinishAnotherMethodOccupy(List<WhCommand> commandList, List<WhInvOccupy> occupyList) throws Exception {
        return this.whProxyService.firstMethodCreateCommandThenFinishAnotherMethodOccupy(commandList, occupyList);
    }

    @Deprecated
    public boolean isWarehouseMove(String warehouseCode1, String warehouseCode2) {
        return this.whInfoService.isWarehouseMove(warehouseCode1, warehouseCode2);
    }

    public boolean isWarehouseInSameWarehouseGroup(String warehouseCode1, String warehouseCode2) {
        return this.whInfoService.isWarehouseInSameWarehouseGroup(warehouseCode1, warehouseCode2);
    }

    public boolean colseCommandByReferenceCode(int inoutType, String referenceCode) {
        return this.whCommandService.colseCommandByReferenceCode(inoutType, referenceCode);
    }

    public List<String> createAllotRcdByList(List<WhAllotRcdVO> whAllotRcdVOList) throws Exception {
        return this.whAllotService.createAllotRcdByList(whAllotRcdVOList);
    }

    public boolean createAllotRcdAndPrdcJobOccupy(List<WhAllotRcd> whAllotRcds, List<WhInvOccupy> whJobInvOccupyList, List<WhJitPackageSkuReferenceVO> whJobJitPackageSkuReferenceVOList) throws Exception {
        return this.whAllotService.createAllotRcdAndPrdcJobOccupy(whAllotRcds, whJobInvOccupyList, whJobJitPackageSkuReferenceVOList);
    }

    public boolean revertAllotRcd(String code) throws Exception {
        return this.whAllotService.revertAllotRcd(code);
    }

    public boolean cancelCommand(WhCommand whCommand) {
        return this.whCommandService.cancelCommand(whCommand);
    }

    public boolean cancelCommandforShortage(String commandCode) {
        return this.whCommandService.cancelCommandforShortage(commandCode);
    }

    public boolean cancelCommandForSalesOrder(List<WhCommand> whCommands, List<SStockReleaseDTO> releaseList) {
        return this.whCommandService.cancelCommandForSalesOrder(whCommands, releaseList);
    }

    public boolean finishCommand(WhCommand rcd) throws Exception {
        return this.whCommandService.finishCommand(rcd);
    }

    public boolean finishCommandWithoutOccupy(WhCommand rcd) {
        return this.whCommandService.finishCommandWithoutOccupy(rcd);
    }

    public boolean finishCommandWithoutOccupy(WhCommand rcd, List<WhReleaseOccupationVO> releaseList) {
        return this.whCommandService.finishCommandWithoutOccupy(rcd, releaseList);
    }

    public void releaseWhCommandOccupy(WhCommand rcd) {
        this.whCommandService.releaseWhCommandOccupy(rcd);
    }

    public void updateCommand(WhCommand whCommand) {
        this.whCommandService.updateCommand(whCommand);
    }

    public List<WhInvOccupy> getWhInvOccupy(List<String> referenceCodes) {
        return this.whInvService.getWhInvOccupy(referenceCodes);
    }

    public void cancelAllotRcdCommandByTypeAndReferenceCode(Integer type, String referenceCode) {
        this.whCommandService.cancelAllotRcdCommandByTypeAndReferenceCode(type, referenceCode);
    }

    public Integer getPanicBuyCampaignOccupy(String wareHouseCode, String campaignCode, String skuCode) {
        return this.whInvService.findOccupyByCampaignCodeAndSkuCode(wareHouseCode, campaignCode, skuCode);
    }

    public Map<String, List<Long>> campaignOccupy(Map<String, List<WhInvOccupy>> params) {
        return this.whInvService.campaignOccupy(params);
    }

    public WhInvOccupy findOccupyQttByReferenceCode(String referenceCode) {
        return this.whInvService.findOccupyQttByReferenceCode(referenceCode);
    }

    public List<WhCommandSku> findDiffCommandSkuByCommandReferenceCodes(List<String> allotCodeList) {
        return this.whCommandService.findDiffCommandSkuByCommandReferenceCodes(allotCodeList);
    }

    public Integer autoCloseCommandInEndMonth() {
        return this.whCommandService.autoCloseCommandInEndMonth();
    }

    public void updateCommandSku(WhCommandSku whCommandSku) {
        this.whCommandService.updateCommandSku(whCommandSku);
    }

    public List<String> findGoodWarehouseCode() {
        return this.whInfoService.findGoodWarehouseCode();
    }

    public int applicationAllot(WhAllotStoreApplicationVO storeApplication) throws Exception {
        return this.whAllotStoreApplicationService.applicationAllot(storeApplication);
    }

    public WhAllotStoreApplication findApplicationByKey(Integer id) {
        return this.whAllotStoreApplicationService.findApplicationByKey(id);
    }

    public PageInfo<WhAllotStoreApplicationSkuVO> listApplicationRecord(WhAllotStoreApplicationCond cond) {
        return this.whAllotStoreApplicationService.listApplicationRecord(cond);
    }

    public int cancelApplication(Integer applicationLineId, Long cancelPerson) throws Exception {
        return this.whAllotStoreApplicationService.cancelApplication(applicationLineId, cancelPerson);
    }

    public PageInfo<WhAllotStoreApplicationSkuVO> listApprovalListByCond(WhAllotStoreApplicationCond cond) {
        return this.whAllotStoreApplicationService.listApprovalListByCond(cond);
    }

    public List<WhAllotStoreApplicationSkuVO> approve(WhAllotStoreApplicationApproveVO approveVO, Map<String, WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap) throws Exception {
        return this.whAllotStoreApplicationService.approve(approveVO, skuPurchaseOrderMap);
    }

    public PageInfo<WhAllotStoreApplicationSkuVO> listChannelGroupApplicationBySkuCode(WhAllotStoreApplicationCond cond) {
        return this.whAllotStoreApplicationService.listChannelGroupApplicationBySkuCode(cond);
    }

    public void nofityStoreAllotApplovalResult() {
        this.whAllotStoreApplicationService.nofityApplovalResult();
    }

    public ThirdpartyGoodsQuantityResponse syncThirdpartyGoodsStocks(ThirdpartyGoodsQuantityRequest goodsQuantitySyncVO) throws Exception {
        return this.whThirdPartyService.syncCommodityStocks(goodsQuantitySyncVO);
    }
}

