package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by devin.li on 2016/3/16.
 */
public class WhWmsWarehouseAreaVO extends WhWmsWarehouseArea implements Serializable {

    /**
     * 库区
     */
    public static final String HOUSE_TYPE_RECEIVE = "HOUSE_TYPE_RECEIVE";//收货暂存区
    public static final String HOUSE_TYPE_PUSH_KEEP = "HOUSE_TYPE_PUSH_KEEP";//地推保管区
    public static final String HOUSE_TYPE_HEAVY_SHELF = "HOUSE_TYPE_HEAVY_SHELF";//重型货架区
    public static final String HOUSE_TYPE_ZERO_PICKING = "HOUSE_TYPE_ZERO_PICKING";//零拣区
    public static final String HOUSE_TYPE_COLD_STORAGE = "HOUSE_TYPE_COLD_STORAGE";//冷藏区
    public static final String HOUSE_TYPE_TEMPERATURE_HUMIDITY = "HOUSE_TYPE_TEMPERATURE_HUMIDITY";//恒温恒湿区
    public static final String HOUSE_TYPE_EXPENSIVE = "HOUSE_TYPE_EXPENSIVE";//贵品区

    public static final String HOUSE_TYPE_PACKING = "HOUSE_TYPE_PACKING";//分拨包装区
    public static final String HOUSE_TYPE_HANDOVER = "HOUSE_TYPE_HANDOVER";//交接区
    public static final String HOUSE_TYPE_DEFECTIVE = "HOUSE_TYPE_DEFECTIVE";//残次品区
    public static final String HOUSE_TYPE_PROCESSING = "HOUSE_TYPE_PROCESSING";//加工区
    public static final String HOUSE_TYPE_ACTIVE = "HOUSE_TYPE_ACTIVE";//活动区
    public static final String HOUSE_TYPE_ALLOCATION = "HOUSE_TYPE_ALLOCATION";//调拨区
    public static final String HOUSE_TYPE_DIFF = "HOUSE_TYPE_DIFF";//差异区
    public static final String HOUSE_TYPE_SAMPLE = "HOUSE_TYPE_SAMPLE";//样品区
    public static final String HOUSE_TYPE_NORMAL = "HOUSE_TYPE_NORMAL";//普通区
    public static final String HOUSE_TYPE_CUSTOMIZATION = "HOUSE_TYPE_CUSTOMIZATION";//定制商品区
    public static final String HOUSE_TYPE_SCRAP = "HOUSE_TYPE_SCRAP";

    public static final String HOUSE_TYPE_EXHIBITS = "HOUSE_TYPE_EXHIBITS";//定制商品区

    // 待定商品区
    public static final String HOUSE_TYPE_HOLD_PENDING = "HOUSE_TYPE_HOLD_PENDING";

    public static final String TYPE_NORMAL = "NORMAL";
    public static final String TYPE_RECEIVE = "RECEIVE";
    public static final String TYPE_PROCESSING = "PROCESSING";
    public static final String TYPE_ACTIVE = "ACTIVE";
    public static final String TYPE_PACKING = "PACKING";
    public static final String TYPE_HANDOVER = "HANDOVER";
    public static final String TYPE_DIFF = "DIFF";
    public static final String TYPE_CUSTOMIZATION = "CUSTOMIZATION";

//    public static String getHouseTypeNo(String houseType){
//        if (houseType.equals(HOUSE_TYPE_RECEIVE)){
//            return "A";
//        }
//        else if (houseType.equals(HOUSE_TYPE_HOLDING)){
//            return "B";
//        }
//        else if (houseType.equals(HOUSE_TYPE_PICKING)){
//            return "C";
//        }
//        else if (houseType.equals(HOUSE_TYPE_PACKING)){
//            return "D";
//        }
//        else if (houseType.equals(HOUSE_TYPE_HANDOVER)){
//            return "E";
//        }
//        else if (houseType.equals(HOUSE_TYPE_DEFECTIVE)){
//            return "F";
//        }
//        else if (houseType.equals(HOUSE_TYPE_PROCESSING)){
//            return "G";
//        }
//        else if (houseType.equals(HOUSE_TYPE_ACTIVE)){
//            return "H";
//        }
//        else if (houseType.equals(HOUSE_TYPE_ALLOCATION)){
//            return "I";
//        }
//        else if (houseType.equals(HOUSE_TYPE_DIFF)){
//            return "J";
//        }
//        else if (houseType.equals(HOUSE_TYPE_SAMPLE)){
//            return "K";
//        }
//        else if (houseType.equals(HOUSE_TYPE_NORMAL)){
//            return "L";
//        }
//        else return "";
//    }

    /*
     *库区中文名称映射Map
     */
    public final static Map<Integer, String> WH_TYPE_MAP = new HashMap(){{
        put(HOUSE_TYPE_RECEIVE,"收货暂存区");
//        put(HOUSE_TYPE_HOLDING,"保管区");
//        put(HOUSE_TYPE_PICKING,"拣货区");
        put(HOUSE_TYPE_PACKING,"分拨包装区");
        put(HOUSE_TYPE_HANDOVER,"交接区");
        put(HOUSE_TYPE_DEFECTIVE,"残次品区");
        put(HOUSE_TYPE_PROCESSING,"加工区");
        put(HOUSE_TYPE_ACTIVE,"活动区");
        put(HOUSE_TYPE_ALLOCATION,"差异区");
        put(HOUSE_TYPE_DIFF,"活动区");
        put(HOUSE_TYPE_SAMPLE,"样品区");
        put(HOUSE_TYPE_NORMAL,"普通区");
        put(HOUSE_TYPE_PUSH_KEEP,"地推保管区");
        put(HOUSE_TYPE_HEAVY_SHELF,"重型货架区");
        put(HOUSE_TYPE_ZERO_PICKING,"零拣区");
        put(HOUSE_TYPE_TEMPERATURE_HUMIDITY,"恒温恒湿区");
        put(HOUSE_TYPE_COLD_STORAGE,"冷藏区");
        put(HOUSE_TYPE_EXPENSIVE,"贵品区");
        put(HOUSE_TYPE_CUSTOMIZATION,"定制商品区");
    }};


    public static String getHouseAreaName(String houseType){

        return HOUSE_TYPE_RECEIVE.equals(houseType)?"收货暂存区":
                HOUSE_TYPE_PACKING.equals(houseType)?"分拨包装区":
                HOUSE_TYPE_HANDOVER.equals(houseType)?"交接区":
                HOUSE_TYPE_DEFECTIVE.equals(houseType)?"残次品区":
                        HOUSE_TYPE_PROCESSING.equals(houseType)?"加工区":
                                HOUSE_TYPE_ACTIVE.equals(houseType)?"活动区":
                                        HOUSE_TYPE_ALLOCATION.equals(houseType)?"调拨区":
                                                HOUSE_TYPE_DIFF.equals(houseType)?"差异区":
                                                        HOUSE_TYPE_SAMPLE.equals(houseType)?"样品区":
                                                                HOUSE_TYPE_NORMAL.equals(houseType)?"普通区":
                                                                        HOUSE_TYPE_PUSH_KEEP.equals(houseType)?"地推保管区":
                                                                                HOUSE_TYPE_HEAVY_SHELF.equals(houseType)?"重型货架区":
                                                                                        HOUSE_TYPE_ZERO_PICKING.equals(houseType)?"零拣区":
                                                                                                HOUSE_TYPE_TEMPERATURE_HUMIDITY.equals(houseType)?"恒温恒湿区":
                                                                                                        HOUSE_TYPE_COLD_STORAGE.equals(houseType)?"冷藏区":
                                                                                                                HOUSE_TYPE_CUSTOMIZATION.equals(houseType)?"定制商品区":
                                                                                                                HOUSE_TYPE_EXPENSIVE.equals(houseType)?"贵品区":"";

    }
}
