package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutaway;
import com.thebeastshop.pegasus.util.model.CommFileRef;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2016/3/23.
 */
public class WhWmsWaitPutawayVO extends WhWmsWaitPutaway implements Serializable {
    private Integer currpage;

    private Integer pagenum;

    private List<Long> ids;

    private String qcUserName;//质检人姓名

    private String ptUserName;//上架人姓名

    private String skuCode;

    private String skuName;

    // qc处理
    private Integer qcSkuStatus;

    private Integer skuType;

    private String skuCodeListJson;

    private List<String> skuCodeList;

    private List<String> cerSkuCodeList;

    private String beginTime;

    private String endTime;

    private String category;

    private Integer originType;

    private List<WhWmsStartPutawayVO> startPutList;//多选数据上架开始

    private String houseType; //仓库区域

    private String physicalWarehouseCode; //物理仓库编码

    private String shelves; //库位号

    private String planAmount; //计划上架数

    private String alreadyAmount; //已上架数

    private String actualAmount; //实际上架数
    
    private String standard;//收货标准

    // 计划收货日期
    private Date planedReceiveDate;

    // 实际收货日期
    private Date receiveDate;

    private String poCode;

    private String popCode;
    private List<String> popCodes;

    private Long popId;

    // pop_line id 关联残次图片的 referenceCode
    private Long lineId;

    // 质检残次图片
    private List<CommFileRef> commFileRefs;

    // 中文标签 SKU是否需要生产日期 1是0否
    private Integer certNeedProdDate;

    // 中文标签 打印类型1中文标签，2简易标签
    private Integer cerType;

    // SKU保质期
    private Integer shelfLife;

    List<String> receiptsNos;

    // 质检ID
    private Long qcId;

    // 批次表中的字段
    private Date firstInDate;

    private Integer inType;

    private String refCode;

    private String orderByClause;

    private boolean checkedStock;

    private Long processUserId;

    private Date processTime;

    private String processReason;

    // 使用供应商标签
    private String supplierCode;
    private boolean useSupplierCode;

    private Integer isHasTag;
    private Integer printMpCode;


    public List<String> getCerSkuCodeList() {
        return cerSkuCodeList;
    }

    public void setCerSkuCodeList(List<String> cerSkuCodeList) {
        this.cerSkuCodeList = cerSkuCodeList;
    }

    public Integer getSkuType() {
        return skuType;
    }

    public void setSkuType(Integer skuType) {
        this.skuType = skuType;
    }

    public String getQcUserName() {
        return qcUserName;
    }

    public void setQcUserName(String qcUserName) {
        this.qcUserName = qcUserName;
    }

    public String getPtUserName() {
        return ptUserName;
    }

    public void setPtUserName(String ptUserName) {
        this.ptUserName = ptUserName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Integer getQcSkuStatus() {
        return qcSkuStatus;
    }

    public void setQcSkuStatus(Integer qcSkuStatus) {
        this.qcSkuStatus = qcSkuStatus;
    }

    public String getSkuCodeListJson() {
        return skuCodeListJson;
    }

    public void setSkuCodeListJson(String skuCodeListJson) {
        this.skuCodeListJson = skuCodeListJson;
    }

    public List<String> getSkuCodeList() {
        return skuCodeList;
    }

    public void setSkuCodeList(List<String> skuCodeList) {
        this.skuCodeList = skuCodeList;
    }

    public Integer getCurrpage() {
        return currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
    }

    public Integer getPagenum() {
        return pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Integer getOriginType() {
        return originType;
    }

    public void setOriginType(Integer originType) {
        this.originType = originType;
    }

    public String getHouseType() {
        return houseType;
    }

    public void setHouseType(String houseType) {
        this.houseType = houseType;
    }

    public String getShelves() {
        return shelves;
    }

    public void setShelves(String shelves) {
        this.shelves = shelves;
    }

    @Override
    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    @Override
    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public List<WhWmsStartPutawayVO> getStartPutList() {
        return startPutList;
    }

    public void setStartPutList(List<WhWmsStartPutawayVO> startPutList) {
        this.startPutList = startPutList;
    }

    public String getPlanAmount() {
        return planAmount;
    }

    public void setPlanAmount(String planAmount) {
        this.planAmount = planAmount;
    }

    public String getAlreadyAmount() {
        return alreadyAmount;
    }

    public void setAlreadyAmount(String alreadyAmount) {
        this.alreadyAmount = alreadyAmount;
    }

    public String getActualAmount() {
        return actualAmount;
    }

    public void setActualAmount(String actualAmount) {
        this.actualAmount = actualAmount;
    }
    
    public String getStandard() {
		return standard;
	}

    public String getInOutTypeStr(){
        return WhCommand.getPutAwayTypeName(getInOutType());
    }

	public void setStandard(String standard) {
		this.standard = standard;
	}

    public Date getPlanedReceiveDate() {
        return planedReceiveDate;
    }

    public void setPlanedReceiveDate(Date planedReceiveDate) {
        this.planedReceiveDate = planedReceiveDate;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public String getPoCode() {
        return poCode;
    }

    public void setPoCode(String poCode) {
        this.poCode = poCode;
    }

    public String getPopCode() {
        return popCode;
    }

    public void setPopCode(String popCode) {
        this.popCode = popCode;
    }

    public List<String> getPopCodes() {
        return popCodes;
    }

    public void setPopCodes(List<String> popCodes) {
        this.popCodes = popCodes;
    }

    public Long getPopId() {
        return popId;
    }

    public void setPopId(Long popId) {
        this.popId = popId;
    }

    public Long getLineId() {
        return lineId;
    }

    public void setLineId(Long lineId) {
        this.lineId = lineId;
    }

    public List<CommFileRef> getCommFileRefs() {
        return commFileRefs;
    }

    public void setCommFileRefs(List<CommFileRef> commFileRefs) {
        this.commFileRefs = commFileRefs;
    }

    public Integer getCertNeedProdDate() {
        return certNeedProdDate;
    }

    public void setCertNeedProdDate(Integer certNeedProdDate) {
        this.certNeedProdDate = certNeedProdDate;
    }

    public Integer getCerType() {
        return cerType;
    }

    public void setCerType(Integer cerType) {
        this.cerType = cerType;
    }

    public Integer getShelfLife() {
        return shelfLife;
    }

    public void setShelfLife(Integer shelfLife) {
        this.shelfLife = shelfLife;
    }

    public List<String> getReceiptsNos() {
        return receiptsNos;
    }

    public void setReceiptsNos(List<String> receiptsNos) {
        this.receiptsNos = receiptsNos;
    }

    public Long getQcId() {
        return qcId;
    }

    public void setQcId(Long qcId) {
        this.qcId = qcId;
    }

    public Date getFirstInDate() {
        return firstInDate;
    }

    public void setFirstInDate(Date firstInDate) {
        this.firstInDate = firstInDate;
    }

    public Integer getInType() {
        return inType;
    }

    public void setInType(Integer inType) {
        this.inType = inType;
    }

    public String getRefCode() {
        return refCode;
    }

    public void setRefCode(String refCode) {
        this.refCode = refCode;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public boolean isCheckedStock() {
        return checkedStock;
    }

    public void setCheckedStock(boolean checkedStock) {
        this.checkedStock = checkedStock;
    }

    public Long getProcessUserId() {
        return processUserId;
    }

    public void setProcessUserId(Long processUserId) {
        this.processUserId = processUserId;
    }

    public Date getProcessTime() {
        return processTime;
    }

    public void setProcessTime(Date processTime) {
        this.processTime = processTime;
    }

    public String getProcessReason() {
        return processReason;
    }

    public void setProcessReason(String processReason) {
        this.processReason = processReason;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public boolean isUseSupplierCode() {
        return useSupplierCode;
    }

    public void setUseSupplierCode(boolean useSupplierCode) {
        this.useSupplierCode = useSupplierCode;
    }

    public Integer getIsHasTag() {
        return isHasTag;
    }

    public void setIsHasTag(Integer isHasTag) {
        this.isHasTag = isHasTag;
    }

    public Integer getPrintMpCode() {
        return printMpCode;
    }

    public void setPrintMpCode(Integer printMpCode) {
        this.printMpCode = printMpCode;
    }

    public String getCriteriaStr() {
        if (currpage == null) {
            return "";
        }
        Integer pagestart = getPageStart();
        return new StringBuilder(" LIMIT ").append(pagestart).append(",").append(pagenum).append("  ").toString();
    }

    public int getPageStart() {
        return (currpage > 0 ? (currpage - 1) * pagenum : 0);
    }

}
