package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutawayTask;
import com.thebeastshop.pegasus.util.cond.BaseQueryCond;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2016/3/23.
 */
public class WhWmsWaitPutawayTaskVO extends WhWmsWaitPutawayTask implements Serializable {
    private Integer currpage;

    private Integer pagenum;

    private String statusStr;
    private String nameCn;
    private String operateUserName;
    private String operateTime;
    private String popCode;

    // 效期商品 默认false
    private boolean expiryDateFlag;

    // 上架日期范围
    private String putawayTimeBegin;

    private String putawayTimeEnd;

    private Date prodDate;

    private Date expirationDate;

    private String shelvesCodeStart;

    private String shelvesCodeEnd;

    private String supplierCode;

    public String getPopCode() {
        return popCode;
    }

    public void setPopCode(String popCode) {
        this.popCode = popCode;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public String getStatusStr() {
        return statusStr;
    }

    public void setStatusStr(String statusStr) {
        this.statusStr = statusStr;
    }

    public String getSkuStatusStr(){
        return WhWarehouseVO.getSkuStatusName(getSkuStatus());
    }

    public Integer getCurrpage() {
        return currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
    }

    public Integer getPagenum() {
        return pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }
    public String getCriteriaStr() {
        if (currpage == null) {
            return "";
        }
        Integer pagestart = getPageStart();
        return new StringBuilder(" LIMIT ").append(pagestart).append(",").append(pagenum).append("  ").toString();
    }

    public int getPageStart() {
        if(currpage == null){
            return 0;
        }
        return (currpage > 0 ? (currpage - 1) * pagenum : 0);
    }

    public String getOperateUserName() {
        return operateUserName;
    }

    public void setOperateUserName(String operateUserName) {
        this.operateUserName = operateUserName;
    }

    public String getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(String operateTime) {
        this.operateTime = operateTime;
    }

    public String getInOutTypeStr(){
        return WhCommand.getPutAwayTypeName(getInOutType());
    }

    public boolean isExpiryDateFlag() {
        return expiryDateFlag;
    }

    public void setExpiryDateFlag(boolean expiryDateFlag) {
        this.expiryDateFlag = expiryDateFlag;
    }

    public String getPutawayTimeBegin() {
        return putawayTimeBegin;
    }

    public void setPutawayTimeBegin(String putawayTimeBegin) {
        this.putawayTimeBegin = putawayTimeBegin;
    }

    public String getPutawayTimeEnd() {
        return putawayTimeEnd;
    }

    public void setPutawayTimeEnd(String putawayTimeEnd) {
        this.putawayTimeEnd = putawayTimeEnd;
    }

    public Date getProdDate() {
        return prodDate;
    }

    public void setProdDate(Date prodDate) {
        this.prodDate = prodDate;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getShelvesCodeStart() {
        return shelvesCodeStart;
    }

    public void setShelvesCodeStart(String shelvesCodeStart) {
        this.shelvesCodeStart = shelvesCodeStart;
    }

    public String getShelvesCodeEnd() {
        return shelvesCodeEnd;
    }

    public void setShelvesCodeEnd(String shelvesCodeEnd) {
        this.shelvesCodeEnd = shelvesCodeEnd;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
}
