/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsWaitOutStockVO.java, v 0.1 2016-03-23 下午5:52
 */
public class WhWmsWaitOutStockVO extends WhCommand implements Serializable {

	private static final long serialVersionUID = -3785703984730214088L;

	private String oriPhysicalWarehouseName;//调拨单来源物理仓

    private String tarPhysicalWarehouseName;//调拨单目的物理仓
    
    private String allotRcdRemark;//调拨单备注
    
    private String channelCode;//来源渠道
    
    private Date planedDeliveryDate;
    
    private Date expectReceiveDate;
    
    private String limitDeliveryTimeDesc;
    
    private Integer cardType;
    
    private String supplierName;
    
    private String pcsRtnRemark;//采退备注
    
    private String purchaseReturnCode;//采退单号

	private String receiveReason;//领用原因

	private List<String> packageCodeList;		// 包裹号集合

    public Date getPlanedDeliveryDate() {
		return planedDeliveryDate;
	}

	public void setPlanedDeliveryDate(Date planedDeliveryDate) {
		this.planedDeliveryDate = planedDeliveryDate;
	}

	public Date getExpectReceiveDate() {
		return expectReceiveDate;
	}

	public void setExpectReceiveDate(Date expectReceiveDate) {
		this.expectReceiveDate = expectReceiveDate;
	}

	public String getLimitDeliveryTimeDesc() {
		return limitDeliveryTimeDesc;
	}

	public void setLimitDeliveryTimeDesc(String limitDeliveryTimeDesc) {
		this.limitDeliveryTimeDesc = limitDeliveryTimeDesc;
	}

    public String getOriPhysicalWarehouseName() {
        return oriPhysicalWarehouseName;
    }

    public void setOriPhysicalWarehouseName(String oriPhysicalWarehouseName) {
        this.oriPhysicalWarehouseName = oriPhysicalWarehouseName;
    }

    public String getTarPhysicalWarehouseName() {
        return tarPhysicalWarehouseName;
    }

    public void setTarPhysicalWarehouseName(String tarPhysicalWarehouseName) {
        this.tarPhysicalWarehouseName = tarPhysicalWarehouseName;
    }

	public String getChannelCode() {
		return channelCode;
	}

	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}
	
	public String getPlanedDeliveryDateStr(){
    	if(EmptyUtil.isEmpty(planedDeliveryDate)){
    		return "";
    	}
    	return DateUtil.format(planedDeliveryDate, DateUtil.DEFAULT_DATE_FORMAT);
    }
    
    public String getExpectReceiveDateStr(){
    	if(EmptyUtil.isEmpty(expectReceiveDate)){
    		return "";
    	}
    	return DateUtil.format(expectReceiveDate, DateUtil.DEFAULT_DATE_FORMAT);
    }
	public Integer getCardType() {
		return cardType;
	}

	public void setCardType(Integer cardType) {
		this.cardType = cardType;
	}
	
	public boolean needCard(){
		if(EmptyUtil.isEmpty(this.cardType)){
			return false;
		}
		return this.cardType>0;
	}

	public String getAllotRcdRemark() {
		return allotRcdRemark;
	}

	public void setAllotRcdRemark(String allotRcdRemark) {
		this.allotRcdRemark = allotRcdRemark;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public String getPcsRtnRemark() {
		return pcsRtnRemark;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public void setPcsRtnRemark(String pcsRtnRemark) {
		this.pcsRtnRemark = pcsRtnRemark;
	}

	public String getPurchaseReturnCode() {
		return purchaseReturnCode;
	}

	public void setPurchaseReturnCode(String purchaseReturnCode) {
		this.purchaseReturnCode = purchaseReturnCode;
	}

	public String getReceiveReason() {
		return receiveReason;
	}

	public void setReceiveReason(String receiveReason) {
		this.receiveReason = receiveReason;
	}

	public List<String> getPackageCodeList() {
		return packageCodeList;
	}

	public void setPackageCodeList(List<String> packageCodeList) {
		this.packageCodeList = packageCodeList;
	}
}