package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsTakeStockPlan;
import com.thebeastshop.stock.vo.SStockRecordVO;

import java.util.List;

/**
 * Created by devin.li on 16/6/1.
 */
public class WhWmsTakeStockPlanVO extends WhWmsTakeStockPlan {


   //self
    private String houseTypeName;

    private String physicalWarehouseName;

    private String createUserName;

    private String auditUserName;

    private String takeStockCode;

    private String assignOperatorName;

    private List<WhWmsTakeStockRcdVO> takeStockRcdList;

    private Long auditUserId;

    private List<WhWmsSkuStockVO> skuStockList;

    private Long operatorId;

    //库存记录回滚List
    private List<SStockRecordVO> rollbackRecordList;

    // 入逻辑仓
    private WhWarehouse inWhWarehouse;
    private String notExicstInWhWarehouseMsg;
    // 出逻辑仓
    private WhWarehouse outWhWarehouse;
    private String notExicstOutWhWarehouseMsg;


    public String getHouseTypeName() {
        return houseTypeName;
    }

    public void setHouseTypeName(String houseTypeName) {
        this.houseTypeName = houseTypeName;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getAuditUserName() {
        return auditUserName;
    }

    public void setAuditUserName(String auditUserName) {
        this.auditUserName = auditUserName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getTakeStockCode() {
        return takeStockCode;
    }

    public void setTakeStockCode(String takeStockCode) {
        this.takeStockCode = takeStockCode;
    }

    //status
    public static final Integer WAITTING_FOR_INVENTORY = 1;//待盘点

    public static final Integer INVENTORIED = 2;//已盘点

    public static final Integer WAITTING_FOR_SECOND_CHECK = 4;//待二次盘点

    public static final Integer WAITTING_FOR_AUDITE = 5;//待审核

    public static final Integer AUDITED = 3;//已审核

    public static final Integer CANCEL = 6;//已取消

    public String getAssignOperatorName() {
        return assignOperatorName;
    }

    public void setAssignOperatorName(String assignOperatorName) {
        this.assignOperatorName = assignOperatorName;
    }

    public List<WhWmsTakeStockRcdVO> getTakeStockRcdList() {
        return takeStockRcdList;
    }

    public void setTakeStockRcdList(List<WhWmsTakeStockRcdVO> takeStockRcdList) {
        this.takeStockRcdList = takeStockRcdList;
    }

    public String getStatusName(){
        return getStatusStr(this.getStatus());
    }

    public Long getAuditUserId() {
        return auditUserId;
    }

    public void setAuditUserId(Long auditUserId) {
        this.auditUserId = auditUserId;
    }

    public List<WhWmsSkuStockVO> getSkuStockList() {
        return skuStockList;
    }

    public void setSkuStockList(List<WhWmsSkuStockVO> skuStockList) {
        this.skuStockList = skuStockList;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public List<SStockRecordVO> getRollbackRecordList() {
        return rollbackRecordList;
    }

    public void setRollbackRecordList(List<SStockRecordVO> rollbackRecordList) {
        this.rollbackRecordList = rollbackRecordList;
    }

    public WhWarehouse getInWhWarehouse() {
        return inWhWarehouse;
    }

    public void setInWhWarehouse(WhWarehouse inWhWarehouse) {
        this.inWhWarehouse = inWhWarehouse;
    }

    public String getNotExicstInWhWarehouseMsg() {
        return notExicstInWhWarehouseMsg;
    }

    public void setNotExicstInWhWarehouseMsg(String notExicstInWhWarehouseMsg) {
        this.notExicstInWhWarehouseMsg = notExicstInWhWarehouseMsg;
    }

    public WhWarehouse getOutWhWarehouse() {
        return outWhWarehouse;
    }

    public void setOutWhWarehouse(WhWarehouse outWhWarehouse) {
        this.outWhWarehouse = outWhWarehouse;
    }

    public String getNotExicstOutWhWarehouseMsg() {
        return notExicstOutWhWarehouseMsg;
    }

    public void setNotExicstOutWhWarehouseMsg(String notExicstOutWhWarehouseMsg) {
        this.notExicstOutWhWarehouseMsg = notExicstOutWhWarehouseMsg;
    }

    public static String getStatusStr(Integer status){
        return WAITTING_FOR_INVENTORY.equals(status)?"待盘点":
                    INVENTORIED.equals(status)?"已盘点":
                        AUDITED.equals(status)?"已审核":
                                WAITTING_FOR_SECOND_CHECK.equals(status)?"待二次盘点":
                                        WAITTING_FOR_AUDITE.equals(status)?"待审核":
                                                CANCEL.equals(status)?"已取消":"";
    }
}
