package com.thebeastshop.pegasus.service.warehouse.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;

/**
 * Created by Administrator on 2016/3/23.
 */
public class WhWmsSkuStockVO extends WhWmsSkuStock implements Serializable {

    //self

    private String shelvesCodeStart;
    private String shelvesCodeEnd;
    private String shelvesCode;
    private String skuCodeLike;//sku模糊
    private String skuContains;//sku包含
    private String skuCategory;

    // 物理他类型 [1:仓库(WMS) 2：门店 3:仓库(SCM) 4：虚拟仓库]
    private Integer physicalWarehouseType;

    private List<String> houseTypes;

	private String houseType;
	private String noHouseType;
    private Date expirationDate;//过期日期
    
    private Integer inOutType;//出入库类型
    
    private String receiptNo;//相关单据号

    private List<String> shelvesCodeList;//库位号

    private List<String> skuCodeList;
    private String categoryFullName;
	private List<String> barCodeList;
	private List<String> notBarCodeList;

    private Integer changeDays;
	//是否过期
	private String expireDate;
	
	private String whetherOpHaiTao;//是否海淘
    /**
     * 已占用数量
     */
    private int occupiedAccount;
    /**
     * 可用数量
     */
    private int availableAccount;

    private String supplierSkuBarcode;//供应商条码

    private boolean expire = false;
    
    
    //bao.yu
    private Integer totalAmount;//总数量
    private Integer availableAmount;//可用数量
    private Integer occupiedAmount;//占用数量
    private Integer amountGood;//良品数量
    private Integer amountBad;//残次数量
    private Integer amountSample;//样品数量
    private Integer amountWaste;//废品数量

    private String physicalWarehouseName;//仓库名
    private String skuName;//SKU名
    private String houseTypeName;//区域名
    
    
    private Integer goodAmount;//良品数
    private Integer badAmount;//残次品数
    private Integer moderateBadAmount;//中残次品数
    private Integer severeBadAmount;//重残次品数
    private Integer sampleAmount;//样品数
    private Integer displayAmount;//样品数
    private Integer wasteAmount;//废品数
    private Integer propAmount;//道具数
    private Integer holdPendingAmount;//待定数

    private String categoryName;//品类名
    
    private String upCategoryName;//上一级品类
    
    private Integer whetherConsignment;//是否代销，1：是，0：否

    private String hideZeroAvailableAmount = "false"; // 查询时 是否隐藏可用库存为0的记录

	private List<Integer> shelvesTypeList;

    /**效期商品查询字段***/
    private String expiryDateAlert; // 效期预警

    private String wareMsg;

    private Date prodDate;//生产日期

    private Integer surplusDays; // 剩余天数

    private Date unShelveDate; // 下架日期

    // 通过库位的 混载类型 过滤
    private boolean filterByMixedType;

    private boolean qcProcess;

    // 小于安全库存下限
    private boolean lessSafeMinStock;
    // 大于等于安全库存下限
    // private boolean greaterThanSafeMinStock;

    private boolean gtZero;

    // 搬库标签
    private String moveStorehouseCode;

    @ExcelColumn(name="成本")
    @Min(value = 0)
    @NotNull
    private BigDecimal costPrice;

    @ExcelColumn(name="良品库存金额")
    @Min(value = 0)
    @NotNull
    private BigDecimal goodsStockPrice;

    @ExcelColumn(name="残次品库存金额")
    @Min(value = 0)
    @NotNull
    private BigDecimal badStockPrice;

    @ExcelColumn(name="中残品库存金额")
    @Min(value = 4)
    @NotNull
    private BigDecimal moderateBadStockPrice;

    @ExcelColumn(name="重残品库存金额")
    @Min(value = 5)
    @NotNull
    private BigDecimal severeBadStockPrice;

    private BigDecimal sampleStockPrice;
    private BigDecimal displayStockPrice;

	private Integer shelvesSortOrder;//拣货排序

    private Integer shelfLife; // 保持期天数

    private String brandName; // 品牌名

    private String firstLevelCategory; // 一级类目
    private Long firstLevelCategoryID; // 一级类目


    private String secondLevelCategory; // 二级类目
    private Long secondLevelCategoryID; // 二级类目

    public String getCategoryFullName() {
        return categoryFullName;
    }

    public void setCategoryFullName(String categoryFullName) {
        this.categoryFullName = categoryFullName;
    }

    // 品类id集
    private List<Long> categoryIds;
    private List<String> skuListNot;

    private Set<Long> categoryBeautyIdSet;
    private Set<Long> categoryCandleIdSet;
    private Set<Long> categoryFoodIdSet;

    private String buyerName; // 采购员

    private Integer buyerId; // 采购员ID

	private boolean enough = false;//拣货是否足够

	private List<String> pickStockList;//拣货位置

    // 逻辑仓编码
    private String warehouseCode;

    // 目标批次
    private String targetBarcode;

    private Long createOperatorId;

    // 是否跨境购 0普通１跨境购
    private Integer crossBorderFlag;

    // 是否进口 0否1是
    private Integer isImported;

    // 供应商条码
    private boolean needFetchSupplierCode;
    private String supplierCode;

    public String getWhetherOpHaiTao() {
		return whetherOpHaiTao;
	}

	public void setWhetherOpHaiTao(String whetherOpHaiTao) {
		this.whetherOpHaiTao = whetherOpHaiTao;
	}

	public int getOccupiedAccount() {
        return occupiedAccount;
    }

    public void setOccupiedAccount(int occupiedAccount) {
        this.occupiedAccount = occupiedAccount;
    }

    public int getAvailableAccount() {
        return availableAccount;
    }

    public void setAvailableAccount(int availableAccount) {
        this.availableAccount = availableAccount;
    }

    public String getShelvesCodeStart() {
        return shelvesCodeStart;
    }

    public void setShelvesCodeStart(String shelvesCodeStart) {
        this.shelvesCodeStart = shelvesCodeStart;
    }

    public String getShelvesCodeEnd() {
        return shelvesCodeEnd;
    }

    public void setShelvesCodeEnd(String shelvesCodeEnd) {
        this.shelvesCodeEnd = shelvesCodeEnd;
    }

    @Override
    public String getShelvesCode() {
        return shelvesCode;
    }

    @Override
    public void setShelvesCode(String shelvesCode) {
        this.shelvesCode = shelvesCode;
    }

    public String getSkuCodeLike() {
        return skuCodeLike;
    }

	@Override
	public String getHouseType() {
		return houseType;
	}

	@Override
	public void setHouseType(String houseType) {
		this.houseType = houseType;
	}

    public String getNoHouseType() {
        return noHouseType;
    }

    public void setNoHouseType(String noHouseType) {
        this.noHouseType = noHouseType;
    }

    public void setSkuCodeLike(String skuCodeLike) {
        this.skuCodeLike = skuCodeLike;
    }

    public String getSkuCategory() {
        return skuCategory;
    }

    public void setSkuCategory(String skuCategory) {
        this.skuCategory = skuCategory;
    }

    public Integer getPhysicalWarehouseType() {
        return physicalWarehouseType;
    }

    public void setPhysicalWarehouseType(Integer physicalWarehouseType) {
        this.physicalWarehouseType = physicalWarehouseType;
    }

    public String getSkuContains() {
        return skuContains;
    }

    public void setSkuContains(String skuContains) {
        this.skuContains = skuContains;
    }

    public List<String> getShelvesCodeList() {
        return shelvesCodeList;
    }

    public void setShelvesCodeList(List<String> shelvesCodeList) {
        this.shelvesCodeList = shelvesCodeList;
    }

    public Integer getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(Integer totalAmount) {
		this.totalAmount = totalAmount;
	}

	public Integer getAvailableAmount() {
		return availableAmount;
	}

	public void setAvailableAmount(Integer availableAmount) {
		this.availableAmount = availableAmount;
	}

	public String getPhysicalWarehouseName() {
		return physicalWarehouseName;
	}

	public void setPhysicalWarehouseName(String physicalWarehouseName) {
		this.physicalWarehouseName = physicalWarehouseName;
	}

	public List<Integer> getShelvesTypeList() {
		return shelvesTypeList;
	}

	public void setShelvesTypeList(List<Integer> shelvesTypeList) {
		this.shelvesTypeList = shelvesTypeList;
	}

	public List<String> getSkuCodeList() {
        return skuCodeList;
    }

    public void setSkuCodeList(List<String> skuCodeList) {
        this.skuCodeList = skuCodeList;
    }

    public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}

    public String getSupplierSkuBarcode() {
        return supplierSkuBarcode;
    }

    public void setSupplierSkuBarcode(String supplierSkuBarcode) {
        this.supplierSkuBarcode = supplierSkuBarcode;
    }

    public String getHouseTypeName() {
		return houseTypeName;
	}

	public void setHouseTypeName(String houseTypeName) {
		this.houseTypeName = houseTypeName;
	}

	public Integer getOccupiedAmount() {
		return occupiedAmount;
	}

	public void setOccupiedAmount(Integer occupiedAmount) {
		this.occupiedAmount = occupiedAmount;
	}

    public Integer getAmountGood() {
        return amountGood;
    }

    public void setAmountGood(Integer amountGood) {
        this.amountGood = amountGood;
    }

    public Integer getAmountBad() {
        return amountBad;
    }

    public void setAmountBad(Integer amountBad) {
        this.amountBad = amountBad;
    }

    public Integer getAmountSample() {
        return amountSample;
    }

    public void setAmountSample(Integer amountSample) {
        this.amountSample = amountSample;
    }

    public Integer getAmountWaste() {
        return amountWaste;
    }

    public void setAmountWaste(Integer amountWaste) {
        this.amountWaste = amountWaste;
    }

/**
	 * 添加分页
	 * */
	/**
     *第几页
     */
    private Integer currpage;
    /**
     *每页的数量
     */
    private Integer pagenum = 20;

    public Integer getCurrpage() {
        return currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
    }

    public Integer getPagenum() {
        return pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

	public String getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(String expireDate) {
		this.expireDate = expireDate;
	}

	/**
     * 获取分页 Limit后的 str
     * @return
     */
    public String getCriteriaStr() {
        if (currpage == null) {
            return "";
        }
        Integer pagestart = getPageStart();

        return new StringBuilder(" LIMIT ").append(pagestart).append(",").append(pagenum).append("  ").toString();
    }

    public int getPageStart() {
    	if(currpage==null){
    		return 1;
    	}
        return (currpage > 0 ? (currpage - 1) * pagenum : 0);
    }



	public List<String> getHouseTypes() {
		return houseTypes;
	}

	public void setHouseTypes(List<String> houseTypes) {
		this.houseTypes = houseTypes;
	}

	public Integer getGoodAmount() {
		return goodAmount;
	}

	public void setGoodAmount(Integer goodAmount) {
		this.goodAmount = goodAmount;
	}

	public Integer getBadAmount() {
		return badAmount;
	}

	public void setBadAmount(Integer badAmount) {
		this.badAmount = badAmount;
	}

    public Integer getModerateBadAmount() {
        return moderateBadAmount;
    }

    public void setModerateBadAmount(Integer moderateBadAmount) {
        this.moderateBadAmount = moderateBadAmount;
    }

    public Integer getSevereBadAmount() {
        return severeBadAmount;
    }

    public void setSevereBadAmount(Integer severeBadAmount) {
        this.severeBadAmount = severeBadAmount;
    }

    public Integer getSampleAmount() {
		return sampleAmount;
	}

	public void setSampleAmount(Integer sampleAmount) {
		this.sampleAmount = sampleAmount;
	}

    public Integer getDisplayAmount() {
        return displayAmount;
    }

    public void setDisplayAmount(Integer displayAmount) {
        this.displayAmount = displayAmount;
    }

    public Integer getWasteAmount() {
        return wasteAmount;
    }

    public void setWasteAmount(Integer wasteAmount) {
        this.wasteAmount = wasteAmount;
    }

    public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

    public Integer getPropAmount() {
        return propAmount;
    }

    public void setPropAmount(Integer propAmount) {
        this.propAmount = propAmount;
    }

    public Integer getHoldPendingAmount() {
        return holdPendingAmount;
    }

    public void setHoldPendingAmount(Integer holdPendingAmount) {
        this.holdPendingAmount = holdPendingAmount;
    }

    public String getUpCategoryName() {
		return upCategoryName;
	}

	public void setUpCategoryName(String upCategoryName) {
		this.upCategoryName = upCategoryName;
	}
	
	public String getHideZeroAvailableAmount() {
		return hideZeroAvailableAmount;
	}

	public void setHideZeroAvailableAmount(String hideZeroAvailableAmount) {
		this.hideZeroAvailableAmount = hideZeroAvailableAmount;
	}

	public Date getExpirationDate() {
		return expirationDate;
	}

	public void setExpirationDate(Date expirationDate) {
		this.expirationDate = expirationDate;
	}

    public Integer getChangeDays() {
        return changeDays;
    }

    public void setChangeDays(Integer changeDays) {
        this.changeDays = changeDays;
    }

    //ohters
	
	public String getExpirationDateStr(){
		if(this.expirationDate == null){
			return "";
		}
		return DateUtil.format(expirationDate, "yyyy-MM-dd");
	}

	public Integer getShelvesSortOrder() {
		return shelvesSortOrder;
	}

	public void setShelvesSortOrder(Integer shelvesSortOrder) {
		this.shelvesSortOrder = shelvesSortOrder;
	}

	/**
     * SKU状态
     * 弃用
     * 统一用 WhWarehouseVO COMMODITY_STATUS
     */
    public static final Integer SKU_STATUS_BAD = 0;//残次
    public static final Integer SKU_STATUS_GOOD = 1;//良品
    public static final Integer SKU_STATUS_SAMPLE = 2;//样品
    public static final Integer SKU_STATUS_WASTE = 3;// 废品



    //others

    /*public static List<KeyValueVO> getAllSkuStatus(){
        List<KeyValueVO> skuStatusList = new ArrayList(){{
            add(new KeyValueVO(WhWmsSkuStockVO.SKU_STATUS_GOOD.toString(),"良品"));
            add(new KeyValueVO(WhWmsSkuStockVO.SKU_STATUS_BAD.toString(),"残次"));
            add(new KeyValueVO(WhWmsSkuStockVO.SKU_STATUS_SAMPLE.toString(),"样品"));
            add(new KeyValueVO(WhWmsSkuStockVO.SKU_STATUS_WASTE.toString(),"废品"));
        }};
        return skuStatusList;
    }*/

    /*public static List<Integer> getAllSingleSkuStatus(){
        List<Integer> skuStatus = new ArrayList(){{
            add(WhWmsSkuStockVO.SKU_STATUS_GOOD);
            add(WhWmsSkuStockVO.SKU_STATUS_BAD);
            add(WhWmsSkuStockVO.SKU_STATUS_SAMPLE);
            add(WhWmsSkuStockVO.SKU_STATUS_WASTE);
        }};
        return skuStatus;
    }*/

    public String getSkuStatusStr(){
        return WhWarehouseVO.getSkuStatusName(getSkuStatus());
    }

	public Integer getWhetherConsignment() {
		return whetherConsignment;
	}

	public void setWhetherConsignment(Integer whetherConsignment) {
		this.whetherConsignment = whetherConsignment;
	}

	public Integer getInOutType() {
		return inOutType;
	}

	public void setInOutType(Integer inOutType) {
		this.inOutType = inOutType;
	}

	public String getReceiptNo() {
		return receiptNo;
	}

	public void setReceiptNo(String receiptNo) {
		this.receiptNo = receiptNo;
	}

	public String getExpiryDateAlert() {
		return expiryDateAlert;
	}

	public void setExpiryDateAlert(String expiryDateAlert) {
		this.expiryDateAlert = expiryDateAlert;
	}

    public String getWareMsg() {
        return wareMsg;
    }

    public void setWareMsg(String wareMsg) {
        this.wareMsg = wareMsg;
    }

    public Date getProdDate() {
		return prodDate;
	}

	public String getProdDateStr() {
		if (EmptyUtil.isEmpty(prodDate)){
			return "";
		}
		return DateUtil.format(prodDate, "yyyy-MM-dd");
	}

	public void setProdDate(Date prodDate) {
		this.prodDate = prodDate;
	}

	public Integer getSurplusDays() {
		return surplusDays;
	}

	public void setSurplusDays(Integer surplusDays) {
		this.surplusDays = surplusDays;
	}

	public Date getUnShelveDate() {
		return unShelveDate;
	}

	public String getUnShelveDateStr() {
		if (EmptyUtil.isEmpty(unShelveDate)){
			return "";
		}
		return DateUtil.format(unShelveDate, "yyyy-MM-dd");
	}

	public void setUnShelveDate(Date unShelveDate) {
		this.unShelveDate = unShelveDate;
	}

    public boolean isFilterByMixedType() {
        return filterByMixedType;
    }

    public void setFilterByMixedType(boolean filterByMixedType) {
        this.filterByMixedType = filterByMixedType;
    }

    public boolean isQcProcess() {
        return qcProcess;
    }

    public void setQcProcess(boolean qcProcess) {
        this.qcProcess = qcProcess;
    }

    public boolean isLessSafeMinStock() {
        return lessSafeMinStock;
    }

    public void setLessSafeMinStock(boolean lessSafeMinStock) {
        this.lessSafeMinStock = lessSafeMinStock;
    }

    public boolean isGtZero() {
        return gtZero;
    }

    public void setGtZero(boolean gtZero) {
        this.gtZero = gtZero;
    }

    public String getMoveStorehouseCode() {
        return moveStorehouseCode;
    }

    public void setMoveStorehouseCode(String moveStorehouseCode) {
        this.moveStorehouseCode = moveStorehouseCode;
    }

    public BigDecimal getCostPrice() {
		return costPrice;
	}

	public void setCostPrice(BigDecimal costPrice) {
		this.costPrice = costPrice;
	}

	public BigDecimal getGoodsStockPrice() {
		return goodsStockPrice;
	}

	public void setGoodsStockPrice(BigDecimal goodsStockPrice) {
		this.goodsStockPrice = goodsStockPrice;
	}

	public BigDecimal getBadStockPrice() {
		return badStockPrice;
	}

	public void setBadStockPrice(BigDecimal badStockPrice) {
		this.badStockPrice = badStockPrice;
	}

    public BigDecimal getModerateBadStockPrice() {
        return moderateBadStockPrice;
    }

    public void setModerateBadStockPrice(BigDecimal moderateBadStockPrice) {
        this.moderateBadStockPrice = moderateBadStockPrice;
    }

    public BigDecimal getSevereBadStockPrice() {
        return severeBadStockPrice;
    }

    public void setSevereBadStockPrice(BigDecimal severeBadStockPrice) {
        this.severeBadStockPrice = severeBadStockPrice;
    }

    public BigDecimal getSampleStockPrice() {
        return sampleStockPrice;
    }

    public void setSampleStockPrice(BigDecimal sampleStockPrice) {
        this.sampleStockPrice = sampleStockPrice;
    }

    public BigDecimal getDisplayStockPrice() {
        return displayStockPrice;
    }

    public void setDisplayStockPrice(BigDecimal displayStockPrice) {
        this.displayStockPrice = displayStockPrice;
    }

    public Integer getShelfLife() {
		return shelfLife;
	}

	public void setShelfLife(Integer shelfLife) {
		this.shelfLife = shelfLife;
	}

	public String getBrandName() {
		return brandName;
	}

	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}

	public String getFirstLevelCategory() {
		return firstLevelCategory;
	}

	public void setFirstLevelCategory(String firstLevelCategory) {
		this.firstLevelCategory = firstLevelCategory;
	}

    public Long getFirstLevelCategoryID() {
        return firstLevelCategoryID;
    }

    public void setFirstLevelCategoryID(Long firstLevelCategoryID) {
        this.firstLevelCategoryID = firstLevelCategoryID;
    }

    public String getSecondLevelCategory() {
		return secondLevelCategory;
	}

	public void setSecondLevelCategory(String secondLevelCategory) {
		this.secondLevelCategory = secondLevelCategory;
	}

    public Long getSecondLevelCategoryID() {
        return secondLevelCategoryID;
    }

    public void setSecondLevelCategoryID(Long secondLevelCategoryID) {
        this.secondLevelCategoryID = secondLevelCategoryID;
    }

    public List<Long> getCategoryIds() {
        return categoryIds;
    }

    public void setCategoryIds(List<Long> categoryIds) {
        this.categoryIds = categoryIds;
    }

    public Set<Long> getCategoryBeautyIdSet() {
        return categoryBeautyIdSet;
    }

    public void setCategoryBeautyIdSet(Set<Long> categoryBeautyIdSet) {
        this.categoryBeautyIdSet = categoryBeautyIdSet;
    }

    public Set<Long> getCategoryCandleIdSet() {
        return categoryCandleIdSet;
    }

    public void setCategoryCandleIdSet(Set<Long> categoryCandleIdSet) {
        this.categoryCandleIdSet = categoryCandleIdSet;
    }

    public Set<Long> getCategoryFoodIdSet() {
        return categoryFoodIdSet;
    }

    public void setCategoryFoodIdSet(Set<Long> categoryFoodIdSet) {
        this.categoryFoodIdSet = categoryFoodIdSet;
    }

    public boolean isEnough() {
		return enough;
	}

	public void setEnough(boolean enough) {
		this.enough = enough;
	}

	public List<String> getPickStockList() {
		return pickStockList;
	}

	public void setPickStockList(List<String> pickStockList) {
		this.pickStockList = pickStockList;
	}

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getTargetBarcode() {
        return targetBarcode;
    }

    public void setTargetBarcode(String targetBarcode) {
        this.targetBarcode = targetBarcode;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public void setCreateOperatorId(Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public boolean isNeedFetchSupplierCode() {
        return needFetchSupplierCode;
    }

    public void setNeedFetchSupplierCode(boolean needFetchSupplierCode) {
        this.needFetchSupplierCode = needFetchSupplierCode;
    }

    public Integer getIsImported() {
        return isImported;
    }

    public void setIsImported(Integer isImported) {
        this.isImported = isImported;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getBuyerName() {
		return buyerName;
	}

	public void setBuyerName(String buyerName) {
		this.buyerName = buyerName;
	}

	public Integer getBuyerId() {
		return buyerId;
	}

	public void setBuyerId(Integer buyerId) {
		this.buyerId = buyerId;
	}

    public boolean isExpire() {
        return expire;
    }

    public void setExpire(boolean expire) {
        this.expire = expire;
    }

    public List<String> getBarCodeList() {
		return barCodeList;
	}

	public void setBarCodeList(List<String> barCodeList) {
		this.barCodeList = barCodeList;
	}

    public List<String> getNotBarCodeList() {
        return notBarCodeList;
    }

    public void setNotBarCodeList(List<String> notBarCodeList) {
        this.notBarCodeList = notBarCodeList;
    }

    public List<String> getSkuListNot() {
		return skuListNot;
	}
	public void setSkuListNot(List<String> skuListNot) {
		this.skuListNot = skuListNot;
	}
}