package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuPickShelves;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by devin.li on 2016/3/16.
 */
@ExcelTemplate
public class WhWmsShelvesSkuInfoVO implements Serializable {

    private Long id;

    @ExcelColumn(name="SKU")
    @NotNull
    private String skuCode;

    @ExcelColumn(name="库位最大保存量")
    @NotNull
    @Min(value = 0)
    private Integer maxAmount;

    @ExcelColumn(name="长(mm)")
    @NotNull
    @Min(value = 0)
    private Float skuLength;

    @ExcelColumn(name="宽(mm)")
    @NotNull
    @Min(value = 0)
    private Float skuWidth;

    @ExcelColumn(name="高(mm)")
    @NotNull
    @Min(value = 0)
    private Float skuHeight;

    @ExcelColumn(name="重量(g)")
    @NotNull
    @Min(value = 0)
    private Float skuWeight;

    private Long createUserId;

    @ExcelColumn(name="是否航空禁运（0:否 1:是）")
    @NotNull
    private Integer airEmbargo;

    private Date createTime;

    private Date updateTime;

    private String houseType;

    private String houseTypeName;

    private String houseCode;

    /**
     * ############### self ###############
     */
    /**
     * 品类名称
     */
    private String categoryName;

    /**
     * sku名
     */
    private String skuName;
    /**
     * sku中文名称
     */
    private String skuNameCN;
    /**
     * 重要等级
     */
    private Integer serviceLevel;

    /**
     * 类型
     */
    private String skuType;

    /**
     * 创建人
     * @return
     */
    private String createUserName;

    // 供应商条码
    private String supplierCode;

    private List<WhWmsSkuPickShelves> whWmsSkuPickShelves;

    private List<WhWmsSkuPickShelvesVO> whWmsSkuPickShelvesVO;

    public Integer getAirEmbargo() {
        return airEmbargo;
    }

    public void setAirEmbargo(Integer airEmbargo) {
        this.airEmbargo = airEmbargo;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getHouseType() {
        return houseType;
    }

    public void setHouseType(String houseType) {
        this.houseType = houseType;
    }

    public String getHouseTypeName() {
        return houseTypeName;
    }

    public void setHouseTypeName(String houseTypeName) {
        this.houseTypeName = houseTypeName;
    }

    public String getHouseCode() {
        return houseCode;
    }

    public void setHouseCode(String houseCode) {
        this.houseCode = houseCode;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Float getSkuWeight() {
        return skuWeight;
    }

    public void setSkuWeight(Float skuWeight) {
        this.skuWeight = skuWeight;
    }

    public Float getSkuHeight() {
        return skuHeight;
    }

    public void setSkuHeight(Float skuHeight) {
        this.skuHeight = skuHeight;
    }

    public Float getSkuWidth() {
        return skuWidth;
    }

    public void setSkuWidth(Float skuWidth) {
        this.skuWidth = skuWidth;
    }

    public Integer getMaxAmount() {
        return maxAmount;
    }

    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }

    public Float getSkuLength() {
        return skuLength;
    }

    public void setSkuLength(Float skuLength) {
        this.skuLength = skuLength;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Integer getServiceLevel() {
        return serviceLevel;
    }

    public void setServiceLevel(Integer serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getSkuType() {
        return skuType;
    }

    public void setSkuType(String skuType) {
        this.skuType = skuType;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSkuNameCN() {
        return skuNameCN;
    }

    public void setSkuNameCN(String skuNameCN) {
        this.skuNameCN = skuNameCN;
    }

    public List<WhWmsSkuPickShelves> getWhWmsSkuPickShelves() {
        return whWmsSkuPickShelves;
    }

    public void setWhWmsSkuPickShelves(List<WhWmsSkuPickShelves> whWmsSkuPickShelves) {
        this.whWmsSkuPickShelves = whWmsSkuPickShelves;
    }

    public List<WhWmsSkuPickShelvesVO> getWhWmsSkuPickShelvesVO() {
        return whWmsSkuPickShelvesVO;
    }

    public void setWhWmsSkuPickShelvesVO(List<WhWmsSkuPickShelvesVO> whWmsSkuPickShelvesVO) {
        this.whWmsSkuPickShelvesVO = whWmsSkuPickShelvesVO;
    }
}
