package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRule;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRuleBlacklist;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhWmsReplenishRuleVO extends WhWmsReplenishRule implements Serializable{

    public static final String COMM_LOG_ENTITY_FOR_REPLENISHRULE = "WhWmsReplenishRule";

    private String physicalWarehouseName;

    private String ruleStateName;

    private List<WhWmsReplenishRuleHousetypeVO> ruleHousetypeVOs;

    private List<WhWmsReplenishRuleBlacklistVO> ruleBlacklistVOs;

    private String ruleHousetypeLog;

    private String skuCode;

    private String skuName;

    private Long categoryId;

    private String categoryName;

    public final static Map<Integer,String> RULE_STATE_MAP = new HashMap(){{
        put(PegasusConstants.YES,"开启");
        put(PegasusConstants.NO,"关闭");
    }};

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getRuleStateName() {
        if (EmptyUtil.isEmpty(ruleStateName)){
            if (EmptyUtil.isEmpty(this.getRuleState())){
                ruleStateName = "";
            }else{
                ruleStateName = RULE_STATE_MAP.get(this.getRuleState());
            }
        }
        return ruleStateName;
    }

    public void setRuleStateName(String ruleStateName) {
        this.ruleStateName = ruleStateName;
    }

    public List<WhWmsReplenishRuleHousetypeVO> getRuleHousetypeVOs() {
        return ruleHousetypeVOs;
    }

    public void setRuleHousetypeVOs(List<WhWmsReplenishRuleHousetypeVO> ruleHousetypeVOs) {
        this.ruleHousetypeVOs = ruleHousetypeVOs;
    }

    public List<WhWmsReplenishRuleBlacklistVO> getRuleBlacklistVOs() {
        return ruleBlacklistVOs;
    }

    public void setRuleBlacklistVOs(List<WhWmsReplenishRuleBlacklistVO> ruleBlacklistVOs) {
        this.ruleBlacklistVOs = ruleBlacklistVOs;
    }

    public String getRuleHousetypeLog() {
        return ruleHousetypeLog;
    }

    public void setRuleHousetypeLog(String ruleHousetypeLog) {
        this.ruleHousetypeLog = ruleHousetypeLog;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Override
    public String toString() {
        return "WhWmsReplenishRuleVO{" +
                "physicalWarehouseName='" + physicalWarehouseName + '\'' +
                ", ruleHousetypeVOs=" + ruleHousetypeVOs +
                ", ruleBlacklistVOs=" + ruleBlacklistVOs +
                '}';
    }

    public String toStringLog() {
        return "规则状态=" + this.getRuleStateName() + "," +
                "运行间隔=" + this.getRunInterval() + "," +
                "仓库=" + this.physicalWarehouseName + "," +
                "库区={" + ruleHousetypeLog + "},"+
                "黑名单={" + ruleBlacklistVOsToString() + "}";
    }

    private String ruleHousetypeVOsToString(){
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.ruleHousetypeVOs)){
            for (WhWmsReplenishRuleHousetypeVO ruleHousetypeVO : this.ruleHousetypeVOs){
                sb.append(ruleHousetypeVO.getHouseType()).append(",");
            }
        }
        return sb.toString();
    }

    private String ruleBlacklistVOsToString(){
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.ruleBlacklistVOs)){
            for (WhWmsReplenishRuleBlacklistVO ruleBlacklistVO : this.ruleBlacklistVOs){
                if (EmptyUtil.isNotEmpty(ruleBlacklistVO.getSecondCategoryName())){
                    sb.append("二级类目:"+ruleBlacklistVO.getSecondCategoryName()+",");
                }
                if (EmptyUtil.isNotEmpty(ruleBlacklistVO.getSkuCode())){
                    sb.append("SKU:"+ruleBlacklistVO.getSkuCode()).append(",");
                }
            }
        }
        return sb.toString();
    }
}
