package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishInfo;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class WhWmsReplenishInfoVO extends WhWmsReplenishInfo implements Serializable{

    // 待补货
    public static final Integer STATES_WAIT_REPLENISH = 0;
    // 补货中
    public static final Integer STATES_REPLENISHING = 1;
    // 补货完成
    public static final Integer STATES_REPLENISH_FINISHED = 2;

    // refType
    public static final Integer REF_TYPE_MOVE_STOCK = 1;


    private String physicalWarehouseName;

    private String skuName;

    private String replenishStatesName;

    private String houseTypeName;

    // 总库存
    private Integer totalAmount;

    // 可用库存
    private Integer canUseAmount;

    // 小于安全库存下限
    private boolean lessSafeMinStock;

    private String supplierCode;

    public final static Map<Integer,String> REPLENISH_STATE_MAP = new HashMap(){{
        put(STATES_WAIT_REPLENISH,"待补货");
        put(STATES_REPLENISHING,"补货中");
        put(STATES_REPLENISH_FINISHED,"已完成");
    }};

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getReplenishStatesName() {
        if (EmptyUtil.isEmpty(replenishStatesName)){
            if (EmptyUtil.isEmpty(getReplenishStates())){
                replenishStatesName = "";
            }else{
                replenishStatesName = REPLENISH_STATE_MAP.get(getReplenishStates());
            }
        }
        return replenishStatesName;
    }

    public void setReplenishStatesName(String replenishStatesName) {
        this.replenishStatesName = replenishStatesName;
    }

    public String getHouseTypeName() {
        return houseTypeName;
    }

    public void setHouseTypeName(String houseTypeName) {
        this.houseTypeName = houseTypeName;
    }

    public Integer getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getCanUseAmount() {
        return canUseAmount;
    }

    public void setCanUseAmount(Integer canUseAmount) {
        this.canUseAmount = canUseAmount;
    }

    public boolean isLessSafeMinStock() {
        return lessSafeMinStock;
    }

    public void setLessSafeMinStock(boolean lessSafeMinStock) {
        this.lessSafeMinStock = lessSafeMinStock;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
}
