package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReceiveShelvesDetail;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommFileRef;

import java.io.Serializable;
import java.util.List;

/**
 * @author xw
 * @create 2018-08-27 14:57
 */
public class WhWmsReceiveShelvesDetailVO extends WhWmsReceiveShelvesDetail implements Serializable {

    private String skuName;

    private String skuStatusName;

    private String createUserName;

    private Long poId;

    private String barCode;

    private Integer defectiveAllQuantity;

    private Long processUserId;

    private List<CommFileRef> commFileRefs;

    private Integer shelfLife;

    private String physicalWarehouseCode;

    public static final int ORIGIN_TYPE_WMS_QC = 1;

    public static final int ORIGIN_TYPE_SCM_QC = 2;

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuStatusName() {
        if (EmptyUtil.isEmpty(skuStatusName) && EmptyUtil.isNotEmpty(this.getSkuStatus())){
            skuStatusName = WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(this.getSkuStatus());
            if (EmptyUtil.isEmpty(skuStatusName)){
                if (WhCommand.TYPE_PURCHASE_RETURN_OUT.equals(this.getSkuStatus())){
                    return "采退";
                }
            }
        }
        return skuStatusName;
    }

    public void setSkuStatusName(String skuStatusName) {
        this.skuStatusName = skuStatusName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getPoId() {
        return poId;
    }

    public void setPoId(Long poId) {
        this.poId = poId;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public Integer getDefectiveAllQuantity() {
        return defectiveAllQuantity;
    }

    public void setDefectiveAllQuantity(Integer defectiveAllQuantity) {
        this.defectiveAllQuantity = defectiveAllQuantity;
    }

    public Long getProcessUserId() {
        return processUserId;
    }

    public void setProcessUserId(Long processUserId) {
        this.processUserId = processUserId;
    }

    public List<CommFileRef> getCommFileRefs() {
        return commFileRefs;
    }

    public void setCommFileRefs(List<CommFileRef> commFileRefs) {
        this.commFileRefs = commFileRefs;
    }

    public Integer getShelfLife() {
        return shelfLife;
    }

    public void setShelfLife(Integer shelfLife) {
        this.shelfLife = shelfLife;
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    @Override
    public String toString() {
        return "WhWmsReceiveShelvesDetailVO{" +
                "skuName='" + skuName + '\'' +
                ", skuStatusName='" + skuStatusName + '\'' +
                ", createUserName='" + createUserName + '\'' +
                ", poId=" + poId +
                ", barCode='" + barCode + '\'' +
                ", defectiveAllQuantity=" + defectiveAllQuantity +
                ", commFileRefs=" + commFileRefs +
                '}';
    }
}
