package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsQcProcessDetail;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author xw
 * @create 2018-09-03 14:07
 */
public class WhWmsQcProcessDetailVO extends WhWmsQcProcessDetail implements Serializable {

    // pop残次处理状态
    public static final int DEFECTIVE_PROCESS_STATUS_WAIT = 0;
    public static final int DEFECTIVE_PROCESS_STATUS_PROCESSED = 1;
    public final static Map<Integer,String> DEFECTIVE_PROCESS_STATUS_MAP = new HashMap(){{
        put(DEFECTIVE_PROCESS_STATUS_WAIT,"待处理");
        put(DEFECTIVE_PROCESS_STATUS_PROCESSED,"已处理");
    }};

    public WhWmsQcProcessDetailVO() {
    }

    public WhWmsQcProcessDetailVO(Integer processStatus) {
        this.processStatus = processStatus;
    }

    private String skuName;
    private String processUserName;
    private Integer processStatus;
    private String processStatusName;


    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getProcessUserName() {
        return processUserName;
    }

    public void setProcessUserName(String processUserName) {
        this.processUserName = processUserName;
    }

    @Override
    public Integer getProcessStatus() {
        return processStatus;
    }

    public void setProcessStatus(Integer processStatus) {
        this.processStatus = processStatus;
    }

    public String getProcessStatusName() {
        if (EmptyUtil.isEmpty(processStatusName) && EmptyUtil.isNotEmpty(this.processStatus)){
            processStatusName = DEFECTIVE_PROCESS_STATUS_MAP.get(this.processStatus);
            processStatusName = processStatusName!=null?processStatusName:"待处理";
        }
        return processStatusName;
    }

    public void setProcessStatusName(String processStatusName) {
        this.processStatusName = processStatusName;
    }
}
