package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.PegasusWmsServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTask;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTaskDetail;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskDetailService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.util.CollectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by devin.li on 16/4/14.
 */
public class WhWmsPrdcJobTaskVO extends WhWmsPrdcJobTask {

    @Autowired
    private PegasusWmsServiceFacade              wmsFacade = PegasusWmsServiceFacade.getInstance();

    private PegasusWarehouseServiceFacade        whFacade = PegasusWarehouseServiceFacade.getInstance();

    @Autowired
    private WhWmsOccupyService                   whWmsOccupyService;

    private List<WhWmsOccupyVO> historykOccupyList;

    //base
    private String physicalWarehouseCode;

    private String warehouseCode;

    private Integer status;

    private String code;

    //self
    private Integer jobPlanStatus;//job订单状态

    private Integer estQuantity;//job计划数量

    private List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList;//子任务详情列

    private String moveStockCode;

    private String createUserName;

    private Long createUserId;

    private String finishedUserName;

    private String skuNameCn;

    private Long skuId;
    
    private Long packageSkuId;

    private Long PrdcJobId;

    private String commandCode;
    
    private String batchNo;
    
    private Date productDate;//生产日期

    private Date expirationDate;//生产日期

    private Integer shelfLife;//保质期

    private String firstCategory;//一级类目

    private String customizationContent;//定制内容

    private String orderCreateDate;//下单日期

    private String prodDetailsAttribute;//PROD详情页的属性

    private Integer isBr = 0;//是否手动换行 1-是 0否

    private String customizeType;//定制类型

    private String referenceCode;

    private Integer priority;//优先级

    private String secondCategory;//一级类目

    // 主耗材批次信息
    private List<WhWmsSkuStockRecordVO> prdcMaterialDetails;

    // 是否 生成新批次
    private boolean makeNewBarcode = false;

    private String barcode;

    private Long bcId;

    // 耗材sku列表
    private List<String> materialSkus;

    private List<String> materialBarcodes;
  //打印模板类型 （1：蜡烛模板，2：散香器模板）
    private Short printTemplateType;

    private boolean occupyFlag = true;

    private Integer customization;//是否定制

    private List<WhWmsSkuBarcodeVO> wmsSkuBarcodeVOs;


    //auto

    public Integer getJobPlanStatus() {
        return jobPlanStatus;
    }

    public Long getPackageSkuId() {
		return packageSkuId;
	}

	public void setPackageSkuId(Long packageSkuId) {
		this.packageSkuId = packageSkuId;
	}

	public void setJobPlanStatus(Integer jobPlanStatus) {
        this.jobPlanStatus = jobPlanStatus;
    }

    public Integer getEstQuantity() {
        return estQuantity;
    }

    public void setEstQuantity(Integer estQuantity) {
        this.estQuantity = estQuantity;
    }

    public List<WhWmsPrdcJobTaskDetailVO> getJobTaskDetailList() {
        return jobTaskDetailList;
    }

    public void setJobTaskDetailList(List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList) {
        this.jobTaskDetailList = jobTaskDetailList;
    }

    public String getMoveStockCode() {
        return moveStockCode;
    }

    public void setMoveStockCode(String moveStockCode) {
        this.moveStockCode = moveStockCode;
    }
    @Override
    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    @Override
    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    @Override
    public Integer getStatus() {
        return status;
    }

    @Override
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public String getFinishedUserName() {
        return finishedUserName;
    }

    public void setFinishedUserName(String finishedUserName) {
        this.finishedUserName = finishedUserName;
    }
    public String getCustomizationContent() {
        return customizationContent;
    }

    public void setCustomizationContent(String customizationContent) {
        this.customizationContent = customizationContent;
    }

    public String getReferenceCode() {
        return referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @Override
    public Long getCreateUserId() {
        return createUserId;
    }

    @Override
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getPrdcJobId() {
        return PrdcJobId;
    }

    public void setPrdcJobId(Long prdcJobId) {
        PrdcJobId = prdcJobId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    /**
     * 子任务状态
     */
    public static final Integer STATUS_PROCESSING = 1;//加工中

    public static final Integer STATUS_FINISHED = 2;//已完成

    /**
     * job状态
     */
    public static final Integer WMS_STATUS_RETURN_MODIFY = 5;//待加工

    public static final Integer WMS_PLAN_STATUS_PROCESSING = 6;//加工中

    public static final Integer WMS_PLAN_STATUS_PARTFINISHED = 7;//部分完成

    public static final Integer WMS_PLAN_STATUS_FINISHED = 8; //加工完成

    /**
     * jobType
     */

    public static final Integer JOB_TYPE_ASSEMBLE = 1;//组装

    public static final Integer JOB_TYPE_SPLIT = 2; //拆分


    //others
    /**
     * 状态名称
     * @return
     */
    public String getTaskStatusName(){
        return status==null?"N/A":
                status.equals(WhWmsPrdcJobTaskVO.STATUS_PROCESSING)?"加工中":
                        status.equals(WhWmsPrdcJobTaskVO.STATUS_PROCESSING)?"已完成":"error";

    }


    public static List<KeyValueVO> getAllStatus(){
        List<KeyValueVO> jobTypeList = new ArrayList(){{
            add(new KeyValueVO(WhWmsPrdcJobTaskVO.STATUS_PROCESSING.toString(),"加工中"));
            add(new KeyValueVO(WhWmsPrdcJobTaskVO.STATUS_FINISHED.toString(),"已完成"));
        }};
        return jobTypeList;
    }


    public String getPhysicalWarehouseName(){
        if (EmptyUtil.isEmpty(this.physicalWarehouseCode)) return null;
        WhPhysicalWarehouse warehouse = whFacade.findPhysicalWarehouseByCode(this.physicalWarehouseCode);
        return warehouse.getName();
    }


    public List<WhWmsPrdcJobTaskDetailVO> getJobTaskDetails(){
        List<WhWmsPrdcJobTaskDetailVO> taskDetails = wmsFacade.getTaskDetailByTaskCode(this.code);
        if(CollectionUtils.isEmpty(taskDetails)) return Collections.EMPTY_LIST;
        return taskDetails;
    }

    public List<WhWmsOccupyVO> getOcupyList(){
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(code);
        List<WhWmsOccupyVO> occupyVOs = wmsFacade.getWmsOccupyByCond(cond);
        return occupyVOs;
    }




    public Object getRtObj(){
        Map<String,String> rtMap = new HashMap<String,String>();
        if(!StringUtils.isEmpty(this.commandCode)){
            rtMap.put("commandCode", this.commandCode);
        }
        if(!StringUtils.isEmpty(this.moveStockCode)){
            rtMap.put("moveCode", this.moveStockCode);
        }
        if(!StringUtils.isEmpty(this.batchNo)){
            rtMap.put("batchNo", this.batchNo);
        }
        return rtMap;
    }

    public String getCommandCode() {
        return commandCode;
    }

    public void setCommandCode(String commandCode) {
        this.commandCode = commandCode;
    }

	public String getBatchNo() {
		return batchNo;
	}

	public void setBatchNo(String batchNo) {
		this.batchNo = batchNo;
	}

	public Date getProductDate() {
		return productDate;
	}

	public void setProductDate(Date productDate) {
		this.productDate = productDate;
	}

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Integer getShelfLife() {
		return shelfLife;
	}

	public void setShelfLife(Integer shelfLife) {
		this.shelfLife = shelfLife;
	}

	public List<WhWmsOccupyVO> getHistorykOccupyList() {
		return historykOccupyList;
	}

	public void setHistorykOccupyList(List<WhWmsOccupyVO> historykOccupyList) {
		this.historykOccupyList = historykOccupyList;
	}

    public String getFirstCategory() {
        return firstCategory;
    }

    public void setFirstCategory(String firstCategory) {
        this.firstCategory = firstCategory;
    }

    public String getSecondCategory() {
        return secondCategory;
    }

    public void setSecondCategory(String secondCategory) {
        this.secondCategory = secondCategory;
    }

    public List<WhWmsSkuStockRecordVO> getPrdcMaterialDetails() {
        return prdcMaterialDetails;
    }

    public void setPrdcMaterialDetails(List<WhWmsSkuStockRecordVO> prdcMaterialDetails) {
        this.prdcMaterialDetails = prdcMaterialDetails;
    }

    public boolean isMakeNewBarcode() {
        return makeNewBarcode;
    }

    public void setMakeNewBarcode(boolean makeNewBarcode) {
        this.makeNewBarcode = makeNewBarcode;
    }

    public String getBarcode() {
        return barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public Long getBcId() {
        return bcId;
    }

    public void setBcId(Long bcId) {
        this.bcId = bcId;
    }

    public List<String> getMaterialSkus() {
        return materialSkus;
    }

    public void setMaterialSkus(List<String> materialSkus) {
        this.materialSkus = materialSkus;
    }

    public List<String> getMaterialBarcodes() {
        return materialBarcodes;
    }

    public void setMaterialBarcodes(List<String> materialBarcodes) {
        this.materialBarcodes = materialBarcodes;
    }

  public String getOrderCreateDate() {
    return orderCreateDate;
  }

  public void setOrderCreateDate(String orderCreateDate) {
    this.orderCreateDate = orderCreateDate;
  }

  public String getProdDetailsAttribute() {
    return prodDetailsAttribute;
  }

  public void setProdDetailsAttribute(String prodDetailsAttribute) {
    this.prodDetailsAttribute = prodDetailsAttribute;
  }

  public Integer getIsBr() {
    return isBr;
  }

  public void setIsBr(Integer isBr) {
    this.isBr = isBr;
  }

    public Integer getCustomization() {
        return customization;
    }

    public void setCustomization(Integer customization) {
        this.customization = customization;
    }

    public List<WhWmsSkuBarcodeVO> getWmsSkuBarcodeVOs() {
        return wmsSkuBarcodeVOs;
    }

    public void setWmsSkuBarcodeVOs(List<WhWmsSkuBarcodeVO> wmsSkuBarcodeVOs) {
        this.wmsSkuBarcodeVOs = wmsSkuBarcodeVOs;
    }

    public String getCustomizeType() {
    return customizeType;
  }

  public void setCustomizeType(String customizeType) {
    this.customizeType = customizeType;
  }

  public Short getPrintTemplateType() {
    return printTemplateType;
  }

  public void setPrintTemplateType(Short printTemplateType) {
    this.printTemplateType = printTemplateType;
  }

    public boolean isOccupyFlag() {
        return occupyFlag;
    }

    public void setOccupyFlag(boolean occupyFlag) {
        this.occupyFlag = occupyFlag;
    }
}
