package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsOutStockRecord;

/**
 * com.thebeastshop.pegasus.service.warehouse.vo
 *
 * @author xwei
 * @create 2017-03-30 21:08
 */
public class WhWmsOutStockRecordVO extends WhWmsOutStockRecord {

    /*########################操作类型--start########################*/
    // 波次启动
    public final static int OPT_TYPE_CONNECT_START = 1;
    // 任务领取
    public final static int OPT_TYPE_TASK_RECEIVE = 2;
    // 拣货开始
    public final static int OPT_TYPE_PICKING_START = 3;
    // 拣货完成
    public final static int OPT_TYPE_PICKING_FINISHED = 4;
    // 分拨开始
    public final static int OPT_TYPE_ALLOCATE_START = 5;
    // 分拨完成
    public final static int OPT_TYPE_ALLOCATE_FINISHED = 6;
    // 交接
    public final static int OPT_TYPE_JIAOJIE = 7;
    // 拣货明细
    public final static int OPT_TYPE_PICKING_DETAIL = 8;
    // [验货-多品单件] 多品单件验货开始时写入
    public final static int OPT_TYPE_DUOPIN_DANJIAN_START = 9;
    // [验货-多品单件] 多品单件验货结束时写入
    public final static int OPT_TYPE_DUOPIN_DANJIAN_END = 10;
    // [验货-多品多件] 多品多件验货开始时写入
    public final static int OPT_TYPE_DUOPIN_DUOJIAN_START = 11;
    // [验货-多品多件] 多品多件验货结束时写入
    public final static int OPT_TYPE_DUOPIN_DUOJIAN_END = 12;
    // [调拨打包] 调拨打包开始
    public final static int OPT_TYPE_ALLOT_PACK_START = 13;
    // [调拨打包] 调拨打包完成
    public final static int OPT_TYPE_ALLOT_PACK_FINISHED = 14;
    //[多品单件]验货明细
    public final static int OPT_TYPE_MULTI_PRODUCT_SINGLE_PIECE_CHECK_DETAIL = 15;
    // [验货-单品单件] 单品单件验货开始时写入
    public final static int OPT_TYPE_DANPIN_DANJIAN_START = 16;
    // [验货-单品单件] 单品单件验货结束时写入
    public final static int OPT_TYPE_DANPIN_DANJIAN_END = 17;
    // [验货-多件活动] 多件活动验货开始时写入
    public final static int OPT_TYPE_MULTI_PIECE_ACTIVITY_START = 18;
    // [验货-多件活动] 多件活动验货结束时写入
    public final static int OPT_TYPE_MULTI_PIECE_ACTIVITY_END = 19;
    // [验货-大宗订单] 大宗订单验货开始时写入
    public final static int OPT_TYPE_BULK_ORDER_START = 20;
    // [验货-大宗订单] 大宗订单验货结束时写入
    public final static int OPT_TYPE_BULK_ORDER_END = 21;
    // [验货-多品多件]验货明细
    public final static int OPT_TYPE_DUOPIN_DUOJIAN_CHECK_DETAIL = 22;
    // [验货-大宗订单]验货明细
    public final static int OPT_TYPE_BULK_ORDER_CHECK_DETAIL = 23;
    /*########################操作类型--end########################*/

    /*########################记录类型--start########################*/
    // 入口：WMS->发货出库->波次启动,波次启动成功时写入 [波次启动]
    public final static int RECORD_TYPE_CONNECT_START = 1;
    // 入口：WMS->发货出库->波次启动-调拨,波次启动成功时写入 [波次启动-调拨]
    public final static int RECORD_TYPE_CONNECT_START_ALLOT = 2;
    // 入口：WMS->发货出库->波次启动-采退,启动成功时写入 [波次启动-采退]
    public final static int RECORD_TYPE_CONNECT_START_CAITUI = 3;
    // 入口：WMS->发货出库->波次启动-采退,启动成功时写入 [波次启动-报废领用]
    public final static int RECORD_TYPE_CONNECT_START_RECWASTE = 4;
    // 入口：RF 成功领取拣货任务时写入 [任务领取]
    public final static int RECORD_TYPE_TASK_RECEIVE = 4;
    // 入口：波次中首次拣货发生时写入 [拣货开始]
    public final static int RECORD_TYPE_PICKING_START = 5;
    // 入口：波次中所有拣货任务完成时写入 [拣货完成]
    public final static int RECORD_TYPE_PICKING_FINISHED = 6;
    // 入口：[分拨开始]
    public final static int RECORD_TYPE_ALLOCATE_START = 7;
    // 入口：[分拨完成]
    public final static int RECORD_TYPE_ALLOCATE_FINISHED = 8;
    // 入口:WMS->发货出库->包裹交接
    public final static int RECORD_TYPE_JIAOJIE = 9;
    // 入口:RF->拣货详情->提交
    public final static int RECORD_TYPE_PICKING_DETAIL = 10;
    // 入口：WMS->发货出库->出库验货-多品单件 [多品单件验货开始]
    public final static int RECORD_TYPE_DUOPIN_DANJIAN_START = 11;
    // 入口：WMS->发货出库->出库验货-多品单件 [多品单件验货结束]
    public final static int RECORD_TYPE_DUOPIN_DANJIAN_END = 12;
    // 入口：WMS->发货出库->出库验货-多品多件 [多品多件验货开始]
    public final static int RECORD_TYPE_DUOPIN_DUOJIAN_START = 13;
    // 入口：WMS->发货出库->出库验货-多品多件 [多品多件验货结束]
    public final static int RECORD_TYPE_DUOPIN_DUOJIAN_END = 14;
    // 入口:WMS->发货出库->包装验货-调拨 [调拨打包开始]
    public final static int RECORD_TYPE_ALLOT_PACK_START = 15;
    // 入口:WMS->发货出库->包装验货-调拨 [调拨打包完成]
    public final static int RECORD_TYPE_ALLOT_PACK_FINISHED = 16;
    // 入口：WMS->发货出库->出库验货-单品单件 [单品单件验货开始]
    public final static int RECORD_TYPE_DANPIN_DANJIAN_START = 17;
    // 入口：WMS->发货出库->出库验货-单品单件 [单品单件验货结束]
    public final static int RECORD_TYPE_DANPIN_DANJIAN_END = 18;
    // 入口：WMS->发货出库->出库验货-多件活动 [多件活动验货开始]
    public final static int RECORD_TYPE_MULTI_PIECE_ACTIVITY_START = 19;
    // 入口：WMS->发货出库->出库验货-多件活动 [多件活动验货结束]
    public final static int RECORD_TYPE_MULTI_PIECE_ACTIVITY_END = 20;
    // 入口：WMS->发货出库->出库验货-多品多件 [大宗订单验货开始]
    public final static int RECORD_TYPE_BULK_ORDER_START = 21;
    // 入口：WMS->发货出库->出库验货-多品多件 [大宗订单验货结束]
    public final static int RECORD_TYPE_BULK_ORDER_END = 22;
    // 入口：WMS->发货出库->出库验货-特殊订单->多品单件验货
    public final static int RECORD_TYPE_DUOPIN_DANJIAN_CHECK = 23;
    // 入口：WMS->发货出库->出库验货-多品多件验货
    public final static int RECORD_TYPE_DUOPIN_DUOJIAN_CHECK = 24;
    // 入口：WMS->发货出库->出库验货-大宗订单验货
    public final static int RECORD_TYPE_BULK_ORDER_CHECK = 25;
    /*########################记录类型--end########################*/

    /*########################处理类型--start########################*/
    // 首次正常出库 0
    public final static int DISPOSE_TYPE_ZERO = 1;
    // 1~N:缺货等异常导致的二次、三次出库
    public final static int DISPOSE_TYPE_MORE = 2;
    /*########################处理类型--end########################*/

    /*########################关联描述--start########################*/
    // 波次启动
    public final static String REF_DESC_CONNECT_START = "WhWmsConnectInfo";
    // 任务领取
    public final static String REF_DESC_TASK_RECEIVE = "WhWmsTaskAssign";
    // 拣货
    public final static String REF_DESC_PICKING = "WhWmsPickSku";
    // 分拨
    public final static String REF_DESC_ALLOCATE = "WhWmsConnectDistribution";
    // 出库验货
    public final static String REF_DESC_COMMAND_CHECK = "WhWmsCommandCheck";
    /*########################处理类型--end########################*/

    public enum OptTypeDescEnum{
        CONNECT_START(OPT_TYPE_CONNECT_START, "波次启动"),
        TASK_RECEIVE(OPT_TYPE_TASK_RECEIVE, "任务领取"),
        PICKING_START(OPT_TYPE_PICKING_START, "拣货开始"),
        PICKING_FINISHED(OPT_TYPE_PICKING_FINISHED,"拣货完成"),
        ALLOCATE_START(OPT_TYPE_ALLOCATE_START,"分拨开始"),
        ALLOCATE_FINISHED(OPT_TYPE_ALLOCATE_FINISHED,"分拨完成"),
        JIAOJIE(OPT_TYPE_JIAOJIE,"交接"),
        PICKING_DETAIL(OPT_TYPE_PICKING_DETAIL,"拣货明细"),
        DUOPIN_DANJIAN_START(OPT_TYPE_DUOPIN_DANJIAN_START,"多品单件验货开始"),
        DUOPIN_DANJIAN_END(OPT_TYPE_DUOPIN_DANJIAN_END,"多品单件验货结束"),
        DANPIN_DANJIAN_START(OPT_TYPE_DANPIN_DANJIAN_START,"单品单件验货开始"),
        DANPIN_DANJIAN_END(OPT_TYPE_DANPIN_DANJIAN_END,"单品单件验货结束"),
        MULTI_PIECE_ACTIVITY_START(OPT_TYPE_MULTI_PIECE_ACTIVITY_START,"多件活动验货开始"),
        MULTI_PIECE_ACTIVITY_END(OPT_TYPE_MULTI_PIECE_ACTIVITY_END,"多件活动验货结束"),
        DUOPIN_DUOJIAN_START(OPT_TYPE_DUOPIN_DUOJIAN_START,"多品多件验货开始"),
        DUOPIN_DUOJIAN_END(OPT_TYPE_DUOPIN_DUOJIAN_END,"多品多件验货结束"),
        BULK_ORDER_START(OPT_TYPE_BULK_ORDER_START,"大宗订单验货开始"),
        BULK_ORDER_END(OPT_TYPE_BULK_ORDER_END,"大宗订单验货结束"),
        ALLOT_PACK_START(OPT_TYPE_ALLOT_PACK_START,"调拨打包开始"),
        ALLOT_PACK_FINISHED(OPT_TYPE_ALLOT_PACK_FINISHED,"调拨打包完成"),
        MULTI_PRODUCT_SINGLE_PIECE_CHECK_DETAIL(OPT_TYPE_MULTI_PRODUCT_SINGLE_PIECE_CHECK_DETAIL,"多品单件验货明细"),
        DUOPIN_DUOJIAN_CHECK_DETAIL(OPT_TYPE_DUOPIN_DUOJIAN_CHECK_DETAIL,"多品多件验货明细"),
        BULK_ORDER_CHECK_DETAIL(OPT_TYPE_BULK_ORDER_CHECK_DETAIL,"大宗订单验货明细");

        private int optType;
        private String optDesc;

        private OptTypeDescEnum(int optType, String optDesc) {
            this.optType = optType;
            this.optDesc = optDesc;
        }

        public int getOptType() {
            return optType;
        }

        public String getOptDesc() {
            return optDesc;
        }
    }

}
