package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsOccupy;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2016/3/23.
 */
public class WhWmsOccupyVO extends WhWmsOccupy implements Serializable {


    //self
    private String skuName;
    
    private Date expirationDate;

    private List<String> receiptsNoList;

    private List<Long> ids;

	public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }
    
    public Date getExpirationDate() {
		return expirationDate;
	}

	public void setExpirationDate(Date expirationDate) {
		this.expirationDate = expirationDate;
	}

    /**
     * SKU状态
     */
    public static final Integer OCCUPY_STATUS_BAD = 0;//残次
    public static final Integer OCCUPY_STATUS_GOOD = 1;//良品
    public static final Integer OCCUPY_STATUS_SAMPLE = 2;//样品

    /**
     * 占用状态
     */
    public static final Integer OCCUPIED = 1;//占用
    public static final Integer RELEASED = 0;//释放

    /**
     * 占用类型
     */
    public static final Integer TYPE_MOVE = 1;//移库占用
    public static final Integer TYPE_CONNECT = 2;//波次占用
    public static final Integer TYPE_PRODUCTION = 3;//生产占用
    public static final Integer TYPE_GRADE_ADJUST = 4;//品级调整占用
    public static final Integer TYPE_MOVE_STOREHOUSE = 9;//搬仓占用

    /**
     * 根据skuStock build占用vo,RECEIPTS_NO,TYPE,AMOUNT 三个字段外部填充
     * @param stock
     * @return
     */
    public static WhWmsOccupyVO buildOccupyVOFromStock(WhWmsSkuStockVO stock){
        WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
        occupyVO.setSkuStatus(stock.getSkuStatus());
        occupyVO.setSkuCode(stock.getSkuCode());
        occupyVO.setBarCode(stock.getBarCode());
        occupyVO.setHouseType(stock.getHouseType());
        occupyVO.setOriShelvesCode(stock.getShelvesCode());
        occupyVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
        return occupyVO;
    }

    public List<String> getReceiptsNoList() {
        return receiptsNoList;
    }

    public void setReceiptsNoList(List<String> receiptsNoList) {
        this.receiptsNoList = receiptsNoList;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}
