package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.PegasusWmsServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStock;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveSkuService;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by devin.li on 2016/3/25.
 */
public class WhWmsMoveStockVO extends WhWmsMoveStock implements Serializable {

    private PegasusWmsServiceFacade wmsFacade = PegasusWmsServiceFacade.getInstance();

    private PegasusWarehouseServiceFacade warehouseFacade = PegasusWarehouseServiceFacade.getInstance();


    //base
    private String code;
    private String physicalWarehouseCode;

    private boolean autoFinish = false;


    //self
    private List<WhWmsMoveSkuVO> moveSkuList;

    private String createUserName;

    private String assignOperatorName;

    private String operatorName;

    private List<WhWmsOccupyVO> occupyList;




    public List<WhWmsMoveSkuVO> getMoveSkuList() {
        return moveSkuList;
    }

    public void setMoveSkuList(List<WhWmsMoveSkuVO> moveSkuList) {
        this.moveSkuList = moveSkuList;
    }
    @Override
    public String getCode() {
        return code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    @Override
    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getAssignOperatorName() {
        return assignOperatorName;
    }

    public void setAssignOperatorName(String assignOperatorName) {
        this.assignOperatorName = assignOperatorName;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public boolean isAutoFinish() {
        return autoFinish;
    }

    public void setAutoFinish(boolean autoFinish) {
        this.autoFinish = autoFinish;
    }

    public List<WhWmsOccupyVO> getOccupyList() {
        return occupyList;
    }

    public void setOccupyList(List<WhWmsOccupyVO> occupyList) {
        this.occupyList = occupyList;
    }

    /**
     * 移库状态
     */
    public static final Integer STATUS_WAITTINT_OUT = 0;//待出库
    public static final Integer STATUS_WAITTING_IN = 1;//待入库
    public static final Integer STATUS_FINISHED = 2;//移库完成
    public static final Integer STATUS_CANCEL = 4;//已取消
    public static final Integer STATUS_PROCESSING = 5;//部分完成

    /**
     * 移库类型
     */
    public static final Integer MOVE_TYPE_COMMON = 1;//普通移库
    public static final Integer MOVE_TYPE_SUPPLEMENT = 2;//补货移库
    public static final Integer MOVE_TYPE_PRODUCTION = 3;//生产加工移库
    public static final Integer MOVE_TYPE_CANCEL_MAKE = 5;//包裹取消移库
    public static final Integer MOVE_TYPE_AUTORETURN = 6;//耗材自动回库
    public static final Integer MOVE_TYPE_SKU_TRANSLATE = 7;//状态变更移库




    public List<WhWmsMoveSkuVO> getMoveSkuVOs(){
        if (EmptyUtil.isNotEmpty(code)){
            return wmsFacade.getMoveSkuByMoveCode(code);
        }
        return null;
    }


    public String getWarehouseInfo(){
        if (EmptyUtil.isNotEmpty(physicalWarehouseCode)){
            WhPhysicalWarehouse warehouse =  warehouseFacade.findPhysicalWarehouseByCode(physicalWarehouseCode);
            if (EmptyUtil.isNotEmpty(warehouse)){
                return "["+warehouse.getHouseNo()+"]"+warehouse.getName();
            }
        }
        return null;
    }


    public String getWarehouseName(){
        if (EmptyUtil.isNotEmpty(physicalWarehouseCode)){
            WhPhysicalWarehouse warehouse =  warehouseFacade.findPhysicalWarehouseByCode(physicalWarehouseCode);
            if (EmptyUtil.isNotEmpty(warehouse)){
                return warehouse.getName();
            }
        }
        return null;
    }


    //others
    public static List<KeyValueVO> getAllStatus(){
        List<KeyValueVO> moveStatusList = new ArrayList(){{
            add(new KeyValueVO(WhWmsMoveStockVO.STATUS_WAITTINT_OUT.toString(),"待出库"));
            add(new KeyValueVO(WhWmsMoveStockVO.STATUS_WAITTING_IN.toString(),"待入库"));
            add(new KeyValueVO(WhWmsMoveStockVO.STATUS_FINISHED.toString(),"移库完成"));
            add(new KeyValueVO(WhWmsMoveStockVO.STATUS_CANCEL.toString(),"已取消"));
            add(new KeyValueVO(WhWmsMoveStockVO.STATUS_PROCESSING.toString(),"部分完成"));
        }};
        return moveStatusList;
    }

    public static List<KeyValueVO> getAllMoveType(){
        List<KeyValueVO> moveTypeList = new ArrayList(){{
            add(new KeyValueVO(WhWmsMoveStockVO.MOVE_TYPE_COMMON.toString(),"普通移库"));
            add(new KeyValueVO(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT.toString(),"补货移库"));
            add(new KeyValueVO(WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION.toString(),"加工移库"));
            add(new KeyValueVO(WhWmsMoveStockVO.MOVE_TYPE_CANCEL_MAKE.toString(),"包裹取消移库"));
            add(new KeyValueVO(WhWmsMoveStockVO.MOVE_TYPE_AUTORETURN.toString(),"耗材自动回库"));
            add(new KeyValueVO(WhWmsMoveStockVO.MOVE_TYPE_SKU_TRANSLATE.toString(),"状态变更移库"));
        }};
        return moveTypeList;
    }

    public static String getStatusName(Integer status){
        return STATUS_WAITTINT_OUT.equals(status)?"待出库":
                    STATUS_FINISHED.equals(status)?"移库完成":
                        STATUS_WAITTING_IN.equals(status)?"待入库":
                                STATUS_PROCESSING.equals(status)?"部分完成":"";
    }

    public String getMoveTypeStr(){
        return getMoveTypeName(getMoveType());
    }

    public static String getMoveTypeName(Integer moveType){
        return WhWmsMoveStockVO.MOVE_TYPE_COMMON.equals(moveType)?"普通移库":
                WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT.equals(moveType)?"补货移库":
                        WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION.equals(moveType)?"加工移库":
                                WhWmsMoveStockVO.MOVE_TYPE_CANCEL_MAKE.equals(moveType)?"包裹取消移库":
                                        WhWmsMoveStockVO.MOVE_TYPE_AUTORETURN.equals(moveType)?"耗材自动回库":
                                                WhWmsMoveStockVO.MOVE_TYPE_SKU_TRANSLATE.equals(moveType)?"状态变更移库":"";
    }

}
