package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlan;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2018/5/31.
 */
public class WhWmsInventoryPlanVO extends WhWmsInventoryPlan {

    final static public Integer STATUS_PENDING = 1;

    final static public Integer STATUS_PROCESSING = 2;

    final static public Integer STATUS_FINISHED = 3;

    final static public Integer STATUS_CANCELED = -1;

    final static public Integer TYPE_DAYTODAY_INVENTORY = 1;//日常盘点

    final static public Integer TYPE_REGULAR_INVENTORY = 2;//定期盘点

    final static public Integer MODE_SHOW = 1;//明盘

    final static public Integer MODE_HIDE = 2;//盲盘


    private List<WhWmsInventoryPlanShelvesVO> inventroyShelvesList;

    private String physicalWarehouseName;

    private String createUserName;

    public String getStatusStr(){
        return getStatusName(getStatus());
    }

    public String getModeStr(){
        return getModeName(getMode());
    }

    public String getTypeStr(){
        return getTypeName(getType());
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public List<WhWmsInventoryPlanShelvesVO> getInventroyShelvesList() {
        return inventroyShelvesList;
    }

    public void setInventroyShelvesList(List<WhWmsInventoryPlanShelvesVO> inventroyShelvesList) {
        this.inventroyShelvesList = inventroyShelvesList;
    }

    public static String getStatusName(Integer status){
        return STATUS_PENDING.equals(status)?"待盘点":
                STATUS_PROCESSING.equals(status)?"盘点中":
                        STATUS_FINISHED.equals(status)?"盘点完成":
                                STATUS_CANCELED.equals(status)?"取消":"";
    }

    public static String getModeName(Integer mode){
        return MODE_SHOW.equals(mode)?"明盘":
                MODE_HIDE.equals(mode)?"盲盘":"";
    }

    public static String getTypeName(Integer type){
        return TYPE_DAYTODAY_INVENTORY.equals(type)?"日常盘点":
                TYPE_REGULAR_INVENTORY.equals(type)?"定期盘点":"";
    }

    public static List<KeyValueVO> getModeKvList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(MODE_SHOW.toString(),"明盘"));
        list.add(new KeyValueVO(MODE_HIDE.toString(),"盲盘"));
        return list;
    }

    public static List<KeyValueVO> getTypeKvList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(STATUS_PENDING.toString(),"日常盘点"));
        list.add(new KeyValueVO(TYPE_REGULAR_INVENTORY.toString(),"定期盘点"));
        return list;
    }

    public static List<KeyValueVO> getStatusKvList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(TYPE_DAYTODAY_INVENTORY.toString(),"待盘点"));
        list.add(new KeyValueVO(STATUS_PROCESSING.toString(),"盘点中"));
        list.add(new KeyValueVO(STATUS_FINISHED.toString(),"盘点完成"));
        list.add(new KeyValueVO(STATUS_CANCELED.toString(),"取消"));
        return list;
    }
}
