package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlanShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2018/5/31.
 */
public class WhWmsInventoryPlanShelvesVO extends WhWmsInventoryPlanShelves {

    final static public Integer STATUS_PENDING = 1;

    final static public Integer STATUS_PROCESSING = 2;

    final static public Integer STATUS_CHECK_PENDING = 3;

    final static public Integer STATUS_FINISHED = 4;

    final static public Integer STATUS_CANCELED = -1;

    private Long operatorId;

    private Long taskAssignedId;//任务Id

    private List<WhWmsInventoryPlanShelvesDetailVO> inventoryShelvesDetailList;

    private List<WhWmsInventoryPlanDiffDetailVO> shelvesDiffDetailList;

    private List<WhWmsSkuStockVO> skuStockList;

    private String physicalWarehouseName;

    private String houseTypeName;

    private boolean inventoryQuick = false;//是否快盘

    private boolean showOriAmount = false;

    private String assignedOperatorName;

    private String shelvesHouseTypeName;

    public String getHouseTypeName() {
        return houseTypeName;
    }

    public void setHouseTypeName(String houseTypeName) {
        this.houseTypeName = houseTypeName;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public List<WhWmsInventoryPlanShelvesDetailVO> getInventoryShelvesDetailList() {
        return inventoryShelvesDetailList;
    }

    public void setInventoryShelvesDetailList(List<WhWmsInventoryPlanShelvesDetailVO> inventoryShelvesDetailList) {
        this.inventoryShelvesDetailList = inventoryShelvesDetailList;
    }

    public List<WhWmsInventoryPlanDiffDetailVO> getShelvesDiffDetailList() {
        return shelvesDiffDetailList;
    }

    public void setShelvesDiffDetailList(List<WhWmsInventoryPlanDiffDetailVO> shelvesDiffDetailList) {
        this.shelvesDiffDetailList = shelvesDiffDetailList;
    }

    public List<WhWmsSkuStockVO> getSkuStockList() {
        return skuStockList;
    }

    public void setSkuStockList(List<WhWmsSkuStockVO> skuStockList) {
        this.skuStockList = skuStockList;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public Long getTaskAssignedId() {
        return taskAssignedId;
    }

    public void setTaskAssignedId(Long taskAssignedId) {
        this.taskAssignedId = taskAssignedId;
    }

    public String getStatusStr(){
        return getStatusName(getStatus());
    }

    public static String getStatusName(Integer status){
        return STATUS_PENDING.equals(status)?"待盘点":
                STATUS_PROCESSING.equals(status)?"盘点中":
                        STATUS_CHECK_PENDING.equals(status)?"待二次盘点":
                        STATUS_FINISHED.equals(status)?"盘点完成":
                                STATUS_CANCELED.equals(status)?"取消":"";
    }

    public static List<KeyValueVO> getStatusKVList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(STATUS_PENDING.toString(),"待盘点"));
        list.add(new KeyValueVO(STATUS_PROCESSING.toString(),"盘点中"));
        list.add(new KeyValueVO(STATUS_CHECK_PENDING.toString(),"待二次盘点"));
        list.add(new KeyValueVO(STATUS_FINISHED.toString(),"盘点完成"));
        list.add(new KeyValueVO(STATUS_CANCELED.toString(),"取消"));
        return list;
    }

    public boolean isInventoryQuick() {
        return inventoryQuick;
    }

    public void setInventoryQuick(boolean inventoryQuick) {
        this.inventoryQuick = inventoryQuick;
    }

    public String getAssignedOperatorName() {
        return assignedOperatorName;
    }

    public void setAssignedOperatorName(String assignedOperatorName) {
        this.assignedOperatorName = assignedOperatorName;
    }

    public String getShelvesHouseTypeName() {
        return shelvesHouseTypeName;
    }

    public void setShelvesHouseTypeName(String shelvesHouseTypeName) {
        this.shelvesHouseTypeName = shelvesHouseTypeName;
    }

    public boolean isShowOriAmount() {
        return showOriAmount;
    }

    public void setShowOriAmount(boolean showOriAmount) {
        this.showOriAmount = showOriAmount;
    }
}
