package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStockRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlanDiffDetail;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/6/6.
 */
public class WhWmsInventoryPlanDiffDetailVO extends WhWmsInventoryPlanDiffDetail {

    public static List<KeyValueVO> adjustTypeList = null;

    public static Integer PROCESS_TYPE_PROFIT_OR_LOSS = 1;

    public static Integer PROCESS_TYPE_NOTHING = 2;

    private static Map<Integer,String> adjustTypeMap = new HashMap<>();

    private static Map<String,Integer> adjustTypeNameMap = new HashMap<>();

    static {
        adjustTypeList = new ArrayList<>();
        adjustTypeList.add(new KeyValueVO("1","盘盈盘亏"));
        adjustTypeList.add(new KeyValueVO("3","虚拟出/人库"));
        adjustTypeList.add(new KeyValueVO("4","调拨出库(耗材)"));
        adjustTypeList.add(new KeyValueVO("5","包装耗材申领"));
        adjustTypeList.add(new KeyValueVO("6","加工辅材(多退少补)"));
        adjustTypeList.add(new KeyValueVO("7","交叉差异"));
        adjustTypeList.add(new KeyValueVO("8","退货回收"));
        adjustTypeList.add(new KeyValueVO("9","补发"));
        adjustTypeList.add(new KeyValueVO("11","内卖"));
        adjustTypeList.add(new KeyValueVO("12","其他"));

        for(KeyValueVO kv : adjustTypeList){
            Integer code = Integer.parseInt(kv.getKey());
            adjustTypeMap.put(code,kv.getValue());
            adjustTypeNameMap.put(kv.getValue(),code);
        }
    }

    public static Integer STATUS_PENDING = 1;

    public static Integer STATUS_AUDITE_PENDING = 2;

    public static Integer STATUS_AUDITE_REFUSE = 3;

    public static Integer STATUS_AUDITE_PASS = 4;

    private String inventoryPlanCode;

    private String inventoryPlanName;

    private String houseTypeName;

    private String physicalWarehouseName;

    private String skuName;

    private String createUserName;

    private Integer inventoryPlanStatus;

    private String supplierSkuBarcode;

    private List<WhTakeStockRcd> takeStockList;//scm盘点行

    public String getInventoryPlanCode() {
        return inventoryPlanCode;
    }

    public void setInventoryPlanCode(String inventoryPlanCode) {
        this.inventoryPlanCode = inventoryPlanCode;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getSkuStatusStr(){
        return WhWarehouseVO.getSkuStatusName(this.getSkuStatus());
    }

    public String getStatusStr(){
        return getStatusName(getStatus());
    }

    public String getAdjustTypeStr(){
        return getAdjustTypeName(getAdjustType());
    }

    public String getProcessTypeStr(){
        return getProcessTypeName(getProcessType());
    }

    public static String getStatusName(Integer status){
        return STATUS_PENDING.equals(status)?"待确认":
                STATUS_AUDITE_PASS.equals(status)?"审核通过":
                        STATUS_AUDITE_REFUSE.equals(status)?"驳回":
                STATUS_AUDITE_PENDING.equals(status)?"待审核":"";
    }

    public static String getProcessTypeName(Integer processType){
        return PROCESS_TYPE_PROFIT_OR_LOSS.equals(processType)?"盘盈亏":
                PROCESS_TYPE_NOTHING.equals(processType)?"手动处理":"";
    }

    public static String getAdjustTypeName(Integer adjustType){
        return adjustTypeMap.get(adjustType);
    }

    public static Integer getAdjustTypeByName(String adjustTypeName){
        return adjustTypeNameMap.get(adjustTypeName);
    }

    public static List<KeyValueVO> getProcessTypeKvList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(PROCESS_TYPE_PROFIT_OR_LOSS.toString(),"盘盈盘亏"));
        list.add(new KeyValueVO(PROCESS_TYPE_NOTHING.toString(),"手动处理"));
        return list;
    }

    public static List<KeyValueVO> getStatusKvList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(STATUS_PENDING.toString(),"待确认"));
        list.add(new KeyValueVO(STATUS_AUDITE_PENDING.toString(),"待审核"));
        list.add(new KeyValueVO(STATUS_AUDITE_REFUSE.toString(),"驳回"));
        list.add(new KeyValueVO(STATUS_AUDITE_PASS.toString(),"审核通过"));
        return list;
    }

    public String getInventoryPlanName() {
        return inventoryPlanName;
    }

    public void setInventoryPlanName(String inventoryPlanName) {
        this.inventoryPlanName = inventoryPlanName;
    }

    public String getHouseTypeName() {
        return houseTypeName;
    }

    public void setHouseTypeName(String houseTypeName) {
        this.houseTypeName = houseTypeName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getSupplierSkuBarcode() {
        return supplierSkuBarcode;
    }

    public void setSupplierSkuBarcode(String supplierSkuBarcode) {
        this.supplierSkuBarcode = supplierSkuBarcode;
    }

    public Integer getInventoryPlanStatus() {
        return inventoryPlanStatus;
    }

    public void setInventoryPlanStatus(Integer inventoryPlanStatus) {
        this.inventoryPlanStatus = inventoryPlanStatus;
    }

    public List<WhTakeStockRcd> getTakeStockList() {
        return takeStockList;
    }

    public void setTakeStockList(List<WhTakeStockRcd> takeStockList) {
        this.takeStockList = takeStockList;
    }
}
