package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.PegasusWmsServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.util.PegasusConstants.Gender;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by devin.li on 2016/3/16.
 */
@ExcelTemplate
public class WhWmsHouseShelvesVO  implements Serializable {

    private PegasusWarehouseServiceFacade  whFacade = PegasusWarehouseServiceFacade.getInstance();

    private PegasusWmsServiceFacade wmsFacade = PegasusWmsServiceFacade.getInstance();

    //base
    private Long id;

    private String code;

    private String physicalWarehouseCode;

    private String houseType;

    private Integer shelvesStatus;

    @ExcelColumn(name="库位(例:01-01-01-01)")
    @NotNull
    private String shelves;

    @ExcelColumn(name="混载类型(1单品单批,2多品单批,3无限制)")
    @NotNull
    private Integer mixedType;

    @ExcelColumn(name="关联SKU")
    private String skuCode;

    @ExcelColumn(name="最大保管量")
    @Min(value = 0)
    private Integer maxAmount;

    @ExcelColumn(name="安全库存")
    @Min(value = 0)
    private Integer safeAmount;

    @ExcelColumn(name="可用状态(0可用,1禁用,2冻结)")
    @NotNull
    private Integer shelvesUsableStatus;

    private Date createTime;

    private Long createUserId;


    //self

    @ExcelColumn(name="物理仓(例:01)")
    @NotNull
    private String physicalWarehouseNo;

    @ExcelColumn(name="区域(例:A)")
    @NotNull
    private String houseCode;
    
    @ExcelColumn(name="库位类型(1常规,2拣货,3保管)")
    @NotNull
    private Integer shelvesType;
    
    @ExcelColumn(name="保存类型(1普通常温,2冷藏,3恒温恒湿,4贵品)")
    @NotNull
    private Integer storageType;
    
    @ExcelColumn(name="存放商品状态(0残次,1良品,2样品,3废品)")
    @NotNull
    private Integer skuStatus;

    @ExcelColumn(name="拣货顺序")
    private Integer sortOrder;
    
    


    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getShelvesUsableStatus() {
        return shelvesUsableStatus;
    }

    public String getHouseCode() {
        return houseCode;
    }

    public void setHouseCode(String houseCode) {
        this.houseCode = houseCode;
    }

    public void setShelvesUsableStatus(Integer shelvesUsableStatus) {
        this.shelvesUsableStatus = shelvesUsableStatus;
    }

    public Integer getSafeAmount() {
        return safeAmount;
    }

    public void setSafeAmount(Integer safeAmount) {
        this.safeAmount = safeAmount;
    }

    public Integer getMaxAmount() {
        return maxAmount;
    }

    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getShelvesStatus() {
        return shelvesStatus;
    }

    public void setShelvesStatus(Integer shelvesStatus) {
        this.shelvesStatus = shelvesStatus;
    }

    public Integer getMixedType() {
        return mixedType;
    }

    public void setMixedType(Integer mixedType) {
        this.mixedType = mixedType;
    }

    public String getShelves() {
        return shelves;
    }

    public void setShelves(String shelves) {
        this.shelves = shelves;
    }


    public String getPhysicalWarehouseNo() {
        return physicalWarehouseNo;
    }

    public void setPhysicalWarehouseNo(String physicalWarehouseNo) {
        this.physicalWarehouseNo = physicalWarehouseNo;
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getHouseType() {
        return houseType;
    }

    public void setHouseType(String houseType) {
        this.houseType = houseType;
    }

    public PegasusWarehouseServiceFacade getWhFacade() {
        return whFacade;
    }

    public void setWhFacade(PegasusWarehouseServiceFacade whFacade) {
        this.whFacade = whFacade;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    /**
     * 库位状态
     */
    public static final Integer SHELVES_STATUS_OCCUPY = 1;//库存库位
    public static final Integer SHELVES_STATUS_UNOCCUPY = 0;//空库位

    /**
     * 可用状态
     */
    public static final Integer SHELVES_USABLE_SUATUS_AVAILABLE = 0;//可用
    public static final Integer SHELVES_USABLE_SUATUS_DISABLE = 1;//禁用
    public static final Integer SHELVES_USABLE_SUATUS_FROZEN = 2;//冻结

    /**
     *混载类型
     */
    public static final Integer MIXED_TYPE_SINGLE = 1;//单品单批
    public static final Integer MIXED_TYPE_MULTI = 2;//单品多批
    public static final Integer MIXED_TYPE_UNLIMIT = 3;//单品多批
    
    //库位类型1常规2拣货3保管
    public static final Integer SHELVES_TYPE_NORMAL = 1;
    public static final Integer SHELVES_TYPE_PICKING = 2;
    public static final Integer SHELVES_TYPE_HOLDING = 3;
    
    //1普通常温2冷藏3恒温恒湿4贵品
    public static final Integer STORAGE_TYPE_NORMAL_TEMPERATURE = 1;
    public static final Integer STORAGE_TYPE_COLD_STORAGE = 2;
    public static final Integer STORAGE_TYPE_CONSTANT_TEMPERATURE_HUMIDITY = 3;
    public static final Integer STORAGE_TYPE_VALUABLES = 4;
    
    public String getStorageTypeName() {
    	return getStorageTypeStr(getStorageType());
    }

    public static String getStorageTypeStr(Integer storageType){
        if(STORAGE_TYPE_NORMAL_TEMPERATURE.equals(storageType)){
            return "普通常温";
        }
        if(SHELVES_TYPE_PICKING.equals(storageType)){
            return "冷藏";
        }
        if(SHELVES_TYPE_HOLDING.equals(storageType)){
            return "恒温恒湿";
        }
        if(STORAGE_TYPE_VALUABLES.equals(storageType)){
            return "贵品";
        }
        return "";
    }
    
    public static String getShelvesTypeNameStr(Integer shelvesType){
    	if(SHELVES_TYPE_NORMAL.equals(shelvesType)){
    		return "常规";
    	}
    	if(SHELVES_TYPE_PICKING.equals(shelvesType)){
    		return "拣货";
    	}
    	if(SHELVES_TYPE_HOLDING.equals(shelvesType)){
    		return "保管";
    	}
    	return "";
    }

    public String getShelvesTypeName(){
    	if(SHELVES_TYPE_NORMAL.equals(this.shelvesType)){
    		return "常规";
    	}
    	if(SHELVES_TYPE_PICKING.equals(this.shelvesType)){
    		return "拣货";
    	}
    	if(SHELVES_TYPE_HOLDING.equals(this.shelvesType)){
    		return "保管";
    	}
    	return "";
    }
    
    public String getSkuStatusName(){
        return WhWarehouseVO.getSkuStatusName(this.skuStatus);
    }
    
    
    public static List<Map<String, String>> getAllShelvesTypes() {
    	List<Map<String, String>> types = new ArrayList<>();
       
        Map<String, String> option;
        option = new HashMap<String, String>();
        option.put("text", "常规");
        option.put("value", SHELVES_TYPE_NORMAL.toString());
        types.add(option);
        option = new HashMap<String, String>();
        option.put("text", "拣货");
        option.put("value", SHELVES_TYPE_PICKING.toString());
        types.add(option);
        option = new HashMap<String, String>();
        option.put("text", "保管");
        option.put("value", SHELVES_TYPE_HOLDING.toString());
        types.add(option);
        return types;
    }
    
    public static List<Map<String,String>> getAllShelvesStorageTypes(){
    	List<Map<String, String>> types = new ArrayList<>();
        Map<String, String> option;
        option = new HashMap<String, String>();
        option.put("text", "普通常温");
        option.put("value", STORAGE_TYPE_NORMAL_TEMPERATURE.toString());
        types.add(option);
        option = new HashMap<String, String>();
        option.put("text", "冷藏");
        option.put("value", STORAGE_TYPE_COLD_STORAGE.toString());
        types.add(option);
        option = new HashMap<String, String>();
        option.put("text", "恒温恒湿");
        option.put("value", STORAGE_TYPE_CONSTANT_TEMPERATURE_HUMIDITY.toString());
        types.add(option);
        option = new HashMap<String, String>();
        option.put("text", "贵品");
        option.put("value", STORAGE_TYPE_VALUABLES.toString());
        types.add(option);
        return types;
    }
    

    public String getMixedTypeName() {
        if(mixedType == MIXED_TYPE_SINGLE){
            return "单品单批";
        }else if (mixedType == MIXED_TYPE_MULTI){
            return "单品多批";
        }else if(mixedType == MIXED_TYPE_UNLIMIT){
        	return "无限制";
        }
            return  null;

    }


    /**
     * 可用状态
     * @return
     */
    public String getShelvesUsableStatusName() {
        if(shelvesUsableStatus == SHELVES_USABLE_SUATUS_AVAILABLE){
            return "可用";
        }else if (shelvesUsableStatus == SHELVES_USABLE_SUATUS_DISABLE){
            return "禁用";
        }else if (shelvesUsableStatus == SHELVES_USABLE_SUATUS_FROZEN){
            return "冻结";
        }
            return null;
    }


    /**
     * 库位状态
     * @return
     */
    public String getShelvesStatusName() {
        if (EmptyUtil.isEmpty(shelvesStatus)) {
            return null;
        }else if(shelvesStatus == SHELVES_STATUS_OCCUPY){
            return "库存库位";
        }else if (shelvesStatus == SHELVES_STATUS_UNOCCUPY){
            return "空库位";
        }
            return null;
    }


    /**
     * 区域名
     * @return
     */
    public String getHouseTypeName() {
        if(EmptyUtil.isEmpty(houseCode)){
            houseCode = code.substring(code.indexOf('-')+1,code.indexOf('-')+2);
        }
        if (EmptyUtil.isNotEmpty(houseCode)) {
            WhWmsWarehouseArea house = wmsFacade.findHouseAreaByCode(houseCode);
            if (EmptyUtil.isNotEmpty(house)) {
                return house.getHouseTypeName();
            }
        }
        return null;
    }

    /**
     * 区域str
     * @return
     */
    public String getHouseTypeStr() {
        if (EmptyUtil.isNotEmpty(houseCode)){
            WhWmsWarehouseArea houseArea = wmsFacade.findHouseAreaByCode(houseCode);
            if (EmptyUtil.isNotEmpty(houseArea)) return houseArea.getHouseType();
        }
        return null;
    }

    /**
     * 物理仓
     * @return
     */
    public String getPhysicalWarehouseName(){
        if (EmptyUtil.isNotEmpty(physicalWarehouseCode)) {
            WhPhysicalWarehouse warehouse = whFacade.findPhysicalWarehouseByCode(physicalWarehouseCode);
            if (EmptyUtil.isNotEmpty(warehouse)) {
                return warehouse.getName();
            }
        }
        return null;
    }


    //others
    public static List<KeyValueVO> getAllShelvesStatus(){
        List<KeyValueVO> shelvesStatusList = new ArrayList<KeyValueVO>(){{
            add(new KeyValueVO(WhWmsHouseShelvesVO.SHELVES_STATUS_UNOCCUPY.toString(),"空库位"));
            add(new KeyValueVO(WhWmsHouseShelvesVO.SHELVES_STATUS_OCCUPY.toString(),"库存库位"));
        }};
        return shelvesStatusList;
    }


    public static List<KeyValueVO> getAllShelvesUsableStatus(){
        List<KeyValueVO> shelvesUsableStatusList = new ArrayList<KeyValueVO>(){{
            add(new KeyValueVO(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE.toString(),"可用"));
            add(new KeyValueVO(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_DISABLE.toString(),"禁用"));
            add(new KeyValueVO(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_FROZEN.toString(),"冻结"));
        }};
        return shelvesUsableStatusList;
    }


    public static List<KeyValueVO> getAllMixedType(){
        List<KeyValueVO> mixedTypeList = new ArrayList(){{
            add(new KeyValueVO(WhWmsHouseShelvesVO.MIXED_TYPE_SINGLE.toString(),"单品单批"));
            add(new KeyValueVO(WhWmsHouseShelvesVO.MIXED_TYPE_MULTI.toString(),"多品单批"));
            add(new KeyValueVO(WhWmsHouseShelvesVO.MIXED_TYPE_UNLIMIT.toString(),"无限制"));
        }};
        return  mixedTypeList;
    }

	public Integer getStorageType() {
		return storageType;
	}

	public void setStorageType(Integer storageType) {
		this.storageType = storageType;
	}

	public Integer getSkuStatus() {
		return skuStatus;
	}

	public void setSkuStatus(Integer skuStatus) {
		this.skuStatus = skuStatus;
	}

	public Integer getShelvesType() {
		return shelvesType;
	}

	public void setShelvesType(Integer shelvesType) {
		this.shelvesType = shelvesType;
	}

}
