package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQuality;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualitySku;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.util.*;

/**
 * @author admin
 * @create 2018-04-23 14:57
 */
public class WhWmsGradeOfQualityVO extends WhWmsGradeOfQuality implements Serializable {

    private String sourceGradeStr;

    private String targetGradeStr;

    private String physicalWarehouseName;

    private String createUserName;

    private String submitUserName;

    private String approveStatusStr;

    private List<WhWmsGradeOfQualitySkuVO> gradeSkuVOs;

    private List<WhWmsGradeOfQualityBarcodeVO> gradeBarcodeVOs;

    private List<WhWmsGradeOfQualitySku> gradeSkus;

    private List<String> shelvesCodes;

    private String sourceWarehouseCode;

    private List<WhGradeOfQualityVO> whGradeVOS;

    private boolean autoApproveSuccess;

    // 系统自动通过
    private boolean systemAutoPass = false;

    private Integer defectiveAllQuantity;
    private boolean checkedStock;

    public static final String COMM_LOG_ENTITY_FOR_GRADE = "WhWmsGradeOfQuality";
    // 初始
    public static final int APPROVE_STATUS_INIT = 0;
    // 待审批
    public static final int APPROVE_STATUS_WAIT = 1;
    // 审批中
    public static final int APPROVE_STATUS_APPROVING = 2;
    // 审批完成(部分通过)
    public static final int APPROVE_STATUS_PARTLY_COMPLETED = 3;
    // 审批完成
    public static final int APPROVE_STATUS_COMPLETED = 4;
    // 驳回
    public static final int APPROVE_STATUS_REJECT = -1;
    // 取消
    public static final int APPROVE_STATUS_CANCEL = -2;

    public final static Map<Integer,String> APPROVE_STATUS_MAP = new HashMap(){{
        put(APPROVE_STATUS_INIT,"初始");
        put(APPROVE_STATUS_WAIT,"待审批");
        put(APPROVE_STATUS_APPROVING,"审批中");
        put(APPROVE_STATUS_PARTLY_COMPLETED,"审批完成(部分通过)");
        put(APPROVE_STATUS_COMPLETED,"审批完成");
        put(APPROVE_STATUS_REJECT,"驳回");
        put(APPROVE_STATUS_CANCEL,"取消");
    }};

    public String getSourceGradeStr() {
        if (EmptyUtil.isEmpty(sourceGradeStr)){
           return WhWarehouseVO.getSkuStatusName(this.getSourceGrade());
        }
        return sourceGradeStr;
    }

    public void setSourceGradeStr(String sourceGradeStr) {
        this.sourceGradeStr = sourceGradeStr;
    }

    public String getTargetGradeStr() {
        if (EmptyUtil.isEmpty(targetGradeStr)){
            return WhWarehouseVO.getSkuStatusName(this.getTargetGrade());
        }
        return targetGradeStr;
    }

    public void setTargetGradeStr(String targetGradeStr) {
        this.targetGradeStr = targetGradeStr;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getSubmitUserName() {
        return submitUserName;
    }

    public void setSubmitUserName(String submitUserName) {
        this.submitUserName = submitUserName;
    }

    public String getApproveStatusStr() {
        if (EmptyUtil.isEmpty(approveStatusStr)){
            approveStatusStr = APPROVE_STATUS_MAP.get(this.getApproveStatus());
            return EmptyUtil.isEmpty(approveStatusStr)?"":approveStatusStr;
        }
        return approveStatusStr;
    }

    public void setApproveStatusStr(String approveStatusStr) {
        this.approveStatusStr = approveStatusStr;
    }

    public List<WhWmsGradeOfQualitySkuVO> getGradeSkuVOs() {
        return gradeSkuVOs;
    }

    public void setGradeSkuVOs(List<WhWmsGradeOfQualitySkuVO> gradeSkuVOs) {
        this.gradeSkuVOs = gradeSkuVOs;
    }

    public List<WhWmsGradeOfQualityBarcodeVO> getGradeBarcodeVOs() {
        return gradeBarcodeVOs;
    }

    public void setGradeBarcodeVOs(List<WhWmsGradeOfQualityBarcodeVO> gradeBarcodeVOs) {
        this.gradeBarcodeVOs = gradeBarcodeVOs;
    }

    public List<WhWmsGradeOfQualitySku> getGradeSkus() {
        return gradeSkus;
    }

    public void setGradeSkus(List<WhWmsGradeOfQualitySku> gradeSkus) {
        this.gradeSkus = gradeSkus;
    }

    public List<String> getShelvesCodes() {
        return shelvesCodes;
    }

    public void setShelvesCodes(List<String> shelvesCodes) {
        this.shelvesCodes = shelvesCodes;
    }

    public String getSourceWarehouseCode() {
        return sourceWarehouseCode;
    }

    public void setSourceWarehouseCode(String sourceWarehouseCode) {
        this.sourceWarehouseCode = sourceWarehouseCode;
    }

    public List<WhGradeOfQualityVO> getWhGradeVOS() {
        return whGradeVOS;
    }

    public void setWhGradeVOS(List<WhGradeOfQualityVO> whGradeVOS) {
        this.whGradeVOS = whGradeVOS;
    }

    public boolean isAutoApproveSuccess() {
        return autoApproveSuccess;
    }

    public void setAutoApproveSuccess(boolean autoApproveSuccess) {
        this.autoApproveSuccess = autoApproveSuccess;
    }

    public boolean isSystemAutoPass() {
        return systemAutoPass;
    }

    public void setSystemAutoPass(boolean systemAutoPass) {
        this.systemAutoPass = systemAutoPass;
    }

    public Integer getDefectiveAllQuantity() {
        return defectiveAllQuantity;
    }

    public void setDefectiveAllQuantity(Integer defectiveAllQuantity) {
        this.defectiveAllQuantity = defectiveAllQuantity;
    }

    public boolean isCheckedStock() {
        return checkedStock;
    }

    public void setCheckedStock(boolean checkedStock) {
        this.checkedStock = checkedStock;
    }
}
