package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualityBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualitySku;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author admin
 * @create 2018-04-23 14:59
 */
public class WhWmsGradeOfQualitySkuVO extends WhWmsGradeOfQualitySku implements Serializable {

    private String skuName;

    private List<WhWmsGradeOfQualityBarcode> gradeBarcodes;

    private List<WhWmsGradeOfQualityBarcodeVO> gradeBarcodeVOs;

    private String condShelvesStart;

    private String condShelvesEnd;

    private List<CommFileRef> commFileRefs;

    private WhGradeOfQualityVO whGradeVO;

    private String rejectReason;

    private String adjustTypeStr;

    private String supplierCode;

    // 初始
    public static final int APPROVE_STATUS_INIT = 0;
    // 通过
    public static final int APPROVE_STATUS_PASS = 1;
    // 驳回
    public static final int APPROVE_STATUS_REJECT = -1;
    // 取消
    public static final int APPROVE_STATUS_CANCEL = -2;

    // 品级调整类型
    // 包装问题
    public static final int ADJUST_TYPE_OF_PACKING = 1;
    // 外观工艺问题
    public static final int ADJUST_TYPE_OF_APPEARANCE = 2;
    // 功能问题
    public static final int ADJUST_TYPE_OF_FEATURE = 3;
    // 标签问题
    public static final int ADJUST_TYPE_OF_TAG = 4;
    // 配件缺失
    public static final int ADJUST_TYPE_OF_ACCESSORY = 5;
    // 产品安全性问题
    public static final int ADJUST_TYPE_OF_SECURITY = 6;
    // 保质期问题
    public static final int ADJUST_TYPE_OF_SHELF_LIFE = 7;
    // 其它
    public static final int ADJUST_TYPE_OF_OTHER = 0;

    public final static Map<Integer,String> GRADE_ADJUST_TYPE_MAP = new HashMap(){{
        put(ADJUST_TYPE_OF_PACKING,"包装问题");
        put(ADJUST_TYPE_OF_APPEARANCE,"外观工艺问题");
        put(ADJUST_TYPE_OF_FEATURE,"功能问题");
        put(ADJUST_TYPE_OF_TAG,"标签问题");
        put(ADJUST_TYPE_OF_ACCESSORY,"配件缺失");
        put(ADJUST_TYPE_OF_SECURITY,"产品安全性问题");
        put(ADJUST_TYPE_OF_SHELF_LIFE,"保质期问题");
        put(ADJUST_TYPE_OF_OTHER,"其它");
    }};

    public static List<Integer> getGradeAdjustTypeList(){
        List<Integer> adjustType = new ArrayList(){{
            add(ADJUST_TYPE_OF_PACKING);
            add(ADJUST_TYPE_OF_APPEARANCE);
            add(ADJUST_TYPE_OF_FEATURE);
            add(ADJUST_TYPE_OF_TAG);
            add(ADJUST_TYPE_OF_ACCESSORY);
            add(ADJUST_TYPE_OF_SECURITY);
            add(ADJUST_TYPE_OF_SHELF_LIFE);
            add(ADJUST_TYPE_OF_OTHER);
        }};
        return adjustType;
    }

    public static List<KeyValueVO> getAdjustTypeKeyValueVOs() {
        List<Integer> keyList = getGradeAdjustTypeList();
        List<KeyValueVO> adjustTypeKVs = new ArrayList<>();
        for (Integer key : keyList) {
            String value = GRADE_ADJUST_TYPE_MAP.get(key);
            if (EmptyUtil.isEmpty(value)) continue;
            adjustTypeKVs.add(new KeyValueVO(key.toString(),value));
        }
        return adjustTypeKVs;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public List<WhWmsGradeOfQualityBarcode> getGradeBarcodes() {
        return gradeBarcodes;
    }

    public void setGradeBarcodes(List<WhWmsGradeOfQualityBarcode> gradeBarcodes) {
        this.gradeBarcodes = gradeBarcodes;
    }

    public List<WhWmsGradeOfQualityBarcodeVO> getGradeBarcodeVOs() {
        return gradeBarcodeVOs;
    }

    public void setGradeBarcodeVOs(List<WhWmsGradeOfQualityBarcodeVO> gradeBarcodeVOs) {
        this.gradeBarcodeVOs = gradeBarcodeVOs;
    }

    public String getCondShelvesStart() {
        return condShelvesStart;
    }

    public void setCondShelvesStart(String condShelvesStart) {
        this.condShelvesStart = condShelvesStart;
    }

    public String getCondShelvesEnd() {
        return condShelvesEnd;
    }

    public void setCondShelvesEnd(String condShelvesEnd) {
        this.condShelvesEnd = condShelvesEnd;
    }

    public List<CommFileRef> getCommFileRefs() {
        return commFileRefs;
    }

    public void setCommFileRefs(List<CommFileRef> commFileRefs) {
        this.commFileRefs = commFileRefs;
    }

    public WhGradeOfQualityVO getWhGradeVO() {
        return whGradeVO;
    }

    public void setWhGradeVO(WhGradeOfQualityVO whGradeVO) {
        this.whGradeVO = whGradeVO;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public String getAdjustTypeStr() {
        if (EmptyUtil.isEmpty(adjustTypeStr)){
            return GRADE_ADJUST_TYPE_MAP.get(this.getAdjustType());
        }
        return adjustTypeStr;
    }

    public void setAdjustTypeStr(String adjustTypeStr) {
        this.adjustTypeStr = adjustTypeStr;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
}
