package com.thebeastshop.pegasus.service.warehouse.vo;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.thebeastshop.pegasus.util.comm.NullUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2017/9/8.
 */
public class WhWmsConnectStartResultVO {

    private List<WhCommandPickStockInfoVO> failureList = new ArrayList<>();

    @JsonIgnore
    private List<WhWmsConnectInfoVO> startConnectInfoList = new ArrayList<>();

    private List<String> failureCommandCodes = new ArrayList<>();

    private Integer needAmount;

    private Integer planedAmount;

    private Integer startedAmount = 0;

    private Integer skuStatus;

    private Long operaterId;

    private boolean autoDistribute;

    public boolean isEnough(){
        return needAmount<=0;
    }

    public static WhWmsConnectStartResultVO newInstance(){
        return new WhWmsConnectStartResultVO();
    }

    public List<WhCommandPickStockInfoVO> getFailureList() {
        return failureList;
    }

    public Integer getNeedAmount() {
        return needAmount;
    }

    public void setNeedAmount(Integer needAmount) {
        this.needAmount = needAmount;
    }

    public WhWmsConnectStartResultVO needAmountAuotDec(){
        this.needAmount = this.needAmount - 1;
        return this;
    }

    public WhWmsConnectStartResultVO startedAmountAuotInc(){
        this.startedAmount = this.startedAmount + 1;
        return this;
    }

    public WhWmsConnectStartResultVO addFailure(List<WhCommandPickStockInfoVO> failureList){
        this.failureList.addAll(failureList);
        return this;
    }

    public WhWmsConnectStartResultVO addFailure(WhCommandPickStockInfoVO failure){
        this.failureList.add(failure);
        return this;
    }

    public List<String> getFailureCommandCodes() {
        return failureCommandCodes;
    }

    private WhWmsConnectStartResultVO addFailureCommandCode(String commandCode){
        failureCommandCodes.add(commandCode);
        return this;
    }

    public Long getOperaterId() {
        return operaterId;
    }

    public void setOperaterId(Long operaterId) {
        this.operaterId = operaterId;
    }

    public Integer getSkuStatus() {
        return skuStatus;
    }

    public void setSkuStatus(Integer skuStatus) {
        this.skuStatus = skuStatus;
    }

    public List<WhWmsConnectInfoVO> getStartConnectInfoList() {
        return startConnectInfoList;
    }

    public WhWmsConnectStartResultVO addStartConnectInfo(WhWmsConnectInfoVO connectInfo){
        startConnectInfoList.add(connectInfo);
        return this;
    }

    public Integer getPlanedAmount() {
        return planedAmount;
    }

    public void setPlanedAmount(Integer planedAmount) {
        this.planedAmount = planedAmount;
    }

    public Integer getStartedAmount() {
        return startedAmount;
    }

    public void setStartedAmount(Integer startedAmount) {
        this.startedAmount = startedAmount;
    }

    public boolean isAutoDistribute() {
        return autoDistribute;
    }

    public void setAutoDistribute(boolean autoDistribute) {
        this.autoDistribute = autoDistribute;
    }
}
