package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/9/14.
 */
public class WhWmsConnectStartConditionsVO {

    private WhWmsConnectStartInOutConditionVO inOutCondition;

    private List<WhWmsConnectStartChannelConditionVO> channelConditions;

    private WhWmsConnectStartShelvesAreaConditionVO shelvesAreaCondition;

    private List<WhWmsConnectStartExpressConditionVO> expressConditions;

    private List<WhWmsConnectStartActiveConditionVO> activeConditions;

    private boolean autoDistribute = true;

    private Date planedDeliveryDate;

    private List<Integer> skuStatusList;

    private Map<String,String> channelGroupMap;

    private Map<Long,String> expressGroupMap;

    public Map<String,String> getChannelGroupMap(){
        if(channelGroupMap == null){
            channelGroupMap = new HashMap<>();
            if(EmptyUtil.isNotEmpty(channelConditions)){
                for(WhWmsConnectStartChannelConditionVO condition : channelConditions){
                    for(String channelCode : condition.getChannelCodes()){
                        channelGroupMap.put(channelCode,condition.getCode());
                    }
                }
            }
        }
        return channelGroupMap;
    }

    public Map<Long,String> getExpressGroupMap(){
        if(expressGroupMap == null){
            expressGroupMap = new HashMap<>();
            if(EmptyUtil.isNotEmpty(expressConditions)){
                for(WhWmsConnectStartExpressConditionVO condition : expressConditions){
                    for(Long expressType : condition.getExpressList()){
                        expressGroupMap.put(expressType,condition.getCode());
                    }
                }
            }
        }
        return expressGroupMap;
    }

    public WhWmsConnectStartInOutConditionVO getInOutCondition() {
        return inOutCondition;
    }

    public void setInOutCondition(WhWmsConnectStartInOutConditionVO inOutCondition) {
        this.inOutCondition = inOutCondition;
    }

    public List<WhWmsConnectStartChannelConditionVO> getChannelConditions() {
        return channelConditions;
    }

    public void setChannelConditions(List<WhWmsConnectStartChannelConditionVO> channelConditions) {
        this.channelConditions = channelConditions;
    }

    public WhWmsConnectStartShelvesAreaConditionVO getShelvesAreaCondition() {
        return shelvesAreaCondition;
    }

    public void setShelvesAreaCondition(WhWmsConnectStartShelvesAreaConditionVO shelvesAreaCondition) {
        this.shelvesAreaCondition = shelvesAreaCondition;
    }

    public List<WhWmsConnectStartExpressConditionVO> getExpressConditions() {
        return expressConditions;
    }

    public void setExpressConditions(List<WhWmsConnectStartExpressConditionVO> expressConditions) {
        this.expressConditions = expressConditions;
    }

    public List<WhWmsConnectStartActiveConditionVO> getActiveConditions() {
        return activeConditions;
    }

    public void setActiveConditions(List<WhWmsConnectStartActiveConditionVO> activeConditions) {
        this.activeConditions = activeConditions;
    }

    public List<Integer> getSkuStatusList() {
        return skuStatusList;
    }

    public void setSkuStatusList(List<Integer> skuStatusList) {
        this.skuStatusList = skuStatusList;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public boolean isAutoDistribute() {
        return autoDistribute;
    }

    public void setAutoDistribute(boolean autoDistribute) {
        this.autoDistribute = autoDistribute;
    }
}
