/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectPickSku;

import java.io.Serializable;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectPickSkuVO.java, v 0.1 2016-03-25 下午5:45
 */
public class WhWmsConnectPickSkuVO extends WhWmsConnectPickSku implements Serializable {

    final public static Integer STATUS_CANCELED = -1;

    final public static Integer STATUS_PENDING = 0;

    final public static Integer STATUS_FINISH = 1;

    private String skuName;

    private String houseType;

    private Integer packedQuantity;//已装箱数

    private boolean needCheckBarcode = false;//是否需要校验批次

    private String supplierSkuBarcode;//供应商条码

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    //manual generate
    public String getSkuStatusName(){
        return WhWarehouseVO.getSkuStatusName(getSkuStatus());
    }

    public String getStatusStr(){
        return getSkuStatus() == null?"":
                STATUS_CANCELED.equals(getStatus())?"已取消":
                STATUS_PENDING.equals(getStatus())?"待拣货":
                        STATUS_FINISH.equals(getStatus())?"已完成":"";
    }

    public String getHouseType() {
        return houseType;
    }

    public void setHouseType(String houseType) {
        this.houseType = houseType;
    }

    public boolean isNeedCheckBarcode() {
        return needCheckBarcode;
    }

    public void setNeedCheckBarcode(boolean needCheckBarcode) {
        this.needCheckBarcode = needCheckBarcode;
    }

    public String getSupplierSkuBarcode() {
        return supplierSkuBarcode;
    }

    public void setSupplierSkuBarcode(String supplierSkuBarcode) {
        this.supplierSkuBarcode = supplierSkuBarcode;
    }

    public Integer getPackedQuantity() {
		return packedQuantity;
	}

	public void setPackedQuantity(Integer packedQuantity) {
		this.packedQuantity = packedQuantity;
	}
}
