/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.vo;


import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectTurnoverBox;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectInfoVO.java, v 0.1 2016-03-16 下午4:42
 */
public class WhWmsConnectInfoVO extends WhWmsConnectInfo implements Serializable {

    /**
     * 操作人
     */
    private String connectUser;

    /**
     * skuCode
     */
    private String skuCode;

    /**
     * 仓库指令
     */
    private List<String> whCommandsCodes = new ArrayList<>();

    /**
     * 仓库指令实体
     */
    private List<WhCommand> whCommands = new ArrayList<>();

    /**
     * 仓库指令与波次
     */
    private List<WhWmsCommandConnectVO> whWmsCommandConnectVOs = new ArrayList<>();

    /**
     * 仓库指令与波次数
     */
    private Integer cmdConnectCount;

    /**
     * 拣货任务
     */
    private List<WhWmsConnectPickSkuVO> whWmsConnectPickSkuVOs;

    /**
     * 失败没有库存的指令code
     */
    private List<String> failureShortageCommandCodes = new ArrayList<>();

    /**
     * 拣货周转箱列表
     */
    private List<WhWmsConnectTurnoverBox> boxes = new ArrayList<>();
    
    private String channelName;
    
    private String purchaseReturnCode;//采退单号

    /**
     * 拣货打打印次数
     * */
    private Integer printPickSkuCount;

    private String tarPhysicalWarehouseName;

    private String assignOperatorName;

    private String channelOrTarPhyWhName;

    private String shelvesRuleName;

    private Integer channelType;

    private Boolean focusCreate;

    private String turnoverBoxNo;

    // 组合：需组装
    private String combinedStr;

    private boolean assembleFlag;
    private String assembleStr;

    // 当前cmd是否包含组装商品
    private Map<String,Boolean> cmdCombinedMap;

    //manual
    public String getConnectTypeName(){
        return getConnectTypeName(getConnectType());
    }
    public String getConnectStatusName(){
        return getConnectStatusStr(getConnectStatus());
    }

    public static String getConnectTypeName(String connectType){
        return connectType==null||connectType.equals("")?"":
                connectType.equals(WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE)?"单品单件":
                        connectType.equals(WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE)?"多品单件":
                                connectType.equals(WMSConstants.ConnectType.MULTI_PIECE_ACTIVITY)?"多件活动":
                                        connectType.equals(WMSConstants.ConnectType.BULK_ORDER)?"大宗订单":
                                                connectType.equals(WMSConstants.ConnectType.LARGE_SIZED_PACKAGE)?"大件包裹":
                                                connectType.equals(WMSConstants.ConnectType.RECEIVE_WASTE)?"报废出库":
                                                connectType.equals(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE)?"多品多件":"";
    }

    public String getDistributeStatusName(){
        return NullUtil.isNotNull(getDistributeStatus()) && PegasusConstants.YES == getDistributeStatus()?"已分发":"待分发";
    }

    public String getConnectDateStr(){
    	if(this.getConnectDate() == null){
    		return "";
    	}
    	return DateUtil.format(this.getConnectDate(), DateUtil.DEFAULT_DATETIME_FORMAT);
    }

    public String getChannelOrTarPhyWhName() {
        return channelOrTarPhyWhName;
    }

    public void setChannelOrTarPhyWhName(String channelOrTarPhyWhName) {
        this.channelOrTarPhyWhName = channelOrTarPhyWhName;
    }

    public String getShelvesRuleName() {
        return shelvesRuleName;
    }

    public void setShelvesRuleName(String shelvesRuleName) {
        this.shelvesRuleName = shelvesRuleName;
    }

    public Integer getChannelType() {
        return channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public String getInOutTypeStr(){
    	return WhCommand.getInOutTypeName(getInOutType());
    }
    //auto
    public String getConnectUser() {
        return connectUser;
    }

    public void setConnectUser(String connectUser) {
        this.connectUser = connectUser;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public List<String> getWhCommandsCodes() {
        return whCommandsCodes;
    }

    public void setWhCommandsCodes(List<String> whCommandsCodes) {
        this.whCommandsCodes = whCommandsCodes;
    }

    public List<WhCommand> getWhCommands() {
        return whCommands;
    }

    public void setWhCommands(List<WhCommand> whCommands) {
        this.whCommands = whCommands;
    }

    public List<WhWmsCommandConnectVO> getWhWmsCommandConnectVOs() {
        return whWmsCommandConnectVOs;
    }

    public void setWhWmsCommandConnectVOs(List<WhWmsCommandConnectVO> whWmsCommandConnectVOs) {
        this.whWmsCommandConnectVOs = whWmsCommandConnectVOs;
    }

    public Integer getCmdConnectCount() {
        return cmdConnectCount;
    }

    public void setCmdConnectCount(Integer cmdConnectCount) {
        this.cmdConnectCount = cmdConnectCount;
    }

    public List<WhWmsConnectPickSkuVO> getWhWmsConnectPickSkuVOs() {
        return whWmsConnectPickSkuVOs;
    }

    public void setWhWmsConnectPickSkuVOs(List<WhWmsConnectPickSkuVO> whWmsConnectPickSkuVOs) {
        this.whWmsConnectPickSkuVOs = whWmsConnectPickSkuVOs;
    }

    public List<String> getFailureShortageCommandCodes() {
        return failureShortageCommandCodes;
    }

    public void setFailureShortageCommandCodes(List<String> failureShortageCommandCodes) {
        this.failureShortageCommandCodes = failureShortageCommandCodes;
    }

    public List<WhWmsConnectTurnoverBox> getBoxes() {
        return boxes;
    }

    public void setBoxes(List<WhWmsConnectTurnoverBox> boxes) {
        this.boxes = boxes;
    }
	public String getChannelName() {
		return channelName;
	}
	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}
	public Integer getPrintPickSkuCount() {
		return printPickSkuCount;
	}
	public void setPrintPickSkuCount(Integer printPickSkuCount) {
		this.printPickSkuCount = printPickSkuCount;
	}
	public String getTarPhysicalWarehouseName() {
		return tarPhysicalWarehouseName;
	}
	public void setTarPhysicalWarehouseName(String tarPhysicalWarehouseName) {
		this.tarPhysicalWarehouseName = tarPhysicalWarehouseName;
	}

	public String getSkuStatusStr(){
		return WhCommand.getSkuStatusName(getSkuStatus());
	}
	public String getPurchaseReturnCode() {
		return purchaseReturnCode;
	}
	public void setPurchaseReturnCode(String purchaseReturnCode) {
		this.purchaseReturnCode = purchaseReturnCode;
	}

    public String getAssignOperatorName() {
        return assignOperatorName;
    }

    public void setAssignOperatorName(String assignOperatorName) {
        this.assignOperatorName = assignOperatorName;
    }

    public static String getConnectStatusStr(Integer status){
        return status==null?"":
                status.equals(WMSConstants.ConnectStatus.WAITING_PROCESS)?"待拣货":
                        status.equals(WMSConstants.ConnectStatus.PROCESSING)?"拣货中":
                                status.equals(WMSConstants.ConnectStatus.DISTRIBUTION)?"分拨中":
                                        status.equals(WMSConstants.ConnectStatus.FINISHED)?"已完成":
                                                status.equals(WMSConstants.ConnectStatus.CANCELED)?"已取消":
                                                status.equals(WMSConstants.ConnectStatus.WAITING_PACK)?"待打包":"";
    }

    public boolean isFocusCreate() {
        return focusCreate==null?false:focusCreate;
    }

    public String getTurnoverBoxNo() {
        return turnoverBoxNo;
    }

    public void setTurnoverBoxNo(String turnoverBoxNo) {
        this.turnoverBoxNo = turnoverBoxNo;
    }

    public void setFocusCreate(boolean focusCreate) {
        this.focusCreate = focusCreate;
    }

    public String getCombinedStr() {
        return combinedStr;
    }

    public void setCombinedStr(String combinedStr) {
        this.combinedStr = combinedStr;
    }

    public Map<String, Boolean> getCmdCombinedMap() {
        return cmdCombinedMap;
    }

    public void setCmdCombinedMap(Map<String, Boolean> cmdCombinedMap) {
        this.cmdCombinedMap = cmdCombinedMap;
    }

    public boolean isAssembleFlag() {
        return assembleFlag;
    }

    public void setAssembleFlag(boolean assembleFlag) {
        this.assembleFlag = assembleFlag;
    }

    public String getAssembleStr() {
        return assembleStr;
    }

    public void setAssembleStr(String assembleStr) {
        this.assembleStr = assembleStr;
    }
}
