package com.thebeastshop.pegasus.service.warehouse.vo;

import java.util.Date;
import java.util.List;

import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectAllotPackage;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsExpressInfo;
import com.thebeastshop.pegasus.util.comm.DateUtil;

public class WhWmsConnectAllotPackageVO extends WhWmsConnectAllotPackage{
	
	public final static String ENTITY_LOG_CODE = "AltPackage";

	public final static Integer STATUS_WAITING_RECEIVE = 1;

	public final static Integer STATUS_RECEIVED = 2;
	
	private boolean isFocusFinish = false;
	
	private boolean isConnectAltDone = false;

	private boolean isCustomizationAlt = false;

	private List<WhWmsConnectAllotPackageDetailVO> details;

	private String operatorName;
	
	private String targetPhyWarehouseName;
	
	private String sourcePhyWarehouseName;

	private String expressTypeName;

    private String srcCityName;

    private String tarCityName;

    private String tarAddress;

    private Integer boxs;

    private Integer connectStatus;

    // 调拨类型
    private Integer allotType;

    // 调拨单号
    private String allotCode;

    // 调拨备注
    private String allotRemark;

	private Date minEstimatedAllocationDate; //最小调拨单预计时间

	private Long sourceAltPackageId;//

	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public List<WhWmsConnectAllotPackageDetailVO> getDetails() {
		return details;
	}

	public void setDetails(List<WhWmsConnectAllotPackageDetailVO> details) {
		this.details = details;
	}
	
	public String getPackageTimeStr(){
		return DateUtil.format(this.getPackageTime(), DateUtil.DEFAULT_DATETIME_FORMAT);
	}

	public boolean isConnectAltDone() {
		return isConnectAltDone;
	}

	public void setConnectAltDone(boolean isConnectAltDone) {
		this.isConnectAltDone = isConnectAltDone;
	}
	
	public boolean isFocusFinish() {
		return isFocusFinish;
	}

	public void setFocusFinish(boolean isFocusFinish) {
		this.isFocusFinish = isFocusFinish;
	}

	public String getTargetPhyWarehouseName() {
		return targetPhyWarehouseName;
	}

	public void setTargetPhyWarehouseName(String targetPhyWarehouseName) {
		this.targetPhyWarehouseName = targetPhyWarehouseName;
	}

	public String getExpressTypeName() {
		if(expressTypeName != null && !"".equals(expressTypeName)){
			return expressTypeName;
		}
		if(getExpressType() != null){
			WhWmsExpressInfo whWmsExpressInfo = PegasusWarehouseServiceFacade.getInstance().findExpressInfoById(Long.parseLong(getExpressType().toString()));
			if(whWmsExpressInfo != null){
				return  whWmsExpressInfo.getName();
			}
		}
		return "";
	}

	public String getStatusName(){
	    return getStatusName(getStatus());
    }

	public static String getStatusName(Integer status){
	    return STATUS_WAITING_RECEIVE.equals(status)?"待收货":
                STATUS_RECEIVED.equals(status)?"收货完成":"";
    }

	public void setExpressTypeName(String expressTypeName) {
		this.expressTypeName = expressTypeName;
	}

	public String getExpressTypeStr(){
		if(getExpressType() != null){
			WhWmsExpressInfo whWmsExpressInfo = PegasusWarehouseServiceFacade.getInstance().findExpressInfoById(Long.parseLong(getExpressType().toString()));
			if(whWmsExpressInfo != null){
				return whWmsExpressInfo.getName();
			}
		}
		return "";
	}

	public String getSourcePhyWarehouseName() {
		return sourcePhyWarehouseName;
	}

	public void setSourcePhyWarehouseName(String sourcePhyWarehouseName) {
		this.sourcePhyWarehouseName = sourcePhyWarehouseName;
	}


    public String getSrcCityName() {
        return srcCityName;
    }

    public void setSrcCityName(String srcCityName) {
        this.srcCityName = srcCityName;
    }

    public String getTarCityName() {
        return tarCityName;
    }

    public void setTarCityName(String tarCityName) {
        this.tarCityName = tarCityName;
    }

    public String getTarAddress() {
        return tarAddress;
    }

    public void setTarAddress(String tarAddress) {
        this.tarAddress = tarAddress;
    }

    public Integer getBoxs() {
        return boxs;
    }

    public void setBoxs(Integer boxs) {
        this.boxs = boxs;
    }

    public Integer getConnectStatus() {
        return connectStatus;
    }

    public void setConnectStatus(Integer connectStatus) {
        this.connectStatus = connectStatus;
    }

    public Integer getAllotType() {
        return allotType;
    }

    public void setAllotType(Integer allotType) {
        this.allotType = allotType;
    }

	public boolean isCustomizationAlt() {
		return isCustomizationAlt;
	}

	public void setCustomizationAlt(boolean customizationAlt) {
		isCustomizationAlt = customizationAlt;
	}

	public Date getMinEstimatedAllocationDate() {
		return minEstimatedAllocationDate;
	}

	public void setMinEstimatedAllocationDate(Date minEstimatedAllocationDate) {
		this.minEstimatedAllocationDate = minEstimatedAllocationDate;
	}

	public String getAllotCode() {
        return allotCode;
    }

    public void setAllotCode(String allotCode) {
        this.allotCode = allotCode;
    }

    public String getAllotRemark() {
        return allotRemark;
    }

    public void setAllotRemark(String allotRemark) {
        this.allotRemark = allotRemark;
    }

    public Long getSourceAltPackageId() {
		return sourceAltPackageId;
	}

	public void setSourceAltPackageId(Long sourceAltPackageId) {
		this.sourceAltPackageId = sourceAltPackageId;
	}
}
