package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/12/5.
 */
public class WhWarehouseVO extends WhWarehouse {

    final public static Integer RELATE_IN = 1;//入

    final public static Integer RELATE_OUT = 2;//出

    final public static Integer WAREHOUSE_STATUS_CAN_USE = 1;//可用

    final public static Integer WAREHOUSE_STATUS_DISABLED = 0;//禁用

    private Integer relateInOrOut;//出、入

    private Integer relateInOutSkuStatus;

    // 逻辑仓分组类型 0非仓库 1仓库
    private Integer warehouseGroupType;

    final public static String WAREHOUSE_WH020600010096 = "WH020600010096";//颛兴路 - 良品待分配仓
    final public static String WAREHOUSE_MILD_DAMAGED= "WH020600010097";//颛兴路 - 轻残次品仓

    final public static String WAREHOUSE_MODERATE_DEFECTIVE= "WH020600010097";//颛兴路 - 中残品仓  待定
    // 从字典配置获取
    public static final String WAREHOUSE_MODERATE_DEFECTIVE_CONFIG = "zxl.warehouseModerateDefectiveCode";

    final public static String WAREHOUSE_SEVERE_DEFECTIVE= "WH020600010097";//颛兴路 - 重残品仓    待定
    // 从字典配置获取
    public static final String WAREHOUSE_SEVERE_DEFECTIVE_CONFIG = "zxl.warehouseSevereDefectiveCode";

    final public static String WAREHOUSE_WH020600010098= "WH020600010098";//颛兴路 - 废品仓
    final public static String WAREHOUSE_WH020600010101= "WH020600010101";//颛兴路 - 样品仓
    // 颛兴路 陈列品仓 从字典配置获取
    public static final String WAREHOUSE_DISPLAY_CONFIG = "zxl.warehouseDisplayCode";

    final public static String WAREHOUSE_WH020600010102= "WH020600010102";//颛兴路 - 官网渠道销售仓

    final public static String WAREHOUSE_WH020600010120= "WH020600010120";//颛兴路 - 线下渠道销售总仓

    final public static String WAREHOUSE_WH02060036= "WH02060036";// 差异物理仓

    public Integer getRelateInOutSkuStatus() {
        return relateInOutSkuStatus;
    }

    public void setRelateInOutSkuStatus(Integer relateInOutSkuStatus) {
        this.relateInOutSkuStatus = relateInOutSkuStatus;
    }

    public Integer getRelateInOrOut() {
        return relateInOrOut;
    }

    public void setRelateInOrOut(Integer relateInOrOut) {
        this.relateInOrOut = relateInOrOut;
    }

    public Integer getWarehouseGroupType() {
        return warehouseGroupType;
    }

    public void setWarehouseGroupType(Integer warehouseGroupType) {
        this.warehouseGroupType = warehouseGroupType;
    }

    // self
    /**
     * 逻辑仓类型
     * 1.良品待分配仓 2.残次品仓 3.废品仓 4.礼品仓 5.样品仓 6.生产加工仓 ,7道具仓，9.渠道销售仓
     */
    public static final Integer TYPE_WAIT_FOR_DISPATCHING = 1;
    public static final Integer TYPE_DAMAGED              = 2;
    public static final Integer TYPE_WASTED               = 3;
    public static final Integer TYPE_GIFT                 = 4;
    public static final Integer TYPE_SAMPLE               = 5;
    public static final Integer TYPE_PRODUCING            = 6;
    public static final Integer TYPE_PROP                 = 7;
    public static final Integer TYPE_CHANNEL_SALES        = 9;

    /**
     * 商品状态
     * 0.轻残 1.良品 2.样品 3.废品 4中残 5重残 6陈列品 7道具 8待定
     */
    // 所有残次
    public static final Integer COMMODITY_STATUS_FOR_ALL_DAMAGED = 20;
    // 轻残
    public static final Integer COMMODITY_STATUS_FOR_MILD_DAMAGED = 0;
    // 中残
    public static final Integer COMMODITY_STATUS_FOR_MODERATE_DAMAGED = 4;
    // 重残
    public static final Integer COMMODITY_STATUS_FOR_SEVERE_DAMAGED = 5;

    // 所有良品
    public static final Integer COMMODITY_STATUS_FOR_ALL_NONDEFECTIVE = 21;
    // 良品
    public static final Integer COMMODITY_STATUS_FOR_NONDEFECTIVE = 1;

    // 所有样品
    public static final Integer COMMODITY_STATUS_FOR_ALL_SAMPLE = 22;
    // 样品
    public static final Integer COMMODITY_STATUS_FOR_SAMPLE = 2;
    // 陈列品
    public static final Integer COMMODITY_STATUS_FOR_DISPLAY = 6;

    //道具
    public static final Integer COMMODITY_STATUS_FOR_PROP = 7;

    // 所有废品
    public static final Integer COMMODITY_STATUS_FOR_ALL_WASTED = 23;
    // 废品
    public static final Integer COMMODITY_STATUS_FOR_WASTED = 3;

    // 待定
    public static final Integer COMMODITY_STATUS_FOR_HOLD_PENDING = 8;


    public final static Map<Integer,String> WAREHOUSE_TYPE_MAP=new HashMap(){{
        put(TYPE_WAIT_FOR_DISPATCHING,"良品待分配仓");
        put(TYPE_DAMAGED,"残次品仓");
        put(TYPE_WASTED,"废品仓");
        put(TYPE_GIFT,"礼品仓");
        put(TYPE_SAMPLE,"样品仓");
        put(TYPE_PRODUCING,"生产加工仓");
        put(TYPE_CHANNEL_SALES,"渠道销售仓");
        put(TYPE_PROP,"道具仓");
    }};

    public final static Map<Integer,String> COMMODITY_STATUS_DETAIL_MAP = new HashMap(){{
        put(COMMODITY_STATUS_FOR_NONDEFECTIVE,"良品");
        put(COMMODITY_STATUS_FOR_SAMPLE,"样品");
        put(COMMODITY_STATUS_FOR_DISPLAY,"陈列品");
        put(COMMODITY_STATUS_FOR_MILD_DAMAGED,"轻残品");
        put(COMMODITY_STATUS_FOR_MODERATE_DAMAGED,"中残品");
        put(COMMODITY_STATUS_FOR_SEVERE_DAMAGED,"重残品");
        put(COMMODITY_STATUS_FOR_WASTED,"废品");
        put(COMMODITY_STATUS_FOR_PROP,"资产（工程部专用）");
        put(COMMODITY_STATUS_FOR_HOLD_PENDING,"待定");
    }};

    //非残次商品状态 map
    public final static Map<Integer,String> NOT_DEFECTIVE_COMMODITY_STATUS_DETAIL_MAP = new HashMap(){{
      put(COMMODITY_STATUS_FOR_NONDEFECTIVE,"良品");
      put(COMMODITY_STATUS_FOR_SAMPLE,"样品");
      put(COMMODITY_STATUS_FOR_DISPLAY,"陈列品");
      put(COMMODITY_STATUS_FOR_WASTED,"废品");
      put(COMMODITY_STATUS_FOR_PROP,"资产（工程部专用）");
      put(COMMODITY_STATUS_FOR_HOLD_PENDING,"待定");
    }};

    public static List<Integer> getSkuStatusList(){
        List<Integer> skuStatus = new ArrayList(){{
            add(COMMODITY_STATUS_FOR_NONDEFECTIVE);
            add(COMMODITY_STATUS_FOR_SAMPLE);
            add(COMMODITY_STATUS_FOR_DISPLAY);
            add(COMMODITY_STATUS_FOR_MILD_DAMAGED);
            add(COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
            add(COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
            add(COMMODITY_STATUS_FOR_WASTED);
            add(COMMODITY_STATUS_FOR_PROP);
            add(COMMODITY_STATUS_FOR_HOLD_PENDING);
        }};
        return skuStatus;
    }

    // 商品状态 二级分层的时候用到
    public static List<Integer> getChildCommodityStatusByParentId(Integer parentId){
        List<Integer> skuStatus = new ArrayList<>();
        if (COMMODITY_STATUS_FOR_ALL_NONDEFECTIVE.equals(parentId)){
            skuStatus.add(COMMODITY_STATUS_FOR_NONDEFECTIVE);
        }else if(COMMODITY_STATUS_FOR_ALL_DAMAGED.equals(parentId)){
            skuStatus.add(COMMODITY_STATUS_FOR_MILD_DAMAGED);
            skuStatus.add(COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
            skuStatus.add(COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
        }else if(COMMODITY_STATUS_FOR_ALL_SAMPLE.equals(parentId)){
            skuStatus.add(COMMODITY_STATUS_FOR_SAMPLE);
            skuStatus.add(COMMODITY_STATUS_FOR_DISPLAY);
        }else if(COMMODITY_STATUS_FOR_ALL_WASTED.equals(parentId)){
            skuStatus.add(COMMODITY_STATUS_FOR_WASTED);
        }
        return skuStatus;
    }

    public static List<KeyValueVO> getCommodityStatusKeyValueVOs() {
        List<Integer> keyList = getSkuStatusList();
        List<KeyValueVO> commodityStatusKVs = new ArrayList<>();
        for (Integer key : keyList) {
            String value = COMMODITY_STATUS_DETAIL_MAP.get(key);
            if (EmptyUtil.isEmpty(value)) continue;
            commodityStatusKVs.add(new KeyValueVO(key.toString(),value));
        }
        return commodityStatusKVs;
    }

    public static List<KeyValueVO> getCommodityStatusKeyValueVOsByDic(List<CommDictionary> commDictionaries) {
        List<KeyValueVO> commodityStatusKVs = new ArrayList();
        if (CollectionUtils.isEmpty(commDictionaries)){
            return commodityStatusKVs;
        }
        for (CommDictionary commDic : commDictionaries) {
            commodityStatusKVs.add(new KeyValueVO(commDic.getDictValue(),commDic.getDictName()));
        }
        return commodityStatusKVs;
    }

    public final static Map<Integer,String> RELATE_MAP=new HashMap(){{
        put(RELATE_IN,"入");
        put(RELATE_OUT,"出");
    }};

    public static Integer convertSkuStatusByCommodityStatus(Integer commodityStatus){
        return commodityStatus;
    }

    public static String getSkuStatusName(Integer skuStatus){
        if (EmptyUtil.isEmpty(skuStatus)){
            return "";
        }
        String skuStatusName = COMMODITY_STATUS_DETAIL_MAP.get(skuStatus);
        return EmptyUtil.isEmpty(skuStatusName)?"":skuStatusName;
    }

    // 判断是否为残次品
    public static boolean isDamagedCommodity(Integer skuStatus){
        if (EmptyUtil.isEmpty(skuStatus)){
            return false;
        }
        if (COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(skuStatus)
                || COMMODITY_STATUS_FOR_MODERATE_DAMAGED.equals(skuStatus)
                || COMMODITY_STATUS_FOR_SEVERE_DAMAGED.equals(skuStatus)
                || COMMODITY_STATUS_FOR_ALL_DAMAGED.equals(skuStatus)){
            return true;
        }
        return false;
    }

    /**
     *
     * 获取物流差异逻辑仓[WH020600360218:物流差异-良品仓] [WH020600360219:物流差异-残次仓] [WH020600360220:物流差异-样品仓]
     * @param commodityStatus [0.轻度残次 1.良品 2.样品 3.废品]
     * @return 默认返回 [WH020600360218:物流差异-良品仓]
     */
    public static String fetchDiffWarehouseByCommodityStatus(Integer commodityStatus){
        return WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(commodityStatus)? "WH020600360218":
                    WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(commodityStatus)?"WH020600360219":
                        WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(commodityStatus)?"WH020600360220":"WH020600360218";
    }
}
