/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.util.comm.NullUtil;

/**
 * @author Royan
 * @version $Id: ScmWarehouseSkuInvVO.java, v 0.1 2015-08-10 下午6:17
 */
public class WhWarehouseSkuInvVO {

    private String warehouseCode;

    private String warehouseName;

    private String skuCode;

    private String skuName;

    private int    quantityInRcd;

    private int    quantityInOccupy;

    private int    quantityWillIn;

    private PhyWhStockVO phyWhStockVO;

    private String physicalWarehouseName;

    private Integer minCanUseInv;

    private String supplierSkuBarcode;

    private int quantityAllotWillIn; //调拨在途数量

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public int getQuantityInRcd() {
        return quantityInRcd;
    }

    public void setQuantityInRcd(int quantityInRcd) {
        this.quantityInRcd = quantityInRcd;
    }

    public int getQuantityInOccupy() {
        return quantityInOccupy;
    }

    public void setQuantityInOccupy(int quantityInOccupy) {
        this.quantityInOccupy = quantityInOccupy;
    }

    public int getCanUseInv() {
        return quantityInRcd - quantityInOccupy;
    }

    public int getQuantityWillIn() {
        return quantityWillIn;
    }

    public void setQuantityWillIn(int quantityWillIn) {
        this.quantityWillIn = quantityWillIn;
    }

    public PhyWhStockVO getPhyWhStockVO() {
        return phyWhStockVO;
    }

    public void setPhyWhStockVO(PhyWhStockVO phyWhStockVO) {
        this.phyWhStockVO = phyWhStockVO;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getSupplierSkuBarcode() {
        return supplierSkuBarcode;
    }

    public void setSupplierSkuBarcode(String supplierSkuBarcode) {
        this.supplierSkuBarcode = supplierSkuBarcode;
    }

    public Integer getMinCanUseInv() {
        if (NullUtil.isNull(getPhyWhStockVO())){
            return 0;
        }
        return Math.min(getCanUseInv(),getPhyWhStockVO().getCanUseQuantity());
    }

    public int getQuantityAllotWillIn() {
        return quantityAllotWillIn;
    }

    public void setQuantityAllotWillIn(int quantityAllotWillIn) {
        this.quantityAllotWillIn = quantityAllotWillIn;
    }
}