package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnException;
import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnExceptionSku;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * com.thebeastshop.pegasus.service.warehouse.vo
 *
 * @author xwei
 * @create 2018-03-09 10:20
 */
public class WhSalesReturnExceptionVO extends WhSalesReturnException implements Serializable {

    private List<Long> ids;
    private String processStatusStr;
    private String createOperatorName;
    private String expressName;
    private boolean checkFlag;

    public static final Map<Integer,String> EXPRESS_TYPE_MAP = new HashMap(){{
        put(1,"顺丰");
        put(2,"中通");
        put(3,"圆通");
        put(4,"申通");
        put(5,"韵达");
        put(6,"邮政");
        put(7,"京东");
        put(8,"百世汇通");
        put(9,"天天");
        put(10,"如风达");
        put(11,"速尔");
        put(12,"全峰");
        put(13,"德邦");
        put(14,"联邦");
        put(15,"其它");
    }};

    // 待处理
    public static final Integer PROCESS_STATUS_WAIT_PROCESS = 0;
    // 待入库
    public static final Integer PROCESS_STATUS_WAIT_IN = 1;
    // 已入库
    public static final Integer PROCESS_STATUS_IN_STORAGE = 2;
    // 部分入库
    public static final Integer PROCESS_STATUS_PART_IN_STORAGE = 3;

    // 操作方式 异常
    public static final Integer OPT_FLAG_EXCEPTION = 1;

    private boolean isFetch;

    private List<WhSalesReturnExceptionSkuVO> salesReturnExceptionSkuVOs;

    private List<WhSalesReturnExceptionSku> salesReturnExceptionSkus;

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public String getProcessStatusStr() {
        return processStatusStr;
    }

    public void setProcessStatusStr(String processStatusStr) {
        this.processStatusStr = processStatusStr;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public String getExpressName() {
        return expressName;
    }

    public void setExpressName(String expressName) {
        this.expressName = expressName;
    }

    public boolean isCheckFlag() {
        return checkFlag;
    }

    public void setCheckFlag(boolean checkFlag) {
        this.checkFlag = checkFlag;
    }

    public boolean isFetch() {
        return isFetch;
    }

    public void setFetch(boolean fetch) {
        isFetch = fetch;
    }

    public List<WhSalesReturnExceptionSkuVO> getSalesReturnExceptionSkuVOs() {
        return salesReturnExceptionSkuVOs;
    }

    public void setSalesReturnExceptionSkuVOs(List<WhSalesReturnExceptionSkuVO> salesReturnExceptionSkuVOs) {
        this.salesReturnExceptionSkuVOs = salesReturnExceptionSkuVOs;
    }

    public List<WhSalesReturnExceptionSku> getSalesReturnExceptionSkus() {
        return salesReturnExceptionSkus;
    }

    public void setSalesReturnExceptionSkus(List<WhSalesReturnExceptionSku> salesReturnExceptionSkus) {
        this.salesReturnExceptionSkus = salesReturnExceptionSkus;
    }

    public static String convertProcessStatusToStr(Integer processStatus){
        if (PROCESS_STATUS_WAIT_PROCESS.equals(processStatus)){
            return "待处理";
        }else if(PROCESS_STATUS_WAIT_IN.equals(processStatus)){
            return "待入库";
        }else if(PROCESS_STATUS_IN_STORAGE.equals(processStatus)){
            return "已入库";
        }else if(PROCESS_STATUS_PART_IN_STORAGE.equals(processStatus)){
            return "部分入库";
        }
        return "";
    }

}
