package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnExceptionSku;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * com.thebeastshop.pegasus.service.warehouse.vo
 *
 * @author xwei
 * @create 2018-03-09 16:23
 */
public class WhSalesReturnExceptionSkuVO extends WhSalesReturnExceptionSku implements Serializable{

    private String skuName;

    // 收货日期
    private Date receiveDate;
    // 快递公司
    private Integer expressType;
    private String expressName;
    // 快递单号
    private String expressNo;
    // 包裹号
    private String packageCode;
    // 到付金额
    private BigDecimal amount;
    // 处理状态
    private Integer processStatus;
    private String processStatusStr;

    // 包裹备注
    private String packageMemo;

    private String statusStr;

    // 待处理
    public static final Integer SKU_PROCESS_STATUS_WAIT_PROCESS = 0;
    // 已入库
    public static final Integer SKU_PROCESS_STATUS_IN_STORAGE = 2;

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public String getExpressName() {
        return expressName;
    }

    public void setExpressName(String expressName) {
        this.expressName = expressName;
    }

    public String getExpressNo() {
        return expressNo;
    }

    public void setExpressNo(String expressNo) {
        this.expressNo = expressNo;
    }

    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getProcessStatus() {
        return processStatus;
    }

    public void setProcessStatus(Integer processStatus) {
        this.processStatus = processStatus;
    }

    public String getProcessStatusStr() {
        return processStatusStr;
    }

    public void setProcessStatusStr(String processStatusStr) {
        this.processStatusStr = processStatusStr;
    }

    public String getPackageMemo() {
        return packageMemo;
    }

    public void setPackageMemo(String packageMemo) {
        this.packageMemo = packageMemo;
    }

    public String getStatusStr() {
        if (EmptyUtil.isNotEmpty(this.getStatus())){
            if (SKU_PROCESS_STATUS_WAIT_PROCESS.equals(this.getStatus())){
                statusStr = "待处理";
            }else if(SKU_PROCESS_STATUS_IN_STORAGE.equals(this.getStatus())){
                statusStr = "已入库";
            }
        }else{
            statusStr = "";
        }
        return statusStr;
    }

    public void setStatusStr(String statusStr) {
        this.statusStr = statusStr;
    }
}
