package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.util.List;

/**
 * Created by Administrator on 2017/7/17.
 */
public class WhRecipeInvVO {

    // original
    private String warehouseCode;

    private String skuCode;

    // self
    private String skuName;

    private String skuNameCn;

    private String warehouseName;

    private String nameCn;

    private boolean customization = false;

    private boolean recipeExist = false;

    private List<WhMaterialRecipeInvVO> materialSkuInvList;

    // manual generate
    public int getCanUseInv() {
        if(EmptyUtil.isEmpty(materialSkuInvList)){
            return 0;
        }
        int quantity = Integer.MAX_VALUE;
        for(WhMaterialRecipeInvVO materialSkuInv : materialSkuInvList){
            quantity = Math.min(materialSkuInv.getCanUseInv(),quantity);
        }
        return Math.max(quantity,0);
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public boolean isCustomization() {
        return customization;
    }

    public void setCustomization(boolean customization) {
        this.customization = customization;
    }

    public List<WhMaterialRecipeInvVO> getMaterialSkuInvList() {
        return materialSkuInvList;
    }

    public void setMaterialSkuInvList(List<WhMaterialRecipeInvVO> materialSkuInvList) {
        this.materialSkuInvList = materialSkuInvList;
    }

    public boolean isRecipeExist() {
        return recipeExist;
    }

    public void setRecipeExist(boolean recipeExist) {
        this.recipeExist = recipeExist;
    }

    static public class WhMaterialRecipeInvVO{
        // original
        private String warehouseCode;

        private String skuCode;

        private Float recipeAmount;
        // self
        private String skuName;

        private String skuNameCn;

        private String warehouseName;

        private String nameCn;

        private WhInvVO skuInvVO;

        // manual generate
        public int getCanUseInv() {
            if(skuInvVO == null){
                return 0;
            }
            return Math.max((int)Math.floor(skuInvVO.getCanUseInv()/recipeAmount),0);
        }


        public String getWarehouseCode() {
            return warehouseCode;
        }

        public void setWarehouseCode(String warehouseCode) {
            this.warehouseCode = warehouseCode;
        }

        public String getSkuCode() {
            return skuCode;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public String getSkuName() {
            return skuName;
        }

        public void setSkuName(String skuName) {
            this.skuName = skuName;
        }

        public String getSkuNameCn() {
            return skuNameCn;
        }

        public void setSkuNameCn(String skuNameCn) {
            this.skuNameCn = skuNameCn;
        }

        public String getWarehouseName() {
            return warehouseName;
        }

        public void setWarehouseName(String warehouseName) {
            this.warehouseName = warehouseName;
        }

        public String getNameCn() {
            return nameCn;
        }

        public void setNameCn(String nameCn) {
            this.nameCn = nameCn;
        }

        public Float getRecipeAmount() {
            return recipeAmount;
        }

        public void setRecipeAmount(Float recipeAmount) {
            this.recipeAmount = recipeAmount;
        }

        public WhInvVO getSkuInvVO() {
            return skuInvVO;
        }

        public void setSkuInvVO(WhInvVO skuInvVO) {
            this.skuInvVO = skuInvVO;
        }
    }
}
