package com.thebeastshop.pegasus.service.warehouse.vo;

import java.util.Date;

/**
 * 重复调拨
 * Created by Gary on 2017/6/1.
 */
public class WhPreAllotRcdRepeat extends  WhPreAllotRcdKey {

  private static final long serialVersionUID = -8796893903826021474L;

  private String sourceWarehouseCode;

  private String targetWarehouseCode;

  private String remark;

  private Integer minAmount;

  private Date estimatedAllocationDate;

  private Date estimatedFinishedDate;

  private String skuCode;

  private Integer quantity;

  @Override
  public String getSourceWarehouseCode() {
    return sourceWarehouseCode;
  }

  @Override
  public void setSourceWarehouseCode(String sourceWarehouseCode) {
    this.sourceWarehouseCode = sourceWarehouseCode;
  }

  @Override
  public String getTargetWarehouseCode() {
    return targetWarehouseCode;
  }

  @Override
  public void setTargetWarehouseCode(String targetWarehouseCode) {
    this.targetWarehouseCode = targetWarehouseCode;
  }

  @Override
  public String getRemark() {
    return remark;
  }

  @Override
  public void setRemark(String remark) {
    this.remark = remark;
  }

  @Override
  public Integer getMinAmount() {
    return minAmount;
  }

  @Override
  public void setMinAmount(Integer minAmount) {
    this.minAmount = minAmount;
  }

  @Override
  public Date getEstimatedAllocationDate() {
    return estimatedAllocationDate;
  }

  @Override
  public void setEstimatedAllocationDate(Date estimatedAllocationDate) {
    this.estimatedAllocationDate = estimatedAllocationDate;
  }

  @Override
  public Date getEstimatedFinishedDate() {
    return estimatedFinishedDate;
  }

  @Override
  public void setEstimatedFinishedDate(Date estimatedFinishedDate) {
    this.estimatedFinishedDate = estimatedFinishedDate;
  }

  public String getSkuCode() {
    return skuCode;
  }

  public void setSkuCode(String skuCode) {
    this.skuCode = skuCode;
  }

  public Integer getQuantity() {
    return quantity;
  }

  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    if (!super.equals(o)) {
      return false;
    }

    WhPreAllotRcdRepeat that = (WhPreAllotRcdRepeat) o;

    if (sourceWarehouseCode != null
        ? !sourceWarehouseCode.equals(that.sourceWarehouseCode)
        : that.sourceWarehouseCode != null) {
      return false;
    }
    if (targetWarehouseCode != null
        ? !targetWarehouseCode.equals(that.targetWarehouseCode)
        : that.targetWarehouseCode != null) {
      return false;
    }
    if (remark != null ? !remark.equals(that.remark) : that.remark != null) {
      return false;
    }
    if (minAmount != null ? !minAmount.equals(that.minAmount) : that.minAmount != null) {
      return false;
    }
    if (estimatedAllocationDate != null
        ? !estimatedAllocationDate.equals(that.estimatedAllocationDate)
        : that.estimatedAllocationDate != null) {
      return false;
    }
    if (estimatedFinishedDate != null
        ? !estimatedFinishedDate.equals(that.estimatedFinishedDate)
        : that.estimatedFinishedDate != null) {
      return false;
    }
    if (skuCode != null ? !skuCode.equals(that.skuCode) : that.skuCode != null) {
      return false;
    }
    return quantity != null ? quantity.equals(that.quantity) : that.quantity == null;

  }

  @Override
  public int hashCode() {
    int result = super.hashCode();
    result = 31 * result + (sourceWarehouseCode != null ? sourceWarehouseCode.hashCode() : 0);
    result = 31 * result + (targetWarehouseCode != null ? targetWarehouseCode.hashCode() : 0);
    result = 31 * result + (remark != null ? remark.hashCode() : 0);
    result = 31 * result + (minAmount != null ? minAmount.hashCode() : 0);
    result = 31 * result + (estimatedAllocationDate != null ? estimatedAllocationDate.hashCode() : 0);
    result = 31 * result + (estimatedFinishedDate != null ? estimatedFinishedDate.hashCode() : 0);
    result = 31 * result + (skuCode != null ? skuCode.hashCode() : 0);
    result = 31 * result + (quantity != null ? quantity.hashCode() : 0);
    return result;
  }
}
