package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.util.Date;

/**
 * 预调拨sku合单规则：
 * 1.源仓库和目标仓库相同
   2.最小调拨数量相同
   3.预计调拨日期、预计完成日期相同
   4.备注一致
   5.源物理仓和目标物理仓相同 可为空
 * Created by Gary on 2017/5/31.
 */
public class WhPreAllotRcdKey  implements Serializable {

  private static final long serialVersionUID = 8403432591176829417L;

  private String sourceWarehouseCode;

  private String targetWarehouseCode;

  private String sourcePhysicalWarehouseCode;

  private String targetPhysicalWarehouseCode;

  private String remark;

  private Integer minAmount;

  private Date estimatedAllocationDate;

  private Date estimatedFinishedDate;

  public String getSourceWarehouseCode() {
    return sourceWarehouseCode;
  }

  public void setSourceWarehouseCode(String sourceWarehouseCode) {
    this.sourceWarehouseCode = sourceWarehouseCode;
  }

  public String getTargetWarehouseCode() {
    return targetWarehouseCode;
  }

  public void setTargetWarehouseCode(String targetWarehouseCode) {
    this.targetWarehouseCode = targetWarehouseCode;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Integer getMinAmount() {
    return minAmount;
  }

  public void setMinAmount(Integer minAmount) {
    this.minAmount = minAmount;
  }

  public Date getEstimatedAllocationDate() {
    return estimatedAllocationDate;
  }

  public void setEstimatedAllocationDate(Date estimatedAllocationDate) {
    this.estimatedAllocationDate = estimatedAllocationDate;
  }

  public Date getEstimatedFinishedDate() {
    return estimatedFinishedDate;
  }

  public void setEstimatedFinishedDate(Date estimatedFinishedDate) {
    this.estimatedFinishedDate = estimatedFinishedDate;
  }

  public String getSourcePhysicalWarehouseCode() {
    return sourcePhysicalWarehouseCode;
  }

  public void setSourcePhysicalWarehouseCode(String sourcePhysicalWarehouseCode) {
    this.sourcePhysicalWarehouseCode = sourcePhysicalWarehouseCode;
  }

  public String getTargetPhysicalWarehouseCode() {
    return targetPhysicalWarehouseCode;
  }

  public void setTargetPhysicalWarehouseCode(String targetPhysicalWarehouseCode) {
    this.targetPhysicalWarehouseCode = targetPhysicalWarehouseCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    WhPreAllotRcdKey that = (WhPreAllotRcdKey) o;

    if(!isPhysicalWarehouseEqual(this.getSourcePhysicalWarehouseCode(),that.getSourcePhysicalWarehouseCode())){
      return false;
    }

    if(!isPhysicalWarehouseEqual(this.getTargetPhysicalWarehouseCode(),that.getTargetPhysicalWarehouseCode())){
      return false;
    }

    if (sourceWarehouseCode != null
        ? !sourceWarehouseCode.equals(that.sourceWarehouseCode)
        : that.sourceWarehouseCode != null) {
      return false;
    }
    if (targetWarehouseCode != null
        ? !targetWarehouseCode.equals(that.targetWarehouseCode)
        : that.targetWarehouseCode != null) {
      return false;
    }
    if (remark != null ? !remark.equals(that.remark) : that.remark != null) {
      return false;
    }
    if (minAmount != null ? !minAmount.equals(that.minAmount) : that.minAmount != null) {
      return false;
    }
    if (estimatedAllocationDate != null
        ? !estimatedAllocationDate.equals(that.estimatedAllocationDate)
        : that.estimatedAllocationDate != null) {
      return false;
    }
    return estimatedFinishedDate != null
           ? estimatedFinishedDate.equals(that.estimatedFinishedDate)
           : that.estimatedFinishedDate == null;

  }

  private boolean isPhysicalWarehouseEqual(String phyWh1,String phyWh2){
    return EmptyUtil.isEmpty(phyWh1) && EmptyUtil.isEmpty(phyWh2) || EmptyUtil.isNotEmpty(phyWh1) && phyWh1.equals(phyWh2);
  }

  @Override
  public int hashCode() {
    int result = sourceWarehouseCode != null ? sourceWarehouseCode.hashCode() : 0;
    result = 31 * result + (targetWarehouseCode != null ? targetWarehouseCode.hashCode() : 0);
    result = 31 * result + (sourcePhysicalWarehouseCode != null ? sourcePhysicalWarehouseCode.hashCode() : 0);
    result = 31 * result + (targetPhysicalWarehouseCode != null ? targetPhysicalWarehouseCode.hashCode() : 0);
    result = 31 * result + (remark != null ? remark.hashCode() : 0);
    result = 31 * result + (minAmount != null ? minAmount.hashCode() : 0);
    result = 31 * result + (estimatedAllocationDate != null ? estimatedAllocationDate.hashCode() : 0);
    result = 31 * result + (estimatedFinishedDate != null ? estimatedFinishedDate.hashCode() : 0);
    return result;
  }
}
