package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhPreAllotRcd;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * Created by admin on 2016/12/26.
 */
@ExcelTemplate
public class WhPreAllotRcdDownloadVO {
    @ExcelColumn(name="预调拨单号")
    private String code;
    @ExcelColumn(name="预调拨状态")
    private String allotStatusName;

    @ExcelColumn(name="源物理仓")
    private String sourcePhysicalWarehouseName;

    @ExcelColumn(name="源仓库")
    private String sourceWarehouseName;

    @ExcelColumn(name="目标物理仓")
    private String targetPhysicalWarehouseName;

    @ExcelColumn(name="目标仓库")
    private String targetWarehouseName;
    private Integer allotStatus;
    @ExcelColumn(name="预计调拨日期")
    private String estimatedAllocationDateStr;
    @ExcelColumn(name="预计完成日期")
    private String estimatedFinishedDateStr;
    @ExcelColumn(name="最小调拨数量")
    private Integer minAmount;
    @ExcelColumn(name="SKU")
    private String skuCode;
    @ExcelColumn(name="SKU名称")
    private String skuName;

    @ExcelColumn(name="预计调拨数量")
    private Integer quantity;

    @ExcelColumn(name="已调拨数量")
    private Integer finishQuantity;
    @ExcelColumn(name="差值")
    private Integer diff;


    private String targetPhysicalWarehouseCode;

    private String sourcePhysicalWarehouseCode;


    public String getAllotStatusName() {
        if(allotStatus == null){
            return "";
        }
        String returnStr = "";
        switch (allotStatus){
            case 1:returnStr="初始化"; break;
            case 2:returnStr="调拨中"; break;
            case 3:returnStr="已完成";
        }
        return returnStr;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setAllotStatusName(String allotStatusName) {
        this.allotStatusName = allotStatusName;
    }

    public String getSourceWarehouseName() {
        return sourceWarehouseName;
    }

    public void setSourceWarehouseName(String sourceWarehouseName) {
        this.sourceWarehouseName = sourceWarehouseName;
    }

    public String getTargetWarehouseName() {
        return targetWarehouseName;
    }

    public void setTargetWarehouseName(String targetWarehouseName) {
        this.targetWarehouseName = targetWarehouseName;
    }

    public Integer getAllotStatus() {
        return allotStatus;
    }

    public void setAllotStatus(Integer allotStatus) {
        this.allotStatus = allotStatus;
    }

    public String getEstimatedAllocationDateStr() {
        return estimatedAllocationDateStr;
    }

    public void setEstimatedAllocationDateStr(String estimatedAllocationDateStr) {
        this.estimatedAllocationDateStr = estimatedAllocationDateStr;
    }

    public String getEstimatedFinishedDateStr() {
        return estimatedFinishedDateStr;
    }

    public void setEstimatedFinishedDateStr(String estimatedFinishedDateStr) {
        this.estimatedFinishedDateStr = estimatedFinishedDateStr;
    }

    public String getSourcePhysicalWarehouseName() {
        return sourcePhysicalWarehouseName;
    }

    public void setSourcePhysicalWarehouseName(String sourcePhysicalWarehouseName) {
        this.sourcePhysicalWarehouseName = sourcePhysicalWarehouseName;
    }

    public String getTargetPhysicalWarehouseName() {
        return targetPhysicalWarehouseName;
    }

    public void setTargetPhysicalWarehouseName(String targetPhysicalWarehouseName) {
        this.targetPhysicalWarehouseName = targetPhysicalWarehouseName;
    }

    public String getTargetPhysicalWarehouseCode() {
        return targetPhysicalWarehouseCode;
    }

    public void setTargetPhysicalWarehouseCode(String targetPhysicalWarehouseCode) {
        this.targetPhysicalWarehouseCode = targetPhysicalWarehouseCode;
    }

    public String getSourcePhysicalWarehouseCode() {
        return sourcePhysicalWarehouseCode;
    }

    public void setSourcePhysicalWarehouseCode(String sourcePhysicalWarehouseCode) {
        this.sourcePhysicalWarehouseCode = sourcePhysicalWarehouseCode;
    }

    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getFinishQuantity() {
        return finishQuantity;
    }

    public void setFinishQuantity(Integer finishQuantity) {
        this.finishQuantity = finishQuantity;
    }

    public Integer getDiff() {
        return diff;
    }

    public void setDiff(Integer diff) {
        this.diff = diff;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }
}
