package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 导入模板
 * @author jim.huang
 * @date 2016/4/11
 */
@ExcelTemplate
public class WhPreAllotRcdBatchVO implements Serializable {

	
	@ExcelColumn(name="sku编码")
	@NotNull
	private String skuCode;

	@ExcelColumn(name="sku名称")
	private String skuName;

	@ExcelColumn(name="调拨数量")
	@NotNull
	private Integer amount;

	@ExcelColumn(name="源物理仓")
	private String sourcePhysicalHouseName;

	@ExcelColumn(name="源仓库")
	private String sourceHouseName;

	@ExcelColumn(name="目标物理仓")
	@NotNull
	private String targetPhysicalHouseName;

	@ExcelColumn(name="目标仓库")
	@NotNull
	private String targetHouseName;
	@ExcelColumn(name="最小调拨数量")
	@NotNull
	private Integer minAmount;
	@ExcelColumn(name="预计调拨日期")
	@NotNull
	private Date estimatedAllocationDate;
	@ExcelColumn(name="预计完成日期")
	@NotNull
	private Date estimatedFinishedDate;
	@ExcelColumn(name="备注")
	private String remark;

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}

	public Integer getAmount() {
		return amount;
	}

	public void setAmount(Integer amount) {
		this.amount = amount;
	}

	public String getSourceHouseName() {
		return sourceHouseName;
	}

	public void setSourceHouseName(String sourceHouseName) {
		this.sourceHouseName = sourceHouseName;
	}

	public String getTargetHouseName() {
		return targetHouseName;
	}

	public void setTargetHouseName(String targetHouseName) {
		this.targetHouseName = targetHouseName;
	}

	public Integer getMinAmount() {
		return minAmount;
	}

	public void setMinAmount(Integer minAmount) {
		this.minAmount = minAmount;
	}

	public Date getEstimatedAllocationDate() {
		return estimatedAllocationDate;
	}

	public void setEstimatedAllocationDate(Date estimatedAllocationDate) {
		this.estimatedAllocationDate = estimatedAllocationDate;
	}

	public Date getEstimatedFinishedDate() {
		return estimatedFinishedDate;
	}

	public void setEstimatedFinishedDate(Date estimatedFinishedDate) {
		this.estimatedFinishedDate = estimatedFinishedDate;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getSourcePhysicalHouseName() {
		return sourcePhysicalHouseName;
	}

	public void setSourcePhysicalHouseName(String sourcePhysicalHouseName) {
		this.sourcePhysicalHouseName = sourcePhysicalHouseName;
	}

	public String getTargetPhysicalHouseName() {
		return targetPhysicalHouseName;
	}

	public void setTargetPhysicalHouseName(String targetPhysicalHouseName) {
		this.targetPhysicalHouseName = targetPhysicalHouseName;
	}
}
