package com.thebeastshop.pegasus.service.warehouse.vo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

/**
 * Created by Administrator on 2017/4/10.
 */
public class WhPhysicalWarehouseVO extends WhPhysicalWarehouse {

    final static public Integer DELIVERYNOTICE_YES = 1;

    final static public Integer DELIVERYNOTICE_NO = 0;

    // 默认的物理仓 [WH02060001]颛兴路物理仓
    public static final String DEFAULT_PHYSICAL_WAREHOUSE_CODE = "WH02060001";
    public static final String DEFAULT_PHYSICAL_WAREHOUSE_CODE_NEW = "WH10580083";
    // 北京总仓 物理仓
    public static final String BJ_CENTRAL_PHYSICAL_WAREHOUSE_CODE = "WH00650041";

    private List<WhWarehouseVO> relateInOutWarehouses;
    
    private List<Integer> warehouseTypeList;		// 物理仓type集合

    // 逻辑仓分组类型 0非仓库 1仓库
    private Integer warehouseGroupType;

    private String channelCode;

    private Integer channelWayType;

    private String channelWayTypeStr;

	public List<WhWarehouseVO> getRelateInOutWarehouses() {
        return relateInOutWarehouses;
    }

    public void setRelateInOutWarehouses(List<WhWarehouseVO> relateInOutWarehouses) {
        this.relateInOutWarehouses = relateInOutWarehouses;
    }

    public List<Integer> getWarehouseTypeList() {
		return warehouseTypeList;
	}
	public void setWarehouseTypeList(List<Integer> warehouseTypeList) {
		this.warehouseTypeList = warehouseTypeList;
	}

    public Integer getWarehouseGroupType() {
        return warehouseGroupType;
    }

    public void setWarehouseGroupType(Integer warehouseGroupType) {
        this.warehouseGroupType = warehouseGroupType;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Integer getChannelWayType() {
        return channelWayType;
    }

    public void setChannelWayType(Integer channelWayType) {
        this.channelWayType = channelWayType;
    }

    public String getChannelWayTypeStr() {
        return channelWayTypeStr;
    }

    public void setChannelWayTypeStr(String channelWayTypeStr) {
        this.channelWayTypeStr = channelWayTypeStr;
    }

    // 物理仓类型 1:仓库(WMS) 2：门店 3:仓库(SCM) 4：虚拟仓库
    public static final Integer WAREHOUSE_TYPE_WH_WMS = 1;// 1:仓库(WMS)
    public static final Integer WAREHOUSE_TYPE_SHOP = 2;// 2：门店
    public static final Integer WAREHOUSE_TYPE_WH_SCM = 3;// 3:仓库(SCM).aka.公司总部
    public static final Integer WAREHOUSE_TYPE_WH_VIRTUAL = 4;// 4：虚拟仓库

    private List<String> warehouseCodes = new ArrayList<String>();

    public final static Map<Integer,String> PHYSICAL_WAREHOUSE_TYPE_MAP=new HashMap(){{
        put(WAREHOUSE_TYPE_WH_WMS,"仓库(WMS)");
        put(WAREHOUSE_TYPE_SHOP,"门店");
        put(WAREHOUSE_TYPE_WH_SCM,"仓库(SCM)");
        put(WAREHOUSE_TYPE_WH_VIRTUAL,"虚拟仓库");
    }};

    public static String getDeliveryNoticeName(Integer deliveryNotice){
        return DELIVERYNOTICE_YES.equals(deliveryNotice)?"发送":"不发送";
    }

    public List<String> getWarehouseCodes() {
        return warehouseCodes;
    }

    public void setWarehouseCodes(List<String> warehouseCodes) {
        this.warehouseCodes = warehouseCodes;
    }
    public static String getPhyWarehouseTypeName(Integer warehouseType){
        return WAREHOUSE_TYPE_WH_WMS.equals(warehouseType)?"仓库":
                WAREHOUSE_TYPE_SHOP.equals(warehouseType)?"门店":
                        WAREHOUSE_TYPE_WH_SCM.equals(warehouseType)?"公司总部":
                                WAREHOUSE_TYPE_WH_VIRTUAL.equals(warehouseType)?"虚拟仓库":"N/A";
    }

    public static List<KeyValueVO> getAllPhyWarehouseType(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(WAREHOUSE_TYPE_WH_WMS.toString(),"仓库"));
        list.add(new KeyValueVO(WAREHOUSE_TYPE_SHOP.toString(),"门店"));
        list.add(new KeyValueVO(WAREHOUSE_TYPE_WH_SCM.toString(),"公司总部"));
        list.add(new KeyValueVO(WAREHOUSE_TYPE_WH_VIRTUAL.toString(),"虚拟仓库"));
        return list;
    }
}
