package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhInventory;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2018/8/2.
 */
public class WhInventoryVO extends WhInventory {

    public static Integer TYPE_SHOW = 1;//明盘

    public static Integer TYPE_HIDDEN = 2;//盲盘

    public static Integer STATUS_INIT = 1;//初始

    public static Integer STATUS_PROCESSING = 2;//进行中

    public static Integer STATUS_WAIT_AUDIT_MANAGER = 3;//待经理审核

    public static Integer STATUS_WAIT_AUDIT_FINANCE = 4;//待财务审核

    public static Integer STATUS_FINISH = 5;//已完成

    public static Integer STATUS_CANCEL = -1;//取消

    private String physicalWarehouseName;

    private String createUserName;

    private String financeAuditUserName;

    private String manageAuditUserName;

    private List<WhInventoryDetailVO> inventoryDetailList;

    private List<Long> skuCategoryIdList;

    private List<Integer> skuStatusList;//必盘sku状态

    private List<Integer> skuTypeList;//必盘sku类型

    private List<WhInventorySkuCategoryVO> skuCategoryList;

    private Long auditOperaterId;

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getTypeName(){
        return getTypeName(getType());
    }

    public String getStatusName(){
        return getStatusName(getStatus());
    }

    public static String getStatusName(Integer status){
        return STATUS_INIT.equals(status)?"初始化":
                STATUS_PROCESSING.equals(status)?"进行中":
                        STATUS_WAIT_AUDIT_MANAGER.equals(status)?"待经理审核":
                                STATUS_WAIT_AUDIT_FINANCE.equals(status)?"待财务审核":
                                        STATUS_FINISH.equals(status)?"已完成":
                                                STATUS_CANCEL.equals(status)?"取消":"";
    }

    public static String getTypeName(Integer type){
        return TYPE_SHOW.equals(type)?"明盘":
                TYPE_HIDDEN.equals(type)?"盲盘":"";
    }

    public static List<KeyValueVO> getStatusKvList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(STATUS_INIT.toString(),"初始化"));
        list.add(new KeyValueVO(STATUS_PROCESSING.toString(),"进行中"));
        list.add(new KeyValueVO(STATUS_WAIT_AUDIT_MANAGER.toString(),"待经理审核"));
        list.add(new KeyValueVO(STATUS_WAIT_AUDIT_FINANCE.toString(),"待财务审核"));
        list.add(new KeyValueVO(STATUS_FINISH.toString(),"已完成"));
        list.add(new KeyValueVO(STATUS_CANCEL.toString(),"取消"));
        return list;
    }

    public List<Long> getSkuCategoryIdList() {
        return skuCategoryIdList;
    }

    public void setSkuCategoryIdList(List<Long> skuCategoryIdList) {
        this.skuCategoryIdList = skuCategoryIdList;
    }

    public List<WhInventoryDetailVO> getInventoryDetailList() {
        return inventoryDetailList;
    }

    public void setInventoryDetailList(List<WhInventoryDetailVO> inventoryDetailList) {
        this.inventoryDetailList = inventoryDetailList;
    }

    public List<WhInventorySkuCategoryVO> getSkuCategoryList() {
        return skuCategoryList;
    }

    public void setSkuCategoryList(List<WhInventorySkuCategoryVO> skuCategoryList) {
        this.skuCategoryList = skuCategoryList;
    }

    public Long getAuditOperaterId() {
        return auditOperaterId;
    }

    public void setAuditOperaterId(Long auditOperaterId) {
        this.auditOperaterId = auditOperaterId;
    }

    public List<Integer> getSkuTypeList() {
        return skuTypeList;
    }

    public void setSkuTypeList(List<Integer> skuTypeList) {
        this.skuTypeList = skuTypeList;
    }

    public String getFinanceAuditUserName() {
        return financeAuditUserName;
    }

    public void setFinanceAuditUserName(String financeAuditUserName) {
        this.financeAuditUserName = financeAuditUserName;
    }

    public String getManageAuditUserName() {
        return manageAuditUserName;
    }

    public void setManageAuditUserName(String manageAuditUserName) {
        this.manageAuditUserName = manageAuditUserName;
    }

    public List<Integer> getSkuStatusList() {
        return skuStatusList;
    }

    public void setSkuStatusList(List<Integer> skuStatusList) {
        this.skuStatusList = skuStatusList;
    }
}
