package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryDetail;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2018/8/2.
 */
public class WhInventoryDetailVO extends WhInventoryDetail{

    public static Integer STATUS_CANCEL = -1;//取消

    public static Integer STATUS_NONE = 1;//未盘点

    public static Integer STATUS_DONE = 2;//已盘点

    public static Integer  AUDIT_STATUS_INIT = 1;//初始

    public static Integer  AUDIT_STATUS_REJECT = 2;//驳回

    public static Integer  AUDIT_STATUS_WAIT_AUDIT_MANAGER = 3;//待经理审核

    public static Integer AUDIT_STATUS_WAIT_AUDIT_FINANCE = 4;//待财务审核

    public static Integer AUDIT_STATUS_FINISH = 5;//已完成

    public static Integer AUDIT_STATUS_CANCEL = -1;//取消

    public Integer needMark;

    private String skuName;

    private String diffReasionTypeName;

    private String categoryLevel1Name;

    private Long categoryLevel1Id;

    private String categoryLevle2Name;

    private String categoryFullName;
    private Long categoryLevel2Id;

    private Integer inventoryStatus;

    private String createUserName;

    private Integer skuType;

    private Integer inventoryType;

    private String supplierSkuBarcode;//供应商条码

    private Double salePrice;

    private String size;

    public String getStatusName(){
        return getStatusName(getStatus());
    }

    public String getAuditStatusName(){
        return getAuditStatusName(getAuditStatus());
    }

    public String getCategoryLevle2Name() {
        return categoryLevle2Name;
    }

    public void setCategoryLevle2Name(String categoryLevle2Name) {
        this.categoryLevle2Name = categoryLevle2Name;
    }

    public String getCategoryLevel1Name() {
        return categoryLevel1Name;
    }

    public void setCategoryLevel1Name(String categoryLevel1Name) {
        this.categoryLevel1Name = categoryLevel1Name;
    }

    public String getCategoryFullName() {
        return categoryFullName;
    }

    public Double getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(Double salePrice) {
        this.salePrice = salePrice;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setCategoryFullName(String categoryFullName) {
        this.categoryFullName = categoryFullName;
    }

    public static String getAuditStatusName(Integer auditStatus){
        return AUDIT_STATUS_INIT.equals(auditStatus)?"初始":
                AUDIT_STATUS_REJECT.equals(auditStatus)?"驳回":
                        AUDIT_STATUS_WAIT_AUDIT_MANAGER.equals(auditStatus)?"待经理审核":
                                AUDIT_STATUS_WAIT_AUDIT_FINANCE.equals(auditStatus)?"待财务审核":
                                        AUDIT_STATUS_FINISH.equals(auditStatus)?"已完成":
                                                AUDIT_STATUS_CANCEL.equals(auditStatus)?"取消":"";
    }

    public static String getStatusName(Integer status){
        return STATUS_NONE.equals(status)?"未盘点":
                STATUS_DONE.equals(status)?"已盘点":
                        STATUS_CANCEL.equals(status)?"已盘点":"";
    }

    public static List<KeyValueVO> getAuditStatusKvList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(AUDIT_STATUS_INIT.toString(),"初始化"));
        list.add(new KeyValueVO(AUDIT_STATUS_REJECT.toString(),"驳回"));
        list.add(new KeyValueVO(AUDIT_STATUS_WAIT_AUDIT_MANAGER.toString(),"待经理审核"));
        list.add(new KeyValueVO(AUDIT_STATUS_WAIT_AUDIT_FINANCE.toString(),"待财务审核"));
        list.add(new KeyValueVO(AUDIT_STATUS_FINISH.toString(),"已完成"));
        list.add(new KeyValueVO(AUDIT_STATUS_CANCEL.toString(),"取消"));
        return list;
    }

    public static List<KeyValueVO> getStatusKvList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(STATUS_NONE.toString(),"未盘点"));
        list.add(new KeyValueVO(STATUS_DONE.toString(),"已盘点"));
        return list;
    }

    public Integer getInventoryStatus() {
        return inventoryStatus;
    }

    public void setInventoryStatus(Integer inventoryStatus) {
        this.inventoryStatus = inventoryStatus;
    }

    public String getSkuStatusName(){
        return WhWarehouseVO.getSkuStatusName(getSkuStatus());
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getDiffReasionTypeName() {
        return diffReasionTypeName;
    }

    public void setDiffReasionTypeName(String diffReasionTypeName) {
        this.diffReasionTypeName = diffReasionTypeName;
    }

    public Integer getNeedMark() {
        return needMark;
    }

    public void setNeedMark(Integer needMark) {
        this.needMark = needMark;
    }

    public Long getCategoryLevel1Id() {
        return categoryLevel1Id;
    }

    public void setCategoryLevel1Id(Long categoryLevel1Id) {
        this.categoryLevel1Id = categoryLevel1Id;
    }

    public Long getCategoryLevel2Id() {
        return categoryLevel2Id;
    }

    public void setCategoryLevel2Id(Long categoryLevel2Id) {
        this.categoryLevel2Id = categoryLevel2Id;
    }

    public Integer getSkuType() {
        return skuType;
    }

    public void setSkuType(Integer skuType) {
        this.skuType = skuType;
    }

    public String getSupplierSkuBarcode() {
        return supplierSkuBarcode;
    }

    public void setSupplierSkuBarcode(String supplierSkuBarcode) {
        this.supplierSkuBarcode = supplierSkuBarcode;
    }

    public Integer getInventoryType() {
        return inventoryType;
    }

    public void setInventoryType(Integer inventoryType) {
        this.inventoryType = inventoryType;
    }

    public String getSkuTypeName(){
        return getSkuType() == null?"":
                getSkuType() == 3?"成品":
                        getSkuType() == 2?"半成品":
                                getSkuType() == 1?"原材料":"";
    }
}
