package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhGradeAffectInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQuality;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQualityDetail;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.stock.vo.SOccupyResultVO;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xw
 * @create 2018-04-23 15:00
 */
public class WhGradeOfQualityVO extends WhGradeOfQuality implements Serializable {

    public static final String COMM_LOG_ENTITY_FOR_GRADE = "WhGradeOfQuality";

    // 初始
    public static final int APPROVE_STATUS_INIT = 0;
    // 待审批
    public static final int APPROVE_STATUS_WAIT = 1;
    // 审批通过
    public static final int APPROVE_STATUS_PASS = 2;
    // 驳回
    public static final int APPROVE_STATUS_REJECT = -1;

    public static final int ORIGIN_TYPE_WMS = 1;

    public static final int ORIGIN_TYPE_SCM = 2;

    // 品级调整申请人 邮箱
    public static final String GRADE_ADJUST_APPLY_EMAIL = "grade.sendMailGradeAdjustApply";
    // 订单缺货 收件人邮箱
    public static final String GRADE_ADJUST_STOCK_OUT_EMAIL = "grade.sendMailStockOutByGradeAdjust";
    // 单据异常 收件人邮箱
    public static final String GRADE_ADJUST_ORDER_EXCEPTION_EMAIL = "grade.sendMailOrderExceptionByGradeAdjust";
    // 库存变化 收件人邮箱
    public static final String GRADE_ADJUST_STOCK_CHANGE_EMAIL = "grade.sendMailStockChangeByGradeAdjust";
    // 需要手动审批的目标品级状态
    public static final String NEED_MANUAL_APPROVE_GRADE_STATUS = "grade.needManualApproveTargetGradeStatus";

    // 品级调整 移库目标库位
    public static final String GRADE_ADJUST_MOVE_TARGET_SHELVES_CODE = "grade.gradeAdjustMoveTargetShelvesCode";

    String physicalWarehouseName;
    String createUserName;
    String approveUserName;
    String sourceGradeStr;
    String targetGradeStr;
    String approveStatusStr;

    String buyerName;
    String skuName;
    String firstLevelCategory;
    String secondLevelCategory;

    Boolean optPass;

    boolean batchProcess = false;

    boolean systemGradeEmail = false;

    List<WhGradeOfQualityDetailVO> whGradeDetailVOs;

    List<WhGradeOfQualityDetail> whGradeDetails;

    List<WhGradeAffectInfo> whGradeAffectInfos;

    List<Long> whAffectGradeIds;

    //占用回滚List
    private List<SOccupyResultVO> rollbackOccupyList;

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName;
    }

    // 天猫两家店
    public final static List<String> WAREHOUSE_TMALL_LIST = new ArrayList(){{
        add("WH020600010121");
        add("WH000275910275");
    }};

    public final static Map<String,String> WAREHOUSE_CHANNEL_TMALL_MAP = new HashMap(){{
        put("WH020600010121","CHN1031");
        put("WH000275910275","CHN2069");
    }};

    public final static Map<Integer,String> APPROVE_STATUS_MAP = new HashMap(){{
        //put(APPROVE_STATUS_INIT,"初始");
        put(APPROVE_STATUS_WAIT,"待审批");
        put(APPROVE_STATUS_PASS,"审批通过");
        put(APPROVE_STATUS_REJECT,"驳回");
    }};

    public String getSourceGradeStr() {
        if (EmptyUtil.isEmpty(sourceGradeStr)){
            return WhWarehouseVO.getSkuStatusName(this.getSourceGrade());
        }
        return sourceGradeStr;
    }

    public void setSourceGradeStr(String sourceGradeStr) {
        this.sourceGradeStr = sourceGradeStr;
    }

    public String getTargetGradeStr() {
        if (EmptyUtil.isEmpty(targetGradeStr)){
            return WhWarehouseVO.getSkuStatusName(this.getTargetGrade());
        }
        return targetGradeStr;
    }

    public void setTargetGradeStr(String targetGradeStr) {
        this.targetGradeStr = targetGradeStr;
    }

    public String getApproveStatusStr() {
        if (EmptyUtil.isEmpty(approveStatusStr)){
            approveStatusStr = APPROVE_STATUS_MAP.get(this.getApproveStatus());
            return EmptyUtil.isEmpty(approveStatusStr)?"":approveStatusStr;
        }
        return approveStatusStr;
    }

    public void setApproveStatusStr(String approveStatusStr) {
        this.approveStatusStr = approveStatusStr;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getFirstLevelCategory() {
        return firstLevelCategory;
    }

    public void setFirstLevelCategory(String firstLevelCategory) {
        this.firstLevelCategory = firstLevelCategory;
    }

    public String getSecondLevelCategory() {
        return secondLevelCategory;
    }

    public void setSecondLevelCategory(String secondLevelCategory) {
        this.secondLevelCategory = secondLevelCategory;
    }

    public Boolean getOptPass() {
        return optPass;
    }

    public void setOptPass(Boolean optPass) {
        this.optPass = optPass;
    }

    public boolean isBatchProcess() {
        return batchProcess;
    }

    public void setBatchProcess(boolean batchProcess) {
        this.batchProcess = batchProcess;
    }

    public boolean isSystemGradeEmail() {
        return systemGradeEmail;
    }

    public void setSystemGradeEmail(boolean systemGradeEmail) {
        this.systemGradeEmail = systemGradeEmail;
    }

    public List<WhGradeOfQualityDetailVO> getWhGradeDetailVOs() {
        return whGradeDetailVOs;
    }

    public void setWhGradeDetailVOs(List<WhGradeOfQualityDetailVO> whGradeDetailVOs) {
        this.whGradeDetailVOs = whGradeDetailVOs;
    }

    public List<WhGradeOfQualityDetail> getWhGradeDetails() {
        return whGradeDetails;
    }

    public void setWhGradeDetails(List<WhGradeOfQualityDetail> whGradeDetails) {
        this.whGradeDetails = whGradeDetails;
    }

    public List<WhGradeAffectInfo> getWhGradeAffectInfos() {
        return whGradeAffectInfos;
    }

    public void setWhGradeAffectInfos(List<WhGradeAffectInfo> whGradeAffectInfos) {
        this.whGradeAffectInfos = whGradeAffectInfos;
    }

    public List<Long> getWhAffectGradeIds() {
        return whAffectGradeIds;
    }

    public void setWhAffectGradeIds(List<Long> whAffectGradeIds) {
        this.whAffectGradeIds = whAffectGradeIds;
    }

    public List<SOccupyResultVO> getRollbackOccupyList() {
        return rollbackOccupyList;
    }

    public void setRollbackOccupyList(List<SOccupyResultVO> rollbackOccupyList) {
        this.rollbackOccupyList = rollbackOccupyList;
    }
}
