package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQualityDetail;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author xw
 * @create 2018-04-23 15:01
 */
public class WhGradeOfQualityDetailVO extends WhGradeOfQualityDetail implements Serializable {

    // 待审批
    public static final int APPROVE_STATUS_WAIT = 0;
    // 审批通过
    public static final int APPROVE_STATUS_PASS = 1;
    // 驳回
    public static final int APPROVE_STATUS_REJECT = -1;

    private String sourceWarehouseName;
    private String targetWarehouseName;
    private String skuName;

    private String approveStatusStr;

    public final static Map<Integer,String> APPROVE_STATUS_MAP = new HashMap(){{
        put(APPROVE_STATUS_WAIT,"待审批");
        put(APPROVE_STATUS_PASS,"审批通过");
        put(APPROVE_STATUS_REJECT,"驳回");
    }};

    public String getSourceWarehouseName() {
        return sourceWarehouseName;
    }

    public void setSourceWarehouseName(String sourceWarehouseName) {
        this.sourceWarehouseName = sourceWarehouseName;
    }

    public String getTargetWarehouseName() {
        return targetWarehouseName;
    }

    public void setTargetWarehouseName(String targetWarehouseName) {
        this.targetWarehouseName = targetWarehouseName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getApproveStatusStr() {
        if (EmptyUtil.isEmpty(approveStatusStr)){
            approveStatusStr = APPROVE_STATUS_MAP.get(this.getApproveStatus());
            return EmptyUtil.isEmpty(approveStatusStr)?"":approveStatusStr;
        }
        return approveStatusStr;
    }

    public void setApproveStatusStr(String approveStatusStr) {
        this.approveStatusStr = approveStatusStr;
    }
}
