package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhGradeAffectInfo;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xw
 * @create 2018-05-04 11:54
 */
public class WhGradeAffectInfoVO extends WhGradeAffectInfo {

    //  数据来源类型 可用
    public static final int USE_SOURCE_CANUSE = 1;

    //  数据来源类型 包裹占用
    public static final int USE_SOURCE_PACK_OCCUPY = 2;
    //  数据来源类型 其它订单占用
    public static final int USE_SOURCE_PACK_OTHER_OCCUPY = 3;
    //  数据来源类型 负的占用
    public static final int USE_SOURCE_NEGATIVE_OCCUPY = 4;

    // 是否处理 待处理
    public static final int OPT_FLAG_WAIT_PROCESS = 0;
    // 是否处理 已处理
    public static final int OPT_FLAG_PROCESSED = 1;
    // 是否处理 已出取消
    public static final int OPT_FLAG_CANCELED = -1;

    // 是否发送邮件 0未发送
    public static final int SEND_MAIL_FLAG_NO = 0;
    // 是否发送邮件 1已发送
    public static final int SEND_MAIL_FLAG_YES = 1;

    // scm品级单状态 1待审批
    public static final int WH_GRADE_STATUS__WAIT = 1;
    // scm品级单状态 2审批通过
    public static final int WH_GRADE_STATUS_PASS = 2;

    // 天猫仓库存同步成功标志
    public static final int SYNC_RESULT_SUCCESS = 1;
    public static final int SYNC_RESULT_FAILURE = -1;
    public static final int SYNC_RESULT_DEFAULT = 0;

    public static final String SEND_EMAIL_ALL = "SEND_EMAIL_ALL";
    public static final String SEND_EMAIL_CHANNEL = "SEND_EMAIL_CHANNEL";
    public static final String SEND_EMAIL_WAREHOUSE = "SEND_EMAIL_WAREHOUSE";

    public static final Map<Integer,String> SYNC_RESULT_MAP = new HashMap(){{
        put(SYNC_RESULT_SUCCESS,"成功");
        put(SYNC_RESULT_FAILURE,"失败");
        put(SYNC_RESULT_DEFAULT,"");
    }};

    public String getSyncResultStr(){
        if (EmptyUtil.isEmpty(this.getSyncResult())){
            return "";
        }
        return SYNC_RESULT_MAP.get(this.getSyncResult());
    }

    private String salesOrderCode;

    private String warehouseGroupName;

    private String warehouseName;

    private String channelNoticeEmails;

    private String warehouseContactEmails;

    private String fullAddress;

    private List<String> toAddressList;
    private String emailAddressKey;
    private String waitSendHead;
    private StringBuilder waitSendContent;
    private String waitSendBottom;
    private List<Long> waitUpdateAffectIds;

    public String getSalesOrderCode() {
        return salesOrderCode;
    }

    public void setSalesOrderCode(String salesOrderCode) {
        this.salesOrderCode = salesOrderCode;
    }

    public String getWarehouseGroupName() {
        return warehouseGroupName;
    }

    public void setWarehouseGroupName(String warehouseGroupName) {
        this.warehouseGroupName = warehouseGroupName;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getChannelNoticeEmails() {
        return channelNoticeEmails;
    }

    public void setChannelNoticeEmails(String channelNoticeEmails) {
        this.channelNoticeEmails = channelNoticeEmails;
    }

    public String getWarehouseContactEmails() {
        return warehouseContactEmails;
    }

    public void setWarehouseContactEmails(String warehouseContactEmails) {
        this.warehouseContactEmails = warehouseContactEmails;
    }

    public String getFullAddress() {
        return fullAddress;
    }

    public void setFullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
    }

    public List<String> getToAddressList() {
        return toAddressList;
    }

    public void setToAddressList(List<String> toAddressList) {
        this.toAddressList = toAddressList;
    }

    public String getEmailAddressKey() {
        return emailAddressKey;
    }

    public void setEmailAddressKey(String emailAddressKey) {
        this.emailAddressKey = emailAddressKey;
    }

    public String getWaitSendHead() {
        return waitSendHead;
    }

    public void setWaitSendHead(String waitSendHead) {
        this.waitSendHead = waitSendHead;
    }

    public StringBuilder getWaitSendContent() {
        return waitSendContent;
    }

    public void setWaitSendContent(StringBuilder waitSendContent) {
        this.waitSendContent = waitSendContent;
    }

    public String getWaitSendBottom() {
        return waitSendBottom;
    }

    public void setWaitSendBottom(String waitSendBottom) {
        this.waitSendBottom = waitSendBottom;
    }

    public List<Long> getWaitUpdateAffectIds() {
        return waitUpdateAffectIds;
    }

    public void setWaitUpdateAffectIds(List<Long> waitUpdateAffectIds) {
        this.waitUpdateAffectIds = waitUpdateAffectIds;
    }
}
