package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhExpressWaybill;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class WhExpressWaybillVO extends WhExpressWaybill implements Serializable {

    private String processStatusStr;

    private String expressName;

    private String createOperatorName;

    private String commandStatusStr;

    private List<String> expressNos;

    // 重新生成快递单的标志
    public static final Integer REBUILD_EXPRESS_CODE_FLAG = 1;

    private List<WhExpressWaybillVO> expressInfos;

    public String getProcessStatusStr() {
        return processStatusStr;
    }

    public void setProcessStatusStr(String processStatusStr) {
        this.processStatusStr = processStatusStr;
    }

    public String getExpressName() {
        return expressName;
    }

    public void setExpressName(String expressName) {
        this.expressName = expressName;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public String getCommandStatusStr() {
        return WhCommand.getCommandStatusStr(getCommandStatus());
    }

    public void setCommandStatusStr(String commandStatusStr) {
        this.commandStatusStr = commandStatusStr;
    }

    public List<WhExpressWaybillVO> getExpressInfos() {
        return expressInfos;
    }

    public void setExpressInfos(List<WhExpressWaybillVO> expressInfos) {
        this.expressInfos = expressInfos;
    }


    public List<String> getExpressNos() {
        return expressNos;
    }

    public void setExpressNos(List<String> expressNos) {
        this.expressNos = expressNos;
    }

    // 处理状态 【0：未处理  1：已处理】
    public static final Integer PROCESS_STATUS_NO = 0;
    public static final Integer PROCESS_STATUS_YES = 1;
    public static List<KeyValueVO> getAllProcessStatus(){
        List<KeyValueVO> processStatusList = new ArrayList(){{
            add(new KeyValueVO(PROCESS_STATUS_NO.toString(),"未处理"));
            add(new KeyValueVO(PROCESS_STATUS_YES.toString(),"已处理"));
        }};
        return processStatusList;
    }

    // 路由信息 【0：未揽件  1：已揽件】
    public static final Integer ROUTING_INFO_NO = 0;
    public static final Integer ROUTING_INFO_YES = 1;
    public static List<KeyValueVO> getAllRoutingInfo(){
        List<KeyValueVO> routingInfoList = new ArrayList(){{
            add(new KeyValueVO(ROUTING_INFO_YES.toString(),"已揽件"));
            add(new KeyValueVO(ROUTING_INFO_NO.toString(),"未揽件"));
        }};
        return routingInfoList;
    }

}