package com.thebeastshop.pegasus.service.warehouse.vo;

import java.util.List;

public class WhCommandAssoExpressVO {
	
	private String commandCode;
	
	private String packageCode;

    private List<String> packageCodeList;
	
	private Long packageId;
	
	private Long packageDeliveryInfoId;

	private String expressCode;

	private Integer packageStatus;
	
	private Integer deliveryType;
	
	private Integer deliveryInfoCount;

    // 修改物流单号，修改原因
    private String operationDesc;

    // 相关单据号
    private String referenceCode;

    // 关联快递单，操作来源  【onlineLogistics：线上物流查询时，关联快递单，不作出库单状态限制】
    private String operationSource;

	private boolean confirmed = false;//是否确认更改

	// self
    // cardType
    // packageStatus
    /**
     * 包裹状态~未发货取消
     */
    public static final Integer PACKAGE_STATUS_UNSENT_CANCEL = -1;
    /**
     * 包裹状态~初始
     */
    public static final Integer PACKAGE_STATUS_DEFAULT = 10;
    /**
     * 包裹状态~待制单
     */
    public static final Integer PACKAGE_STATUS_WAITING_MAKE = 11;
    /**
     * 包裹状态~待发货
     */
    public static final Integer PACKAGE_STATUS_WAITING_SEND = 12;
    /**
     * 包裹状态~待收货
     */
    public static final Integer PACKAGE_STATUS_WAITING_RECEIVE = 13;
    /**
     * 包裹状态~已收货
     */
    public static final Integer PACKAGE_STATUS_ALREADY_RECEIVE = 14;

    /**
     * 卡片类型~不需要
     */
    public static final Integer CARD_TYPE_NULL = 0;
    /**
     * 卡片类型~空白
     */
    public static final Integer CARD_TYPE_BLANK_ = 1;
    /**
     * 卡片类型~代写
     */
    public static final Integer CARD_TYPE_GHOSTWRITE = 2;

    // deliveryType
    /**
     * 配送方式~快递
     */
    public static final Integer DELIVERY_TYPE_EXPRESS = 1;
    /**
     * 配送方式~非快递
     */
    public static final Integer DELIVERY_TYPE_NOT_EXPRESS = 0;

	public Integer getPackageStatus() {
		return packageStatus;
	}

	public void setPackageStatus(Integer packageStatus) {
		this.packageStatus = packageStatus;
	}

	public Integer getDeliveryType() {
		return deliveryType;
	}

	public void setDeliveryType(Integer deliveryType) {
		this.deliveryType = deliveryType;
	}

	

	public String getCommandCode() {
		return commandCode;
	}

	public void setCommandCode(String commandCode) {
		this.commandCode = commandCode;
	}

	public String getExpressCode() {
		return expressCode;
	}

	public void setExpressCode(String expressCode) {
		this.expressCode = expressCode;
	}

	public String getPackageCode() {
		return packageCode;
	}

	public void setPackageCode(String packageCode) {
		this.packageCode = packageCode;
	}

    public List<String> getPackageCodeList() {
        return packageCodeList;
    }

    public void setPackageCodeList(List<String> packageCodeList) {
        this.packageCodeList = packageCodeList;
    }

    public Integer getDeliveryInfoCount() {
		return deliveryInfoCount;
	}

	public void setDeliveryInfoCount(Integer deliveryInfoCount) {
		this.deliveryInfoCount = deliveryInfoCount;
	}
	
	public Long getPackageId() {
		return packageId;
	}

	public void setPackageId(Long packageId) {
		this.packageId = packageId;
	}

	public Long getPackageDeliveryInfoId() {
		return packageDeliveryInfoId;
	}

	public void setPackageDeliveryInfoId(Long packageDeliveryInfoId) {
		this.packageDeliveryInfoId = packageDeliveryInfoId;
	}

    public String getOperationDesc() {
        return operationDesc;
    }

    public void setOperationDesc(String operationDesc) {
        this.operationDesc = operationDesc;
    }

    public String getReferenceCode() {
        return referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public String getOperationSource() {
        return operationSource;
    }

    public void setOperationSource(String operationSource) {
        this.operationSource = operationSource;
    }

	public boolean isConfirmed() {
		return confirmed;
	}

	public void setConfirmed(boolean confirmed) {
		this.confirmed = confirmed;
	}
}
