package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.util.List;

public class WhAutoAllotSkuVO {

  private String skuCode;

  private int planAllotQuantity;

  private int canUseQuantity;

  private List<WhAutoAllotGroupVO> groupList;

  public String getSkuCode() {
    return skuCode;
  }

  public void setSkuCode(String skuCode) {
    this.skuCode = skuCode;
  }

  public Integer getPlanAllotQuantity() {
    if (EmptyUtil.isEmpty(groupList)) {
      return 0;
    }
    planAllotQuantity = 0;
    for (WhAutoAllotGroupVO allotGroup : groupList) {
      planAllotQuantity += allotGroup.getPlanAllotQuantity();
    }
    return planAllotQuantity;
  }

  public void setPlanAllotQuantity(Integer planAllotQuantity) {
    this.planAllotQuantity = planAllotQuantity;
  }

  public List<WhAutoAllotGroupVO> getGroupList() {
    return groupList;
  }

  public void setGroupList(List<WhAutoAllotGroupVO> groupList) {
    this.groupList = groupList;
  }

  public Integer getCanUseQuantity() {
    return canUseQuantity;
  }

  public void setCanUseQuantity(Integer canUseQuantity) {
    this.canUseQuantity = canUseQuantity;
  }
}
